/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.colorpicker;

import java.io.IOException;
import java.util.Map;
import java.util.regex.Pattern;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UINamingContainer;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import org.primefaces.component.colorpicker.ColorPicker;
import org.primefaces.renderkit.InputRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.EscapeUtils;
import org.primefaces.util.HTML;
import org.primefaces.util.LangUtils;
import org.primefaces.util.WidgetBuilder;
import org.primefaces.validate.ClientValidator;

public class ColorPickerRenderer
extends InputRenderer {
    private static final Pattern COLOR_PATTERN = Pattern.compile("^#(?:[\\da-f]{3}){1,2}$|^#(?:[\\da-f]{4}){1,2}$|(rgb|hsl)a?\\((\\s*-?\\d+%?\\s*,){2}(\\s*-?\\d+%?\\s*)\\)|(rgb|hsl)a?\\((\\s*-?\\d+%?\\s*,){3}\\s*(0|(0?\\.\\d+)|1)\\)", 2);

    public void decode(FacesContext context, UIComponent component) {
        boolean inline;
        ColorPicker colorPicker = (ColorPicker)component;
        if (!this.shouldDecode((UIInput)colorPicker)) {
            return;
        }
        Map params = context.getExternalContext().getRequestParameterMap();
        Object paramName = colorPicker.getClientId(context);
        boolean bl = inline = !"popup".equalsIgnoreCase(colorPicker.getMode());
        if (inline && !params.containsKey(paramName = (String)paramName + "_color")) {
            paramName = "clr-color-value";
        }
        if (params.containsKey(paramName)) {
            String submittedValue = (String)params.get(paramName);
            if (!COLOR_PATTERN.matcher(submittedValue).matches()) {
                submittedValue = "";
            }
            colorPicker.setSubmittedValue(submittedValue);
        }
        this.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ColorPicker colorPicker = (ColorPicker)component;
        Converter converter = ComponentUtils.getConverter(context, component);
        String value = converter != null ? converter.getAsString(context, component, colorPicker.getValue()) : (String)colorPicker.getValue();
        String clientId = colorPicker.getClientId(context);
        String uuid = clientId.replaceAll(Character.toString(UINamingContainer.getSeparatorChar((FacesContext)context)), "-");
        this.encodeMarkup(context, colorPicker, value, uuid);
        this.encodeScript(context, colorPicker, value, uuid);
    }

    protected void encodeMarkup(FacesContext context, ColorPicker colorPicker, String value, String uuid) throws IOException {
        if ("popup".equalsIgnoreCase(colorPicker.getMode())) {
            this.encodePopup(context, colorPicker, value, uuid);
        } else {
            this.encodeInline(context, colorPicker, value, uuid);
        }
    }

    protected void encodePopup(FacesContext context, ColorPicker colorPicker, String value, String uuid) throws IOException {
        String onchange;
        ResponseWriter writer = context.getResponseWriter();
        String clientId = colorPicker.getClientId(context);
        String styleClass = this.getStyleClassBuilder(context).add(this.createStyleClass((UIInput)colorPicker, "ui-colorpicker ui-inputfield ui-inputtext ui-widget ui-state-default ui-corner-all")).add(ComponentUtils.isRTL(context, colorPicker), "clr-rtl").add(uuid).build();
        writer.startElement("input", (UIComponent)colorPicker);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("name", (Object)clientId, null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (colorPicker.getStyle() != null) {
            writer.writeAttribute("style", (Object)colorPicker.getStyle(), "style");
        }
        if (!this.isValueBlank(onchange = colorPicker.getOnchange())) {
            writer.writeAttribute("onchange", (Object)onchange, null);
        }
        this.renderAccessibilityAttributes(context, (UIInput)colorPicker);
        this.renderRTLDirection(context, colorPicker);
        this.renderPassThruAttributes(context, (UIComponent)colorPicker, HTML.INPUT_TEXT_ATTRS_WITHOUT_EVENTS);
        this.renderDomEvents(context, (UIComponent)colorPicker, HTML.INPUT_TEXT_EVENTS);
        this.renderValidationMetadata(context, (EditableValueHolder)colorPicker, new ClientValidator[0]);
        if (value != null) {
            writer.writeAttribute("value", (Object)value, null);
        }
        writer.endElement("input");
    }

    protected void encodeInline(FacesContext context, ColorPicker colorPicker, String value, String uuid) throws IOException {
        String onchange;
        ResponseWriter writer = context.getResponseWriter();
        String clientId = colorPicker.getClientId(context);
        writer.startElement("div", (UIComponent)colorPicker);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("name", (Object)clientId, null);
        writer.writeAttribute("class", (Object)(this.createStyleClass((UIInput)colorPicker, "ui-colorpicker ui-widget ui-state-default") + " " + uuid), null);
        if (colorPicker.getStyle() != null) {
            writer.writeAttribute("style", (Object)colorPicker.getStyle(), "style");
        }
        if (!this.isValueBlank(onchange = colorPicker.getOnchange())) {
            writer.writeAttribute("onchange", (Object)onchange, null);
        }
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, ColorPicker colorPicker, String value, String uuid) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("ColorPicker", colorPicker).attr("instance", uuid).attr("locale", colorPicker.calculateLocale(context).toString()).attr("mode", colorPicker.getMode()).attr("defaultColor", value, null).attr("theme", colorPicker.getTheme(), "default").attr("themeMode", colorPicker.getThemeMode(), "auto").attr("format", colorPicker.getFormat(), "hex").attr("formatToggle", colorPicker.isFormatToggle(), false).attr("clearButton", colorPicker.isClearButton(), false).attr("closeButton", colorPicker.isCloseButton(), false).attr("alpha", colorPicker.isAlpha(), true).attr("forceAlpha", colorPicker.isForceAlpha(), false).attr("swatchesOnly", colorPicker.isSwatchesOnly(), false).attr("focusInput", colorPicker.isFocusInput(), true).attr("selectInput", colorPicker.isSelectInput(), false);
        String swatchProp = colorPicker.getSwatches();
        if (LangUtils.isNotBlank(swatchProp)) {
            String[] swatches = swatchProp.split(",");
            wb.append(",swatches:[");
            for (int i = 0; i < swatches.length; ++i) {
                String swatch = swatches[i];
                if (i != 0) {
                    wb.append(",");
                }
                wb.append("\"" + EscapeUtils.forJavaScript(swatch) + "\"");
            }
            wb.append("]");
        }
        this.encodeClientBehaviors(context, (ClientBehaviorHolder)colorPicker);
        wb.finish();
    }
}

