/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.filedownload;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import org.primefaces.PrimeFaces;
import org.primefaces.model.StreamedContent;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.DynamicContentSrcBuilder;
import org.primefaces.util.EscapeUtils;
import org.primefaces.util.IOUtils;
import org.primefaces.util.LangUtils;
import org.primefaces.util.ResourceUtils;

public class FileDownloadActionListener
implements ActionListener,
StateHolder {
    private ValueExpression value;
    private ValueExpression contentDisposition;
    private ValueExpression monitorKey;
    private ValueExpression store;

    public FileDownloadActionListener() {
        ResourceUtils.addComponentResource(FacesContext.getCurrentInstance(), "filedownload/filedownload.js");
    }

    public FileDownloadActionListener(ValueExpression value, ValueExpression contentDisposition, ValueExpression monitorKey, ValueExpression store) {
        this();
        this.value = value;
        this.contentDisposition = contentDisposition;
        this.monitorKey = monitorKey;
        this.store = store;
    }

    public void processAction(ActionEvent actionEvent) throws AbortProcessingException {
        FacesContext context = FacesContext.getCurrentInstance();
        ELContext elContext = context.getELContext();
        StreamedContent content = (StreamedContent)this.value.getValue(elContext);
        if (content == null) {
            return;
        }
        if (PrimeFaces.current().isAjaxRequest()) {
            this.ajaxDownload(context, content);
        } else {
            this.regularDownload(context, content);
        }
    }

    protected void ajaxDownload(FacesContext context, StreamedContent content) {
        UIComponent currentComponent = UIComponent.getCurrentComponent((FacesContext)context);
        String uri = DynamicContentSrcBuilder.buildStreaming(context, currentComponent, this.value, false);
        String monitorKeyCookieName = ResourceUtils.getMonitorKeyCookieName(context, this.monitorKey);
        PrimeFaces.current().executeScript(String.format("PrimeFaces.download('%s', '%s', '%s', '%s')", uri, content.getContentType(), EscapeUtils.forJavaScript(content.getName()), monitorKeyCookieName));
    }

    protected void regularDownload(FacesContext context, StreamedContent content) {
        ExternalContext externalContext = context.getExternalContext();
        externalContext.setResponseContentType(content.getContentType());
        String contentDispositionValue = this.contentDisposition != null ? (String)this.contentDisposition.getValue(context.getELContext()) : "attachment";
        externalContext.setResponseHeader("Content-Disposition", ComponentUtils.createContentDisposition(contentDispositionValue, content.getName()));
        String monitorKeyCookieName = ResourceUtils.getMonitorKeyCookieName(context, this.monitorKey);
        HashMap<String, Object> cookieOptions = new HashMap<String, Object>(4);
        cookieOptions.put("path", LangUtils.isBlank(externalContext.getRequestContextPath()) ? "/" : externalContext.getRequestContextPath());
        ResourceUtils.addResponseCookie(context, monitorKeyCookieName, "true", cookieOptions);
        Boolean store = this.store != null ? (Boolean)this.store.getValue(context.getELContext()) : Boolean.FALSE;
        ResourceUtils.addNoCacheControl(externalContext, store);
        if (content.getContentLength() != null) {
            externalContext.setResponseHeader("Content-Length", String.valueOf(content.getContentLength()));
        }
        try {
            if (content.getWriter() != null) {
                content.getWriter().accept(externalContext.getResponseOutputStream());
            } else {
                try (InputStream is = content.getStream().get();){
                    IOUtils.copyLarge(is, externalContext.getResponseOutputStream());
                }
            }
            if (!externalContext.isResponseCommitted()) {
                externalContext.setResponseStatus(200);
            }
            externalContext.responseFlushBuffer();
            context.responseComplete();
        }
        catch (IOException e) {
            throw new FacesException((Throwable)e);
        }
    }

    public boolean isTransient() {
        return false;
    }

    public void setTransient(boolean value) {
    }

    public void restoreState(FacesContext facesContext, Object state) {
        Object[] values = (Object[])state;
        this.value = (ValueExpression)values[0];
        this.contentDisposition = (ValueExpression)values[1];
        this.monitorKey = (ValueExpression)values[2];
    }

    public Object saveState(FacesContext facesContext) {
        Object[] values = new Object[]{this.value, this.contentDisposition, this.monitorKey};
        return values;
    }
}

