/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.keyboard;

import java.io.IOException;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.keyboard.Keyboard;
import org.primefaces.renderkit.InputRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.HTML;
import org.primefaces.util.WidgetBuilder;
import org.primefaces.validate.ClientValidator;

public class KeyboardRenderer
extends InputRenderer {
    public void decode(FacesContext context, UIComponent component) {
        Keyboard keyboard = (Keyboard)component;
        if (!this.shouldDecode((UIInput)keyboard)) {
            return;
        }
        this.decodeBehaviors(context, (UIComponent)keyboard);
        String clientId = keyboard.getClientId(context);
        String submittedValue = (String)context.getExternalContext().getRequestParameterMap().get(clientId);
        if (submittedValue != null) {
            keyboard.setSubmittedValue(submittedValue);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Keyboard keyboard = (Keyboard)component;
        this.encodeMarkup(context, keyboard);
        this.encodeScript(context, keyboard);
    }

    protected void encodeScript(FacesContext context, Keyboard keyboard) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("Keyboard", keyboard).attr("useThemeRoller", true).attr("showOn", keyboard.getShowMode()).attr("showAnim", keyboard.getEffect()).attr("buttonImageOnly", keyboard.isButtonImageOnly(), false).attr("duration", keyboard.getEffectDuration(), null);
        if (keyboard.getButtonImage() != null) {
            wb.attr("buttonImage", this.getResourceURL(context, keyboard.getButtonImage()));
        }
        if (!keyboard.isKeypadOnly()) {
            wb.attr("keypadOnly", false).attr("layoutName", keyboard.getLayout()).attr("layoutTemplate", keyboard.getLayoutTemplate(), null);
        }
        if (ComponentUtils.isRTL(context, keyboard)) {
            wb.attr("isRTL", true);
        }
        wb.attr("keypadClass", keyboard.getStyleClass(), null).attr("prompt", keyboard.getPromptLabel(), null).attr("backText", keyboard.getBackspaceLabel(), null).attr("clearText", keyboard.getClearLabel(), null).attr("closeText", keyboard.getCloseLabel(), null);
        wb.finish();
    }

    protected void encodeMarkup(FacesContext context, Keyboard keyboard) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = keyboard.getClientId(context);
        String type = keyboard.isPassword() ? "password" : "text";
        String styleClass = this.createStyleClass((UIInput)keyboard, "ui-inputfield ui-keyboard-input ui-widget ui-state-default ui-corner-all");
        String valueToRender = ComponentUtils.getValueToRender(context, (UIComponent)keyboard);
        writer.startElement("input", (UIComponent)keyboard);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("name", (Object)clientId, null);
        writer.writeAttribute("type", (Object)type, null);
        if (valueToRender != null) {
            writer.writeAttribute("value", (Object)valueToRender, "value");
        }
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (keyboard.getStyle() != null) {
            writer.writeAttribute("style", (Object)keyboard.getStyle(), "style");
        }
        this.renderAccessibilityAttributes(context, (UIInput)keyboard);
        this.renderPassThruAttributes(context, (UIComponent)keyboard, HTML.INPUT_TEXT_ATTRS_WITHOUT_EVENTS);
        this.renderDomEvents(context, (UIComponent)keyboard, HTML.INPUT_TEXT_EVENTS);
        this.renderValidationMetadata(context, (EditableValueHolder)keyboard, new ClientValidator[0]);
        writer.endElement("input");
    }
}

