/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.spotlight;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.spotlight.Spotlight;
import org.primefaces.expression.SearchExpressionUtils;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.WidgetBuilder;

public class SpotlightRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Spotlight spotlight = (Spotlight)component;
        this.encodeMarkup(context, spotlight);
        this.encodeScript(context, spotlight);
    }

    private void encodeMarkup(FacesContext context, Spotlight spotlight) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("span", (UIComponent)spotlight);
        writer.writeAttribute("id", (Object)spotlight.getClientId(context), null);
        writer.endElement("span");
    }

    private void encodeScript(FacesContext context, Spotlight spotlight) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("Spotlight", spotlight).attr("target", SearchExpressionUtils.resolveClientIdsForClientSide(context, (UIComponent)spotlight, spotlight.getTarget())).attr("active", spotlight.isActive(), false).attr("blockScroll", spotlight.isBlockScroll(), false);
        wb.finish();
    }
}

