/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.model.charts;

import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;
import org.primefaces.util.ChartUtils;
import org.primefaces.util.FastStringWriter;
import org.primefaces.util.LangUtils;

public class ChartFont
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String family;
    private Number size;
    private String style;
    private String weight;
    private Object lineHeight;

    public String getFamily() {
        return this.family;
    }

    public void setFamily(String family) {
        this.family = family;
    }

    public Number getSize() {
        return this.size;
    }

    public void setSize(Number size) {
        this.size = size;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getWeight() {
        return this.weight;
    }

    public void setWeight(String weight) {
        this.weight = weight;
    }

    public Object getLineHeight() {
        return this.lineHeight;
    }

    public void setLineHeight(Object lineHeight) {
        this.lineHeight = lineHeight;
    }

    public boolean shouldRender() {
        return LangUtils.isNotBlank(this.family) || LangUtils.isNotBlank(this.style) || LangUtils.isNotBlank(this.weight) || this.size != null || this.lineHeight != null;
    }

    public void write(FastStringWriter writer) throws IOException {
        this.write(writer, "font", true);
    }

    public void write(FastStringWriter writer, String name, boolean hasComma) throws IOException {
        if (this.shouldRender()) {
            if (hasComma) {
                writer.write(",");
            }
            writer.write("\"" + name + "\":" + this.encode());
        }
    }

    public String encode() throws IOException {
        try (FastStringWriter fsw = new FastStringWriter();){
            fsw.write("{");
            boolean hasComma = false;
            if (LangUtils.isNotBlank(this.family)) {
                ChartUtils.writeDataValue(fsw, "family", this.family, hasComma);
                hasComma = true;
            }
            if (!Objects.isNull(this.size)) {
                ChartUtils.writeDataValue(fsw, "size", this.size, hasComma);
                hasComma = true;
            }
            if (LangUtils.isNotBlank(this.style)) {
                ChartUtils.writeDataValue(fsw, "style", this.style, hasComma);
                hasComma = true;
            }
            if (LangUtils.isNotBlank(this.weight)) {
                ChartUtils.writeDataValue(fsw, "weight", this.weight, hasComma);
                hasComma = true;
            }
            if (!Objects.isNull(this.lineHeight)) {
                ChartUtils.writeDataValue(fsw, "lineHeight", this.lineHeight, hasComma);
                hasComma = true;
            }
            fsw.write("}");
            String string = fsw.toString();
            return string;
        }
    }
}

