/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.util;

import javax.faces.component.ContextCallback;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIPanel;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.CompositeUtils;

public class FacetUtils {
    private FacetUtils() {
    }

    public static boolean shouldRenderFacet(UIComponent facet, boolean alwaysRender) {
        if (facet == null) {
            return false;
        }
        if (alwaysRender) {
            return true;
        }
        if (facet.getClass().equals(UIPanel.class)) {
            if (!facet.isRendered()) {
                return false;
            }
            return ComponentUtils.shouldRenderChildren(facet);
        }
        return facet.isRendered();
    }

    public static boolean shouldRenderFacet(UIComponent facet) {
        return FacetUtils.shouldRenderFacet(facet, false);
    }

    public static void invokeOnEditableValueHolder(FacesContext context, UIComponent facet, ContextCallback callback) {
        VisitContext visitContext = VisitContext.createVisitContext((FacesContext)context, null, ComponentUtils.VISIT_HINTS_SKIP_UNRENDERED);
        facet.visitTree(visitContext, (ctx, component) -> {
            if (CompositeUtils.isComposite(component)) {
                CompositeUtils.invokeOnDeepestEditableValueHolder(context, component, callback);
                return VisitResult.REJECT;
            }
            if (component instanceof EditableValueHolder) {
                callback.invokeContextCallback(context, component);
            }
            return VisitResult.ACCEPT;
        });
    }
}

