/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.virusscan;

import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.primefaces.model.file.UploadedFile;
import org.primefaces.virusscan.VirusException;
import org.primefaces.virusscan.VirusScanner;

public class VirusScannerService {
    private static final Logger LOGGER = Logger.getLogger(VirusScannerService.class.getName());
    private final ClassLoader classLoader;

    public VirusScannerService(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void performVirusScan(UploadedFile file) throws VirusException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Performing virus scan...");
        }
        Iterator<VirusScanner> scanners = ServiceLoader.load(VirusScanner.class, this.classLoader).iterator();
        while (scanners.hasNext()) {
            try {
                VirusScanner scanner = scanners.next();
                String clazz = scanner.getClass().getName();
                if (!scanner.isEnabled()) {
                    if (!LOGGER.isLoggable(Level.FINE)) continue;
                    LOGGER.fine(String.format("Skipping virus scan with %s provider since it is disabled", clazz));
                    continue;
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(String.format("Performing virus scan with %s provider", clazz));
                }
                scanner.scan(file);
                if (!LOGGER.isLoggable(Level.FINE)) continue;
                LOGGER.fine(String.format("No virus detected with %s provider", clazz));
            }
            catch (VirusException ex) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.severe("Detected a virus");
                }
                throw ex;
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("No virus detected");
        }
    }
}

