/*
 © 2023 Alexandre Bonneau

 The MIT License (http://www.opensource.org/licenses/mit-license.php)

 Permission is hereby granted, free of charge, to any person
 obtaining a copy of this software and associated documentation
 files (the "Software"), to deal in the Software without
 restriction, including without limitation the rights to use,
 copy, modify, merge, publish, distribute, sub license, and/or sell
 copies of the Software, and to permit persons to whom the
 Software is furnished to do so, subject to the following
 conditions:

 The above copyright notice and this permission notice shall be
 included in all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 OTHER DEALINGS IN THE SOFTWARE.
 © 2019 Alexandre Bonneau

 The MIT License (http://www.opensource.org/licenses/mit-license.php)

 Permission is hereby granted, free of charge, to any person
 obtaining a copy of this software and associated documentation
 files (the "Software"), to deal in the Software without
 restriction, including without limitation the rights to use,
 copy, modify, merge, publish, distribute, sub license, and/or sell
 copies of the Software, and to permit persons to whom the
 Software is furnished to do so, subject to the following
 conditions:

 The above copyright notice and this permission notice shall be
 included in all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 OTHER DEALINGS IN THE SOFTWARE.
 **************************** !*\
  !*** ./src/AutoNumeric.js ***!
  \*************************** ./AutoNumericHelper  ./AutoNumericEnum  ./maths/Evaluator  ./maths/Parser     Alexandre Bonneau & Robert J. Knothe
 @since        2009-08-09

 @summary      AutoNumeric is a standalone Javascript library
               that provides live *as-you-type* formatting for
               international numbers and currencies.

 @link         http://autonumeric.org
 @docs         https://docs.autonumeric.org

               Note : Some functions are borrowed from big.js
 @see          https://github.com/MikeMcl/big.js/

 Please report any bugs to https://github.com/autoNumeric/autoNumeric

 @license      Released under the MIT License
 @link         http://www.opensource.org/licenses/mit-license.php

 Permission is hereby granted, free of charge, to any person
 obtaining a copy of this software and associated documentation
 files (the "Software"), to deal in the Software without
 restriction, including without limitation the rights to use,
 copy, modify, merge, publish, distribute, sub license, and/or sell
 copies of the Software, and to permit persons to whom the
 Software is furnished to do so, subject to the following
 conditions:

 The above copyright notice and this permission notice shall be
 included in all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 OTHER DEALINGS IN THE SOFTWARE.
 ******************************************* !*\
  !*** ./src/AutoNumericDefaultSettings.js ***!
  \****************************************** ./AutoNumeric  ./AutoNumericOptions  ******************************** !*\
  !*** ./src/AutoNumericEnum.js ***!
  \******************************* ********************************** !*\
  !*** ./src/AutoNumericEvents.js ***!
  \********************************* ********************************** !*\
  !*** ./src/AutoNumericHelper.js ***!
  \********************************* *********************************** !*\
  !*** ./src/AutoNumericOptions.js ***!
  \********************************** ********************************************* !*\
  !*** ./src/AutoNumericPredefinedOptions.js ***!
  \******************************************** ****************************** !*\
  !*** ./src/maths/ASTNode.js ***!
  \***************************** ******************************** !*\
  !*** ./src/maths/Evaluator.js ***!
  \******************************* **************************** !*\
  !*** ./src/maths/Lexer.js ***!
  \*************************** ../AutoNumericHelper  ./Token  ***************************** !*\
  !*** ./src/maths/Parser.js ***!
  \**************************** ./ASTNode  ./Lexer  **************************** !*\
  !*** ./src/maths/Token.js ***!
  \*************************** ********************* !*\
  !*** ./src/main.js ***!
  \******************** ./AutoNumericEvents  ./AutoNumericDefaultSettings  ./AutoNumericPredefinedOptions */
var $jscomp=$jscomp||{};$jscomp.scope={};$jscomp.arrayIteratorImpl=function(t){var D=0;return function(){return D<t.length?{done:!1,value:t[D++]}:{done:!0}}};$jscomp.arrayIterator=function(t){return{next:$jscomp.arrayIteratorImpl(t)}};$jscomp.ASSUME_ES5=!1;$jscomp.ASSUME_NO_NATIVE_MAP=!1;$jscomp.ASSUME_NO_NATIVE_SET=!1;$jscomp.SIMPLE_FROUND_POLYFILL=!1;$jscomp.ISOLATE_POLYFILLS=!1;$jscomp.FORCE_POLYFILL_PROMISE=!1;$jscomp.FORCE_POLYFILL_PROMISE_WHEN_NO_UNHANDLED_REJECTION=!1;
$jscomp.defineProperty=$jscomp.ASSUME_ES5||"function"==typeof Object.defineProperties?Object.defineProperty:function(t,D,G){if(t==Array.prototype||t==Object.prototype)return t;t[D]=G.value;return t};$jscomp.getGlobal=function(t){t=["object"==typeof globalThis&&globalThis,t,"object"==typeof window&&window,"object"==typeof self&&self,"object"==typeof global&&global];for(var D=0;D<t.length;++D){var G=t[D];if(G&&G.Math==Math)return G}throw Error("Cannot find global object");};$jscomp.global=$jscomp.getGlobal(this);
$jscomp.IS_SYMBOL_NATIVE="function"===typeof Symbol&&"symbol"===typeof Symbol("x");$jscomp.TRUST_ES6_POLYFILLS=!$jscomp.ISOLATE_POLYFILLS||$jscomp.IS_SYMBOL_NATIVE;$jscomp.polyfills={};$jscomp.propertyToPolyfillSymbol={};$jscomp.POLYFILL_PREFIX="$jscp$";var $jscomp$lookupPolyfilledValue=function(t,D,G){if(!G||null!=t){G=$jscomp.propertyToPolyfillSymbol[D];if(null==G)return t[D];G=t[G];return void 0!==G?G:t[D]}};
$jscomp.polyfill=function(t,D,G,J){D&&($jscomp.ISOLATE_POLYFILLS?$jscomp.polyfillIsolated(t,D,G,J):$jscomp.polyfillUnisolated(t,D,G,J))};$jscomp.polyfillUnisolated=function(t,D,G,J){G=$jscomp.global;t=t.split(".");for(J=0;J<t.length-1;J++){var n=t[J];if(!(n in G))return;G=G[n]}t=t[t.length-1];J=G[t];D=D(J);D!=J&&null!=D&&$jscomp.defineProperty(G,t,{configurable:!0,writable:!0,value:D})};
$jscomp.polyfillIsolated=function(t,D,G,J){var n=t.split(".");t=1===n.length;J=n[0];J=!t&&J in $jscomp.polyfills?$jscomp.polyfills:$jscomp.global;for(var z=0;z<n.length-1;z++){var C=n[z];if(!(C in J))return;J=J[C]}n=n[n.length-1];G=$jscomp.IS_SYMBOL_NATIVE&&"es6"===G?J[n]:null;D=D(G);null!=D&&(t?$jscomp.defineProperty($jscomp.polyfills,n,{configurable:!0,writable:!0,value:D}):D!==G&&(void 0===$jscomp.propertyToPolyfillSymbol[n]&&(G=1E9*Math.random()>>>0,$jscomp.propertyToPolyfillSymbol[n]=$jscomp.IS_SYMBOL_NATIVE?
$jscomp.global.Symbol(n):$jscomp.POLYFILL_PREFIX+G+"$"+n),$jscomp.defineProperty(J,$jscomp.propertyToPolyfillSymbol[n],{configurable:!0,writable:!0,value:D})))};$jscomp.initSymbol=function(){};
$jscomp.polyfill("Symbol",function(t){if(t)return t;var D=function(z,C){this.$jscomp$symbol$id_=z;$jscomp.defineProperty(this,"description",{configurable:!0,writable:!0,value:C})};D.prototype.toString=function(){return this.$jscomp$symbol$id_};var G="jscomp_symbol_"+(1E9*Math.random()>>>0)+"_",J=0,n=function(z){if(this instanceof n)throw new TypeError("Symbol is not a constructor");return new D(G+(z||"")+"_"+J++,z)};return n},"es6","es3");
$jscomp.polyfill("Symbol.iterator",function(t){if(t)return t;t=Symbol("Symbol.iterator");for(var D="Array Int8Array Uint8Array Uint8ClampedArray Int16Array Uint16Array Int32Array Uint32Array Float32Array Float64Array".split(" "),G=0;G<D.length;G++){var J=$jscomp.global[D[G]];"function"===typeof J&&"function"!=typeof J.prototype[t]&&$jscomp.defineProperty(J.prototype,t,{configurable:!0,writable:!0,value:function(){return $jscomp.iteratorPrototype($jscomp.arrayIteratorImpl(this))}})}return t},"es6",
"es3");$jscomp.iteratorPrototype=function(t){t={next:t};t[Symbol.iterator]=function(){return this};return t};
(function(t,D){"object"===typeof exports&&"object"===typeof module?module.exports=D():"function"===typeof define&&define.amd?define([],D):"object"===typeof exports?exports.AutoNumeric=D():t.AutoNumeric=D()})(this,function(){return function(){function t(n){var z=G[n];if(void 0!==z)return z.exports;z=G[n]={exports:{}};D[n](z,z.exports,t);return z.exports}var D={"./src/AutoNumeric.js":function(n,z,C){function q(d){var a=Array.isArray(d)?I(d):void 0;a||(a="undefined"!==typeof Symbol&&null!=d[Symbol.iterator]||
null!=d["@@iterator"]?Array.from(d):void 0);if(!(d=a||K(d)))throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");return d}function w(d,a){var b=Array.isArray(d)?d:void 0;if(!b)a:{var e=null==d?null:"undefined"!=typeof Symbol&&d[Symbol.iterator]||d["@@iterator"];if(null!=e){var h,g,l,p=[],r=!0,u=!1;try{if(g=(e=e.call(d)).next,0===a){if(Object(e)!==e){b=void 0;break a}r=!1}else for(;!(r=(h=g.call(e)).done)&&
(p.push(h.value),p.length!==a);r=!0);}catch(L){u=!0;var F=L}finally{try{if(!r&&null!=e["return"]&&(l=e["return"](),Object(l)!==l)){b=void 0;break a}}finally{if(u)throw F;}}b=p}else b=void 0}if(!(d=b||K(d,a)))throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");return d}function K(d,a){if(d){if("string"===typeof d)return I(d,a);var b=Object.prototype.toString.call(d).slice(8,-1);"Object"===b&&
d.constructor&&(b=d.constructor.name);if("Map"===b||"Set"===b)return Array.from(d);if("Arguments"===b||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(b))return I(d,a)}}function I(d,a){if(null==a||a>d.length)a=d.length;for(var b=0,e=Array(a);b<a;b++)e[b]=d[b];return e}function E(){E=Object.assign?Object.assign.bind():function(d){for(var a=1;a<arguments.length;a++){var b=arguments[a],e;for(e in b)Object.prototype.hasOwnProperty.call(b,e)&&(d[e]=b[e])}return d};return E.apply(this,arguments)}function x(d){"@babel/helpers - typeof";
return x="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(a){return typeof a}:function(a){return a&&"function"==typeof Symbol&&a.constructor===Symbol&&a!==Symbol.prototype?"symbol":typeof a},x(d)}function A(d,a){for(var b=0;b<a.length;b++){var e=a[b];e.enumerable=e.enumerable||!1;e.configurable=!0;"value"in e&&(e.writable=!0);Object.defineProperty(d,H(e.key),e)}}function v(d,a,b){a&&A(d.prototype,a);b&&A(d,b);Object.defineProperty(d,"prototype",{writable:!1});return d}function B(d,
a,b){a=H(a);a in d?Object.defineProperty(d,a,{value:b,enumerable:!0,configurable:!0,writable:!0}):d[a]=b;return d}function H(d){a:if("object"===x(d)&&null!==d){var a=d[Symbol.toPrimitive];if(void 0!==a){d=a.call(d,"string");if("object"!==x(d))break a;throw new TypeError("@@toPrimitive must return a primitive value.");}d=String(d)}return"symbol"===x(d)?d:String(d)}C.r(z);C.d(z,{"default":function(){return y}});var c=C("./src/AutoNumericHelper.js"),f=C("./src/AutoNumericEnum.js"),k=C("./src/maths/Evaluator.js"),
m=C("./src/maths/Parser.js"),y=function(){function d(){var a=this,b=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null,e=1<arguments.length&&void 0!==arguments[1]?arguments[1]:null,h=2<arguments.length&&void 0!==arguments[2]?arguments[2]:null;if(!(this instanceof d))throw new TypeError("Cannot call a class as a function");e=d._setArgumentsValues(b,e,h);b=e.initialValue;h=e.userOptions;this.domElement=e.domElement;this.defaultRawValue="";this._setSettings(h,!1);this._checkElement();this.savedCancellableValue=
null;this.historyTable=[];this.historyTableIndex=-1;this.onGoingRedo=!1;this.parentForm=this._getParentForm();if(!this.runOnce&&this.settings.formatOnPageLoad)this._formatDefaultValueOnPageLoad(b);else{if(c["default"].isNull(b))switch(this.settings.emptyInputBehavior){case d.options.emptyInputBehavior.min:e=this.settings.minimumValue;break;case d.options.emptyInputBehavior.max:e=this.settings.maximumValue;break;case d.options.emptyInputBehavior.zero:e="0";break;case d.options.emptyInputBehavior.focus:case d.options.emptyInputBehavior.press:case d.options.emptyInputBehavior.always:e=
"";break;case d.options.emptyInputBehavior["null"]:e=null;break;default:e=this.settings.emptyInputBehavior}else e=b;this._setElementAndRawValue(e)}this.runOnce=!0;this.hasEventListeners=!1;if(this.isInputElement||this.isContentEditable)this.settings.noEventListeners||this._createEventListeners(),this._setWritePermissions(!0);this._saveInitialValues(b);this.storageNamePrefix="AUTO_";this._setPersistentStorageName();this.validState=!0;this.isEditing=this.isDropEvent=this.isWheelEvent=this.isFocused=
!1;this.rawValueOnFocus=void 0;this.internalModification=!1;this.attributeToWatch=this._getAttributeToWatch();this.getterSetter=Object.getOwnPropertyDescriptor(this.domElement.__proto__,this.attributeToWatch);this._addWatcher();this.settings.createLocalList&&this._createLocalList();this.constructor._addToGlobalList(this);this.global={set:function(g){var l=1<arguments.length&&void 0!==arguments[1]?arguments[1]:null;a.autoNumericLocalList.forEach(function(p){p.set(g,l)})},setUnformatted:function(g){var l=
1<arguments.length&&void 0!==arguments[1]?arguments[1]:null;a.autoNumericLocalList.forEach(function(p){p.setUnformatted(g,l)})},get:function(){var g=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null,l=[];a.autoNumericLocalList.forEach(function(p){l.push(p.get())});a._executeCallback(l,g);return l},getNumericString:function(){var g=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null,l=[];a.autoNumericLocalList.forEach(function(p){l.push(p.getNumericString())});a._executeCallback(l,
g);return l},getFormatted:function(){var g=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null,l=[];a.autoNumericLocalList.forEach(function(p){l.push(p.getFormatted())});a._executeCallback(l,g);return l},getNumber:function(){var g=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null,l=[];a.autoNumericLocalList.forEach(function(p){l.push(p.getNumber())});a._executeCallback(l,g);return l},getLocalized:function(){var g=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null,l=[];a.autoNumericLocalList.forEach(function(p){l.push(p.getLocalized())});
a._executeCallback(l,g);return l},reformat:function(){a.autoNumericLocalList.forEach(function(g){g.reformat()})},unformat:function(){a.autoNumericLocalList.forEach(function(g){g.unformat()})},unformatLocalized:function(){var g=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null;a.autoNumericLocalList.forEach(function(l){l.unformatLocalized(g)})},update:function(){for(var g=arguments.length,l=Array(g),p=0;p<g;p++)l[p]=arguments[p];a.autoNumericLocalList.forEach(function(r){r.update.apply(r,
l)})},isPristine:function(){var g=0<arguments.length&&void 0!==arguments[0]?arguments[0]:!0,l=!0;a.autoNumericLocalList.forEach(function(p){l&&!p.isPristine(g)&&(l=!1)});return l},clear:function(){var g=0<arguments.length&&void 0!==arguments[0]?arguments[0]:!1;a.autoNumericLocalList.forEach(function(l){l.clear(g)})},remove:function(){a.autoNumericLocalList.forEach(function(g){g.remove()})},wipe:function(){a.autoNumericLocalList.forEach(function(g){g.wipe()})},nuke:function(){a.autoNumericLocalList.forEach(function(g){g.nuke()})},
has:function(g){return g instanceof d?a.autoNumericLocalList.has(g.node()):a.autoNumericLocalList.has(g)},addObject:function(g){if(g instanceof d)var l=g.node();else l=g,g=d.getAutoNumericElement(l);a._hasLocalList()||a._createLocalList();var p=g._getLocalList();0===p.size&&(g._createLocalList(),p=g._getLocalList());if(p instanceof Map)var r=c["default"].mergeMaps(a._getLocalList(),p);else a._addToLocalList(l,g),r=a._getLocalList();r.forEach(function(u){u._setLocalList(r)})},removeObject:function(g){var l=
1<arguments.length&&void 0!==arguments[1]?arguments[1]:!1;if(g instanceof d){var p=g.node();var r=g}else p=g,r=d.getAutoNumericElement(p);var u=a.autoNumericLocalList;a.autoNumericLocalList["delete"](p);u.forEach(function(F){F._setLocalList(a.autoNumericLocalList)});l||p!==a.node()?r._createLocalList():r._setLocalList(new Map)},empty:function(){var g=0<arguments.length&&void 0!==arguments[0]?arguments[0]:!1;a.autoNumericLocalList.forEach(function(l){g?l._createLocalList():l._setLocalList(new Map)})},
elements:function(){var g=[];a.autoNumericLocalList.forEach(function(l){g.push(l.node())});return g},getList:function(){return a.autoNumericLocalList},size:function(){return a.autoNumericLocalList.size}};this.options={reset:function(){a.settings={rawValue:a.defaultRawValue};a.update(d.defaultSettings);return a},allowDecimalPadding:function(g){a.update({allowDecimalPadding:g});return a},alwaysAllowDecimalCharacter:function(g){a.update({alwaysAllowDecimalCharacter:g});return a},caretPositionOnFocus:function(g){a.settings.caretPositionOnFocus=
g;return a},createLocalList:function(g){a.settings.createLocalList=g;a.settings.createLocalList?a._hasLocalList()||a._createLocalList():a._deleteLocalList();return a},currencySymbol:function(g){a.update({currencySymbol:g});return a},currencySymbolPlacement:function(g){a.update({currencySymbolPlacement:g});return a},decimalCharacter:function(g){a.update({decimalCharacter:g});return a},decimalCharacterAlternative:function(g){a.settings.decimalCharacterAlternative=g;return a},decimalPlaces:function(g){c["default"].warning("Using `options.decimalPlaces()` instead of calling the specific `options.decimalPlacesRawValue()`, `options.decimalPlacesShownOnFocus()` and `options.decimalPlacesShownOnBlur()` methods will reset those options.\nPlease call the specific methods if you do not want to reset those.",
a.settings.showWarnings);a.update({decimalPlaces:g});return a},decimalPlacesRawValue:function(g){a.update({decimalPlacesRawValue:g});return a},decimalPlacesShownOnBlur:function(g){a.update({decimalPlacesShownOnBlur:g});return a},decimalPlacesShownOnFocus:function(g){a.update({decimalPlacesShownOnFocus:g});return a},defaultValueOverride:function(g){a.update({defaultValueOverride:g});return a},digitalGroupSpacing:function(g){a.update({digitalGroupSpacing:g});return a},digitGroupSeparator:function(g){a.update({digitGroupSeparator:g});
return a},divisorWhenUnfocused:function(g){a.update({divisorWhenUnfocused:g});return a},emptyInputBehavior:function(g){null===a.rawValue&&g!==d.options.emptyInputBehavior["null"]&&(c["default"].warning("You are trying to modify the `emptyInputBehavior` option to something different than `'null'` (".concat(g,"), but the element raw value is currently set to `null`. This would result in an invalid `rawValue`. In order to fix that, the element value has been changed to the empty string `''`."),a.settings.showWarnings),
a.rawValue="");a.update({emptyInputBehavior:g});return a},eventBubbles:function(g){a.settings.eventBubbles=g;return a},eventIsCancelable:function(g){a.settings.eventIsCancelable=g;return a},failOnUnknownOption:function(g){a.settings.failOnUnknownOption=g;return a},formatOnPageLoad:function(g){a.settings.formatOnPageLoad=g;return a},formulaMode:function(g){a.settings.formulaMode=g;return a},historySize:function(g){a.settings.historySize=g;return a},invalidClass:function(g){a.settings.invalidClass=
g;return a},isCancellable:function(g){a.settings.isCancellable=g;return a},leadingZero:function(g){a.update({leadingZero:g});return a},maximumValue:function(g){a.update({maximumValue:g});return a},minimumValue:function(g){a.update({minimumValue:g});return a},modifyValueOnUpDownArrow:function(g){a.settings.modifyValueOnUpDownArrow=g;return a},modifyValueOnWheel:function(g){a.settings.modifyValueOnWheel=g;return a},negativeBracketsTypeOnBlur:function(g){a.update({negativeBracketsTypeOnBlur:g});return a},
negativePositiveSignPlacement:function(g){a.update({negativePositiveSignPlacement:g});return a},negativeSignCharacter:function(g){a.update({negativeSignCharacter:g});return a},negativePositiveSignBehavior:function(g){a.settings.negativePositiveSignBehavior=g;return a},noEventListeners:function(g){g===d.options.noEventListeners.noEvents&&a.settings.noEventListeners===d.options.noEventListeners.addEvents&&a._removeEventListeners();a.update({noEventListeners:g});return a},onInvalidPaste:function(g){a.settings.onInvalidPaste=
g;return a},outputFormat:function(g){a.settings.outputFormat=g;return a},overrideMinMaxLimits:function(g){a.update({overrideMinMaxLimits:g});return a},positiveSignCharacter:function(g){a.update({positiveSignCharacter:g});return a},rawValueDivisor:function(g){a.update({rawValueDivisor:g});return a},readOnly:function(g){a.settings.readOnly=g;a._setWritePermissions();return a},roundingMethod:function(g){a.update({roundingMethod:g});return a},saveValueToSessionStorage:function(g){a.update({saveValueToSessionStorage:g});
return a},symbolWhenUnfocused:function(g){a.update({symbolWhenUnfocused:g});return a},selectNumberOnly:function(g){a.settings.selectNumberOnly=g;return a},selectOnFocus:function(g){a.settings.selectOnFocus=g;return a},serializeSpaces:function(g){a.settings.serializeSpaces=g;return a},showOnlyNumbersOnFocus:function(g){a.update({showOnlyNumbersOnFocus:g});return a},showPositiveSign:function(g){a.update({showPositiveSign:g});return a},showWarnings:function(g){a.settings.showWarnings=g;return a},styleRules:function(g){a.update({styleRules:g});
return a},suffixText:function(g){a.update({suffixText:g});return a},unformatOnHover:function(g){a.settings.unformatOnHover=g;return a},unformatOnSubmit:function(g){a.settings.unformatOnSubmit=g;return a},upDownStep:function(g){a.settings.upDownStep=g;return a},valuesToStrings:function(g){a.update({valuesToStrings:g});return a},watchExternalChanges:function(g){a.update({watchExternalChanges:g});return a},wheelOn:function(g){a.settings.wheelOn=g;return a},wheelStep:function(g){a.settings.wheelStep=
g;return a}};this._triggerEvent(d.events.initialized,this.domElement,{newValue:c["default"].getElementValue(this.domElement),newRawValue:this.rawValue,error:null,aNElement:this})}v(d,[{key:"_saveInitialValues",value:function(a){this.initialValueHtmlAttribute=c["default"].scientificToDecimal(this.domElement.getAttribute("value"));c["default"].isNull(this.initialValueHtmlAttribute)&&(this.initialValueHtmlAttribute="");this.initialValue=a;c["default"].isNull(this.initialValue)&&(this.initialValue="")}},
{key:"_createEventListeners",value:function(){var a=this;this.formulaMode=!1;this._onFocusInFunc=function(b){a._onFocusIn(b)};this._onFocusInAndMouseEnterFunc=function(b){a._onFocusInAndMouseEnter(b)};this._onFocusFunc=function(){a._onFocus()};this._onKeydownFunc=function(b){a._onKeydown(b)};this._onKeypressFunc=function(b){a._onKeypress(b)};this._onKeyupFunc=function(b){a._onKeyup(b)};this._onFocusOutAndMouseLeaveFunc=function(b){a._onFocusOutAndMouseLeave(b)};this._onPasteFunc=function(b){a._onPaste(b)};
this._onWheelFunc=function(b){a._onWheel(b)};this._onDropFunc=function(b){a._onDrop(b)};this._onKeydownGlobalFunc=function(b){a._onKeydownGlobal(b)};this._onKeyupGlobalFunc=function(b){a._onKeyupGlobal(b)};this.domElement.addEventListener("focusin",this._onFocusInFunc,!1);this.domElement.addEventListener("focus",this._onFocusInAndMouseEnterFunc,!1);this.domElement.addEventListener("focus",this._onFocusFunc,!1);this.domElement.addEventListener("mouseenter",this._onFocusInAndMouseEnterFunc,!1);this.domElement.addEventListener("keydown",
this._onKeydownFunc,!1);this.domElement.addEventListener("keypress",this._onKeypressFunc,!1);this.domElement.addEventListener("keyup",this._onKeyupFunc,!1);this.domElement.addEventListener("blur",this._onFocusOutAndMouseLeaveFunc,!1);this.domElement.addEventListener("mouseleave",this._onFocusOutAndMouseLeaveFunc,!1);this.domElement.addEventListener("paste",this._onPasteFunc,!1);this.domElement.addEventListener("wheel",this._onWheelFunc,!1);this.domElement.addEventListener("drop",this._onDropFunc,
!1);this._setupFormListener();this.hasEventListeners=!0;d._doesGlobalListExists()||(document.addEventListener("keydown",this._onKeydownGlobalFunc,!1),document.addEventListener("keyup",this._onKeyupGlobalFunc,!1))}},{key:"_removeEventListeners",value:function(){this.domElement.removeEventListener("focusin",this._onFocusInFunc,!1);this.domElement.removeEventListener("focus",this._onFocusInAndMouseEnterFunc,!1);this.domElement.removeEventListener("focus",this._onFocusFunc,!1);this.domElement.removeEventListener("mouseenter",
this._onFocusInAndMouseEnterFunc,!1);this.domElement.removeEventListener("blur",this._onFocusOutAndMouseLeaveFunc,!1);this.domElement.removeEventListener("mouseleave",this._onFocusOutAndMouseLeaveFunc,!1);this.domElement.removeEventListener("keydown",this._onKeydownFunc,!1);this.domElement.removeEventListener("keypress",this._onKeypressFunc,!1);this.domElement.removeEventListener("keyup",this._onKeyupFunc,!1);this.domElement.removeEventListener("paste",this._onPasteFunc,!1);this.domElement.removeEventListener("wheel",
this._onWheelFunc,!1);this.domElement.removeEventListener("drop",this._onDropFunc,!1);this._removeFormListener();this.hasEventListeners=!1;document.removeEventListener("keydown",this._onKeydownGlobalFunc,!1);document.removeEventListener("keyup",this._onKeyupGlobalFunc,!1)}},{key:"_updateEventListeners",value:function(){this.settings.noEventListeners||this.hasEventListeners||this._createEventListeners();this.settings.noEventListeners&&this.hasEventListeners&&this._removeEventListeners()}},{key:"_setupFormListener",
value:function(){var a=this;c["default"].isNull(this.parentForm)||(this._onFormSubmitFunc=function(){a._onFormSubmit()},this._onFormResetFunc=function(){a._onFormReset()},this._hasParentFormCounter()?this._incrementParentFormCounter():(this._initializeFormCounterToOne(),this.parentForm.addEventListener("submit",this._onFormSubmitFunc,!1),this.parentForm.addEventListener("reset",this._onFormResetFunc,!1),this._storeFormHandlerFunction()))}},{key:"_removeFormListener",value:function(){if(!c["default"].isNull(this.parentForm)){var a=
this._getParentFormCounter();1===a?(this.parentForm.removeEventListener("submit",this._getFormHandlerFunction().submitFn,!1),this.parentForm.removeEventListener("reset",this._getFormHandlerFunction().resetFn,!1),this._removeFormDataSetInfo()):1<a?this._decrementParentFormCounter():c["default"].throwError("The AutoNumeric object count on the form is incoherent.")}}},{key:"_hasParentFormCounter",value:function(){return"anCount"in this.parentForm.dataset}},{key:"_getParentFormCounter",value:function(){return Number(this.parentForm.dataset.anCount)}},
{key:"_initializeFormCounterToOne",value:function(){this._getFormElement(0<arguments.length&&void 0!==arguments[0]?arguments[0]:null).dataset.anCount=1}},{key:"_incrementParentFormCounter",value:function(){this._getFormElement(0<arguments.length&&void 0!==arguments[0]?arguments[0]:null).dataset.anCount++}},{key:"_decrementParentFormCounter",value:function(){this.parentForm.dataset.anCount--}},{key:"_hasFormHandlerFunction",value:function(){return"anFormHandler"in this._getFormElement(0<arguments.length&&
void 0!==arguments[0]?arguments[0]:null).dataset}},{key:"_getFormElement",value:function(){var a=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null;return c["default"].isNull(a)?this.parentForm:a}},{key:"_storeFormHandlerFunction",value:function(){var a=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null;this.constructor._doesFormHandlerListExists()||this.constructor._createFormHandlerList();var b=c["default"].randomString();this._getFormElement(a).dataset.anFormHandler=b;window.aNFormHandlerMap.set(b,
{submitFn:this._onFormSubmitFunc,resetFn:this._onFormResetFunc})}},{key:"_getFormHandlerKey",value:function(){this._hasFormHandlerFunction()||c["default"].throwError("Unable to retrieve the form handler name");var a=this.parentForm.dataset.anFormHandler;""===a&&c["default"].throwError("The form handler name is invalid");return a}},{key:"_getFormHandlerFunction",value:function(){var a=this._getFormHandlerKey();return window.aNFormHandlerMap.get(a)}},{key:"_removeFormDataSetInfo",value:function(){this._decrementParentFormCounter();
window.aNFormHandlerMap["delete"](this._getFormHandlerKey());this.parentForm.removeAttribute("data-an-count");this.parentForm.removeAttribute("data-an-form-handler")}},{key:"_setWritePermissions",value:function(){0<arguments.length&&void 0!==arguments[0]&&arguments[0]&&this.domElement.readOnly||this.settings.readOnly?this._setReadOnly():this._setReadWrite()}},{key:"_setReadOnly",value:function(){this.isInputElement?this.domElement.readOnly=!0:this.domElement.setAttribute("contenteditable",!1)}},{key:"_setReadWrite",
value:function(){this.isInputElement?this.domElement.readOnly=!1:this.domElement.setAttribute("contenteditable",!0)}},{key:"_addWatcher",value:function(){var a=this;if(!c["default"].isUndefined(this.getterSetter)){var b=this.getterSetter,e=b.set,h=b.get;Object.defineProperty(this.domElement,this.attributeToWatch,{configurable:!0,get:function(){return h.call(a.domElement)},set:function(g){e.call(a.domElement,g);a.settings.watchExternalChanges&&!a.internalModification&&a.set(g)}})}}},{key:"_removeWatcher",
value:function(){var a=this;if(!c["default"].isUndefined(this.getterSetter)){var b=this.getterSetter,e=b.set,h=b.get;Object.defineProperty(this.domElement,this.attributeToWatch,{configurable:!0,get:function(){return h.call(a.domElement)},set:function(g){e.call(a.domElement,g)}})}}},{key:"_getAttributeToWatch",value:function(){if(this.isInputElement)var a="value";else{var b=this.domElement.nodeType;b===Node.ELEMENT_NODE||b===Node.DOCUMENT_NODE||b===Node.DOCUMENT_FRAGMENT_NODE?a="textContent":b===Node.TEXT_NODE&&
(a="nodeValue")}return a}},{key:"_historyTableAdd",value:function(){var a=0===this.historyTable.length;if(a||this.rawValue!==this._historyTableCurrentValueUsed()){var b=!0;a||(a=this.historyTableIndex+1,a<this.historyTable.length&&this.rawValue===this.historyTable[a].value?b=!1:c["default"].arrayTrim(this.historyTable,this.historyTableIndex+1));this.historyTableIndex++;b&&(b=c["default"].getElementSelection(this.domElement),this.selectionStart=b.start,this.selectionEnd=b.end,this.historyTable.push({value:this.rawValue,
start:this.selectionStart+1,end:this.selectionEnd+1}),1<this.historyTable.length&&(this.historyTable[this.historyTableIndex-1].start=this.selectionStart,this.historyTable[this.historyTableIndex-1].end=this.selectionEnd));this.historyTable.length>this.settings.historySize&&this._historyTableForget()}}},{key:"_historyTableUndoOrRedo",value:function(){var a;(0<arguments.length&&void 0!==arguments[0]?arguments[0]:1)?(a=0<this.historyTableIndex)&&this.historyTableIndex--:(a=this.historyTableIndex+1<this.historyTable.length)&&
this.historyTableIndex++;a&&(a=this.historyTable[this.historyTableIndex],this.set(a.value,null,!1),c["default"].setElementSelection(this.domElement,a.start,a.end))}},{key:"_historyTableUndo",value:function(){this._historyTableUndoOrRedo(!0)}},{key:"_historyTableRedo",value:function(){this._historyTableUndoOrRedo(!1)}},{key:"_historyTableForget",value:function(){for(var a=0<arguments.length&&void 0!==arguments[0]?arguments[0]:1,b=[],e=0;e<a;e++)b.push(this.historyTable.shift()),this.historyTableIndex--,
0>this.historyTableIndex&&(this.historyTableIndex=0);return 1===b.length?b[0]:b}},{key:"_historyTableCurrentValueUsed",value:function(){var a=this.historyTableIndex;0>a&&(a=0);return c["default"].isUndefinedOrNullOrEmpty(this.historyTable[a])?"":this.historyTable[a].value}},{key:"_parseStyleRules",value:function(){var a=this;c["default"].isUndefinedOrNullOrEmpty(this.settings.styleRules)||""===this.rawValue||(c["default"].isUndefinedOrNullOrEmpty(this.settings.styleRules.positive)||(0<=this.rawValue?
this._addCSSClass(this.settings.styleRules.positive):this._removeCSSClass(this.settings.styleRules.positive)),c["default"].isUndefinedOrNullOrEmpty(this.settings.styleRules.negative)||(0>this.rawValue?this._addCSSClass(this.settings.styleRules.negative):this._removeCSSClass(this.settings.styleRules.negative)),c["default"].isUndefinedOrNullOrEmpty(this.settings.styleRules.ranges)||0===this.settings.styleRules.ranges.length||this.settings.styleRules.ranges.forEach(function(b){a.rawValue>=b.min&&a.rawValue<
b.max?a._addCSSClass(b["class"]):a._removeCSSClass(b["class"])}),c["default"].isUndefinedOrNullOrEmpty(this.settings.styleRules.userDefined)||0===this.settings.styleRules.userDefined.length||this.settings.styleRules.userDefined.forEach(function(b){if(c["default"].isFunction(b.callback))if(c["default"].isString(b.classes))b.callback(a.rawValue)?a._addCSSClass(b.classes):a._removeCSSClass(b.classes);else if(c["default"].isArray(b.classes))if(2===b.classes.length)b.callback(a.rawValue)?(a._addCSSClass(b.classes[0]),
a._removeCSSClass(b.classes[1])):(a._removeCSSClass(b.classes[0]),a._addCSSClass(b.classes[1]));else if(2<b.classes.length){var e=b.callback(a.rawValue);c["default"].isArray(e)?b.classes.forEach(function(h,g){c["default"].isInArray(g,e)?a._addCSSClass(h):a._removeCSSClass(h)}):c["default"].isInt(e)?b.classes.forEach(function(h,g){g===e?a._addCSSClass(h):a._removeCSSClass(h)}):c["default"].isNull(e)?b.classes.forEach(function(h){a._removeCSSClass(h)}):c["default"].throwError("The callback result is not an array nor a valid array index, ".concat(x(e),
" given."))}else c["default"].throwError("The classes attribute is not valid for the `styleRules` option.");else c["default"].isUndefinedOrNullOrEmpty(b.classes)?b.callback(a):c["default"].throwError("The callback/classes structure is not valid for the `styleRules` option.");else c["default"].warning("The given `styleRules` callback is not a function, ".concat(x(b.callback)," given."),a.settings.showWarnings)}))}},{key:"_addCSSClass",value:function(a){this.domElement.classList.add(a)}},{key:"_removeCSSClass",
value:function(a){this.domElement.classList.remove(a)}},{key:"update",value:function(){for(var a=this,b=arguments.length,e=Array(b),h=0;h<b;h++)e[h]=arguments[h];Array.isArray(e)&&Array.isArray(e[0])&&(e=e[0]);b=c["default"].cloneObject(this.settings);h=this.rawValue;var g={};c["default"].isUndefinedOrNullOrEmpty(e)||0===e.length?g=null:1<=e.length&&e.forEach(function(l){a.constructor._isPreDefinedOptionValid(l)&&(l=a.constructor._getOptionObject(l));E(g,l)});try{this._setSettings(g,!0),this._setWritePermissions(),
this._updateEventListeners(),this.set(h)}catch(l){this._setSettings(b,!0),c["default"].throwError("Unable to update the settings, those are invalid: [".concat(l,"]"))}return this}},{key:"getSettings",value:function(){return this.settings}},{key:"set",value:function(a){var b=1<arguments.length&&void 0!==arguments[1]?arguments[1]:null,e=2<arguments.length&&void 0!==arguments[2]?arguments[2]:!0;if(c["default"].isUndefined(a))return c["default"].warning("You are trying to set an 'undefined' value ; an error could have occurred.",
this.settings.showWarnings),this;c["default"].isNull(b)||this._setSettings(b,!0);if(null===a&&this.settings.emptyInputBehavior!==d.options.emptyInputBehavior["null"])return c["default"].warning("You are trying to set the `null` value while the `emptyInputBehavior` option is set to ".concat(this.settings.emptyInputBehavior,". If you want to be able to set the `null` value, you need to change the 'emptyInputBehavior' option to `'null'`."),this.settings.showWarnings),this;if(null===a)return this._setElementAndRawValue(null,
null,e),this._saveValueToPersistentStorage(),this;b=this.constructor._toNumericValue(a,this.settings);if(isNaN(Number(b)))return c["default"].warning("The value you are trying to set results in `NaN`. The element value is set to the empty string instead.",this.settings.showWarnings),this.setValue("",e),this;if(""===b)switch(this.settings.emptyInputBehavior){case d.options.emptyInputBehavior.zero:b=0;break;case d.options.emptyInputBehavior.min:b=this.settings.minimumValue;break;case d.options.emptyInputBehavior.max:b=
this.settings.maximumValue;break;default:c["default"].isNumber(this.settings.emptyInputBehavior)&&(b=Number(this.settings.emptyInputBehavior))}if(""!==b){var h=this.constructor._checkIfInRangeWithOverrideOption(b,this.settings),g=w(h,2);h=g[0];g=g[1];if(h&&g&&this.settings.valuesToStrings&&this._checkValuesToStrings(b))return this._setElementAndRawValue(this.settings.valuesToStrings[b],b,e),this._saveValueToPersistentStorage(),this;c["default"].isZeroOrHasNoValue(b)&&(b="0");h&&g?(h=this.constructor._roundRawValue(b,
this.settings),h=this._trimLeadingAndTrailingZeros(h.replace(this.settings.decimalCharacter,".")),b=this._getRawValueToFormat(b),this.isFocused?b=this.constructor._roundFormattedValueShownOnFocus(b,this.settings):(this.settings.divisorWhenUnfocused&&(b/=this.settings.divisorWhenUnfocused,b=b.toString()),b=this.constructor._roundFormattedValueShownOnBlur(b,this.settings)),b=this.constructor._modifyNegativeSignAndDecimalCharacterForFormattedValue(b,this.settings),b=this.constructor._addGroupSeparators(b,
this.settings,this.isFocused,this.rawValue,h),!this.isFocused&&this.settings.symbolWhenUnfocused&&(b="".concat(b).concat(this.settings.symbolWhenUnfocused)),(this.settings.decimalPlacesShownOnFocus||this.settings.divisorWhenUnfocused)&&this._saveValueToPersistentStorage(),this._setElementAndRawValue(b,h,e),this._setValidOrInvalidState(h)):(this._triggerRangeEvents(h,g),c["default"].throwError("The value [".concat(b,"] being set falls outside of the minimumValue [").concat(this.settings.minimumValue,
"] and maximumValue [").concat(this.settings.maximumValue,"] range set for this element")),this._removeValueFromPersistentStorage(),this.setValue("",e))}else this._setElementAndRawValue(this.settings.emptyInputBehavior===d.options.emptyInputBehavior.always?this.settings.currencySymbol:"","",e);return this}},{key:"setUnformatted",value:function(a){var b=1<arguments.length&&void 0!==arguments[1]?arguments[1]:null;if(null===a||c["default"].isUndefined(a))return this;c["default"].isNull(b)||this._setSettings(b,
!0);b=this.constructor._removeBrackets(a,this.settings);b=this.constructor._stripAllNonNumberCharacters(b,this.settings,!0,this.isFocused);c["default"].isNumber(b)||c["default"].throwError("The value is not a valid one, it's not a numeric string nor a recognized currency.");this.constructor._isWithinRangeWithOverrideOption(b,this.settings)?this.setValue(a):c["default"].throwError("The value is out of the range limits [".concat(this.settings.minimumValue,", ").concat(this.settings.maximumValue,"]."));
return this}},{key:"setValue",value:function(a){this._setElementAndRawValue(a,1<arguments.length&&void 0!==arguments[1]?arguments[1]:!0);return this}},{key:"_setRawValue",value:function(a){var b=this,e=1<arguments.length&&void 0!==arguments[1]?arguments[1]:!0;if(this.rawValue!==a){var h=this.rawValue;this.rawValue=a;!c["default"].isNull(this.settings.rawValueDivisor)&&0!==this.settings.rawValueDivisor&&""!==a&&null!==a&&this._isUserManuallyEditingTheValue()&&(this.rawValue/=this.settings.rawValueDivisor);
this._triggerEvent(d.events.rawValueModified,this.domElement,{oldRawValue:h,newRawValue:this.rawValue,isPristine:this.isPristine(!0),error:null,aNElement:this});this._parseStyleRules();e&&window.requestAnimationFrame(function(){return b._historyTableAdd()})}}},{key:"_setElementValue",value:function(a){var b=1<arguments.length&&void 0!==arguments[1]?arguments[1]:!0,e=c["default"].getElementValue(this.domElement);a!==e&&(this.internalModification=!0,c["default"].setElementValue(this.domElement,a),this.internalModification=
!1,b&&this._triggerEvent(d.events.formatted,this.domElement,{oldValue:e,newValue:a,oldRawValue:this.rawValue,newRawValue:this.rawValue,isPristine:this.isPristine(!1),error:null,aNElement:this}));return this}},{key:"_setElementAndRawValue",value:function(a){var b=1<arguments.length&&void 0!==arguments[1]?arguments[1]:null,e=2<arguments.length&&void 0!==arguments[2]?arguments[2]:!0;c["default"].isNull(b)?b=a:c["default"].isBoolean(b)&&(e=b,b=a);this._setElementValue(a);this._setRawValue(b,e);return this}},
{key:"_getRawValueToFormat",value:function(a){return c["default"].isNull(this.settings.rawValueDivisor)||0===this.settings.rawValueDivisor||""===a||null===a?a:a*this.settings.rawValueDivisor}},{key:"_checkValuesToStrings",value:function(a){return this.constructor._checkValuesToStringsArray(a,this.valuesToStringsKeys)}},{key:"_isUserManuallyEditingTheValue",value:function(){return this.isFocused&&this.isEditing||this.isDropEvent}},{key:"_executeCallback",value:function(a,b){!c["default"].isNull(b)&&
c["default"].isFunction(b)&&b(a,this)}},{key:"_triggerEvent",value:function(a){c["default"].triggerEvent(a,1<arguments.length&&void 0!==arguments[1]?arguments[1]:document,2<arguments.length&&void 0!==arguments[2]?arguments[2]:null,this.settings.eventBubbles,this.settings.eventIsCancelable)}},{key:"get",value:function(){return this.getNumericString(0<arguments.length&&void 0!==arguments[0]?arguments[0]:null)}},{key:"getNumericString",value:function(){var a=0<arguments.length&&void 0!==arguments[0]?
arguments[0]:null;var b=c["default"].isNull(this.rawValue)?null:c["default"].trimPaddedZerosFromDecimalPlaces(this.rawValue);this._executeCallback(b,a);return b}},{key:"getFormatted",value:function(){var a=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null;"value"in this.domElement||"textContent"in this.domElement||c["default"].throwError("Unable to get the formatted string from the element.");var b=c["default"].getElementValue(this.domElement);this._executeCallback(b,a);return b}},{key:"getNumber",
value:function(){var a=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null;var b=null===this.rawValue?null:this.constructor._toLocale(this.getNumericString(),"number",this.settings);this._executeCallback(b,a);return b}},{key:"getLocalized",value:function(){var a=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null,b=1<arguments.length&&void 0!==arguments[1]?arguments[1]:null;c["default"].isFunction(a)&&c["default"].isNull(b)&&(b=a,a=null);var e=c["default"].isEmptyString(this.rawValue)?
"":""+Number(this.rawValue);""!==e&&0===Number(e)&&this.settings.leadingZero!==d.options.leadingZero.keep&&(e="0");a=c["default"].isNull(a)?this.settings.outputFormat:a;e=this.constructor._toLocale(e,a,this.settings);this._executeCallback(e,b);return e}},{key:"reformat",value:function(){this.set(this.rawValue);return this}},{key:"unformat",value:function(){this._setElementValue(this.getNumericString());return this}},{key:"unformatLocalized",value:function(){this._setElementValue(this.getLocalized(0<
arguments.length&&void 0!==arguments[0]?arguments[0]:null));return this}},{key:"isPristine",value:function(){return(0<arguments.length&&void 0!==arguments[0]?arguments[0]:1)?this.initialValue===this.getNumericString():this.initialValueHtmlAttribute===this.getFormatted()}},{key:"select",value:function(){this.settings.selectNumberOnly?this.selectNumber():this._defaultSelectAll();return this}},{key:"_defaultSelectAll",value:function(){c["default"].setElementSelection(this.domElement,0,c["default"].getElementValue(this.domElement).length)}},
{key:"selectNumber",value:function(){var a=c["default"].getElementValue(this.domElement),b=a.length,e=this.settings.currencySymbol.length,h=this.settings.currencySymbolPlacement,g=c["default"].isNegative(a,this.settings.negativeSignCharacter)?1:0,l=this.settings.suffixText.length;a=h===d.options.currencySymbolPlacement.suffix?0:this.settings.negativePositiveSignPlacement===d.options.negativePositiveSignPlacement.left&&1===g&&0<e?e+1:e;if(h===d.options.currencySymbolPlacement.prefix)b-=l;else switch(this.settings.negativePositiveSignPlacement){case d.options.negativePositiveSignPlacement.left:b-=
l+e;break;case d.options.negativePositiveSignPlacement.right:b=0<e?b-(e+g+l):b-(e+l);break;default:b-=e+l}c["default"].setElementSelection(this.domElement,a,b);return this}},{key:"selectInteger",value:function(){var a=0,b=0<=this.rawValue;if(this.settings.currencySymbolPlacement===d.options.currencySymbolPlacement.prefix||this.settings.currencySymbolPlacement===d.options.currencySymbolPlacement.suffix&&(this.settings.negativePositiveSignPlacement===d.options.negativePositiveSignPlacement.prefix||
this.settings.negativePositiveSignPlacement===d.options.negativePositiveSignPlacement.none))if(this.settings.showPositiveSign&&b||!b&&this.settings.currencySymbolPlacement===d.options.currencySymbolPlacement.prefix&&this.settings.negativePositiveSignPlacement===d.options.negativePositiveSignPlacement.left)a+=1;this.settings.currencySymbolPlacement===d.options.currencySymbolPlacement.prefix&&(a+=this.settings.currencySymbol.length);var e=c["default"].getElementValue(this.domElement),h=e.indexOf(this.settings.decimalCharacter);
-1===h&&(h=this.settings.currencySymbolPlacement===d.options.currencySymbolPlacement.suffix?e.length-this.settings.currencySymbol.length:e.length,b||this.settings.negativePositiveSignPlacement!==d.options.negativePositiveSignPlacement.suffix&&this.settings.currencySymbolPlacement!==d.options.currencySymbolPlacement.suffix||--h,h-=this.settings.suffixText.length);c["default"].setElementSelection(this.domElement,a,h);return this}},{key:"selectDecimal",value:function(){var a=c["default"].getElementValue(this.domElement).indexOf(this.settings.decimalCharacter);
if(-1===a)var b=a=0;else a+=1,b=a+Number(this.isFocused?this.settings.decimalPlacesShownOnFocus:this.settings.decimalPlacesShownOnBlur);c["default"].setElementSelection(this.domElement,a,b);return this}},{key:"node",value:function(){return this.domElement}},{key:"parent",value:function(){return this.domElement.parentNode}},{key:"detach",value:function(){var a=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null;a=c["default"].isNull(a)?this.domElement:a.node();this._removeFromLocalList(a);
return this}},{key:"attach",value:function(a){var b=1<arguments.length&&void 0!==arguments[1]?arguments[1]:!0;this._addToLocalList(a.node());b&&a.update(this.settings);return this}},{key:"formatOther",value:function(a){return this._formatOrUnformatOther(!0,a,1<arguments.length&&void 0!==arguments[1]?arguments[1]:null)}},{key:"unformatOther",value:function(a){return this._formatOrUnformatOther(!1,a,1<arguments.length&&void 0!==arguments[1]?arguments[1]:null)}},{key:"_formatOrUnformatOther",value:function(a,
b){var e=2<arguments.length&&void 0!==arguments[2]?arguments[2]:null;e=c["default"].isNull(e)?this.settings:this._cloneAndMergeSettings(e);if(c["default"].isElement(b)){var h=c["default"].getElementValue(b);e=a?d.format(h,e):d.unformat(h,e);c["default"].setElementValue(b,e);return null}return e=a?d.format(b,e):d.unformat(b,e)}},{key:"init",value:function(a){var b=this,e=1<arguments.length&&void 0!==arguments[1]?arguments[1]:!0,h=!1,g=[];c["default"].isString(a)?g=q(document.querySelectorAll(a)):c["default"].isElement(a)?
(g.push(a),h=!0):c["default"].isArray(a)?g=a:c["default"].throwError("The given parameters to the 'init' function are invalid.");if(0===g.length)return c["default"].warning("No valid DOM elements were given hence no AutoNumeric object were instantiated.",!0),[];var l=this._getLocalList(),p=[];g.forEach(function(r){var u=b.settings.createLocalList;e&&(b.settings.createLocalList=!1);var F=new d(r,c["default"].getElementValue(r),b.settings);e&&(F._setLocalList(l),b._addToLocalList(r,F),b.settings.createLocalList=
u);p.push(F)});return h?p[0]:p}},{key:"clear",value:function(){0<arguments.length&&void 0!==arguments[0]&&arguments[0]?this.set("",{emptyInputBehavior:d.options.emptyInputBehavior.focus}):this.set("");return this}},{key:"remove",value:function(){this._removeValueFromPersistentStorage();this._removeEventListeners();this._removeWatcher();this._removeFromLocalList(this.domElement);this.constructor._removeFromGlobalList(this)}},{key:"wipe",value:function(){this._setElementValue("",!1);this.remove()}},
{key:"nuke",value:function(){this.remove();this.domElement.parentNode.removeChild(this.domElement)}},{key:"form",value:function(){if(0<arguments.length&&void 0!==arguments[0]&&arguments[0]||c["default"].isUndefinedOrNullOrEmpty(this.parentForm)){var a=this._getParentForm();if(!c["default"].isNull(a)&&a!==this.parentForm){var b=this._getFormAutoNumericChildren(this.parentForm);this.parentForm.dataset.anCount=b.length;this._hasFormHandlerFunction(a)?this._incrementParentFormCounter(a):(this._storeFormHandlerFunction(a),
this._initializeFormCounterToOne(a))}this.parentForm=a}return this.parentForm}},{key:"_getFormAutoNumericChildren",value:function(a){var b=this,e=q(a.elements);a=this._getContenteditableElements(a);return c["default"].arrayUnique(e,a).filter(function(h){return b.constructor.isManagedByAutoNumeric(h)})}},{key:"_getContenteditableElements",value:function(a){if(c["default"].isUndefinedOrNullOrEmpty(a)||!a.hasAttribute("id"))return[];var b=q(a.querySelectorAll("[contenteditable\x3dtrue]"));a=q(document.querySelectorAll("*:not(input)[form\x3d".concat(a.id,
"][contenteditable\x3dtrue]")));return c["default"].arrayUnique(b,a)}},{key:"_getParentForm",value:function(){if(!c["default"].isUndefined(this.domElement.form))return this.domElement.form;if("body"===this.domElement.tagName.toLowerCase())return null;var a=this.domElement;do{a=a.parentNode;if(c["default"].isNull(a))return null;var b=a.tagName?a.tagName.toLowerCase():"";if("body"===b)break}while("form"!==b);return"form"===b?a:null}},{key:"formNumericString",value:function(){return this.constructor._serializeNumericString(this.form(),
this.settings.serializeSpaces)}},{key:"formFormatted",value:function(){return this.constructor._serializeFormatted(this.form(),this.settings.serializeSpaces)}},{key:"formLocalized",value:function(){var a=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null;a=c["default"].isNull(a)?this.settings.outputFormat:a;return this.constructor._serializeLocalized(this.form(),this.settings.serializeSpaces,a)}},{key:"formArrayNumericString",value:function(){return this.constructor._serializeNumericStringArray(this.form(),
this.settings.serializeSpaces)}},{key:"formArrayFormatted",value:function(){return this.constructor._serializeFormattedArray(this.form(),this.settings.serializeSpaces)}},{key:"formArrayLocalized",value:function(){var a=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null;a=c["default"].isNull(a)?this.settings.outputFormat:a;return this.constructor._serializeLocalizedArray(this.form(),this.settings.serializeSpaces,a)}},{key:"formJsonNumericString",value:function(){return JSON.stringify(this.formArrayNumericString())}},
{key:"formJsonFormatted",value:function(){return JSON.stringify(this.formArrayFormatted())}},{key:"formJsonLocalized",value:function(){return JSON.stringify(this.formArrayLocalized(0<arguments.length&&void 0!==arguments[0]?arguments[0]:null))}},{key:"formUnformat",value:function(){this.constructor._getChildANInputElement(this.form()).forEach(function(a){d.getAutoNumericElement(a).unformat()});return this}},{key:"formUnformatLocalized",value:function(){this.constructor._getChildANInputElement(this.form()).forEach(function(a){d.getAutoNumericElement(a).unformatLocalized()});
return this}},{key:"formReformat",value:function(){this.constructor._getChildANInputElement(this.form()).forEach(function(a){d.getAutoNumericElement(a).reformat()});return this}},{key:"formSubmitNumericString",value:function(){var a=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null;c["default"].isNull(a)?(this.formUnformat(),this.form().submit(),this.formReformat()):c["default"].isFunction(a)?a(this.formNumericString()):c["default"].throwError("The given callback is not a function.");return this}},
{key:"formSubmitFormatted",value:function(){var a=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null;c["default"].isNull(a)?this.form().submit():c["default"].isFunction(a)?a(this.formFormatted()):c["default"].throwError("The given callback is not a function.");return this}},{key:"formSubmitLocalized",value:function(){var a=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null,b=1<arguments.length&&void 0!==arguments[1]?arguments[1]:null;c["default"].isNull(b)?(this.formUnformatLocalized(),
this.form().submit(),this.formReformat()):c["default"].isFunction(b)?b(this.formLocalized(a)):c["default"].throwError("The given callback is not a function.");return this}},{key:"formSubmitArrayNumericString",value:function(a){c["default"].isFunction(a)?a(this.formArrayNumericString()):c["default"].throwError("The given callback is not a function.");return this}},{key:"formSubmitArrayFormatted",value:function(a){c["default"].isFunction(a)?a(this.formArrayFormatted()):c["default"].throwError("The given callback is not a function.");
return this}},{key:"formSubmitArrayLocalized",value:function(a){var b=1<arguments.length&&void 0!==arguments[1]?arguments[1]:null;c["default"].isFunction(a)?a(this.formArrayLocalized(b)):c["default"].throwError("The given callback is not a function.");return this}},{key:"formSubmitJsonNumericString",value:function(a){c["default"].isFunction(a)?a(this.formJsonNumericString()):c["default"].throwError("The given callback is not a function.");return this}},{key:"formSubmitJsonFormatted",value:function(a){c["default"].isFunction(a)?
a(this.formJsonFormatted()):c["default"].throwError("The given callback is not a function.");return this}},{key:"formSubmitJsonLocalized",value:function(a){var b=1<arguments.length&&void 0!==arguments[1]?arguments[1]:null;c["default"].isFunction(a)?a(this.formJsonLocalized(b)):c["default"].throwError("The given callback is not a function.");return this}},{key:"_createLocalList",value:function(){this.autoNumericLocalList=new Map;this._addToLocalList(this.domElement)}},{key:"_deleteLocalList",value:function(){delete this.autoNumericLocalList}},
{key:"_setLocalList",value:function(a){this.autoNumericLocalList=a}},{key:"_getLocalList",value:function(){return this.autoNumericLocalList}},{key:"_hasLocalList",value:function(){return this.autoNumericLocalList instanceof Map&&0!==this.autoNumericLocalList.size}},{key:"_addToLocalList",value:function(a){var b=1<arguments.length&&void 0!==arguments[1]?arguments[1]:null;c["default"].isNull(b)&&(b=this);c["default"].isUndefined(this.autoNumericLocalList)?c["default"].throwError("The local list provided does not exists when trying to add an element. [".concat(this.autoNumericLocalList,
"] given.")):this.autoNumericLocalList.set(a,b)}},{key:"_removeFromLocalList",value:function(a){if(c["default"].isUndefined(this.autoNumericLocalList))this.settings.createLocalList&&c["default"].throwError("The local list provided does not exists when trying to remove an element. [".concat(this.autoNumericLocalList,"] given."));else this.autoNumericLocalList["delete"](a)}},{key:"_mergeSettings",value:function(){for(var a=arguments.length,b=Array(a),e=0;e<a;e++)b[e]=arguments[e];E.apply(void 0,[this.settings].concat(b))}},
{key:"_cloneAndMergeSettings",value:function(){for(var a={},b=arguments.length,e=Array(b),h=0;h<b;h++)e[h]=arguments[h];E.apply(void 0,[a,this.settings].concat(e));return a}},{key:"_updatePredefinedOptions",value:function(a){var b=1<arguments.length&&void 0!==arguments[1]?arguments[1]:null;c["default"].isNull(b)?this.update(a):(this._mergeSettings(a,b),this.update(this.settings));return this}},{key:"french",value:function(){var a=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null;this._updatePredefinedOptions(d.getPredefinedOptions().French,
a);return this}},{key:"northAmerican",value:function(){var a=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null;this._updatePredefinedOptions(d.getPredefinedOptions().NorthAmerican,a);return this}},{key:"british",value:function(){var a=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null;this._updatePredefinedOptions(d.getPredefinedOptions().British,a);return this}},{key:"swiss",value:function(){var a=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null;this._updatePredefinedOptions(d.getPredefinedOptions().Swiss,
a);return this}},{key:"japanese",value:function(){var a=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null;this._updatePredefinedOptions(d.getPredefinedOptions().Japanese,a);return this}},{key:"spanish",value:function(){var a=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null;this._updatePredefinedOptions(d.getPredefinedOptions().Spanish,a);return this}},{key:"chinese",value:function(){var a=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null;this._updatePredefinedOptions(d.getPredefinedOptions().Chinese,
a);return this}},{key:"brazilian",value:function(){var a=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null;this._updatePredefinedOptions(d.getPredefinedOptions().Brazilian,a);return this}},{key:"_runCallbacksFoundInTheSettingsObject",value:function(){for(var a in this.settings)if(Object.prototype.hasOwnProperty.call(this.settings,a)){var b=this.settings[a];"function"===typeof b?this.settings[a]=b(this,a):(b="",a in this.domElement.dataset&&(b=this.domElement.dataset[a]),b=c["default"].camelize(b),
"function"===typeof this.settings[b]&&(this.settings[a]=b(this,a)))}}},{key:"_setTrailingNegativeSignInfo",value:function(){this.isTrailingNegative=this.settings.currencySymbolPlacement===d.options.currencySymbolPlacement.prefix&&this.settings.negativePositiveSignPlacement===d.options.negativePositiveSignPlacement.suffix||this.settings.currencySymbolPlacement===d.options.currencySymbolPlacement.suffix&&(this.settings.negativePositiveSignPlacement===d.options.negativePositiveSignPlacement.left||this.settings.negativePositiveSignPlacement===
d.options.negativePositiveSignPlacement.right)}},{key:"_modifyNegativeSignAndDecimalCharacterForRawValue",value:function(a){"."!==this.settings.decimalCharacter&&(a=a.replace(this.settings.decimalCharacter,"."));"-"!==this.settings.negativeSignCharacter&&this.settings.isNegativeSignAllowed&&(a=a.replace(this.settings.negativeSignCharacter,"-"));a.match(/\d/)||(a+="0");return a}},{key:"_initialCaretPosition",value:function(a){c["default"].isNull(this.settings.caretPositionOnFocus)&&this.settings.selectOnFocus===
d.options.selectOnFocus.doNotSelect&&c["default"].throwError("`_initialCaretPosition()` should never be called when the `caretPositionOnFocus` option is `null`.");var b=0>this.rawValue,e=c["default"].isZeroOrHasNoValue(a),h=a.length,g=0,l=0,p=0;if(this.settings.caretPositionOnFocus!==d.options.caretPositionOnFocus.start){a=a.replace(this.settings.negativeSignCharacter,"");a=a.replace(this.settings.positiveSignCharacter,"");a=a.replace(this.settings.currencySymbol,"");g=a.length;var r=c["default"].contains(a,
this.settings.decimalCharacter);if(this.settings.caretPositionOnFocus===d.options.caretPositionOnFocus.decimalLeft||this.settings.caretPositionOnFocus===d.options.caretPositionOnFocus.decimalRight)r?(l=a.indexOf(this.settings.decimalCharacter),p=this.settings.decimalCharacter.length):(l=g,p=0)}a="";b?a=this.settings.negativeSignCharacter:this.settings.showPositiveSign&&!e&&(a=this.settings.positiveSignCharacter);a=a.length;r=this.settings.currencySymbol.length;if(this.settings.currencySymbolPlacement===
d.options.currencySymbolPlacement.prefix)if(this.settings.caretPositionOnFocus===d.options.caretPositionOnFocus.start)if(this.settings.negativePositiveSignPlacement!==d.options.negativePositiveSignPlacement.none&&(b||!b&&this.settings.showPositiveSign&&!e))switch(this.settings.negativePositiveSignPlacement){case d.options.negativePositiveSignPlacement.prefix:case d.options.negativePositiveSignPlacement.left:case d.options.negativePositiveSignPlacement.right:var u=a+r;break;case d.options.negativePositiveSignPlacement.suffix:u=
r}else u=r;else if(this.settings.caretPositionOnFocus===d.options.caretPositionOnFocus.end)if(this.settings.negativePositiveSignPlacement!==d.options.negativePositiveSignPlacement.none&&(b||!b&&this.settings.showPositiveSign&&!e))switch(this.settings.negativePositiveSignPlacement){case d.options.negativePositiveSignPlacement.prefix:case d.options.negativePositiveSignPlacement.left:case d.options.negativePositiveSignPlacement.right:u=h;break;case d.options.negativePositiveSignPlacement.suffix:u=r+
g}else u=h;else if(this.settings.caretPositionOnFocus===d.options.caretPositionOnFocus.decimalLeft)if(this.settings.negativePositiveSignPlacement!==d.options.negativePositiveSignPlacement.none&&(b||!b&&this.settings.showPositiveSign&&!e))switch(this.settings.negativePositiveSignPlacement){case d.options.negativePositiveSignPlacement.prefix:case d.options.negativePositiveSignPlacement.left:case d.options.negativePositiveSignPlacement.right:u=a+r+l;break;case d.options.negativePositiveSignPlacement.suffix:u=
r+l}else u=r+l;else{if(this.settings.caretPositionOnFocus===d.options.caretPositionOnFocus.decimalRight)if(this.settings.negativePositiveSignPlacement!==d.options.negativePositiveSignPlacement.none&&(b||!b&&this.settings.showPositiveSign&&!e))switch(this.settings.negativePositiveSignPlacement){case d.options.negativePositiveSignPlacement.prefix:case d.options.negativePositiveSignPlacement.left:case d.options.negativePositiveSignPlacement.right:u=a+r+l+p;break;case d.options.negativePositiveSignPlacement.suffix:u=
r+l+p}else u=r+l+p}else if(this.settings.currencySymbolPlacement===d.options.currencySymbolPlacement.suffix)if(this.settings.caretPositionOnFocus===d.options.caretPositionOnFocus.start)if(this.settings.negativePositiveSignPlacement!==d.options.negativePositiveSignPlacement.none&&(b||!b&&this.settings.showPositiveSign&&!e))switch(this.settings.negativePositiveSignPlacement){case d.options.negativePositiveSignPlacement.suffix:case d.options.negativePositiveSignPlacement.right:case d.options.negativePositiveSignPlacement.left:u=
0;break;case d.options.negativePositiveSignPlacement.prefix:u=a}else u=0;else if(this.settings.caretPositionOnFocus===d.options.caretPositionOnFocus.end)if(this.settings.negativePositiveSignPlacement!==d.options.negativePositiveSignPlacement.none&&(b||!b&&this.settings.showPositiveSign&&!e))switch(this.settings.negativePositiveSignPlacement){case d.options.negativePositiveSignPlacement.suffix:case d.options.negativePositiveSignPlacement.right:case d.options.negativePositiveSignPlacement.left:u=g;
break;case d.options.negativePositiveSignPlacement.prefix:u=a+g}else u=g;else if(this.settings.caretPositionOnFocus===d.options.caretPositionOnFocus.decimalLeft)if(this.settings.negativePositiveSignPlacement!==d.options.negativePositiveSignPlacement.none&&(b||!b&&this.settings.showPositiveSign&&!e))switch(this.settings.negativePositiveSignPlacement){case d.options.negativePositiveSignPlacement.suffix:case d.options.negativePositiveSignPlacement.right:case d.options.negativePositiveSignPlacement.left:u=
l;break;case d.options.negativePositiveSignPlacement.prefix:u=a+l}else u=l;else if(this.settings.caretPositionOnFocus===d.options.caretPositionOnFocus.decimalRight)if(this.settings.negativePositiveSignPlacement!==d.options.negativePositiveSignPlacement.none&&(b||!b&&this.settings.showPositiveSign&&!e))switch(this.settings.negativePositiveSignPlacement){case d.options.negativePositiveSignPlacement.suffix:case d.options.negativePositiveSignPlacement.right:case d.options.negativePositiveSignPlacement.left:u=
l+p;break;case d.options.negativePositiveSignPlacement.prefix:u=a+l+p}else u=l+p;return u}},{key:"_triggerRangeEvents",value:function(a,b){a||this._triggerEvent(d.events.minRangeExceeded,this.domElement);b||this._triggerEvent(d.events.maxRangeExceeded,this.domElement)}},{key:"_setInvalidState",value:function(){this.isInputElement?c["default"].setInvalidState(this.domElement):this._addCSSClass(this.settings.invalidClass);this._triggerEvent(d.events.invalidValue,this.domElement);this.validState=!1}},
{key:"_setValidState",value:function(){this.isInputElement?c["default"].setValidState(this.domElement):this._removeCSSClass(this.settings.invalidClass);this.validState||this._triggerEvent(d.events.correctedValue,this.domElement);this.validState=!0}},{key:"_setValidOrInvalidState",value:function(a){if(this.settings.overrideMinMaxLimits===d.options.overrideMinMaxLimits.invalid){var b=this.constructor._isMinimumRangeRespected(a,this.settings);a=this.constructor._isMaximumRangeRespected(a,this.settings);
b&&a?this._setValidState():this._setInvalidState();this._triggerRangeEvents(b,a)}}},{key:"_keepAnOriginalSettingsCopy",value:function(){this.originalDigitGroupSeparator=this.settings.digitGroupSeparator;this.originalCurrencySymbol=this.settings.currencySymbol;this.originalSuffixText=this.settings.suffixText}},{key:"_trimLeadingAndTrailingZeros",value:function(a){if(""===a||null===a)return a;if(this.settings.leadingZero!==d.options.leadingZero.keep){if(0===Number(a))return"0";a=a.replace(/^(-)?0+(?=\d)/g,
"$1")}c["default"].contains(a,".")&&(a=a.replace(/(\.[0-9]*?)0+$/,"$1"));return a=a.replace(/\.$/,"")}},{key:"_setPersistentStorageName",value:function(){this.settings.saveValueToSessionStorage&&(""===this.domElement.name||c["default"].isUndefined(this.domElement.name)?this.rawValueStorageName="".concat(this.storageNamePrefix).concat(this.domElement.id):this.rawValueStorageName="".concat(this.storageNamePrefix).concat(decodeURIComponent(this.domElement.name)))}},{key:"_saveValueToPersistentStorage",
value:function(){this.settings.saveValueToSessionStorage&&sessionStorage.setItem(this.rawValueStorageName,this.rawValue)}},{key:"_getValueFromPersistentStorage",value:function(){if(this.settings.saveValueToSessionStorage)return sessionStorage.getItem(this.rawValueStorageName);c["default"].warning("`_getValueFromPersistentStorage()` is called but `settings.saveValueToSessionStorage` is false. There must be an error that needs fixing.",this.settings.showWarnings);return null}},{key:"_removeValueFromPersistentStorage",
value:function(){this.settings.saveValueToSessionStorage&&sessionStorage.removeItem(this.rawValueStorageName)}},{key:"_getDefaultValue",value:function(a){a=a.getAttribute("value");return c["default"].isNull(a)?"":a}},{key:"_onFocusInAndMouseEnter",value:function(a){this.isEditing=!1;if(!this.formulaMode&&this.settings.unformatOnHover&&"mouseenter"===a.type&&a.altKey)this.constructor._unformatAltHovered(this);else if("focus"===a.type&&(this.isFocused=!0,this.rawValueOnFocus=this.rawValue),"focus"===
a.type&&this.settings.unformatOnHover&&this.hoveredWithAlt&&this.constructor._reformatAltHovered(this),"focus"===a.type||"mouseenter"===a.type&&!this.isFocused){var b=null;this.settings.emptyInputBehavior===d.options.emptyInputBehavior.focus&&0>this.rawValue&&null!==this.settings.negativeBracketsTypeOnBlur&&this.settings.isNegativeSignAllowed&&(b=this.constructor._removeBrackets(c["default"].getElementValue(this.domElement),this.settings));var e=this._getRawValueToFormat(this.rawValue);""!==e&&(b=
this.constructor._roundFormattedValueShownOnFocusOrBlur(e,this.settings,this.isFocused),this.settings.showOnlyNumbersOnFocus===d.options.showOnlyNumbersOnFocus.onlyNumbers?(this.settings.digitGroupSeparator="",this.settings.currencySymbol="",this.settings.suffixText="",b=b.replace(".",this.settings.decimalCharacter)):b=c["default"].isNull(b)?"":this.constructor._addGroupSeparators(b.replace(".",this.settings.decimalCharacter),this.settings,this.isFocused,e));c["default"].isNull(b)?this.valueOnFocus=
"":this.valueOnFocus=b;this.lastVal=this.valueOnFocus;var h=this.constructor._isElementValueEmptyOrOnlyTheNegativeSign(this.valueOnFocus,this.settings);e=this.constructor._orderValueCurrencySymbolAndSuffixText(this.valueOnFocus,this.settings,!0);(h=h&&""!==e&&this.settings.emptyInputBehavior===d.options.emptyInputBehavior.focus)&&(b=e);c["default"].isNull(b)||this._setElementValue(b);h&&e===this.settings.currencySymbol&&this.settings.currencySymbolPlacement===d.options.currencySymbolPlacement.suffix&&
c["default"].setElementSelection(a.target,0)}}},{key:"_onFocus",value:function(){this.settings.isCancellable&&this._saveCancellableValue()}},{key:"_onFocusIn",value:function(a){this.settings.selectOnFocus?this.select():c["default"].isNull(this.settings.caretPositionOnFocus)||c["default"].setElementSelection(a.target,this._initialCaretPosition(c["default"].getElementValue(this.domElement)))}},{key:"_enterFormulaMode",value:function(){this.settings.formulaMode&&(this.formulaMode=!0,c["default"].setElementValue(this.domElement,
"\x3d"),c["default"].setElementSelection(this.domElement,1))}},{key:"_exitFormulaMode",value:function(){var a=c["default"].getElementValue(this.domElement);a=a.replace(/^\s*=/,"");try{var b=new m["default"](a,this.settings.decimalCharacter);var e=(new k["default"]).evaluate(b)}catch(h){this._triggerEvent(d.events.invalidFormula,this.domElement,{formula:a,aNElement:this});this.reformat();this.formulaMode=!1;return}this._triggerEvent(d.events.validFormula,this.domElement,{formula:a,result:e,aNElement:this});
this.set(e);this.formulaMode=!1}},{key:"_acceptNonPrintableKeysInFormulaMode",value:function(){return this.eventKey===f["default"].keyName.Backspace||this.eventKey===f["default"].keyName.Delete||this.eventKey===f["default"].keyName.LeftArrow||this.eventKey===f["default"].keyName.RightArrow||this.eventKey===f["default"].keyName.Home||this.eventKey===f["default"].keyName.End}},{key:"_onKeydown",value:function(a){this.formatted=!1;this.isEditing=!0;if(!this.formulaMode&&!this.isFocused&&this.settings.unformatOnHover&&
a.altKey&&this.domElement===c["default"].getHoveredElement())this.constructor._unformatAltHovered(this);else{this._updateEventKeyInfo(a);this.keydownEventCounter+=1;1===this.keydownEventCounter&&(this.initialValueOnFirstKeydown=c["default"].getElementValue(a.target),this.initialRawValueOnFirstKeydown=this.rawValue);if(this.formulaMode){if(this.eventKey===f["default"].keyName.Esc){this.formulaMode=!1;this.reformat();return}if(this.eventKey===f["default"].keyName.Enter){this._exitFormulaMode();return}if(this._acceptNonPrintableKeysInFormulaMode())return}else{if(this.eventKey===
f["default"].keyName.Equal){this._enterFormulaMode();return}if(this.settings.modifyValueOnUpDownArrow&&(this.eventKey===f["default"].keyName.UpArrow||this.eventKey===f["default"].keyName.DownArrow)){this.upDownArrowAction(a);return}}if(this.domElement.readOnly||this.settings.readOnly||this.domElement.disabled)this.processed=!0;else{this.eventKey===f["default"].keyName.Esc&&(a.preventDefault(),this.settings.isCancellable&&this.rawValue!==this.savedCancellableValue&&(this.set(this.savedCancellableValue),
this._triggerEvent(d.events["native"].input,a.target)),this.select());var b=c["default"].getElementValue(a.target);this.eventKey===f["default"].keyName.Enter&&this.rawValue!==this.rawValueOnFocus&&(this._triggerEvent(d.events["native"].change,a.target),this.valueOnFocus=b,this.rawValueOnFocus=this.rawValue,this.settings.isCancellable&&this._saveCancellableValue());this._updateInternalProperties(a);if(this._processNonPrintableKeysAndShortcuts(a))this.processed=!0;else if(this.eventKey===f["default"].keyName.Backspace||
this.eventKey===f["default"].keyName.Delete)b=this._processCharacterDeletion(a),this.processed=!0,b?(this._formatValue(a),b=c["default"].getElementValue(a.target),b!==this.lastVal&&this.throwInput&&(this._triggerEvent(d.events["native"].input,a.target),a.preventDefault()),this.lastVal=b,this.throwInput=!0):a.preventDefault()}}}},{key:"_onKeypress",value:function(a){if(this.formulaMode)this._acceptNonPrintableKeysInFormulaMode()||this.settings.formulaChars.test(this.eventKey)||a.preventDefault();else if(this.eventKey!==
f["default"].keyName.Insert){var b=this.processed;this._updateInternalProperties(a);this._processNonPrintableKeysAndShortcuts(a)||(b?a.preventDefault():this._processCharacterInsertion()?(this._formatValue(a),b=c["default"].getElementValue(a.target),b!==this.lastVal&&this.throwInput?this._triggerEvent(d.events["native"].input,a.target):this.eventKey!==this.settings.decimalCharacter&&this.eventKey!==this.settings.decimalCharacterAlternative||c["default"].getElementSelection(a.target).start!==c["default"].getElementSelection(a.target).end||
c["default"].getElementSelection(a.target).start!==b.indexOf(this.settings.decimalCharacter)||(b=c["default"].getElementSelection(a.target).start+1,c["default"].setElementSelection(a.target,b)),a.preventDefault(),this.lastVal=c["default"].getElementValue(a.target),this.throwInput=!0,this._setValidOrInvalidState(this.rawValue)):a.preventDefault())}}},{key:"_onKeyup",value:function(a){this.isEditing=!1;this.keydownEventCounter=0;if(!this.formulaMode)if(this.settings.isCancellable&&this.eventKey===f["default"].keyName.Esc)a.preventDefault();
else{this._updateEventKeyInfo(a);if(this.eventKey===f["default"].keyName.Z||this.eventKey===f["default"].keyName.z){if(a.ctrlKey&&a.shiftKey){a.preventDefault();this._historyTableRedo();this._triggerEvent(d.events["native"].input,a.target);this.onGoingRedo=!0;return}if(a.ctrlKey&&!a.shiftKey)if(this.onGoingRedo)this.onGoingRedo=!1;else{a.preventDefault();this._historyTableUndo();this._triggerEvent(d.events["native"].input,a.target);return}}else if((this.eventKey===f["default"].keyName.Y||this.eventKey===
f["default"].keyName.y)&&a.ctrlKey){a.preventDefault();this._historyTableRedo();this._triggerEvent(d.events["native"].input,a.target);this.onGoingRedo=!0;return}this.onGoingRedo&&(a.ctrlKey||a.shiftKey)&&(this.onGoingRedo=!1);if((a.ctrlKey||a.metaKey)&&this.eventKey===f["default"].keyName.x){var b=c["default"].getElementSelection(this.domElement).start,e=this.constructor._toNumericValue(c["default"].getElementValue(a.target),this.settings);this.set(e);this._setCaretPosition(b)}this.eventKey===f["default"].keyName.Alt&&
this.settings.unformatOnHover&&this.hoveredWithAlt?this.constructor._reformatAltHovered(this):!a.ctrlKey&&!a.metaKey||this.eventKey!==f["default"].keyName.Backspace&&this.eventKey!==f["default"].keyName.Delete?(this._updateInternalProperties(a),b=this._processNonPrintableKeysAndShortcuts(a),delete this.valuePartsBeforePaste,e=c["default"].getElementValue(a.target),b||""===e&&""===this.initialValueOnFirstKeydown||(e===this.settings.currencySymbol?this.settings.currencySymbolPlacement===d.options.currencySymbolPlacement.suffix?
c["default"].setElementSelection(a.target,0):c["default"].setElementSelection(a.target,this.settings.currencySymbol.length):this.eventKey===f["default"].keyName.Tab&&c["default"].setElementSelection(a.target,0,e.length),(e===this.settings.suffixText||""===this.rawValue&&""!==this.settings.currencySymbol&&""!==this.settings.suffixText)&&c["default"].setElementSelection(a.target,0),null!==this.settings.decimalPlacesShownOnFocus&&this._saveValueToPersistentStorage(),this.formatted||this._formatValue(a),
this._setValidOrInvalidState(this.rawValue),this._saveRawValueForAndroid(),e!==this.initialValueOnFirstKeydown&&this._triggerEvent(d.events.formatted,a.target,{oldValue:this.initialValueOnFirstKeydown,newValue:e,oldRawValue:this.initialRawValueOnFirstKeydown,newRawValue:this.rawValue,isPristine:this.isPristine(!1),error:null,aNElement:this}),1<this.historyTable.length&&(a=c["default"].getElementSelection(this.domElement),this.selectionStart=a.start,this.selectionEnd=a.end,this.historyTable[this.historyTableIndex].start=
this.selectionStart,this.historyTable[this.historyTableIndex].end=this.selectionEnd))):(a=c["default"].getElementValue(a.target),this._setRawValue(this._formatOrUnformatOther(!1,a)))}}},{key:"_saveRawValueForAndroid",value:function(){if(this.eventKey===f["default"].keyName.AndroidDefault){var a=this.constructor._stripAllNonNumberCharactersExceptCustomDecimalChar(this.getFormatted(),this.settings,!0,this.isFocused);a=this.constructor._convertToNumericString(a,this.settings);this._setRawValue(a)}}},
{key:"_onFocusOutAndMouseLeave",value:function(a){this.isEditing=!1;if("mouseleave"!==a.type||!this.formulaMode)if(this.settings.unformatOnHover&&"mouseleave"===a.type&&this.hoveredWithAlt)this.constructor._reformatAltHovered(this);else if("mouseleave"===a.type&&!this.isFocused||"blur"===a.type){"blur"===a.type&&this.formulaMode&&this._exitFormulaMode();this._saveValueToPersistentStorage();this.settings.showOnlyNumbersOnFocus===d.options.showOnlyNumbersOnFocus.onlyNumbers&&(this.settings.digitGroupSeparator=
this.originalDigitGroupSeparator,this.settings.currencySymbol=this.originalCurrencySymbol,this.settings.suffixText=this.originalSuffixText);var b=this._getRawValueToFormat(this.rawValue),e=c["default"].isNull(b),h=this.constructor._checkIfInRangeWithOverrideOption(b,this.settings),g=w(h,2);h=g[0];g=g[1];var l=!1;""===b||e||(this._triggerRangeEvents(h,g),this.settings.valuesToStrings&&this._checkValuesToStrings(b)&&(this._setElementValue(this.settings.valuesToStrings[b]),l=!0));if(!l){l=e||""===b?
b:String(b);if(""!==b&&!e)h&&g&&!this.constructor._isElementValueEmptyOrOnlyTheNegativeSign(b,this.settings)?(l=this._modifyNegativeSignAndDecimalCharacterForRawValue(l),this.settings.divisorWhenUnfocused&&!c["default"].isNull(l)&&(l/=this.settings.divisorWhenUnfocused,l=l.toString()),l=this.constructor._roundFormattedValueShownOnBlur(l,this.settings),l=this.constructor._modifyNegativeSignAndDecimalCharacterForFormattedValue(l,this.settings)):this._triggerRangeEvents(h,g);else if(""===b)switch(this.settings.emptyInputBehavior){case d.options.emptyInputBehavior.zero:this._setRawValue("0");
l=this.constructor._roundValue("0",this.settings,0);break;case d.options.emptyInputBehavior.min:this._setRawValue(this.settings.minimumValue);l=this.constructor._roundFormattedValueShownOnFocusOrBlur(this.settings.minimumValue,this.settings,this.isFocused);break;case d.options.emptyInputBehavior.max:this._setRawValue(this.settings.maximumValue);l=this.constructor._roundFormattedValueShownOnFocusOrBlur(this.settings.maximumValue,this.settings,this.isFocused);break;default:c["default"].isNumber(this.settings.emptyInputBehavior)&&
(this._setRawValue(this.settings.emptyInputBehavior),l=this.constructor._roundFormattedValueShownOnFocusOrBlur(this.settings.emptyInputBehavior,this.settings,this.isFocused))}h=this.constructor._orderValueCurrencySymbolAndSuffixText(l,this.settings,!1);this.constructor._isElementValueEmptyOrOnlyTheNegativeSign(l,this.settings)||e&&this.settings.emptyInputBehavior===d.options.emptyInputBehavior["null"]||(h=this.constructor._addGroupSeparators(l,this.settings,!1,b));if(h!==b||""===b||this.settings.allowDecimalPadding===
d.options.allowDecimalPadding.never||this.settings.allowDecimalPadding===d.options.allowDecimalPadding.floats)this.settings.symbolWhenUnfocused&&""!==b&&null!==b&&(h="".concat(h).concat(this.settings.symbolWhenUnfocused)),this._setElementValue(h)}this._setValidOrInvalidState(this.rawValue);"blur"===a.type&&this._onBlur(a)}}},{key:"_onPaste",value:function(a){a.preventDefault();if(!(this.settings.readOnly||this.domElement.readOnly||this.domElement.disabled)){var b;a.clipboardData&&a.clipboardData.getData?
b=a.clipboardData.getData("text/plain"):c["default"].throwError("Unable to retrieve the pasted value. Please use a modern browser (i.e. Firefox or Chromium).");a=a.target.tagName?a.target:a.explicitOriginalTarget;var e=c["default"].getElementValue(a),h=a.selectionStart||0,g=a.selectionEnd||0,l=g-h;if(l===e.length)e=this._preparePastedText(b),e=c["default"].arabicToLatinNumbers(e,!1,!1,!1),"."===e||""===e||"."!==e&&!c["default"].isNumber(e)?(this.formatted=!0,this.settings.onInvalidPaste===d.options.onInvalidPaste.error&&
c["default"].throwError("The pasted value '".concat(b,"' is not a valid paste content."))):(this.set(e),this.formatted=!0,this._triggerEvent(d.events["native"].input,a));else{var p=c["default"].isNegativeStrict(b,this.settings.negativeSignCharacter);p&&(b=b.slice(1,b.length));var r=this._preparePastedText(b);r="."===r?".":c["default"].arabicToLatinNumbers(r,!1,!1,!1);if("."===r||c["default"].isNumber(r)&&""!==r){var u=c["default"].isNegativeStrict(this.getNumericString(),this.settings.negativeSignCharacter);
var F=p&&!u?u=!0:!1;p=e.slice(0,h);var L=e.slice(g,e.length);p=h!==g?this._preparePastedText(p+L):this._preparePastedText(e);u&&(p=c["default"].setRawNegativeSign(p));u=c["default"].convertCharacterCountToIndexPosition(c["default"].countNumberCharactersOnTheCaretLeftSide(e,h,this.settings.decimalCharacter));F&&u++;var O=p.slice(0,u),Q=p.slice(u,p.length);L=!1;"."===r&&(c["default"].contains(O,".")&&(L=!0,O=O.replace(".","")),Q=Q.replace(".",""));var R=!1;""===O&&"-"===Q&&(O="-",Q="",R=!0);switch(this.settings.onInvalidPaste){case d.options.onInvalidPaste.truncate:case d.options.onInvalidPaste.replace:l=
c["default"].parseStr(this.settings.minimumValue);h=c["default"].parseStr(this.settings.maximumValue);g=p;for(F=0;F<r.length;){O+=r[F];p=O+Q;if(!this.constructor._checkIfInRange(p,l,h))break;g=p;F++}u+=F;R&&u++;if(this.settings.onInvalidPaste===d.options.onInvalidPaste.truncate){p=g;L&&u--;break}for(Q=g.length;F<r.length&&u<Q;){if("."!==g[u]){p=c["default"].replaceCharAt(g,u,r[F]);if(!this.constructor._checkIfInRange(p,l,h))break;g=p;F++}u++}L&&u--;p=g;break;default:p="".concat(O).concat(r).concat(Q),
h===g?u=c["default"].convertCharacterCountToIndexPosition(c["default"].countNumberCharactersOnTheCaretLeftSide(e,h,this.settings.decimalCharacter))+r.length:""===Q?(u=c["default"].convertCharacterCountToIndexPosition(c["default"].countNumberCharactersOnTheCaretLeftSide(e,h,this.settings.decimalCharacter))+r.length,R&&u++):(u=c["default"].convertCharacterCountToIndexPosition(c["default"].countNumberCharactersOnTheCaretLeftSide(e,g,this.settings.decimalCharacter)),h=c["default"].getElementValue(a).slice(h,
g),u=u-l+c["default"].countCharInText(this.settings.digitGroupSeparator,h)+r.length),F&&u++,L&&u--}if(c["default"].isNumber(p)&&""!==p){L=r=!1;try{this.set(p),r=!0}catch(S){switch(this.settings.onInvalidPaste){case d.options.onInvalidPaste.clamp:b=c["default"].clampToRangeLimits(p,this.settings);try{this.set(b)}catch(M){c["default"].throwError("Fatal error: Unable to set the clamped value '".concat(b,"'."))}r=L=!0;p=b;break;case d.options.onInvalidPaste.error:case d.options.onInvalidPaste.truncate:case d.options.onInvalidPaste.replace:c["default"].throwError("The pasted value '".concat(b,
"' results in a value '").concat(p,"' that is outside of the minimum [").concat(this.settings.minimumValue,"] and maximum [").concat(this.settings.maximumValue,"] value range."));default:return}}b=c["default"].getElementValue(a);if(r)switch(this.settings.onInvalidPaste){case d.options.onInvalidPaste.clamp:if(L){this.settings.currencySymbolPlacement===d.options.currencySymbolPlacement.suffix?c["default"].setElementSelection(a,b.length-this.settings.currencySymbol.length):c["default"].setElementSelection(a,
b.length);break}default:p=c["default"].findCaretPositionInFormattedNumber(p,u,b,this.settings.decimalCharacter),c["default"].setElementSelection(a,p)}r&&e!==b&&this._triggerEvent(d.events["native"].input,a)}else this.settings.onInvalidPaste===d.options.onInvalidPaste.error&&c["default"].throwError("The pasted value '".concat(b,"' would result into an invalid content '").concat(p,"'."))}else this.formatted=!0,this.settings.onInvalidPaste===d.options.onInvalidPaste.error&&c["default"].throwError("The pasted value '".concat(b,
"' is not a valid paste content."))}}}},{key:"_onBlur",value:function(a){this.isEditing=this.isFocused=!1;c["default"].trimPaddedZerosFromDecimalPlaces(this.rawValue)!==c["default"].trimPaddedZerosFromDecimalPlaces(this.rawValueOnFocus)&&this._triggerEvent(d.events["native"].change,a.target);this.rawValueOnFocus=void 0}},{key:"_wheelAndUpDownActions",value:function(a,b,e,h){var g=a.target.selectionStart||0,l=a.target.selectionEnd||0,p=this.rawValue;var r=c["default"].isUndefinedOrNullOrEmpty(p)?0<
this.settings.minimumValue||0>this.settings.maximumValue?b?this.settings.minimumValue:this.settings.maximumValue:0:p;r=+r;c["default"].isNumber(h)?(h=+h,b?r+=h:e&&(r-=h)):b?r=c["default"].addAndRoundToNearestAuto(r,this.settings.decimalPlacesRawValue):e&&(r=c["default"].subtractAndRoundToNearestAuto(r,this.settings.decimalPlacesRawValue));r=c["default"].clampToRangeLimits(r,this.settings);r!==+p&&(this.set(r),this._triggerEvent(d.events["native"].input,a.target));a.preventDefault();this._setSelection(g,
l)}},{key:"upDownArrowAction",value:function(a){if(!(this.formulaMode||this.settings.readOnly||this.domElement.readOnly||this.domElement.disabled)){var b=!1,e=!1;this.eventKey===f["default"].keyName.UpArrow?b=!0:this.eventKey===f["default"].keyName.DownArrow?e=!0:c["default"].throwError("Something has gone wrong since neither an Up or Down arrow key is detected, but the function was still called!");this._wheelAndUpDownActions(a,b,e,this.settings.upDownStep)}}},{key:"_onWheel",value:function(a){this.formulaMode||
this.settings.readOnly||this.domElement.readOnly||this.domElement.disabled||!this.settings.modifyValueOnWheel||(this.settings.wheelOn===d.options.wheelOn.focus?this.isFocused?a.shiftKey||this.wheelAction(a):a.shiftKey&&this.wheelAction(a):this.settings.wheelOn===d.options.wheelOn.hover?a.shiftKey?(a.preventDefault(),window.scrollBy(0,c["default"].isNegativeStrict(String(a.deltaY))?-50:50)):this.wheelAction(a):c["default"].throwError("Unknown `wheelOn` option."))}},{key:"wheelAction",value:function(a){this.isWheelEvent=
!0;var b=!1,e=!1,h=!1;c["default"].isWheelUpEvent(a)?b=!0:c["default"].isWheelDownEvent(a)?e=!0:c["default"].isWheelEventWithZeroDeltaY(a)?h=!0:c["default"].throwError("The event is not a 'wheel' event.");h||this._wheelAndUpDownActions(a,b,e,this.settings.wheelStep);this.isWheelEvent=!1}},{key:"_onDrop",value:function(a){if(!this.formulaMode){this.isDropEvent=!0;a.preventDefault();a=a.dataTransfer.getData("text/plain");var b=this.unformatOther(a);a=this.rawValue;this.set(b);this.isDropEvent=!1;b=
this.constructor._toNumericValue(b,this.settings);isNaN(Number(b))||c["default"].trimPaddedZerosFromDecimalPlaces(a)!==c["default"].trimPaddedZerosFromDecimalPlaces(b)&&this._triggerEvent(d.events["native"].change,this.domElement)}}},{key:"_onFormSubmit",value:function(){var a=this;this._getFormAutoNumericChildren(this.parentForm).map(function(b){return a.constructor.getAutoNumericElement(b)}).forEach(function(b){return b._unformatOnSubmit()});return!0}},{key:"_onFormReset",value:function(){var a=
this;this._getFormAutoNumericChildren(this.parentForm).map(function(b){return a.constructor.getAutoNumericElement(b)}).forEach(function(b){var e=a._getDefaultValue(b.node());setTimeout(function(){return b.set(e)},0)})}},{key:"_unformatOnSubmit",value:function(){this.settings.unformatOnSubmit&&this._setElementValue(this.rawValue)}},{key:"_onKeydownGlobal",value:function(a){c["default"].character(a)===f["default"].keyName.Alt&&(a=c["default"].getHoveredElement(),d.isManagedByAutoNumeric(a)&&(a=d.getAutoNumericElement(a),
!a.formulaMode&&a.settings.unformatOnHover&&this.constructor._unformatAltHovered(a)))}},{key:"_onKeyupGlobal",value:function(a){c["default"].character(a)===f["default"].keyName.Alt&&(a=c["default"].getHoveredElement(),d.isManagedByAutoNumeric(a)&&(a=d.getAutoNumericElement(a),!a.formulaMode&&a.settings.unformatOnHover&&this.constructor._reformatAltHovered(a)))}},{key:"_isElementTagSupported",value:function(){c["default"].isElement(this.domElement)||c["default"].throwError("The DOM element is not valid, ".concat(this.domElement,
" given."));return c["default"].isInArray(this.domElement.tagName.toLowerCase(),this.allowedTagList)}},{key:"_isInputElement",value:function(){return"input"===this.domElement.tagName.toLowerCase()}},{key:"_isInputTypeSupported",value:function(){return"text"===this.domElement.type||"hidden"===this.domElement.type||"tel"===this.domElement.type||c["default"].isUndefinedOrNullOrEmpty(this.domElement.type)}},{key:"_checkElement",value:function(){var a=this.domElement.tagName.toLowerCase();this._isElementTagSupported()||
c["default"].throwError("The \x3c".concat(a,"\x3e tag is not supported by autoNumeric"));this._isInputElement()?(this._isInputTypeSupported()||c["default"].throwError('The input type "'.concat(this.domElement.type,'" is not supported by autoNumeric')),this.isInputElement=!0):(this.isInputElement=!1,this.isContentEditable=this._isContentEditable(this.domElement))}},{key:"_isContentEditable",value:function(a){return a.hasAttribute("contenteditable")&&"true"===a.getAttribute("contenteditable")}},{key:"_formatDefaultValueOnPageLoad",
value:function(){var a=0<arguments.length&&void 0!==arguments[0]?arguments[0]:null,b=!0;c["default"].isNull(a)&&(a=c["default"].getElementValue(this.domElement).trim(),this.domElement.setAttribute("value",a));if(this.isInputElement||this.isContentEditable){var e=this.constructor._toNumericValue(a,this.settings);if(!this.domElement.hasAttribute("value")||""===this.domElement.getAttribute("value"))isNaN(Number(e))||Infinity===e?c["default"].throwError("The value [".concat(a,"] used in the input is not a valid value autoNumeric can work with.")):
(this.set(e),b=!1);else if(null!==this.settings.defaultValueOverride&&this.settings.defaultValueOverride.toString()!==a||null===this.settings.defaultValueOverride&&""!==a&&a!==this.domElement.getAttribute("value")||""!==a&&"hidden"===this.domElement.getAttribute("type")&&!c["default"].isNumber(e))this.settings.saveValueToSessionStorage&&(null!==this.settings.decimalPlacesShownOnFocus||this.settings.divisorWhenUnfocused)&&this._setRawValue(this._getValueFromPersistentStorage()),this.settings.saveValueToSessionStorage||
(b=this.constructor._removeBrackets(a,this.settings),(this.settings.negativePositiveSignPlacement===d.options.negativePositiveSignPlacement.suffix||this.settings.negativePositiveSignPlacement!==d.options.negativePositiveSignPlacement.prefix&&this.settings.currencySymbolPlacement===d.options.currencySymbolPlacement.suffix)&&""!==this.settings.negativeSignCharacter&&c["default"].isNegative(a,this.settings.negativeSignCharacter)?this._setRawValue("-".concat(this.constructor._stripAllNonNumberCharacters(b,
this.settings,!0,this.isFocused))):this._setRawValue(this.constructor._stripAllNonNumberCharacters(b,this.settings,!0,this.isFocused))),b=!1;if(""===a)switch(this.settings.emptyInputBehavior){case d.options.emptyInputBehavior.focus:case d.options.emptyInputBehavior.press:break;case d.options.emptyInputBehavior.always:this._setElementValue(this.settings.currencySymbol);break;case d.options.emptyInputBehavior.min:this.set(this.settings.minimumValue);break;case d.options.emptyInputBehavior.max:this.set(this.settings.maximumValue);
break;case d.options.emptyInputBehavior.zero:this.set("0");break;case d.options.emptyInputBehavior["null"]:this.set(null);break;default:this.set(this.settings.emptyInputBehavior)}else b&&a===this.domElement.getAttribute("value")&&this.set(a)}else null!==this.settings.defaultValueOverride&&this.settings.defaultValueOverride!==a||this.set(a)}},{key:"_calculateVMinAndVMaxIntegerSizes",value:function(){var a=this.settings.maximumValue.toString().split(".");a=w(a,1)[0];var b=this.settings.minimumValue||
0===this.settings.minimumValue?this.settings.minimumValue.toString().split("."):[];b=w(b,1)[0];a=a.replace(this.settings.negativeSignCharacter,"");b=b.replace(this.settings.negativeSignCharacter,"");this.settings.mIntPos=Math.max(a.length,1);this.settings.mIntNeg=Math.max(b.length,1)}},{key:"_calculateValuesToStringsKeys",value:function(){this.valuesToStringsKeys=this.settings.valuesToStrings?Object.keys(this.settings.valuesToStrings):[]}},{key:"_transformOptionsValuesToDefaultTypes",value:function(){for(var a in this.settings)if(Object.prototype.hasOwnProperty.call(this.settings,
a)){var b=this.settings[a];if("true"===b||"false"===b)this.settings[a]="true"===b;"number"===typeof b&&(this.settings[a]=b.toString())}}},{key:"_setSettings",value:function(a){var b=1<arguments.length&&void 0!==arguments[1]?arguments[1]:!1;!b&&c["default"].isNull(a)||this.constructor._convertOldOptionsToNewOnes(a);b?("decimalPlacesRawValue"in a&&(this.settings.originalDecimalPlacesRawValue=a.decimalPlacesRawValue),"decimalPlaces"in a&&(this.settings.originalDecimalPlaces=a.decimalPlaces),this.constructor._calculateDecimalPlacesOnUpdate(a,
this.settings),this._mergeSettings(a)):(this.settings={},this._mergeSettings(this.constructor.getDefaultConfig(),this.domElement.dataset,a,{rawValue:this.defaultRawValue}),this.caretFix=!1,this.throwInput=!0,this.allowedTagList=f["default"].allowedTagList,this.hoveredWithAlt=this.runOnce=!1);this._transformOptionsValuesToDefaultTypes();this._runCallbacksFoundInTheSettingsObject();this.constructor._correctNegativePositiveSignPlacementOption(this.settings);this.constructor._correctCaretPositionOnFocusAndSelectOnFocusOptions(this.settings);
this.constructor._setNegativePositiveSignPermissions(this.settings);b||(c["default"].isNull(a)||!a.decimalPlaces?this.settings.originalDecimalPlaces=null:this.settings.originalDecimalPlaces=a.decimalPlaces,this.settings.originalDecimalPlacesRawValue=this.settings.decimalPlacesRawValue,this.constructor._calculateDecimalPlacesOnInit(this.settings));this._calculateVMinAndVMaxIntegerSizes();this._setTrailingNegativeSignInfo();this.regex={};this.constructor._cachesUsualRegularExpressions(this.settings,
this.regex);this.constructor._setBrackets(this.settings);this._calculateValuesToStringsKeys();c["default"].isEmptyObj(this.settings)&&c["default"].throwError("Unable to set the settings, those are invalid ; an empty object was given.");this.constructor.validate(this.settings,!1,a);this._keepAnOriginalSettingsCopy()}},{key:"_preparePastedText",value:function(a){return this.constructor._stripAllNonNumberCharacters(a,this.settings,!0,this.isFocused)}},{key:"_updateInternalProperties",value:function(){this.selection=
c["default"].getElementSelection(this.domElement);this.processed=!1}},{key:"_updateEventKeyInfo",value:function(a){this.eventKey=c["default"].character(a)}},{key:"_saveCancellableValue",value:function(){this.savedCancellableValue=this.rawValue}},{key:"_setSelection",value:function(a,b){a=Math.max(a,0);b=Math.min(b,c["default"].getElementValue(this.domElement).length);this.selection={start:a,end:b,length:b-a};c["default"].setElementSelection(this.domElement,a,b)}},{key:"_setCaretPosition",value:function(a){this._setSelection(a,
a)}},{key:"_getLeftAndRightPartAroundTheSelection",value:function(){var a=c["default"].getElementValue(this.domElement),b=a.substring(0,this.selection.start);a=a.substring(this.selection.end,a.length);return[b,a]}},{key:"_getUnformattedLeftAndRightPartAroundTheSelection",value:function(){var a=this._getLeftAndRightPartAroundTheSelection(),b=w(a,2);a=b[0];b=b[1];if(""===a&&""===b)return["",""];var e=!0;this.eventKey!==f["default"].keyName.Hyphen&&this.eventKey!==f["default"].keyName.Minus||0!==Number(a)||
(e=!1);this.isTrailingNegative&&(c["default"].isNegative(b,this.settings.negativeSignCharacter)&&!c["default"].isNegative(a,this.settings.negativeSignCharacter)||""===b&&c["default"].isNegative(a,this.settings.negativeSignCharacter,!0))&&(a=a.replace(this.settings.negativeSignCharacter,""),b=b.replace(this.settings.negativeSignCharacter,""),a=a.replace("-",""),b=b.replace("-",""),a="-".concat(a));a=d._stripAllNonNumberCharactersExceptCustomDecimalChar(a,this.settings,e,this.isFocused);b=d._stripAllNonNumberCharactersExceptCustomDecimalChar(b,
this.settings,!1,this.isFocused);return[a,b]}},{key:"_normalizeParts",value:function(a,b){var e=!0;this.eventKey!==f["default"].keyName.Hyphen&&this.eventKey!==f["default"].keyName.Minus||0!==Number(a)||(e=!1);this.isTrailingNegative&&c["default"].isNegative(b,this.settings.negativeSignCharacter)&&!c["default"].isNegative(a,this.settings.negativeSignCharacter)&&(a="-".concat(a),b=b.replace(this.settings.negativeSignCharacter,""));a=d._stripAllNonNumberCharactersExceptCustomDecimalChar(a,this.settings,
e,this.isFocused);b=d._stripAllNonNumberCharactersExceptCustomDecimalChar(b,this.settings,!1,this.isFocused);this.settings.leadingZero!==d.options.leadingZero.deny||this.eventKey!==f["default"].keyName.num0&&this.eventKey!==f["default"].keyName.numpad0||0!==Number(a)||c["default"].contains(a,this.settings.decimalCharacter)||""===b||(a=a.substring(0,a.length-1));e=a+b;if(this.settings.decimalCharacter){var h=e.match(new RegExp("^".concat(this.regex.aNegRegAutoStrip,"\\").concat(this.settings.decimalCharacter)));
h&&(a=a.replace(h[1],h[1]+"0"),e=a+b)}return[a,b,e]}},{key:"_setValueParts",value:function(a,b){var e=2<arguments.length&&void 0!==arguments[2]?arguments[2]:!1,h=this._normalizeParts(a,b),g=w(h,3);h=g[0];var l=g[1];g=g[2];var p=d._checkIfInRangeWithOverrideOption(g,this.settings),r=w(p,2);p=r[0];r=r[1];if(p&&r){p=d._truncateDecimalPlaces(g,this.settings,e,this.settings.decimalPlacesRawValue).replace(this.settings.decimalCharacter,".");if(""===p||p===this.settings.negativeSignCharacter){switch(this.settings.emptyInputBehavior){case d.options.emptyInputBehavior.focus:case d.options.emptyInputBehavior.press:case d.options.emptyInputBehavior.always:p=
"";break;case d.options.emptyInputBehavior.min:p=this.settings.minimumValue;break;case d.options.emptyInputBehavior.max:p=this.settings.maximumValue;break;case d.options.emptyInputBehavior.zero:p="0";break;case d.options.emptyInputBehavior["null"]:p=null;break;default:p=this.settings.emptyInputBehavior}this._setRawValue(p)}else this._setRawValue(this._trimLeadingAndTrailingZeros(p));e=d._truncateDecimalPlaces(g,this.settings,e,this.settings.decimalPlacesShownOnFocus);g=h.length;g>e.length&&(g=e.length);
1===g&&"0"===h&&this.settings.leadingZero===d.options.leadingZero.deny&&(g=""===l||"0"===h&&""!==l?1:0);this._setElementValue(e,!1);this._setCaretPosition(g);return!0}this._triggerRangeEvents(p,r);return!1}},{key:"_getSignPosition",value:function(){if(this.settings.currencySymbol){var a=this.settings.currencySymbol.length;var b=c["default"].getElementValue(this.domElement);this.settings.currencySymbolPlacement===d.options.currencySymbolPlacement.prefix?a=this.settings.negativeSignCharacter&&b&&b.charAt(0)===
this.settings.negativeSignCharacter?[1,a+1]:[0,a]:(b=b.length,a=[b-a,b])}else a=[1E3,-1];return a}},{key:"_expandSelectionOnSign",value:function(){var a=this._getSignPosition(),b=w(a,2);a=b[0];b=b[1];var e=this.selection;e.start<b&&e.end>a&&((e.start<a||e.end>b)&&c["default"].getElementValue(this.domElement).substring(Math.max(e.start,a),Math.min(e.end,b)).match(/^\s*$/)?e.start<a?this._setSelection(e.start,a):this._setSelection(b,e.end):this._setSelection(Math.min(e.start,a),Math.max(e.end,b)))}},
{key:"_checkPaste",value:function(){if(!this.formatted&&!c["default"].isUndefined(this.valuePartsBeforePaste)){var a=this.valuePartsBeforePaste,b=this._getLeftAndRightPartAroundTheSelection(),e=w(b,2);b=e[0];e=e[1];delete this.valuePartsBeforePaste;b=b.substr(0,a[0].length)+d._stripAllNonNumberCharactersExceptCustomDecimalChar(b.substr(a[0].length),this.settings,!0,this.isFocused);this._setValueParts(b,e,!0)||(this._setElementValue(a.join(""),!1),this._setCaretPosition(a[0].length))}}},{key:"_processNonPrintableKeysAndShortcuts",
value:function(a){if((a.ctrlKey||a.metaKey)&&"keyup"===a.type&&!c["default"].isUndefined(this.valuePartsBeforePaste)||a.shiftKey&&this.eventKey===f["default"].keyName.Insert)return this._checkPaste(),!1;if(this.constructor._shouldSkipEventKey(this.eventKey))return!0;if((a.ctrlKey||a.metaKey)&&this.eventKey===f["default"].keyName.a)return this.settings.selectNumberOnly&&(a.preventDefault(),this.selectNumber()),!0;if((a.ctrlKey||a.metaKey)&&(this.eventKey===f["default"].keyName.c||this.eventKey===f["default"].keyName.v||
this.eventKey===f["default"].keyName.x)){"keydown"===a.type&&this._expandSelectionOnSign();if(this.eventKey===f["default"].keyName.v||this.eventKey===f["default"].keyName.Insert)"keydown"===a.type||"keypress"===a.type?c["default"].isUndefined(this.valuePartsBeforePaste)&&(this.valuePartsBeforePaste=this._getLeftAndRightPartAroundTheSelection()):this._checkPaste();return"keydown"===a.type||"keypress"===a.type||this.eventKey===f["default"].keyName.c}return a.ctrlKey||a.metaKey?!(this.eventKey===f["default"].keyName.Z||
this.eventKey===f["default"].keyName.z):this.eventKey===f["default"].keyName.LeftArrow||this.eventKey===f["default"].keyName.RightArrow?("keydown"!==a.type||a.shiftKey||(a=c["default"].getElementValue(this.domElement),this.eventKey!==f["default"].keyName.LeftArrow||a.charAt(this.selection.start-2)!==this.settings.digitGroupSeparator&&a.charAt(this.selection.start-2)!==this.settings.decimalCharacter?this.eventKey!==f["default"].keyName.RightArrow||a.charAt(this.selection.start+1)!==this.settings.digitGroupSeparator&&
a.charAt(this.selection.start+1)!==this.settings.decimalCharacter||this._setCaretPosition(this.selection.start+1):this._setCaretPosition(this.selection.start-1)),!0):c["default"].isInArray(this.eventKey,f["default"].keyName._directionKeys)}},{key:"_processCharacterDeletionIfTrailingNegativeSign",value:function(a){var b=w(a,2);a=b[0];b=b[1];var e=c["default"].getElementValue(this.domElement),h=c["default"].isNegative(e,this.settings.negativeSignCharacter);this.settings.currencySymbolPlacement===d.options.currencySymbolPlacement.prefix&&
this.settings.negativePositiveSignPlacement===d.options.negativePositiveSignPlacement.suffix&&(this.eventKey===f["default"].keyName.Backspace?(this.caretFix=this.selection.start>=e.indexOf(this.settings.suffixText)&&""!==this.settings.suffixText,"-"===e.charAt(this.selection.start-1)?a=a.substring(1):this.selection.start<=e.length-this.settings.suffixText.length&&(a=a.substring(0,a.length-1))):(this.caretFix=this.selection.start>=e.indexOf(this.settings.suffixText)&&""!==this.settings.suffixText,
this.selection.start>=e.indexOf(this.settings.currencySymbol)+this.settings.currencySymbol.length&&(b=b.substring(1,b.length)),c["default"].isNegative(a,this.settings.negativeSignCharacter)&&"-"===e.charAt(this.selection.start)&&(a=a.substring(1))));if(this.settings.currencySymbolPlacement===d.options.currencySymbolPlacement.suffix)switch(this.settings.negativePositiveSignPlacement){case d.options.negativePositiveSignPlacement.left:this.caretFix=this.selection.start>=e.indexOf(this.settings.negativeSignCharacter)+
this.settings.negativeSignCharacter.length;this.eventKey===f["default"].keyName.Backspace?this.selection.start===e.indexOf(this.settings.negativeSignCharacter)+this.settings.negativeSignCharacter.length&&h?a=a.substring(1):"-"!==a&&(this.selection.start<=e.indexOf(this.settings.negativeSignCharacter)||!h)&&(a=a.substring(0,a.length-1)):("-"===a[0]&&(b=b.substring(1)),this.selection.start===e.indexOf(this.settings.negativeSignCharacter)&&h&&(a=a.substring(1)));break;case d.options.negativePositiveSignPlacement.right:this.caretFix=
this.selection.start>=e.indexOf(this.settings.negativeSignCharacter)+this.settings.negativeSignCharacter.length,this.eventKey===f["default"].keyName.Backspace?this.selection.start===e.indexOf(this.settings.negativeSignCharacter)+this.settings.negativeSignCharacter.length?a=a.substring(1):"-"!==a&&this.selection.start<=e.indexOf(this.settings.negativeSignCharacter)-this.settings.currencySymbol.length?a=a.substring(0,a.length-1):""===a||h||(a=a.substring(0,a.length-1)):(this.caretFix=this.selection.start>=
e.indexOf(this.settings.currencySymbol)&&""!==this.settings.currencySymbol,this.selection.start===e.indexOf(this.settings.negativeSignCharacter)&&(a=a.substring(1)),b=b.substring(1))}return[a,b]}},{key:"_processCharacterDeletion",value:function(a){if(this.selection.length){this._expandSelectionOnSign();var b=this._getUnformattedLeftAndRightPartAroundTheSelection();var e=w(b,2);b=e[0];e=e[1]}else b=this._getUnformattedLeftAndRightPartAroundTheSelection(),e=w(b,2),b=e[0],e=e[1],""===b&&""===e&&(this.throwInput=
!1),this.isTrailingNegative&&c["default"].isNegative(c["default"].getElementValue(this.domElement),this.settings.negativeSignCharacter)?(b=this._processCharacterDeletionIfTrailingNegativeSign([b,e]),e=w(b,2),b=e[0],e=e[1]):this.eventKey===f["default"].keyName.Backspace?b=b.substring(0,b.length-1):e=e.substring(1,e.length);if(!this.constructor._isWithinRangeWithOverrideOption("".concat(b).concat(e),this.settings)||c["default"].getElementValue(a.target)===this.settings.currencySymbol)return!1;this._setValueParts(b,
e);return!0}},{key:"_isDecimalCharacterInsertionAllowed",value:function(){return String(this.settings.decimalPlacesShownOnFocus)!==String(d.options.decimalPlacesShownOnFocus.none)&&String(this.settings.decimalPlaces)!==String(d.options.decimalPlaces.none)}},{key:"_processCharacterInsertion",value:function(){var a=this._getUnformattedLeftAndRightPartAroundTheSelection(),b=w(a,2);a=b[0];b=b[1];this.eventKey!==f["default"].keyName.AndroidDefault&&(this.throwInput=!0);if(this.eventKey===this.settings.decimalCharacter||
this.settings.decimalCharacterAlternative&&this.eventKey===this.settings.decimalCharacterAlternative){if(!this._isDecimalCharacterInsertionAllowed()||!this.settings.decimalCharacter)return!1;if(this.settings.alwaysAllowDecimalCharacter)a=a.replace(this.settings.decimalCharacter,""),b=b.replace(this.settings.decimalCharacter,"");else{if(c["default"].contains(a,this.settings.decimalCharacter)||0<b.indexOf(this.settings.decimalCharacter))return!0;0===b.indexOf(this.settings.decimalCharacter)&&(b=b.substr(1))}this.settings.negativeSignCharacter&&
c["default"].contains(b,this.settings.negativeSignCharacter)&&(a="".concat(this.settings.negativeSignCharacter).concat(a),b=b.replace(this.settings.negativeSignCharacter,""));this._setValueParts(a+this.settings.decimalCharacter,b);return!0}if(("-"===this.eventKey||"+"===this.eventKey)&&this.settings.isNegativeSignAllowed){if(""===a&&c["default"].contains(b,"-")){if(this.settings.negativePositiveSignBehavior||!this.settings.negativePositiveSignBehavior&&"+"===this.eventKey)b=b.replace("-","")}else if(c["default"].isNegativeStrict(a,
"-")){if(this.settings.negativePositiveSignBehavior||!this.settings.negativePositiveSignBehavior&&"+"===this.eventKey)a=a.replace("-","")}else if(this.settings.negativePositiveSignBehavior||!this.settings.negativePositiveSignBehavior&&"-"===this.eventKey)a="".concat(this.settings.negativeSignCharacter).concat(a);this._setValueParts(a,b);return!0}var e=Number(this.eventKey);return 0<=e&&9>=e?(this.settings.isNegativeSignAllowed&&""===a&&c["default"].contains(b,"-")&&(a="-",b=b.substring(1,b.length)),
0>=this.settings.maximumValue&&this.settings.minimumValue<this.settings.maximumValue&&!c["default"].contains(c["default"].getElementValue(this.domElement),this.settings.negativeSignCharacter)&&"0"!==this.eventKey&&(a="-".concat(a)),this._setValueParts("".concat(a).concat(this.eventKey),b),!0):this.throwInput=!1}},{key:"_formatValue",value:function(a){var b=c["default"].getElementValue(this.domElement),e=this._getUnformattedLeftAndRightPartAroundTheSelection(),h=w(e,1)[0];if((""===this.settings.digitGroupSeparator||
""!==this.settings.digitGroupSeparator&&!c["default"].contains(b,this.settings.digitGroupSeparator))&&(""===this.settings.currencySymbol||""!==this.settings.currencySymbol&&!c["default"].contains(b,this.settings.currencySymbol))){e=b.split(this.settings.decimalCharacter);e=w(e,1)[0];var g="";c["default"].isNegative(e,this.settings.negativeSignCharacter)&&(g=this.settings.negativeSignCharacter,e=e.replace(this.settings.negativeSignCharacter,""),h=h.replace("-",""));""===g&&e.length>this.settings.mIntPos&&
"0"===h.charAt(0)&&(h=h.slice(1));g===this.settings.negativeSignCharacter&&e.length>this.settings.mIntNeg&&"0"===h.charAt(0)&&(h=h.slice(1));this.isTrailingNegative||(h="".concat(g).concat(h))}e=this.constructor._addGroupSeparators(b,this.settings,this.isFocused,this.rawValue);g=e.length;if(e){h=h.split("");if((this.settings.negativePositiveSignPlacement===d.options.negativePositiveSignPlacement.suffix||this.settings.negativePositiveSignPlacement!==d.options.negativePositiveSignPlacement.prefix&&
this.settings.currencySymbolPlacement===d.options.currencySymbolPlacement.suffix)&&h[0]===this.settings.negativeSignCharacter&&!this.settings.isNegativeSignAllowed&&(h.shift(),(this.eventKey===f["default"].keyName.Backspace||this.eventKey===f["default"].keyName.Delete)&&this.caretFix)){if(this.settings.currencySymbolPlacement===d.options.currencySymbolPlacement.suffix&&this.settings.negativePositiveSignPlacement===d.options.negativePositiveSignPlacement.left||this.settings.currencySymbolPlacement===
d.options.currencySymbolPlacement.prefix&&this.settings.negativePositiveSignPlacement===d.options.negativePositiveSignPlacement.suffix)h.push(this.settings.negativeSignCharacter),this.caretFix="keydown"===a.type;if(this.settings.currencySymbolPlacement===d.options.currencySymbolPlacement.suffix&&this.settings.negativePositiveSignPlacement===d.options.negativePositiveSignPlacement.right){var l=this.settings.currencySymbol.split(""),p="\\^$.|?*+()[".split(""),r=[];l.forEach(function(u,F){F=l[u];c["default"].isInArray(F,
p)?r.push("\\"+F):r.push(F)});this.eventKey===f["default"].keyName.Backspace&&"-"===this.settings.negativeSignCharacter&&r.push("-");h.push(r.join(""));this.caretFix="keydown"===a.type}}for(a=0;a<h.length;a++)h[a].match("\\d")||(h[a]="\\"+h[a]);a=this.settings.currencySymbolPlacement===d.options.currencySymbolPlacement.suffix?new RegExp("^.*?".concat(h.join(".*?"))):new RegExp("^.*?[".concat(this.settings.currencySymbol,"]*").concat(h.join(".*?")));(a=e.match(a))?(g=a[0].length,this.settings.showPositiveSign&&
(0===g&&a.input.charAt(0)===this.settings.positiveSignCharacter&&(g=1===a.input.indexOf(this.settings.currencySymbol)?this.settings.currencySymbol.length+1:1),0===g&&a.input.charAt(this.settings.currencySymbol.length)===this.settings.positiveSignCharacter&&(g=this.settings.currencySymbol.length+1)),(0===g&&e.charAt(0)!==this.settings.negativeSignCharacter||1===g&&e.charAt(0)===this.settings.negativeSignCharacter)&&this.settings.currencySymbol&&this.settings.currencySymbolPlacement===d.options.currencySymbolPlacement.prefix&&
(g=this.settings.currencySymbol.length+(c["default"].isNegativeStrict(e,this.settings.negativeSignCharacter)?1:0))):(this.settings.currencySymbol&&this.settings.currencySymbolPlacement===d.options.currencySymbolPlacement.suffix&&(g-=this.settings.currencySymbol.length),this.settings.suffixText&&(g-=this.settings.suffixText.length))}e!==b&&(this._setElementValue(e,!1),this._setCaretPosition(g));this.formatted=!0}}],[{key:"version",value:function(){return"4.10.4"}},{key:"_setArgumentsValues",value:function(a,
b,e){c["default"].isNull(a)&&c["default"].throwError("At least one valid parameter is needed in order to initialize an AutoNumeric object");var h=c["default"].isElement(a),g=c["default"].isString(a),l=c["default"].isObject(b),p=Array.isArray(b)&&0<b.length,r=c["default"].isNumberOrArabic(b)||""===b,u=this._isPreDefinedOptionValid(b),F=c["default"].isNull(b),L=c["default"].isEmptyString(b),O=c["default"].isObject(e),Q=Array.isArray(e)&&0<e.length,R=c["default"].isNull(e),S=this._isPreDefinedOptionValid(e),
M;if(h&&F&&R){var N=a;var P=M=null}else h&&r&&R?(N=a,M=b,P=null):h&&l&&R?(N=a,M=null,P=b):h&&u&&R?(N=a,M=null,P=this._getOptionObject(b)):h&&p&&R?(N=a,M=null,P=this.mergeOptions(b)):h&&(F||L)&&O?(N=a,M=null,P=e):h&&(F||L)&&Q?(N=a,M=null,P=this.mergeOptions(e)):g&&F&&R?(N=document.querySelector(a),P=M=null):g&&l&&R?(N=document.querySelector(a),M=null,P=b):g&&u&&R?(N=document.querySelector(a),M=null,P=this._getOptionObject(b)):g&&p&&R?(N=document.querySelector(a),M=null,P=this.mergeOptions(b)):g&&(F||
L)&&O?(N=document.querySelector(a),M=null,P=e):g&&(F||L)&&Q?(N=document.querySelector(a),M=null,P=this.mergeOptions(e)):g&&r&&R?(N=document.querySelector(a),M=b,P=null):g&&r&&O?(N=document.querySelector(a),M=b,P=e):g&&r&&S?(N=document.querySelector(a),M=b,P=this._getOptionObject(e)):g&&r&&Q?(N=document.querySelector(a),M=b,P=this.mergeOptions(e)):h&&r&&O?(N=a,M=b,P=e):h&&r&&S?(N=a,M=b,P=this._getOptionObject(e)):h&&r&&Q?(N=a,M=b,P=this.mergeOptions(e)):c["default"].throwError("The parameters given to the AutoNumeric object are not valid, '".concat(a,
"', '").concat(b,"' and '").concat(e,"' given."));c["default"].isNull(N)&&c["default"].throwError("The selector '".concat(a,"' did not select any valid DOM element. Please check on which element you called AutoNumeric."));return{domElement:N,initialValue:M,userOptions:P}}},{key:"mergeOptions",value:function(a){var b=this,e={};a.forEach(function(h){E(e,b._getOptionObject(h))});return e}},{key:"_isPreDefinedOptionValid",value:function(a){return Object.prototype.hasOwnProperty.call(d.predefinedOptions,
a)}},{key:"_getOptionObject",value:function(a){if(c["default"].isString(a)){var b=d.getPredefinedOptions()[a];void 0!==b&&null!==b||c["default"].warning("The given pre-defined option [".concat(a,"] is not recognized by autoNumeric. Please check that pre-defined option name."),!0)}else b=a;return b}},{key:"_doesFormHandlerListExists",value:function(){var a=x(window.aNFormHandlerMap);return"undefined"!==a&&"object"===a}},{key:"_createFormHandlerList",value:function(){window.aNFormHandlerMap=new Map}},
{key:"_checkValuesToStringsArray",value:function(a,b){return c["default"].isInArray(String(a),b)}},{key:"_checkValuesToStringsSettings",value:function(a,b){return this._checkValuesToStringsArray(a,Object.keys(b.valuesToStrings))}},{key:"_checkStringsToValuesSettings",value:function(a,b){return this._checkValuesToStringsArray(a,Object.values(b.valuesToStrings))}},{key:"_unformatAltHovered",value:function(a){a.hoveredWithAlt=!0;a.unformat()}},{key:"_reformatAltHovered",value:function(a){a.hoveredWithAlt=
!1;a.reformat()}},{key:"_getChildANInputElement",value:function(a){var b=this;a=a.getElementsByTagName("input");var e=[];Array.prototype.slice.call(a,0).forEach(function(h){b.test(h)&&e.push(h)});return e}},{key:"test",value:function(a){return this._isInGlobalList(c["default"].domElement(a))}},{key:"_createWeakMap",value:function(a){window[a]=new WeakMap}},{key:"_createGlobalList",value:function(){this.autoNumericGlobalListName="autoNumericGlobalList";this._createWeakMap(this.autoNumericGlobalListName)}},
{key:"_doesGlobalListExists",value:function(){var a=x(window[this.autoNumericGlobalListName]);return"undefined"!==a&&"object"===a}},{key:"_addToGlobalList",value:function(a){this._doesGlobalListExists()||this._createGlobalList();var b=a.node();if(this._isInGlobalList(b)){if(this._getFromGlobalList(b)===this)return;c["default"].warning("A reference to the DOM element you just initialized already exists in the global AutoNumeric element list. Please make sure to not initialize the same DOM element multiple times.",
a.getSettings().showWarnings)}window[this.autoNumericGlobalListName].set(b,a)}},{key:"_removeFromGlobalList",value:function(a){if(this._doesGlobalListExists())window[this.autoNumericGlobalListName]["delete"](a.node())}},{key:"_getFromGlobalList",value:function(a){return this._doesGlobalListExists()?window[this.autoNumericGlobalListName].get(a):null}},{key:"_isInGlobalList",value:function(a){return this._doesGlobalListExists()?window[this.autoNumericGlobalListName].has(a):!1}},{key:"validate",value:function(a){var b=
1<arguments.length&&void 0!==arguments[1]?arguments[1]:!0,e=2<arguments.length&&void 0!==arguments[2]?arguments[2]:null;!c["default"].isUndefinedOrNullOrEmpty(a)&&c["default"].isObject(a)||c["default"].throwError("The userOptions are invalid ; it should be a valid object, [".concat(a,"] given."));var h=c["default"].isObject(e);h||c["default"].isNull(e)||c["default"].throwError("The 'originalOptions' parameter is invalid ; it should either be a valid option object or `null`, [".concat(a,"] given."));
c["default"].isNull(a)||this._convertOldOptionsToNewOnes(a);b=b?E({},this.getDefaultConfig(),a):a;c["default"].isTrueOrFalseString(b.showWarnings)||c["default"].isBoolean(b.showWarnings)||c["default"].throwError("The debug option 'showWarnings' is invalid ; it should be either 'true' or 'false', [".concat(b.showWarnings,"] given."));var g=/^[0-9]+$/,l=/[0-9]+/,p=/^-?[0-9]+(\.?[0-9]+)?$/,r=/^[0-9]+(\.?[0-9]+)?$/;c["default"].isTrueOrFalseString(b.allowDecimalPadding)||c["default"].isBoolean(b.allowDecimalPadding)||
b.allowDecimalPadding===d.options.allowDecimalPadding.floats||c["default"].isNumber(b.allowDecimalPadding)&&0<b.allowDecimalPadding||c["default"].throwError("The decimal padding option 'allowDecimalPadding' is invalid ; it should either be `false`, `true`, `'floats'` or a positive integer superior to 0, [".concat(b.allowDecimalPadding,"] given."));c["default"].isNumber(b.allowDecimalPadding)&&b.allowDecimalPadding>b.decimalPlaces&&c["default"].warning("Setting 'allowDecimalPadding' to a number [".concat(b.allowDecimalPadding,
"] superior to the current 'decimalPlaces' settings [").concat(b.decimalPlaces,"] is useless, since the padding will not be shown."),b.showWarnings);b.allowDecimalPadding!==d.options.allowDecimalPadding.never&&"false"!==b.allowDecimalPadding||b.decimalPlaces===d.options.decimalPlaces.none&&b.decimalPlacesShownOnBlur===d.options.decimalPlacesShownOnBlur.none&&b.decimalPlacesShownOnFocus===d.options.decimalPlacesShownOnFocus.none||c["default"].warning("Setting 'allowDecimalPadding' to [".concat(b.allowDecimalPadding,
"] will override the current 'decimalPlaces*' settings [").concat(b.decimalPlaces,", ").concat(b.decimalPlacesShownOnBlur," and ").concat(b.decimalPlacesShownOnFocus,"]."),b.showWarnings);c["default"].isTrueOrFalseString(b.alwaysAllowDecimalCharacter)||c["default"].isBoolean(b.alwaysAllowDecimalCharacter)||c["default"].throwError("The option 'alwaysAllowDecimalCharacter' is invalid ; it should either be `true` or `false`, [".concat(b.alwaysAllowDecimalCharacter,"] given."));c["default"].isNull(b.caretPositionOnFocus)||
c["default"].isInArray(b.caretPositionOnFocus,[d.options.caretPositionOnFocus.start,d.options.caretPositionOnFocus.end,d.options.caretPositionOnFocus.decimalLeft,d.options.caretPositionOnFocus.decimalRight])||c["default"].throwError("The display on empty string option 'caretPositionOnFocus' is invalid ; it should either be `null`, 'focus', 'press', 'always' or 'zero', [".concat(b.caretPositionOnFocus,"] given."));e=h?e:this._correctCaretPositionOnFocusAndSelectOnFocusOptions(a);c["default"].isNull(e)||
e.caretPositionOnFocus===d.options.caretPositionOnFocus.doNoForceCaretPosition||e.selectOnFocus!==d.options.selectOnFocus.select||c["default"].warning("The 'selectOnFocus' option is set to 'select', which is in conflict with the 'caretPositionOnFocus' which is set to '".concat(e.caretPositionOnFocus,"'. As a result, if this has been called when instantiating an AutoNumeric object, the 'selectOnFocus' option is forced to 'doNotSelect'."),b.showWarnings);c["default"].isInArray(b.digitGroupSeparator,
[d.options.digitGroupSeparator.comma,d.options.digitGroupSeparator.dot,d.options.digitGroupSeparator.normalSpace,d.options.digitGroupSeparator.thinSpace,d.options.digitGroupSeparator.narrowNoBreakSpace,d.options.digitGroupSeparator.noBreakSpace,d.options.digitGroupSeparator.noSeparator,d.options.digitGroupSeparator.apostrophe,d.options.digitGroupSeparator.arabicThousandsSeparator,d.options.digitGroupSeparator.dotAbove,d.options.digitGroupSeparator.privateUseTwo])||c["default"].throwError("The thousand separator character option 'digitGroupSeparator' is invalid ; it should be ',', '.', '\u066c', '\u02d9', \"'\", '\u0092', ' ', '\u2009', '\u202f', '\u00a0' or empty (''), [".concat(b.digitGroupSeparator,
"] given."));c["default"].isTrueOrFalseString(b.showOnlyNumbersOnFocus)||c["default"].isBoolean(b.showOnlyNumbersOnFocus)||c["default"].throwError("The 'showOnlyNumbersOnFocus' option is invalid ; it should be either 'true' or 'false', [".concat(b.showOnlyNumbersOnFocus,"] given."));c["default"].isInArray(b.digitalGroupSpacing,[d.options.digitalGroupSpacing.two,d.options.digitalGroupSpacing.twoThree,d.options.digitalGroupSpacing.twoScaled,d.options.digitalGroupSpacing.three,d.options.digitalGroupSpacing.four])||
2<=b.digitalGroupSpacing&&4>=b.digitalGroupSpacing||c["default"].throwError("The grouping separator option for thousands 'digitalGroupSpacing' is invalid ; it should be '2', '2t', '2s', '3', or '4', [".concat(b.digitalGroupSpacing,"] given."));c["default"].isInArray(b.decimalCharacter,[d.options.decimalCharacter.comma,d.options.decimalCharacter.dot,d.options.decimalCharacter.middleDot,d.options.decimalCharacter.arabicDecimalSeparator,d.options.decimalCharacter.decimalSeparatorKeySymbol])||c["default"].throwError("The decimal separator character option 'decimalCharacter' is invalid ; it should be '.', ',', '\u00b7', '\u2396' or '\u066b', [".concat(b.decimalCharacter,
"] given."));b.decimalCharacter===b.digitGroupSeparator&&c["default"].throwError("autoNumeric will not function properly when the decimal character 'decimalCharacter' [".concat(b.decimalCharacter,"] and the thousand separator 'digitGroupSeparator' [").concat(b.digitGroupSeparator,"] are the same character."));c["default"].isNull(b.decimalCharacterAlternative)||c["default"].isString(b.decimalCharacterAlternative)||c["default"].throwError("The alternate decimal separator character option 'decimalCharacterAlternative' is invalid ; it should be a string, [".concat(b.decimalCharacterAlternative,
"] given."));""===b.currencySymbol||c["default"].isString(b.currencySymbol)||c["default"].throwError("The currency symbol option 'currencySymbol' is invalid ; it should be a string, [".concat(b.currencySymbol,"] given."));c["default"].isInArray(b.currencySymbolPlacement,[d.options.currencySymbolPlacement.prefix,d.options.currencySymbolPlacement.suffix])||c["default"].throwError("The placement of the currency sign option 'currencySymbolPlacement' is invalid ; it should either be 'p' (prefix) or 's' (suffix), [".concat(b.currencySymbolPlacement,
"] given."));c["default"].isInArray(b.negativePositiveSignPlacement,[d.options.negativePositiveSignPlacement.prefix,d.options.negativePositiveSignPlacement.suffix,d.options.negativePositiveSignPlacement.left,d.options.negativePositiveSignPlacement.right,d.options.negativePositiveSignPlacement.none])||c["default"].throwError("The placement of the negative sign option 'negativePositiveSignPlacement' is invalid ; it should either be 'p' (prefix), 's' (suffix), 'l' (left), 'r' (right) or 'null', [".concat(b.negativePositiveSignPlacement,
"] given."));c["default"].isTrueOrFalseString(b.showPositiveSign)||c["default"].isBoolean(b.showPositiveSign)||c["default"].throwError("The show positive sign option 'showPositiveSign' is invalid ; it should be either 'true' or 'false', [".concat(b.showPositiveSign,"] given."));(!c["default"].isString(b.suffixText)||""!==b.suffixText&&(c["default"].isNegative(b.suffixText,b.negativeSignCharacter)||l.test(b.suffixText)))&&c["default"].throwError("The additional suffix option 'suffixText' is invalid ; it should not contains the negative sign '".concat(b.negativeSignCharacter,
"' nor any numerical characters, [").concat(b.suffixText,"] given."));(!c["default"].isString(b.negativeSignCharacter)||1!==b.negativeSignCharacter.length||c["default"].isUndefinedOrNullOrEmpty(b.negativeSignCharacter)||l.test(b.negativeSignCharacter))&&c["default"].throwError("The negative sign character option 'negativeSignCharacter' is invalid ; it should be a single character, and cannot be any numerical characters, [".concat(b.negativeSignCharacter,"] given."));(!c["default"].isString(b.positiveSignCharacter)||
1!==b.positiveSignCharacter.length||c["default"].isUndefinedOrNullOrEmpty(b.positiveSignCharacter)||l.test(b.positiveSignCharacter))&&c["default"].throwError("The positive sign character option 'positiveSignCharacter' is invalid ; it should be a single character, and cannot be any numerical characters, [".concat(b.positiveSignCharacter,"] given.\nIf you want to show the positive sign character, you need to set the `showPositiveSign` option to `true`."));b.negativeSignCharacter===b.positiveSignCharacter&&
c["default"].throwError("The positive 'positiveSignCharacter' and negative 'negativeSignCharacter' sign characters cannot be identical ; [".concat(b.negativeSignCharacter,"] given."));c["default"].isTrueOrFalseString(b.negativePositiveSignBehavior)||c["default"].isBoolean(b.negativePositiveSignBehavior)||c["default"].throwError("The option 'negativePositiveSignBehavior' is invalid ; it should be either 'true' or 'false', [".concat(b.negativePositiveSignBehavior,"] given."));e=c["default"].isNull(b.negativeBracketsTypeOnBlur)?
["",""]:b.negativeBracketsTypeOnBlur.split(",");h=w(e,2);e=h[0];h=h[1];(c["default"].contains(b.digitGroupSeparator,b.negativeSignCharacter)||c["default"].contains(b.decimalCharacter,b.negativeSignCharacter)||c["default"].contains(b.decimalCharacterAlternative,b.negativeSignCharacter)||c["default"].contains(e,b.negativeSignCharacter)||c["default"].contains(h,b.negativeSignCharacter)||c["default"].contains(b.suffixText,b.negativeSignCharacter))&&c["default"].throwError("The negative sign character option 'negativeSignCharacter' is invalid ; it should not be equal or a part of the digit separator, the decimal character, the decimal character alternative, the negative brackets or the suffix text, [".concat(b.negativeSignCharacter,
"] given."));(c["default"].contains(b.digitGroupSeparator,b.positiveSignCharacter)||c["default"].contains(b.decimalCharacter,b.positiveSignCharacter)||c["default"].contains(b.decimalCharacterAlternative,b.positiveSignCharacter)||c["default"].contains(e,b.positiveSignCharacter)||c["default"].contains(h,b.positiveSignCharacter)||c["default"].contains(b.suffixText,b.positiveSignCharacter))&&c["default"].throwError("The positive sign character option 'positiveSignCharacter' is invalid ; it should not be equal or a part of the digit separator, the decimal character, the decimal character alternative, the negative brackets or the suffix text, [".concat(b.positiveSignCharacter,
"] given."));c["default"].isNull(b.overrideMinMaxLimits)||c["default"].isInArray(b.overrideMinMaxLimits,[d.options.overrideMinMaxLimits.ceiling,d.options.overrideMinMaxLimits.floor,d.options.overrideMinMaxLimits.ignore,d.options.overrideMinMaxLimits.invalid])||c["default"].throwError("The override min \x26 max limits option 'overrideMinMaxLimits' is invalid ; it should either be 'ceiling', 'floor', 'ignore' or 'invalid', [".concat(b.overrideMinMaxLimits,"] given."));b.overrideMinMaxLimits!==d.options.overrideMinMaxLimits.invalid&&
b.overrideMinMaxLimits!==d.options.overrideMinMaxLimits.ignore&&(0<b.minimumValue||0>b.maximumValue)&&c["default"].warning("You've set a `minimumValue` or a `maximumValue` excluding the value `0`. AutoNumeric will force the users to always have a valid value in the input, hence preventing them to clear the field. If you want to allow for temporary invalid values (i.e. out-of-range), you should use the 'invalid' option for the 'overrideMinMaxLimits' setting.");c["default"].isString(b.maximumValue)&&
p.test(b.maximumValue)||c["default"].throwError("The maximum possible value option 'maximumValue' is invalid ; it should be a string that represents a positive or negative number, [".concat(b.maximumValue,"] given."));c["default"].isString(b.minimumValue)&&p.test(b.minimumValue)||c["default"].throwError("The minimum possible value option 'minimumValue' is invalid ; it should be a string that represents a positive or negative number, [".concat(b.minimumValue,"] given."));parseFloat(b.minimumValue)>
parseFloat(b.maximumValue)&&c["default"].throwError("The minimum possible value option is greater than the maximum possible value option ; 'minimumValue' [".concat(b.minimumValue,"] should be smaller than 'maximumValue' [").concat(b.maximumValue,"]."));c["default"].isInt(b.decimalPlaces)&&0<=b.decimalPlaces||c["default"].isString(b.decimalPlaces)&&g.test(b.decimalPlaces)||c["default"].throwError("The number of decimal places option 'decimalPlaces' is invalid ; it should be a positive integer, [".concat(b.decimalPlaces,
"] given."));c["default"].isNull(b.decimalPlacesRawValue)||c["default"].isInt(b.decimalPlacesRawValue)&&0<=b.decimalPlacesRawValue||c["default"].isString(b.decimalPlacesRawValue)&&g.test(b.decimalPlacesRawValue)||c["default"].throwError("The number of decimal places for the raw value option 'decimalPlacesRawValue' is invalid ; it should be a positive integer or `null`, [".concat(b.decimalPlacesRawValue,"] given."));this._validateDecimalPlacesRawValue(b);c["default"].isNull(b.decimalPlacesShownOnFocus)||
g.test(String(b.decimalPlacesShownOnFocus))||c["default"].throwError("The number of expanded decimal places option 'decimalPlacesShownOnFocus' is invalid ; it should be a positive integer or `null`, [".concat(b.decimalPlacesShownOnFocus,"] given."));!c["default"].isNull(b.decimalPlacesShownOnFocus)&&Number(b.decimalPlaces)>Number(b.decimalPlacesShownOnFocus)&&c["default"].warning("The extended decimal places 'decimalPlacesShownOnFocus' [".concat(b.decimalPlacesShownOnFocus,"] should be greater than the 'decimalPlaces' [").concat(b.decimalPlaces,
"] value. Currently, this will limit the ability of your user to manually change some of the decimal places. Do you really want to do that?"),b.showWarnings);(c["default"].isNull(b.divisorWhenUnfocused)||r.test(b.divisorWhenUnfocused))&&0!==b.divisorWhenUnfocused&&"0"!==b.divisorWhenUnfocused&&1!==b.divisorWhenUnfocused&&"1"!==b.divisorWhenUnfocused||c["default"].throwError("The divisor option 'divisorWhenUnfocused' is invalid ; it should be a positive number higher than one, preferably an integer, [".concat(b.divisorWhenUnfocused,
"] given."));c["default"].isNull(b.decimalPlacesShownOnBlur)||g.test(b.decimalPlacesShownOnBlur)||c["default"].throwError("The number of decimals shown when unfocused option 'decimalPlacesShownOnBlur' is invalid ; it should be a positive integer or `null`, [".concat(b.decimalPlacesShownOnBlur,"] given."));c["default"].isNull(b.symbolWhenUnfocused)||c["default"].isString(b.symbolWhenUnfocused)||c["default"].throwError("The symbol to show when unfocused option 'symbolWhenUnfocused' is invalid ; it should be a string, [".concat(b.symbolWhenUnfocused,
"] given."));c["default"].isTrueOrFalseString(b.saveValueToSessionStorage)||c["default"].isBoolean(b.saveValueToSessionStorage)||c["default"].throwError("The save to session storage option 'saveValueToSessionStorage' is invalid ; it should be either 'true' or 'false', [".concat(b.saveValueToSessionStorage,"] given."));c["default"].isInArray(b.onInvalidPaste,[d.options.onInvalidPaste.error,d.options.onInvalidPaste.ignore,d.options.onInvalidPaste.clamp,d.options.onInvalidPaste.truncate,d.options.onInvalidPaste.replace])||
c["default"].throwError("The paste behavior option 'onInvalidPaste' is invalid ; it should either be 'error', 'ignore', 'clamp', 'truncate' or 'replace' (cf. documentation), [".concat(b.onInvalidPaste,"] given."));c["default"].isInArray(b.roundingMethod,[d.options.roundingMethod.halfUpSymmetric,d.options.roundingMethod.halfUpAsymmetric,d.options.roundingMethod.halfDownSymmetric,d.options.roundingMethod.halfDownAsymmetric,d.options.roundingMethod.halfEvenBankersRounding,d.options.roundingMethod.upRoundAwayFromZero,
d.options.roundingMethod.downRoundTowardZero,d.options.roundingMethod.toCeilingTowardPositiveInfinity,d.options.roundingMethod.toFloorTowardNegativeInfinity,d.options.roundingMethod.toNearest05,d.options.roundingMethod.toNearest05Alt,d.options.roundingMethod.upToNext05,d.options.roundingMethod.downToNext05])||c["default"].throwError("The rounding method option 'roundingMethod' is invalid ; it should either be 'S', 'A', 's', 'a', 'B', 'U', 'D', 'C', 'F', 'N05', 'CHF', 'U05' or 'D05' (cf. documentation), [".concat(b.roundingMethod,
"] given."));c["default"].isNull(b.negativeBracketsTypeOnBlur)||c["default"].isInArray(b.negativeBracketsTypeOnBlur,[d.options.negativeBracketsTypeOnBlur.parentheses,d.options.negativeBracketsTypeOnBlur.brackets,d.options.negativeBracketsTypeOnBlur.chevrons,d.options.negativeBracketsTypeOnBlur.curlyBraces,d.options.negativeBracketsTypeOnBlur.angleBrackets,d.options.negativeBracketsTypeOnBlur.japaneseQuotationMarks,d.options.negativeBracketsTypeOnBlur.halfBrackets,d.options.negativeBracketsTypeOnBlur.whiteSquareBrackets,
d.options.negativeBracketsTypeOnBlur.quotationMarks,d.options.negativeBracketsTypeOnBlur.guillemets])||c["default"].throwError("The brackets for negative values option 'negativeBracketsTypeOnBlur' is invalid ; it should either be '(,)', '[,]', '\x3c,\x3e', '{,}', '\u3008,\u3009', '\uff62,\uff63', '\u2e24,\u2e25', '\u27e6,\u27e7', '\u2039,\u203a' or '\u00ab,\u00bb', [".concat(b.negativeBracketsTypeOnBlur,"] given."));(c["default"].isString(b.emptyInputBehavior)||c["default"].isNumber(b.emptyInputBehavior))&&
(c["default"].isInArray(b.emptyInputBehavior,[d.options.emptyInputBehavior.focus,d.options.emptyInputBehavior.press,d.options.emptyInputBehavior.always,d.options.emptyInputBehavior.min,d.options.emptyInputBehavior.max,d.options.emptyInputBehavior.zero,d.options.emptyInputBehavior["null"]])||p.test(b.emptyInputBehavior))||c["default"].throwError("The display on empty string option 'emptyInputBehavior' is invalid ; it should either be 'focus', 'press', 'always', 'min', 'max', 'zero', 'null', a number, or a string that represents a number, [".concat(b.emptyInputBehavior,
"] given."));b.emptyInputBehavior===d.options.emptyInputBehavior.zero&&(0<b.minimumValue||0>b.maximumValue)&&c["default"].throwError("The 'emptyInputBehavior' option is set to 'zero', but this value is outside of the range defined by 'minimumValue' and 'maximumValue' [".concat(b.minimumValue,", ").concat(b.maximumValue,"]."));p.test(String(b.emptyInputBehavior))&&(this._isWithinRangeWithOverrideOption(b.emptyInputBehavior,b)||c["default"].throwError("The 'emptyInputBehavior' option is set to a number or a string that represents a number, but its value [".concat(b.emptyInputBehavior,
"] is outside of the range defined by the 'minimumValue' and 'maximumValue' options [").concat(b.minimumValue,", ").concat(b.maximumValue,"].")));c["default"].isTrueOrFalseString(b.eventBubbles)||c["default"].isBoolean(b.eventBubbles)||c["default"].throwError("The event bubbles option 'eventBubbles' is invalid ; it should be either 'true' or 'false', [".concat(b.eventBubbles,"] given."));c["default"].isTrueOrFalseString(b.eventIsCancelable)||c["default"].isBoolean(b.eventIsCancelable)||c["default"].throwError("The event is cancelable option 'eventIsCancelable' is invalid ; it should be either 'true' or 'false', [".concat(b.eventIsCancelable,
"] given."));!c["default"].isBoolean(b.invalidClass)&&/^-?[_a-zA-Z]+[_a-zA-Z0-9-]*$/.test(b.invalidClass)||c["default"].throwError("The name of the 'invalidClass' option is not a valid CSS class name ; it should not be empty, and should follow the '^-?[_a-zA-Z]+[_a-zA-Z0-9-]*$' regex, [".concat(b.invalidClass,"] given."));c["default"].isInArray(b.leadingZero,[d.options.leadingZero.allow,d.options.leadingZero.deny,d.options.leadingZero.keep])||c["default"].throwError("The leading zero behavior option 'leadingZero' is invalid ; it should either be 'allow', 'deny' or 'keep', [".concat(b.leadingZero,
"] given."));c["default"].isTrueOrFalseString(b.formatOnPageLoad)||c["default"].isBoolean(b.formatOnPageLoad)||c["default"].throwError("The format on initialization option 'formatOnPageLoad' is invalid ; it should be either 'true' or 'false', [".concat(b.formatOnPageLoad,"] given."));c["default"].isTrueOrFalseString(b.formulaMode)||c["default"].isBoolean(b.formulaMode)||c["default"].throwError("The formula mode option 'formulaMode' is invalid ; it should be either 'true' or 'false', [".concat(b.formulaMode,
"] given."));g.test(b.historySize)&&0!==b.historySize||c["default"].throwError("The history size option 'historySize' is invalid ; it should be a positive integer, [".concat(b.historySize,"] given."));c["default"].isTrueOrFalseString(b.selectNumberOnly)||c["default"].isBoolean(b.selectNumberOnly)||c["default"].throwError("The select number only option 'selectNumberOnly' is invalid ; it should be either 'true' or 'false', [".concat(b.selectNumberOnly,"] given."));c["default"].isTrueOrFalseString(b.selectOnFocus)||
c["default"].isBoolean(b.selectOnFocus)||c["default"].throwError("The select on focus option 'selectOnFocus' is invalid ; it should be either 'true' or 'false', [".concat(b.selectOnFocus,"] given."));c["default"].isNull(b.defaultValueOverride)||""===b.defaultValueOverride||p.test(b.defaultValueOverride)||c["default"].throwError("The unformatted default value option 'defaultValueOverride' is invalid ; it should be a string that represents a positive or negative number, [".concat(b.defaultValueOverride,
"] given."));c["default"].isTrueOrFalseString(b.unformatOnSubmit)||c["default"].isBoolean(b.unformatOnSubmit)||c["default"].throwError("The remove formatting on submit option 'unformatOnSubmit' is invalid ; it should be either 'true' or 'false', [".concat(b.unformatOnSubmit,"] given."));c["default"].isNull(b.valuesToStrings)||c["default"].isObject(b.valuesToStrings)||c["default"].throwError("The option 'valuesToStrings' is invalid ; it should be an object, ideally with 'key -\x3e value' entries, [".concat(b.valuesToStrings,
"] given."));c["default"].isNull(b.outputFormat)||c["default"].isInArray(b.outputFormat,[d.options.outputFormat.string,d.options.outputFormat.number,d.options.outputFormat.dot,d.options.outputFormat.negativeDot,d.options.outputFormat.comma,d.options.outputFormat.negativeComma,d.options.outputFormat.dotNegative,d.options.outputFormat.commaNegative])||c["default"].throwError("The custom locale format option 'outputFormat' is invalid ; it should either be null, 'string', 'number', '.', '-.', ',', '-,', '.-' or ',-', [".concat(b.outputFormat,
"] given."));c["default"].isTrueOrFalseString(b.isCancellable)||c["default"].isBoolean(b.isCancellable)||c["default"].throwError("The cancellable behavior option 'isCancellable' is invalid ; it should be either 'true' or 'false', [".concat(b.isCancellable,"] given."));c["default"].isTrueOrFalseString(b.modifyValueOnUpDownArrow)||c["default"].isBoolean(b.modifyValueOnUpDownArrow)||c["default"].throwError("The increment/decrement on up and down arrow keys 'modifyValueOnUpDownArrow' is invalid ; it should be either 'true' or 'false', [".concat(b.modifyValueOnUpDownArrow,
"] given."));c["default"].isTrueOrFalseString(b.modifyValueOnWheel)||c["default"].isBoolean(b.modifyValueOnWheel)||c["default"].throwError("The increment/decrement on mouse wheel option 'modifyValueOnWheel' is invalid ; it should be either 'true' or 'false', [".concat(b.modifyValueOnWheel,"] given."));c["default"].isTrueOrFalseString(b.watchExternalChanges)||c["default"].isBoolean(b.watchExternalChanges)||c["default"].throwError("The option 'watchExternalChanges' is invalid ; it should be either 'true' or 'false', [".concat(b.watchExternalChanges,
"] given."));c["default"].isInArray(b.wheelOn,[d.options.wheelOn.focus,d.options.wheelOn.hover])||c["default"].throwError("The wheel behavior option 'wheelOn' is invalid ; it should either be 'focus' or 'hover', [".concat(b.wheelOn,"] given."));(!c["default"].isString(b.upDownStep)&&!c["default"].isNumber(b.upDownStep)||"progressive"!==b.upDownStep&&!r.test(b.upDownStep)||0===Number(b.upDownStep))&&c["default"].throwError("The up/down arrow step value option 'upDownStep' is invalid ; it should either be the string 'progressive', or a number or a string that represents a positive number (excluding zero), [".concat(b.upDownStep,
"] given."));(!c["default"].isString(b.wheelStep)&&!c["default"].isNumber(b.wheelStep)||"progressive"!==b.wheelStep&&!r.test(b.wheelStep)||0===Number(b.wheelStep))&&c["default"].throwError("The wheel step value option 'wheelStep' is invalid ; it should either be the string 'progressive', or a number or a string that represents a positive number (excluding zero), [".concat(b.wheelStep,"] given."));c["default"].isInArray(b.serializeSpaces,[d.options.serializeSpaces.plus,d.options.serializeSpaces.percent])||
c["default"].throwError("The space replacement character option 'serializeSpaces' is invalid ; it should either be '+' or '%20', [".concat(b.serializeSpaces,"] given."));c["default"].isTrueOrFalseString(b.noEventListeners)||c["default"].isBoolean(b.noEventListeners)||c["default"].throwError("The option 'noEventListeners' that prevent the creation of event listeners is invalid ; it should be either 'true' or 'false', [".concat(b.noEventListeners,"] given."));c["default"].isNull(b.styleRules)||c["default"].isObject(b.styleRules)&&
(Object.prototype.hasOwnProperty.call(b.styleRules,"positive")||Object.prototype.hasOwnProperty.call(b.styleRules,"negative")||Object.prototype.hasOwnProperty.call(b.styleRules,"ranges")||Object.prototype.hasOwnProperty.call(b.styleRules,"userDefined"))||c["default"].throwError("The option 'styleRules' is invalid ; it should be a correctly structured object, with one or more 'positive', 'negative', 'ranges' or 'userDefined' attributes, [".concat(b.styleRules,"] given."));c["default"].isNull(b.styleRules)||
!Object.prototype.hasOwnProperty.call(b.styleRules,"userDefined")||c["default"].isNull(b.styleRules.userDefined)||b.styleRules.userDefined.forEach(function(u){Object.prototype.hasOwnProperty.call(u,"callback")&&!c["default"].isFunction(u.callback)&&c["default"].throwError("The callback defined in the `userDefined` attribute is not a function, ".concat(x(u.callback)," given."))});(c["default"].isNull(b.rawValueDivisor)||r.test(b.rawValueDivisor))&&0!==b.rawValueDivisor&&"0"!==b.rawValueDivisor&&1!==
b.rawValueDivisor&&"1"!==b.rawValueDivisor||c["default"].throwError("The raw value divisor option 'rawValueDivisor' is invalid ; it should be a positive number higher than one, preferably an integer, [".concat(b.rawValueDivisor,"] given."));c["default"].isTrueOrFalseString(b.readOnly)||c["default"].isBoolean(b.readOnly)||c["default"].throwError("The option 'readOnly' is invalid ; it should be either 'true' or 'false', [".concat(b.readOnly,"] given."));c["default"].isTrueOrFalseString(b.unformatOnHover)||
c["default"].isBoolean(b.unformatOnHover)||c["default"].throwError("The option 'unformatOnHover' is invalid ; it should be either 'true' or 'false', [".concat(b.unformatOnHover,"] given."));c["default"].isTrueOrFalseString(b.failOnUnknownOption)||c["default"].isBoolean(b.failOnUnknownOption)||c["default"].throwError("The debug option 'failOnUnknownOption' is invalid ; it should be either 'true' or 'false', [".concat(b.failOnUnknownOption,"] given."));c["default"].isTrueOrFalseString(b.createLocalList)||
c["default"].isBoolean(b.createLocalList)||c["default"].throwError("The debug option 'createLocalList' is invalid ; it should be either 'true' or 'false', [".concat(b.createLocalList,"] given."))}},{key:"_validateDecimalPlacesRawValue",value:function(a){c["default"].isNull(a.decimalPlacesRawValue)||(a.decimalPlacesRawValue<a.decimalPlaces&&c["default"].warning("The number of decimal places to store in the raw value [".concat(a.decimalPlacesRawValue,"] is lower than the ones to display [").concat(a.decimalPlaces,
"]. This will likely confuse your users.\nTo solve that, you'd need to either set `decimalPlacesRawValue` to `null`, or set a number of decimal places for the raw value equal of bigger than `decimalPlaces`."),a.showWarnings),a.decimalPlacesRawValue<a.decimalPlacesShownOnFocus&&c["default"].warning("The number of decimal places to store in the raw value [".concat(a.decimalPlacesRawValue,"] is lower than the ones shown on focus [").concat(a.decimalPlacesShownOnFocus,"]. This will likely confuse your users.\nTo solve that, you'd need to either set `decimalPlacesRawValue` to `null`, or set a number of decimal places for the raw value equal of bigger than `decimalPlacesShownOnFocus`."),
a.showWarnings),a.decimalPlacesRawValue<a.decimalPlacesShownOnBlur&&c["default"].warning("The number of decimal places to store in the raw value [".concat(a.decimalPlacesRawValue,"] is lower than the ones shown when unfocused [").concat(a.decimalPlacesShownOnBlur,"]. This will likely confuse your users.\nTo solve that, you'd need to either set `decimalPlacesRawValue` to `null`, or set a number of decimal places for the raw value equal of bigger than `decimalPlacesShownOnBlur`."),a.showWarnings))}},
{key:"areSettingsValid",value:function(a){var b=!0;try{this.validate(a,!0)}catch(e){b=!1}return b}},{key:"getDefaultConfig",value:function(){return d.defaultSettings}},{key:"getPredefinedOptions",value:function(){return d.predefinedOptions}},{key:"_generateOptionsObjectFromOptionsArray",value:function(a){var b=this;if(c["default"].isUndefinedOrNullOrEmpty(a)||0===a.length)var e=null;else e={},1===a.length&&Array.isArray(a[0])?a[0].forEach(function(h){E(e,b._getOptionObject(h))}):1<=a.length&&a.forEach(function(h){E(e,
b._getOptionObject(h))});return e}},{key:"format",value:function(a){if(c["default"].isUndefined(a)||null===a)return null;var b=c["default"].isElement(a)?c["default"].getElementValue(a):a;c["default"].isString(b)||c["default"].isNumber(b)||c["default"].throwError('The value "'.concat(b,'" being "set" is not numeric and therefore cannot be used appropriately.'));for(var e=arguments.length,h=Array(1<e?e-1:0),g=1;g<e;g++)h[g-1]=arguments[g];e=this._generateOptionsObjectFromOptionsArray(h);e=E({},this.getDefaultConfig(),
e);e.isNegativeSignAllowed=0>b;e.isPositiveSignAllowed=0<=b;this._setBrackets(e);this._cachesUsualRegularExpressions(e,{});h=this._toNumericValue(b,e);isNaN(Number(h))&&c["default"].throwError("The value [".concat(h,"] that you are trying to format is not a recognized number."));this._isWithinRangeWithOverrideOption(h,e)||(c["default"].triggerEvent(d.events.formatted,document,{oldValue:null,newValue:null,oldRawValue:null,newRawValue:null,isPristine:null,error:"Range test failed",aNElement:null},!0,
!0),c["default"].throwError("The value [".concat(h,"] being set falls outside of the minimumValue [").concat(e.minimumValue,"] and maximumValue [").concat(e.maximumValue,"] range set for this element")));if(e.valuesToStrings&&this._checkValuesToStringsSettings(b,e))return e.valuesToStrings[b];this._correctNegativePositiveSignPlacementOption(e);this._calculateDecimalPlacesOnInit(e);c["default"].isUndefinedOrNullOrEmpty(e.rawValueDivisor)||0===e.rawValueDivisor||""===h||null===h||(h*=e.rawValueDivisor);
h=this._roundFormattedValueShownOnFocus(h,e);h=this._modifyNegativeSignAndDecimalCharacterForFormattedValue(h,e);return h=this._addGroupSeparators(h,e,!1,h)}},{key:"formatAndSet",value:function(a){var b=this.format(a,1<arguments.length&&void 0!==arguments[1]?arguments[1]:null);c["default"].setElementValue(a,b);return b}},{key:"unformat",value:function(a){if(c["default"].isNumberStrict(a))return a;var b=c["default"].isElement(a)?c["default"].getElementValue(a):a;if(""===b)return"";if(c["default"].isUndefined(b)||
null===b)return null;(c["default"].isArray(b)||c["default"].isObject(b))&&c["default"].throwError("A number or a string representing a number is needed to be able to unformat it, [".concat(b,"] given."));for(var e=arguments.length,h=Array(1<e?e-1:0),g=1;g<e;g++)h[g-1]=arguments[g];e=this._generateOptionsObjectFromOptionsArray(h);e=E({},this.getDefaultConfig(),e);e.isNegativeSignAllowed=!1;e.isPositiveSignAllowed=!0;b=b.toString();if(e.valuesToStrings&&this._checkStringsToValuesSettings(b,e))return c["default"].objectKeyLookup(e.valuesToStrings,
b);c["default"].isNegative(b,e.negativeSignCharacter)?(e.isNegativeSignAllowed=!0,e.isPositiveSignAllowed=!1):c["default"].isNull(e.negativeBracketsTypeOnBlur)||(h=e.negativeBracketsTypeOnBlur.split(","),h=w(h,2),e.firstBracket=h[0],e.lastBracket=h[1],b.charAt(0)===e.firstBracket&&b.charAt(b.length-1)===e.lastBracket&&(e.isNegativeSignAllowed=!0,e.isPositiveSignAllowed=!1,b=this._removeBrackets(b,e,!1)));b=this._convertToNumericString(b,e);c["default"].isNumber(Number(b))&&(b=c["default"].scientificToDecimal(b));
if(RegExp("[^+-0123456789.]","gi").test(b))return NaN;this._correctNegativePositiveSignPlacementOption(e);e.originalDecimalPlacesRawValue=e.decimalPlacesRawValue?e.decimalPlacesRawValue:e.decimalPlaces;this._calculateDecimalPlacesOnInit(e);c["default"].isUndefinedOrNullOrEmpty(e.rawValueDivisor)||0===e.rawValueDivisor||""===b||null===b||(b/=e.rawValueDivisor);b=this._roundRawValue(b,e);b=b.replace(e.decimalCharacter,".");return b=this._toLocale(b,e.outputFormat,e)}},{key:"unformatAndSet",value:function(a){var b=
this.unformat(a,1<arguments.length&&void 0!==arguments[1]?arguments[1]:null);c["default"].setElementValue(a,b);return b}},{key:"localize",value:function(a){var b=1<arguments.length&&void 0!==arguments[1]?arguments[1]:null;var e=c["default"].isElement(a)?c["default"].getElementValue(a):a;if(""===e)return"";c["default"].isNull(b)&&(b=d.defaultSettings);e=this.unformat(e,b);0===Number(e)&&b.leadingZero!==d.options.leadingZero.keep&&(e="0");var h=c["default"].isNull(b)?b.outputFormat:d.defaultSettings.outputFormat;
return this._toLocale(e,h,b)}},{key:"localizeAndSet",value:function(a){var b=this.localize(a,1<arguments.length&&void 0!==arguments[1]?arguments[1]:null);c["default"].setElementValue(a,b);return b}},{key:"isManagedByAutoNumeric",value:function(a){return this._isInGlobalList(c["default"].domElement(a))}},{key:"getAutoNumericElement",value:function(a){a=c["default"].domElement(a);return this.isManagedByAutoNumeric(a)?this._getFromGlobalList(a):null}},{key:"set",value:function(a,b){var e=2<arguments.length&&
void 0!==arguments[2]?arguments[2]:null,h=3<arguments.length&&void 0!==arguments[3]?arguments[3]:!0,g=c["default"].domElement(a);return this.isManagedByAutoNumeric(g)?this.getAutoNumericElement(g).set(b,e,h):(e=!c["default"].isNull(e)&&Object.prototype.hasOwnProperty.call(e,"showWarnings")?e.showWarnings:!0,c["default"].warning("Impossible to find an AutoNumeric object for the given DOM element or selector.",e),null)}},{key:"getNumericString",value:function(a){return this._get(a,"getNumericString",
1<arguments.length&&void 0!==arguments[1]?arguments[1]:null)}},{key:"getFormatted",value:function(a){return this._get(a,"getFormatted",1<arguments.length&&void 0!==arguments[1]?arguments[1]:null)}},{key:"getNumber",value:function(a){return this._get(a,"getNumber",1<arguments.length&&void 0!==arguments[1]?arguments[1]:null)}},{key:"_get",value:function(a,b){var e=2<arguments.length&&void 0!==arguments[2]?arguments[2]:null,h=c["default"].domElement(a);this.isManagedByAutoNumeric(h)||c["default"].throwError("Impossible to find an AutoNumeric object for the given DOM element or selector.");
return this.getAutoNumericElement(h)[b](e)}},{key:"getLocalized",value:function(a){var b=1<arguments.length&&void 0!==arguments[1]?arguments[1]:null,e=2<arguments.length&&void 0!==arguments[2]?arguments[2]:null,h=c["default"].domElement(a);this.isManagedByAutoNumeric(h)||c["default"].throwError("Impossible to find an AutoNumeric object for the given DOM element or selector.");return this.getAutoNumericElement(h).getLocalized(b,e)}},{key:"_stripAllNonNumberCharacters",value:function(a,b,e,h){return this._stripAllNonNumberCharactersExceptCustomDecimalChar(a,
b,e,h).replace(b.decimalCharacter,".")}},{key:"_stripAllNonNumberCharactersExceptCustomDecimalChar",value:function(a,b,e,h){a=this._normalizeCurrencySuffixAndNegativeSignCharacters(a,b);a=a.replace(b.allowedAutoStrip,"");var g=a.match(b.numRegAutoStrip);a=g?[g[1],g[2],g[3]].join(""):"";if(b.leadingZero===d.options.leadingZero.allow||b.leadingZero===d.options.leadingZero.keep){g="";a=a.split(b.decimalCharacter);var l=w(a,2);a=l[1];l=l[0];c["default"].contains(l,b.negativeSignCharacter)&&(g=b.negativeSignCharacter,
l=l.replace(b.negativeSignCharacter,""));""===g&&l.length>b.mIntPos&&"0"===l.charAt(0)&&(l=l.slice(1));""!==g&&l.length>b.mIntNeg&&"0"===l.charAt(0)&&(l=l.slice(1));a="".concat(g).concat(l).concat(c["default"].isUndefined(a)?"":b.decimalCharacter+a)}if(e&&b.leadingZero===d.options.leadingZero.deny||!h&&b.leadingZero===d.options.leadingZero.allow)a=a.replace(b.stripReg,"$1$2");return a}},{key:"_toggleNegativeBracket",value:function(a,b,e){return e?this._removeBrackets(a,b):this._addBrackets(a,b)}},
{key:"_addBrackets",value:function(a,b){return c["default"].isNull(b.negativeBracketsTypeOnBlur)?a:"".concat(b.firstBracket).concat(a.replace(b.negativeSignCharacter,"")).concat(b.lastBracket)}},{key:"_removeBrackets",value:function(a,b){var e=2<arguments.length&&void 0!==arguments[2]?arguments[2]:!0;if(c["default"].isNull(b.negativeBracketsTypeOnBlur)||a.charAt(0)!==b.firstBracket)var h=a;else h=a.replace(b.firstBracket,""),h=h.replace(b.lastBracket,""),e?(h=h.replace(b.currencySymbol,""),h=this._mergeCurrencySignNegativePositiveSignAndValue(h,
b,!0,!1)):h="".concat(b.negativeSignCharacter).concat(h);return h}},{key:"_setBrackets",value:function(a){if(c["default"].isNull(a.negativeBracketsTypeOnBlur))a.firstBracket="",a.lastBracket="";else{var b=a.negativeBracketsTypeOnBlur.split(",");b=w(b,2);var e=b[1];a.firstBracket=b[0];a.lastBracket=e}}},{key:"_convertToNumericString",value:function(a,b){a=this._removeBrackets(a,b,!1);a=this._normalizeCurrencySuffixAndNegativeSignCharacters(a,b);a=a.replace(new RegExp("[".concat(b.digitGroupSeparator,
"]"),"g"),"");"."!==b.decimalCharacter&&(a=a.replace(b.decimalCharacter,"."));c["default"].isNegative(a)&&a.lastIndexOf("-")===a.length-1&&(a=a.replace("-",""),a="-".concat(a));b.showPositiveSign&&(a=a.replace(b.positiveSignCharacter,""));b=c["default"].arabicToLatinNumbers(a,b.leadingZero!==d.options.leadingZero.keep,!1,!1);isNaN(b)||(a=b.toString());return a}},{key:"_normalizeCurrencySuffixAndNegativeSignCharacters",value:function(a,b){a=String(a);b.currencySymbol!==d.options.currencySymbol.none&&
(a=a.replace(b.currencySymbol,""));b.suffixText!==d.options.suffixText.none&&(a=a.replace(b.suffixText,""));b.negativeSignCharacter!==d.options.negativeSignCharacter.hyphen&&(a=a.replace(b.negativeSignCharacter,"-"));return a}},{key:"_toLocale",value:function(a,b,e){if(c["default"].isNull(b)||b===d.options.outputFormat.string)return a;switch(b){case d.options.outputFormat.number:var h=Number(a);break;case d.options.outputFormat.dotNegative:h=c["default"].isNegative(a)?a.replace("-","")+"-":a;break;
case d.options.outputFormat.comma:case d.options.outputFormat.negativeComma:h=a.replace(".",",");break;case d.options.outputFormat.commaNegative:h=a.replace(".",",");h=c["default"].isNegative(h)?h.replace("-","")+"-":h;break;case d.options.outputFormat.dot:case d.options.outputFormat.negativeDot:h=a;break;default:c["default"].throwError("The given outputFormat [".concat(b,"] option is not recognized."))}b!==d.options.outputFormat.number&&"-"!==e.negativeSignCharacter&&(h=h.replace("-",e.negativeSignCharacter));
return h}},{key:"_modifyNegativeSignAndDecimalCharacterForFormattedValue",value:function(a,b){"-"!==b.negativeSignCharacter&&(a=a.replace("-",b.negativeSignCharacter));"."!==b.decimalCharacter&&(a=a.replace(".",b.decimalCharacter));return a}},{key:"_isElementValueEmptyOrOnlyTheNegativeSign",value:function(a,b){return""===a||a===b.negativeSignCharacter}},{key:"_orderValueCurrencySymbolAndSuffixText",value:function(a,b,e){if(b.emptyInputBehavior===d.options.emptyInputBehavior.always||e)switch(b.negativePositiveSignPlacement){case d.options.negativePositiveSignPlacement.left:case d.options.negativePositiveSignPlacement.prefix:case d.options.negativePositiveSignPlacement.none:a=
a+b.currencySymbol+b.suffixText;break;default:a=b.currencySymbol+a+b.suffixText}return a}},{key:"_addGroupSeparators",value:function(a,b,e,h){var g=4<arguments.length&&void 0!==arguments[4]?arguments[4]:null;var l=c["default"].isNull(g)?c["default"].isNegative(a,b.negativeSignCharacter)||c["default"].isNegativeWithBrackets(a,b.firstBracket,b.lastBracket):0>g;a=this._stripAllNonNumberCharactersExceptCustomDecimalChar(a,b,!1,e);if(this._isElementValueEmptyOrOnlyTheNegativeSign(a,b))return this._orderValueCurrencySymbolAndSuffixText(a,
b,!0);var p=c["default"].isZeroOrHasNoValue(a);l&&(a=a.replace("-",""));var r=a.split(b.decimalCharacter),u=w(r,2);r=u[0];u=u[1];b.decimalCharacterAlternative&&c["default"].isUndefined(u)&&(r=a.split(b.decimalCharacterAlternative),u=w(r,2),r=u[0],u=u[1]);if(""!==b.digitGroupSeparator){b.digitalGroupSpacing=b.digitalGroupSpacing.toString();switch(b.digitalGroupSpacing){case d.options.digitalGroupSpacing.twoThree:var F=/(\d)((\d)(\d{2}?)+)$/;break;case d.options.digitalGroupSpacing.twoScaled:F=/(\d)((?:\d{2}){0,2}\d{3}(?:(?:\d{2}){2}\d{3})*?)$/;
break;default:F=new RegExp("(\\d)((\\d{".concat(b.digitalGroupSpacing,"}?)+)$"))}for(;F.test(r);)r=r.replace(F,"$1".concat(b.digitGroupSeparator,"$2"))}F=e?b.decimalPlacesShownOnFocus:b.decimalPlacesShownOnBlur;0===F||c["default"].isUndefined(u)?a=r:(u.length>F&&(u=u.substring(0,F)),a="".concat(r).concat(b.decimalCharacter).concat(u));a=d._mergeCurrencySignNegativePositiveSignAndValue(a,b,l,p);c["default"].isNull(g)&&(g=h);null!==b.negativeBracketsTypeOnBlur&&(0>g||c["default"].isNegativeStrict(a,
b.negativeSignCharacter))&&(a=this._toggleNegativeBracket(a,b,e));return b.suffixText?"".concat(a).concat(b.suffixText):a}},{key:"_mergeCurrencySignNegativePositiveSignAndValue",value:function(a,b,e,h){var g="";e?g=b.negativeSignCharacter:b.showPositiveSign&&!h&&(g=b.positiveSignCharacter);if(b.currencySymbolPlacement===d.options.currencySymbolPlacement.prefix)if(b.negativePositiveSignPlacement!==d.options.negativePositiveSignPlacement.none&&(e||!e&&b.showPositiveSign&&!h))switch(b.negativePositiveSignPlacement){case d.options.negativePositiveSignPlacement.prefix:case d.options.negativePositiveSignPlacement.left:var l=
"".concat(g).concat(b.currencySymbol).concat(a);break;case d.options.negativePositiveSignPlacement.right:l="".concat(b.currencySymbol).concat(g).concat(a);break;case d.options.negativePositiveSignPlacement.suffix:l="".concat(b.currencySymbol).concat(a).concat(g)}else l=b.currencySymbol+a;else if(b.currencySymbolPlacement===d.options.currencySymbolPlacement.suffix)if(b.negativePositiveSignPlacement!==d.options.negativePositiveSignPlacement.none&&(e||!e&&b.showPositiveSign&&!h))switch(b.negativePositiveSignPlacement){case d.options.negativePositiveSignPlacement.suffix:case d.options.negativePositiveSignPlacement.right:l=
"".concat(a).concat(b.currencySymbol).concat(g);break;case d.options.negativePositiveSignPlacement.left:l="".concat(a).concat(g).concat(b.currencySymbol);break;case d.options.negativePositiveSignPlacement.prefix:l="".concat(g).concat(a).concat(b.currencySymbol)}else l=a+b.currencySymbol;return l}},{key:"_truncateZeros",value:function(a,b){switch(b){case 0:var e=/(\.(?:\d*[1-9])?)0*$/;break;case 1:e=/(\.\d(?:\d*[1-9])?)0*$/;break;default:e=new RegExp("(\\.\\d{".concat(b,"}(?:\\d*[1-9])?)0*"))}a=a.replace(e,
"$1");0===b&&(a=a.replace(/\.$/,""));return a}},{key:"_roundRawValue",value:function(a,b){return this._roundValue(a,b,b.decimalPlacesRawValue)}},{key:"_roundFormattedValueShownOnFocus",value:function(a,b){return this._roundValue(a,b,Number(b.decimalPlacesShownOnFocus))}},{key:"_roundFormattedValueShownOnBlur",value:function(a,b){return this._roundValue(a,b,Number(b.decimalPlacesShownOnBlur))}},{key:"_roundFormattedValueShownOnFocusOrBlur",value:function(a,b,e){return e?this._roundFormattedValueShownOnFocus(a,
b):this._roundFormattedValueShownOnBlur(a,b)}},{key:"_roundValue",value:function(a,b,e){if(c["default"].isNull(a))return a;a=""===a?"0":a.toString();if(b.roundingMethod===d.options.roundingMethod.toNearest05||b.roundingMethod===d.options.roundingMethod.toNearest05Alt||b.roundingMethod===d.options.roundingMethod.upToNext05||b.roundingMethod===d.options.roundingMethod.downToNext05)return this._roundCloseTo05(a,b);var h=d._prepareValueForRounding(a,b),g=w(h,2);h=g[0];a=g[1];var l=a.lastIndexOf("."),
p=-1===l;g=a.split(".");g=w(g,2);var r=g[0];if(!(0<g[1]||b.allowDecimalPadding!==d.options.allowDecimalPadding.never&&b.allowDecimalPadding!==d.options.allowDecimalPadding.floats))return 0===Number(a)?r:"".concat(h).concat(r);g=b.allowDecimalPadding===d.options.allowDecimalPadding.always||b.allowDecimalPadding===d.options.allowDecimalPadding.floats?e:0<b.allowDecimalPadding?b.allowDecimalPadding:0;r=a.length-1-(p?a.length-1:l);if(r<=e){if(r<g)for(p&&(a="".concat(a).concat(b.decimalCharacter)),b="000000";r<
g;)b=b.substring(0,g-r),a+=b,r+=b.length;else r>g?a=this._truncateZeros(a,g):0===r&&0===g&&(a=a.replace(/\.$/,""));return 0===Number(a)?a:"".concat(h).concat(a)}e=p?e-1:Number(e)+Number(l);l=Number(a.charAt(e+1));p=a.substring(0,e+1).split("");a="."===a.charAt(e)?a.charAt(e-1)%2:a.charAt(e)%2;if(this._shouldRoundUp(l,b,h,a))for(b=p.length-1;0<=b;--b)if("."!==p[b]){p[b]=+p[b]+1;if(10>p[b])break;0<b&&(p[b]="0")}p=p.slice(0,e+1);a=this._truncateZeros(p.join(""),g);return 0===Number(a)?a:"".concat(h).concat(a)}},
{key:"_roundCloseTo05",value:function(a,b){switch(b.roundingMethod){case d.options.roundingMethod.toNearest05:case d.options.roundingMethod.toNearest05Alt:a=(Math.round(20*a)/20).toString();break;case d.options.roundingMethod.upToNext05:a=(Math.ceil(20*a)/20).toString();break;default:a=(Math.floor(20*a)/20).toString()}return c["default"].contains(a,".")?3>a.length-a.indexOf(".")?a+"0":a:a+".00"}},{key:"_prepareValueForRounding",value:function(a,b){var e="";c["default"].isNegativeStrict(a,"-")&&(e=
"-",a=a.replace("-",""));a.match(/^\d/)||(a="0".concat(a));0===Number(a)&&(e="");if(0<Number(a)&&b.leadingZero!==d.options.leadingZero.keep||0<a.length&&b.leadingZero===d.options.leadingZero.allow)a=a.replace(/^0*(\d)/,"$1");return[e,a]}},{key:"_shouldRoundUp",value:function(a,b,e,h){return 4<a&&b.roundingMethod===d.options.roundingMethod.halfUpSymmetric||4<a&&b.roundingMethod===d.options.roundingMethod.halfUpAsymmetric&&""===e||5<a&&b.roundingMethod===d.options.roundingMethod.halfUpAsymmetric&&"-"===
e||5<a&&b.roundingMethod===d.options.roundingMethod.halfDownSymmetric||5<a&&b.roundingMethod===d.options.roundingMethod.halfDownAsymmetric&&""===e||4<a&&b.roundingMethod===d.options.roundingMethod.halfDownAsymmetric&&"-"===e||5<a&&b.roundingMethod===d.options.roundingMethod.halfEvenBankersRounding||5===a&&b.roundingMethod===d.options.roundingMethod.halfEvenBankersRounding&&1===h||0<a&&b.roundingMethod===d.options.roundingMethod.toCeilingTowardPositiveInfinity&&""===e||0<a&&b.roundingMethod===d.options.roundingMethod.toFloorTowardNegativeInfinity&&
"-"===e||0<a&&b.roundingMethod===d.options.roundingMethod.upRoundAwayFromZero}},{key:"_truncateDecimalPlaces",value:function(a,b,e,h){e&&(a=this._roundFormattedValueShownOnFocus(a,b));e=a.split(b.decimalCharacter);var g=w(e,2);e=g[0];(g=g[1])&&g.length>h&&(0<h?(a=g.substring(0,h),a="".concat(e).concat(b.decimalCharacter).concat(a)):a=e);return a}},{key:"_checkIfInRangeWithOverrideOption",value:function(a,b){if(c["default"].isNull(a)&&b.emptyInputBehavior===d.options.emptyInputBehavior["null"]||b.overrideMinMaxLimits===
d.options.overrideMinMaxLimits.ignore||b.overrideMinMaxLimits===d.options.overrideMinMaxLimits.invalid)return[!0,!0];a=a.toString();a=a.replace(",",".");var e=c["default"].parseStr(b.minimumValue),h=c["default"].parseStr(b.maximumValue);a=c["default"].parseStr(a);switch(b.overrideMinMaxLimits){case d.options.overrideMinMaxLimits.floor:b=[-1<c["default"].testMinMax(e,a),!0];break;case d.options.overrideMinMaxLimits.ceiling:b=[!0,1>c["default"].testMinMax(h,a)];break;default:b=[-1<c["default"].testMinMax(e,
a),1>c["default"].testMinMax(h,a)]}return b}},{key:"_isWithinRangeWithOverrideOption",value:function(a,b){a=this._checkIfInRangeWithOverrideOption(a,b);a=w(a,2);b=a[1];return a[0]&&b}},{key:"_cleanValueForRangeParse",value:function(a){a=a.toString().replace(",",".");return c["default"].parseStr(a)}},{key:"_isMinimumRangeRespected",value:function(a,b){return-1<c["default"].testMinMax(c["default"].parseStr(b.minimumValue),this._cleanValueForRangeParse(a))}},{key:"_isMaximumRangeRespected",value:function(a,
b){return 1>c["default"].testMinMax(c["default"].parseStr(b.maximumValue),this._cleanValueForRangeParse(a))}},{key:"_correctNegativePositiveSignPlacementOption",value:function(a){if(c["default"].isNull(a.negativePositiveSignPlacement))if(c["default"].isUndefined(a)||!c["default"].isUndefinedOrNullOrEmpty(a.negativePositiveSignPlacement)||c["default"].isUndefinedOrNullOrEmpty(a.currencySymbol))a.negativePositiveSignPlacement=d.options.negativePositiveSignPlacement.left;else switch(a.currencySymbolPlacement){case d.options.currencySymbolPlacement.suffix:a.negativePositiveSignPlacement=
d.options.negativePositiveSignPlacement.prefix;break;case d.options.currencySymbolPlacement.prefix:a.negativePositiveSignPlacement=d.options.negativePositiveSignPlacement.left}}},{key:"_correctCaretPositionOnFocusAndSelectOnFocusOptions",value:function(a){if(c["default"].isNull(a))return null;!c["default"].isUndefinedOrNullOrEmpty(a.caretPositionOnFocus)&&c["default"].isUndefinedOrNullOrEmpty(a.selectOnFocus)&&(a.selectOnFocus=d.options.selectOnFocus.doNotSelect);c["default"].isUndefinedOrNullOrEmpty(a.caretPositionOnFocus)&&
!c["default"].isUndefinedOrNullOrEmpty(a.selectOnFocus)&&a.selectOnFocus===d.options.selectOnFocus.select&&(a.caretPositionOnFocus=d.options.caretPositionOnFocus.doNoForceCaretPosition);return a}},{key:"_calculateDecimalPlacesOnInit",value:function(a){this._validateDecimalPlacesRawValue(a);a.decimalPlacesShownOnFocus===d.options.decimalPlacesShownOnFocus.useDefault&&(a.decimalPlacesShownOnFocus=a.decimalPlaces);a.decimalPlacesShownOnBlur===d.options.decimalPlacesShownOnBlur.useDefault&&(a.decimalPlacesShownOnBlur=
a.decimalPlaces);a.decimalPlacesRawValue===d.options.decimalPlacesRawValue.useDefault&&(a.decimalPlacesRawValue=a.decimalPlaces);var b=0;a.rawValueDivisor&&a.rawValueDivisor!==d.options.rawValueDivisor.none&&(b=String(a.rawValueDivisor).length-1,0>b&&(b=0));a.decimalPlacesRawValue=Math.max(Math.max(a.decimalPlacesShownOnBlur,a.decimalPlacesShownOnFocus)+b,Number(a.originalDecimalPlacesRawValue)+b)}},{key:"_calculateDecimalPlacesOnUpdate",value:function(a){var b=1<arguments.length&&void 0!==arguments[1]?
arguments[1]:null;this._validateDecimalPlacesRawValue(a);c["default"].isNull(b)&&c["default"].throwError("When updating the settings, the previous ones should be passed as an argument.");var e="decimalPlaces"in a;if(e||"decimalPlacesRawValue"in a||"decimalPlacesShownOnFocus"in a||"decimalPlacesShownOnBlur"in a||"rawValueDivisor"in a)e?("decimalPlacesShownOnFocus"in a&&a.decimalPlacesShownOnFocus!==d.options.decimalPlacesShownOnFocus.useDefault||(a.decimalPlacesShownOnFocus=a.decimalPlaces),"decimalPlacesShownOnBlur"in
a&&a.decimalPlacesShownOnBlur!==d.options.decimalPlacesShownOnBlur.useDefault||(a.decimalPlacesShownOnBlur=a.decimalPlaces),"decimalPlacesRawValue"in a&&a.decimalPlacesRawValue!==d.options.decimalPlacesRawValue.useDefault||(a.decimalPlacesRawValue=a.decimalPlaces)):(c["default"].isUndefined(a.decimalPlacesShownOnFocus)&&(a.decimalPlacesShownOnFocus=b.decimalPlacesShownOnFocus),c["default"].isUndefined(a.decimalPlacesShownOnBlur)&&(a.decimalPlacesShownOnBlur=b.decimalPlacesShownOnBlur)),e=0,a.rawValueDivisor&&
a.rawValueDivisor!==d.options.rawValueDivisor.none&&(e=String(a.rawValueDivisor).length-1,0>e&&(e=0)),a.decimalPlacesRawValue=a.decimalPlaces||a.decimalPlacesRawValue?Math.max(Math.max(a.decimalPlacesShownOnBlur,a.decimalPlacesShownOnFocus)+e,Number(a.decimalPlacesRawValue)+e):Math.max(Math.max(a.decimalPlacesShownOnBlur,a.decimalPlacesShownOnFocus)+e,Number(b.originalDecimalPlacesRawValue)+e)}},{key:"_cachesUsualRegularExpressions",value:function(a,b){var e=a.negativeSignCharacter!==d.options.negativeSignCharacter.hyphen?
"([-\\".concat(a.negativeSignCharacter,"]?)"):"(-?)";b.aNegRegAutoStrip=e;a.allowedAutoStrip=new RegExp("[^-0123456789\\".concat(a.decimalCharacter,"]"),"g");a.numRegAutoStrip=new RegExp("".concat(e,"(?:\\").concat(a.decimalCharacter,"?([0-9]+\\").concat(a.decimalCharacter,"[0-9]+)|([0-9]*(?:\\").concat(a.decimalCharacter,"[0-9]*)?))"));a.stripReg=new RegExp("^".concat(b.aNegRegAutoStrip,"0*([0-9])"));a.formulaChars=new RegExp("[0-9".concat(a.decimalCharacter,"+\\-*/() ]"))}},{key:"_convertOldOptionsToNewOnes",
value:function(a){var b={aSep:"digitGroupSeparator",nSep:"showOnlyNumbersOnFocus",dGroup:"digitalGroupSpacing",aDec:"decimalCharacter",altDec:"decimalCharacterAlternative",aSign:"currencySymbol",pSign:"currencySymbolPlacement",pNeg:"negativePositiveSignPlacement",aSuffix:"suffixText",oLimits:"overrideMinMaxLimits",vMax:"maximumValue",vMin:"minimumValue",mDec:"decimalPlacesOverride",eDec:"decimalPlacesShownOnFocus",scaleDecimal:"decimalPlacesShownOnBlur",aStor:"saveValueToSessionStorage",mRound:"roundingMethod",
aPad:"allowDecimalPadding",nBracket:"negativeBracketsTypeOnBlur",wEmpty:"emptyInputBehavior",lZero:"leadingZero",aForm:"formatOnPageLoad",sNumber:"selectNumberOnly",anDefault:"defaultValueOverride",unSetOnSubmit:"unformatOnSubmit",outputType:"outputFormat",debug:"showWarnings",allowDecimalPadding:!0,alwaysAllowDecimalCharacter:!0,caretPositionOnFocus:!0,createLocalList:!0,currencySymbol:!0,currencySymbolPlacement:!0,decimalCharacter:!0,decimalCharacterAlternative:!0,decimalPlaces:!0,decimalPlacesRawValue:!0,
decimalPlacesShownOnBlur:!0,decimalPlacesShownOnFocus:!0,defaultValueOverride:!0,digitalGroupSpacing:!0,digitGroupSeparator:!0,divisorWhenUnfocused:!0,emptyInputBehavior:!0,eventBubbles:!0,eventIsCancelable:!0,failOnUnknownOption:!0,formatOnPageLoad:!0,formulaMode:!0,historySize:!0,isCancellable:!0,leadingZero:!0,maximumValue:!0,minimumValue:!0,modifyValueOnUpDownArrow:!0,modifyValueOnWheel:!0,negativeBracketsTypeOnBlur:!0,negativePositiveSignPlacement:!0,negativeSignCharacter:!0,negativePositiveSignBehavior:!0,
noEventListeners:!0,onInvalidPaste:!0,outputFormat:!0,overrideMinMaxLimits:!0,positiveSignCharacter:!0,rawValueDivisor:!0,readOnly:!0,roundingMethod:!0,saveValueToSessionStorage:!0,selectNumberOnly:!0,selectOnFocus:!0,serializeSpaces:!0,showOnlyNumbersOnFocus:!0,showPositiveSign:!0,showWarnings:!0,styleRules:!0,suffixText:!0,symbolWhenUnfocused:!0,upDownStep:!0,unformatOnHover:!0,unformatOnSubmit:!0,valuesToStrings:!0,watchExternalChanges:!0,wheelOn:!0,wheelStep:!0,allowedAutoStrip:!0,formulaChars:!0,
isNegativeSignAllowed:!0,isPositiveSignAllowed:!0,mIntNeg:!0,mIntPos:!0,numRegAutoStrip:!0,originalDecimalPlaces:!0,originalDecimalPlacesRawValue:!0,stripReg:!0},e;for(e in a)Object.prototype.hasOwnProperty.call(a,e)&&!0!==b[e]&&(Object.prototype.hasOwnProperty.call(b,e)?(c["default"].warning("You are using the deprecated option name '".concat(e,"'. Please use '").concat(b[e],"' instead from now on. The old option name will be dropped very soon\u2122."),!0),a[b[e]]=a[e],delete a[e]):a.failOnUnknownOption&&
c["default"].throwError("Option name '".concat(e,"' is unknown. Please fix the options passed to autoNumeric")));"mDec"in a&&c["default"].warning("The old `mDec` option has been deprecated in favor of more accurate options ; `decimalPlaces`, `decimalPlacesRawValue`, `decimalPlacesShownOnFocus` and `decimalPlacesShownOnBlur`.",!0)}},{key:"_setNegativePositiveSignPermissions",value:function(a){a.isNegativeSignAllowed=0>a.minimumValue;a.isPositiveSignAllowed=0<=a.maximumValue}},{key:"_toNumericValue",
value:function(a,b){if(c["default"].isNumber(Number(a))){c["default"].isNumberStrict(a)||(a=String(a).trim());var e=c["default"].scientificToDecimal(a)}else e=this._convertToNumericString(a.toString(),b),c["default"].isNumber(Number(e))||(c["default"].warning('The given value "'.concat(a,'" cannot be converted to a numeric one and therefore cannot be used appropriately.'),b.showWarnings),e=NaN);return e}},{key:"_checkIfInRange",value:function(a,b,e){a=c["default"].parseStr(a);return-1<c["default"].testMinMax(b,
a)&&1>c["default"].testMinMax(e,a)}},{key:"_shouldSkipEventKey",value:function(a){var b=c["default"].isInArray(a,f["default"].keyName._allFnKeys),e=a===f["default"].keyName.OSLeft||a===f["default"].keyName.OSRight,h=a===f["default"].keyName.ContextMenu,g=c["default"].isInArray(a,f["default"].keyName._someNonPrintableKeys),l=a===f["default"].keyName.NumLock||a===f["default"].keyName.ScrollLock||a===f["default"].keyName.Insert||a===f["default"].keyName.Command;a=a===f["default"].keyName.Unidentified;
return b||e||h||g||a||l}},{key:"_serialize",value:function(a){var b=this,e=1<arguments.length&&void 0!==arguments[1]?arguments[1]:!1,h=2<arguments.length&&void 0!==arguments[2]?arguments[2]:"unformatted",g=3<arguments.length&&void 0!==arguments[3]?arguments[3]:"+",l=4<arguments.length&&void 0!==arguments[4]?arguments[4]:null,p=[];"object"===x(a)&&"form"===a.nodeName.toLowerCase()&&Array.prototype.slice.call(a.elements).forEach(function(u){if(u.name&&!u.disabled&&-1===["file","reset","submit","button"].indexOf(u.type))if("select-multiple"===
u.type)Array.prototype.slice.call(u.options).forEach(function(O){O.selected&&(e?p.push({name:u.name,value:O.value}):p.push("".concat(encodeURIComponent(u.name),"\x3d").concat(encodeURIComponent(O.value))))});else if(-1===["checkbox","radio"].indexOf(u.type)||u.checked){var F;if(b.isManagedByAutoNumeric(u))switch(h){case "unformatted":var L=b.getAutoNumericElement(u);c["default"].isNull(L)||(F=b.unformat(u,L.getSettings()));break;case "localized":L=b.getAutoNumericElement(u);c["default"].isNull(L)||
(F=c["default"].cloneObject(L.getSettings()),c["default"].isNull(l)||(F.outputFormat=l),F=b.localize(u,F));break;default:F=u.value}else F=u.value;c["default"].isUndefined(F)&&c["default"].throwError("This error should never be hit. If it has, something really wrong happened!");e?p.push({name:u.name,value:F}):p.push("".concat(encodeURIComponent(u.name),"\x3d").concat(encodeURIComponent(F)))}});if(e)var r=p;else r=p.join("\x26"),"+"===g&&(r=r.replace(/%20/g,"+"));return r}},{key:"_serializeNumericString",
value:function(a){return this._serialize(a,!1,"unformatted",1<arguments.length&&void 0!==arguments[1]?arguments[1]:"+")}},{key:"_serializeFormatted",value:function(a){return this._serialize(a,!1,"formatted",1<arguments.length&&void 0!==arguments[1]?arguments[1]:"+")}},{key:"_serializeLocalized",value:function(a){return this._serialize(a,!1,"localized",1<arguments.length&&void 0!==arguments[1]?arguments[1]:"+",2<arguments.length&&void 0!==arguments[2]?arguments[2]:null)}},{key:"_serializeNumericStringArray",
value:function(a){return this._serialize(a,!0,"unformatted",1<arguments.length&&void 0!==arguments[1]?arguments[1]:"+")}},{key:"_serializeFormattedArray",value:function(a){return this._serialize(a,!0,"formatted",1<arguments.length&&void 0!==arguments[1]?arguments[1]:"+")}},{key:"_serializeLocalizedArray",value:function(a){return this._serialize(a,!0,"localized",1<arguments.length&&void 0!==arguments[1]?arguments[1]:"+",2<arguments.length&&void 0!==arguments[2]?arguments[2]:null)}}]);return d}();B(y,
"options",void 0);B(y,"events",void 0);B(y,"defaultSettings",void 0);B(y,"predefinedOptions",void 0);y.multiple=function(d){var a=1<arguments.length&&void 0!==arguments[1]?arguments[1]:null,b=2<arguments.length&&void 0!==arguments[2]?arguments[2]:null,e=[];c["default"].isObject(a)&&(b=a,a=null);if(c["default"].isString(d))d=q(document.querySelectorAll(d));else if(c["default"].isObject(d)){Object.prototype.hasOwnProperty.call(d,"rootElement")||c["default"].throwError("The object passed to the 'multiple' function is invalid ; no 'rootElement' attribute found.");
var h=q(d.rootElement.querySelectorAll("input"));Object.prototype.hasOwnProperty.call(d,"exclude")?(Array.isArray(d.exclude)||c["default"].throwError("The 'exclude' array passed to the 'multiple' function is invalid."),d=c["default"].filterOut(h,d.exclude)):d=h}else c["default"].isArray(d)||c["default"].throwError("The given parameters to the 'multiple' function are invalid.");if(0===d.length)return h=!0,!c["default"].isNull(b)&&c["default"].isBoolean(b.showWarnings)&&(h=b.showWarnings),c["default"].warning("No valid DOM elements were given hence no AutoNumeric objects were instantiated.",
h),[];var g=!1;h=!1;if(c["default"].isArray(a)&&1<=a.length){var l=x(Number(a[0]));(g="number"===l&&!isNaN(Number(a[0])))||"string"!==l&&!isNaN(l)&&"object"!==l||(h=!0)}l=!1;if(c["default"].isArray(b)&&1<=b.length){var p=x(b[0]);if("string"===p||"object"===p)l=!0}var r=h?y.mergeOptions(a):l?y.mergeOptions(b):b;var u=c["default"].isNumber(a);if(g)var F=a.length;d.forEach(function(L,O){u?e.push(new y(L,a,r)):g&&O<=F?e.push(new y(L,a[O],r)):e.push(new y(L,null,r))});return e}},"./src/AutoNumericDefaultSettings.js":function(n,
z,C){C.r(z);C.d(z,{"default":function(){return q}});n=C("./src/AutoNumeric.js");C("./src/AutoNumericOptions.js");n["default"].defaultSettings={allowDecimalPadding:n["default"].options.allowDecimalPadding.always,alwaysAllowDecimalCharacter:n["default"].options.alwaysAllowDecimalCharacter.doNotAllow,caretPositionOnFocus:n["default"].options.caretPositionOnFocus.doNoForceCaretPosition,createLocalList:n["default"].options.createLocalList.createList,currencySymbol:n["default"].options.currencySymbol.none,
currencySymbolPlacement:n["default"].options.currencySymbolPlacement.prefix,decimalCharacter:n["default"].options.decimalCharacter.dot,decimalCharacterAlternative:n["default"].options.decimalCharacterAlternative.none,decimalPlaces:n["default"].options.decimalPlaces.two,decimalPlacesRawValue:n["default"].options.decimalPlacesRawValue.useDefault,decimalPlacesShownOnBlur:n["default"].options.decimalPlacesShownOnBlur.useDefault,decimalPlacesShownOnFocus:n["default"].options.decimalPlacesShownOnFocus.useDefault,
defaultValueOverride:n["default"].options.defaultValueOverride.doNotOverride,digitalGroupSpacing:n["default"].options.digitalGroupSpacing.three,digitGroupSeparator:n["default"].options.digitGroupSeparator.comma,divisorWhenUnfocused:n["default"].options.divisorWhenUnfocused.none,emptyInputBehavior:n["default"].options.emptyInputBehavior.focus,eventBubbles:n["default"].options.eventBubbles.bubbles,eventIsCancelable:n["default"].options.eventIsCancelable.isCancelable,failOnUnknownOption:n["default"].options.failOnUnknownOption.ignore,
formatOnPageLoad:n["default"].options.formatOnPageLoad.format,formulaMode:n["default"].options.formulaMode.disabled,historySize:n["default"].options.historySize.medium,invalidClass:n["default"].options.invalidClass,isCancellable:n["default"].options.isCancellable.cancellable,leadingZero:n["default"].options.leadingZero.deny,maximumValue:n["default"].options.maximumValue.tenTrillions,minimumValue:n["default"].options.minimumValue.tenTrillions,modifyValueOnUpDownArrow:n["default"].options.modifyValueOnUpDownArrow.modifyValue,
modifyValueOnWheel:n["default"].options.modifyValueOnWheel.modifyValue,negativeBracketsTypeOnBlur:n["default"].options.negativeBracketsTypeOnBlur.none,negativePositiveSignPlacement:n["default"].options.negativePositiveSignPlacement.none,negativeSignCharacter:n["default"].options.negativeSignCharacter.hyphen,negativePositiveSignBehavior:n["default"].options.negativePositiveSignBehavior.doNotToggle,noEventListeners:n["default"].options.noEventListeners.addEvents,onInvalidPaste:n["default"].options.onInvalidPaste.error,
outputFormat:n["default"].options.outputFormat.none,overrideMinMaxLimits:n["default"].options.overrideMinMaxLimits.doNotOverride,positiveSignCharacter:n["default"].options.positiveSignCharacter.plus,rawValueDivisor:n["default"].options.rawValueDivisor.none,readOnly:n["default"].options.readOnly.readWrite,roundingMethod:n["default"].options.roundingMethod.halfUpSymmetric,saveValueToSessionStorage:n["default"].options.saveValueToSessionStorage.doNotSave,selectNumberOnly:n["default"].options.selectNumberOnly.selectNumbersOnly,
selectOnFocus:n["default"].options.selectOnFocus.select,serializeSpaces:n["default"].options.serializeSpaces.plus,showOnlyNumbersOnFocus:n["default"].options.showOnlyNumbersOnFocus.showAll,showPositiveSign:n["default"].options.showPositiveSign.hide,showWarnings:n["default"].options.showWarnings.show,styleRules:n["default"].options.styleRules.none,suffixText:n["default"].options.suffixText.none,symbolWhenUnfocused:n["default"].options.symbolWhenUnfocused.none,unformatOnHover:n["default"].options.unformatOnHover.unformat,
unformatOnSubmit:n["default"].options.unformatOnSubmit.keepCurrentValue,upDownStep:"1",valuesToStrings:n["default"].options.valuesToStrings.none,watchExternalChanges:n["default"].options.watchExternalChanges.doNotWatch,wheelOn:n["default"].options.wheelOn.focus,wheelStep:n["default"].options.wheelStep.progressive};Object.freeze(n["default"].defaultSettings);Object.defineProperty(n["default"],"defaultSettings",{configurable:!1,writable:!1});var q={}},"./src/AutoNumericEnum.js":function(n,z,C){C.r(z);
C.d(z,{"default":function(){return q}});n={allowedTagList:"b caption cite code const dd del div dfn dt em h1 h2 h3 h4 h5 h6 input ins kdb label li option output p q s sample span strong td th u".split(" ")};Object.freeze(n.allowedTagList);Object.defineProperty(n,"allowedTagList",{configurable:!1,writable:!1});n.fromCharCodeKeyCode={0:"LaunchCalculator",8:"Backspace",9:"Tab",13:"Enter",16:"Shift",17:"Ctrl",18:"Alt",19:"Pause",20:"CapsLock",27:"Escape",32:" ",33:"PageUp",34:"PageDown",35:"End",36:"Home",
37:"ArrowLeft",38:"ArrowUp",39:"ArrowRight",40:"ArrowDown",45:"Insert",46:"Delete",48:"0",49:"1",50:"2",51:"3",52:"4",53:"5",54:"6",55:"7",56:"8",57:"9",91:"OS",92:"OSRight",93:"ContextMenu",96:"0",97:"1",98:"2",99:"3",100:"4",101:"5",102:"6",103:"7",104:"8",105:"9",106:"*",107:"+",109:"-",110:".",111:"/",112:"F1",113:"F2",114:"F3",115:"F4",116:"F5",117:"F6",118:"F7",119:"F8",120:"F9",121:"F10",122:"F11",123:"F12",144:"NumLock",145:"ScrollLock",173:"-",182:"MyComputer",183:"MyCalculator",186:";",
187:"\x3d",188:",",189:"-",190:".",191:"/",192:"`",219:"[",220:"\\",221:"]",222:"'",224:"Meta",225:"AltGraph"};Object.freeze(n.fromCharCodeKeyCode);Object.defineProperty(n,"fromCharCodeKeyCode",{configurable:!1,writable:!1});n.keyName={Unidentified:"Unidentified",AndroidDefault:"AndroidDefault",Alt:"Alt",AltGr:"AltGraph",CapsLock:"CapsLock",Ctrl:"Control",Fn:"Fn",FnLock:"FnLock",Hyper:"Hyper",Meta:"Meta",OSLeft:"OS",OSRight:"OS",Command:"OS",NumLock:"NumLock",ScrollLock:"ScrollLock",Shift:"Shift",
Super:"Super",Symbol:"Symbol",SymbolLock:"SymbolLock",Enter:"Enter",Tab:"Tab",Space:" ",LeftArrow:"ArrowLeft",UpArrow:"ArrowUp",RightArrow:"ArrowRight",DownArrow:"ArrowDown",End:"End",Home:"Home",PageUp:"PageUp",PageDown:"PageDown",Backspace:"Backspace",Clear:"Clear",Copy:"Copy",CrSel:"CrSel",Cut:"Cut",Delete:"Delete",EraseEof:"EraseEof",ExSel:"ExSel",Insert:"Insert",Paste:"Paste",Redo:"Redo",Undo:"Undo",Accept:"Accept",Again:"Again",Attn:"Attn",Cancel:"Cancel",ContextMenu:"ContextMenu",Esc:"Escape",
Execute:"Execute",Find:"Find",Finish:"Finish",Help:"Help",Pause:"Pause",Play:"Play",Props:"Props",Select:"Select",ZoomIn:"ZoomIn",ZoomOut:"ZoomOut",BrightnessDown:"BrightnessDown",BrightnessUp:"BrightnessUp",Eject:"Eject",LogOff:"LogOff",Power:"Power",PowerOff:"PowerOff",PrintScreen:"PrintScreen",Hibernate:"Hibernate",Standby:"Standby",WakeUp:"WakeUp",Compose:"Compose",Dead:"Dead",F1:"F1",F2:"F2",F3:"F3",F4:"F4",F5:"F5",F6:"F6",F7:"F7",F8:"F8",F9:"F9",F10:"F10",F11:"F11",F12:"F12",Print:"Print",num0:"0",
num1:"1",num2:"2",num3:"3",num4:"4",num5:"5",num6:"6",num7:"7",num8:"8",num9:"9",a:"a",b:"b",c:"c",d:"d",e:"e",f:"f",g:"g",h:"h",i:"i",j:"j",k:"k",l:"l",m:"m",n:"n",o:"o",p:"p",q:"q",r:"r",s:"s",t:"t",u:"u",v:"v",w:"w",x:"x",y:"y",z:"z",A:"A",B:"B",C:"C",D:"D",E:"E",F:"F",G:"G",H:"H",I:"I",J:"J",K:"K",L:"L",M:"M",N:"N",O:"O",P:"P",Q:"Q",R:"R",S:"S",T:"T",U:"U",V:"V",W:"W",X:"X",Y:"Y",Z:"Z",Semicolon:";",Equal:"\x3d",Comma:",",Hyphen:"-",Minus:"-",Plus:"+",Dot:".",Slash:"/",Backquote:"`",LeftParenthesis:"(",
RightParenthesis:")",LeftBracket:"[",RightBracket:"]",Backslash:"\\",Quote:"'",numpad0:"0",numpad1:"1",numpad2:"2",numpad3:"3",numpad4:"4",numpad5:"5",numpad6:"6",numpad7:"7",numpad8:"8",numpad9:"9",NumpadDot:".",NumpadDotAlt:",",NumpadMultiply:"*",NumpadPlus:"+",NumpadMinus:"-",NumpadSubtract:"-",NumpadSlash:"/",NumpadDotObsoleteBrowsers:"Decimal",NumpadMultiplyObsoleteBrowsers:"Multiply",NumpadPlusObsoleteBrowsers:"Add",NumpadMinusObsoleteBrowsers:"Subtract",NumpadSlashObsoleteBrowsers:"Divide",
_allFnKeys:"F1 F2 F3 F4 F5 F6 F7 F8 F9 F10 F11 F12".split(" "),_someNonPrintableKeys:"Tab Enter Shift ShiftLeft ShiftRight Control ControlLeft ControlRight Alt AltLeft AltRight Pause CapsLock Escape".split(" "),_directionKeys:"PageUp PageDown End Home ArrowDown ArrowLeft ArrowRight ArrowUp".split(" ")};Object.freeze(n.keyName._allFnKeys);Object.freeze(n.keyName._someNonPrintableKeys);Object.freeze(n.keyName._directionKeys);Object.freeze(n.keyName);Object.defineProperty(n,"keyName",{configurable:!1,
writable:!1});Object.freeze(n);var q=n},"./src/AutoNumericEvents.js":function(n,z,C){C.r(z);C.d(z,{"default":function(){return q}});n=C("./src/AutoNumeric.js");n["default"].events={correctedValue:"autoNumeric:correctedValue",initialized:"autoNumeric:initialized",invalidFormula:"autoNumeric:invalidFormula",invalidValue:"autoNumeric:invalidValue",formatted:"autoNumeric:formatted",rawValueModified:"autoNumeric:rawValueModified",minRangeExceeded:"autoNumeric:minExceeded",maxRangeExceeded:"autoNumeric:maxExceeded",
"native":{input:"input",change:"change"},validFormula:"autoNumeric:validFormula"};Object.freeze(n["default"].events.native);Object.freeze(n["default"].events);Object.defineProperty(n["default"],"events",{configurable:!1,writable:!1});var q={}},"./src/AutoNumericHelper.js":function(n,z,C){function q(c){var f=Array.isArray(c)?E(c):void 0;f||(f="undefined"!==typeof Symbol&&null!=c[Symbol.iterator]||null!=c["@@iterator"]?Array.from(c):void 0);if(!(c=f||I(c)))throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
return c}function w(){w=Object.assign?Object.assign.bind():function(c){for(var f=1;f<arguments.length;f++){var k=arguments[f],m;for(m in k)Object.prototype.hasOwnProperty.call(k,m)&&(c[m]=k[m])}return c};return w.apply(this,arguments)}function K(c,f){var k=Array.isArray(c)?c:void 0;if(!k)a:{var m=null==c?null:"undefined"!=typeof Symbol&&c[Symbol.iterator]||c["@@iterator"];if(null!=m){var y,d,a,b=[],e=!0,h=!1;try{if(d=(m=m.call(c)).next,0===f){if(Object(m)!==m){k=void 0;break a}e=!1}else for(;!(e=
(y=d.call(m)).done)&&(b.push(y.value),b.length!==f);e=!0);}catch(l){h=!0;var g=l}finally{try{if(!e&&null!=m["return"]&&(a=m["return"](),Object(a)!==a)){k=void 0;break a}}finally{if(h)throw g;}}k=b}else k=void 0}if(!(c=k||I(c,f)))throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");return c}function I(c,f){if(c){if("string"===typeof c)return E(c,f);var k=Object.prototype.toString.call(c).slice(8,
-1);"Object"===k&&c.constructor&&(k=c.constructor.name);if("Map"===k||"Set"===k)return Array.from(c);if("Arguments"===k||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(k))return E(c,f)}}function E(c,f){if(null==f||f>c.length)f=c.length;for(var k=0,m=Array(f);k<f;k++)m[k]=c[k];return m}function x(c){"@babel/helpers - typeof";return x="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(f){return typeof f}:function(f){return f&&"function"==typeof Symbol&&f.constructor===Symbol&&f!==
Symbol.prototype?"symbol":typeof f},x(c)}function A(c,f){for(var k=0;k<f.length;k++){var m=f[k];m.enumerable=m.enumerable||!1;m.configurable=!0;"value"in m&&(m.writable=!0);var y=Object,d=y.defineProperty;a:{var a=m.key;if("object"===x(a)&&null!==a){var b=a[Symbol.toPrimitive];if(void 0!==b){a=b.call(a,"string");if("object"!==x(a))break a;throw new TypeError("@@toPrimitive must return a primitive value.");}a=String(a)}}a="symbol"===x(a)?a:String(a);d.call(y,c,a,m)}}function v(c,f,k){f&&A(c.prototype,
f);k&&A(c,k);Object.defineProperty(c,"prototype",{writable:!1});return c}C.r(z);C.d(z,{"default":function(){return H}});var B=C("./src/AutoNumericEnum.js"),H=function(){function c(){if(!(this instanceof c))throw new TypeError("Cannot call a class as a function");}v(c,null,[{key:"isNull",value:function(f){return null===f}},{key:"isUndefined",value:function(f){return void 0===f}},{key:"isUndefinedOrNullOrEmpty",value:function(f){return null===f||void 0===f||""===f}},{key:"isString",value:function(f){return"string"===
typeof f||f instanceof String}},{key:"isEmptyString",value:function(f){return""===f}},{key:"isBoolean",value:function(f){return"boolean"===typeof f}},{key:"isTrueOrFalseString",value:function(f){f=String(f).toLowerCase();return"true"===f||"false"===f}},{key:"isObject",value:function(f){return"object"===x(f)&&null!==f&&!Array.isArray(f)}},{key:"isEmptyObj",value:function(f){for(var k in f)if(Object.prototype.hasOwnProperty.call(f,k))return!1;return!0}},{key:"isNumberStrict",value:function(f){return"number"===
typeof f}},{key:"isNumber",value:function(f){return!this.isArray(f)&&!isNaN(parseFloat(f))&&isFinite(f)}},{key:"isDigit",value:function(f){return/\d/.test(f)}},{key:"isNumberOrArabic",value:function(f){f=this.arabicToLatinNumbers(f,!1,!0,!0);return this.isNumber(f)}},{key:"isInt",value:function(f){return"number"===typeof f&&parseFloat(f)===parseInt(f,10)&&!isNaN(f)}},{key:"isFunction",value:function(f){return"function"===typeof f}},{key:"contains",value:function(f,k){return this.isString(f)&&this.isString(k)&&
""!==f&&""!==k?-1!==f.indexOf(k):!1}},{key:"isInArray",value:function(f,k){return!this.isArray(k)||k===[]||this.isUndefined(f)?!1:-1!==k.indexOf(f)}},{key:"isArray",value:function(f){if("[object Array]"===Object.prototype.toString.call([]))return Array.isArray(f)||"object"===x(f)&&"[object Array]"===Object.prototype.toString.call(f);throw Error("toString message changed for Object Array");}},{key:"isElement",value:function(f){return"undefined"===typeof Element?!1:f instanceof Element}},{key:"isInputElement",
value:function(f){return this.isElement(f)&&"input"===f.tagName.toLowerCase()}},{key:"decimalPlaces",value:function(f){f=f.split(".");f=K(f,2)[1];return this.isUndefined(f)?0:f.length}},{key:"indexFirstNonZeroDecimalPlace",value:function(f){f=String(Math.abs(f)).split(".");f=K(f,2)[1];if(this.isUndefined(f))return 0;f=f.lastIndexOf("0");return-1===f?0:f+2}},{key:"keyCodeNumber",value:function(f){return"undefined"===typeof f.which?f.keyCode:f.which}},{key:"character",value:function(f){if("Unidentified"===
f.key||void 0===f.key||this.isSeleniumBot()){f=this.keyCodeNumber(f);if(229===f)return B["default"].keyName.AndroidDefault;var k=B["default"].fromCharCodeKeyCode[f];f=c.isUndefinedOrNullOrEmpty(k)?String.fromCharCode(f):k}else switch(f.key){case "Add":f=B["default"].keyName.NumpadPlus;break;case "Apps":f=B["default"].keyName.ContextMenu;break;case "Crsel":f=B["default"].keyName.CrSel;break;case "Decimal":f=f["char"]?f["char"]:B["default"].keyName.NumpadDot;break;case "Del":f=B["default"].keyName.Delete;
break;case "Divide":f=B["default"].keyName.NumpadSlash;break;case "Down":f=B["default"].keyName.DownArrow;break;case "Esc":f=B["default"].keyName.Esc;break;case "Exsel":f=B["default"].keyName.ExSel;break;case "Left":f=B["default"].keyName.LeftArrow;break;case "Meta":case "Super":f=B["default"].keyName.OSLeft;break;case "Multiply":f=B["default"].keyName.NumpadMultiply;break;case "Right":f=B["default"].keyName.RightArrow;break;case "Spacebar":f=B["default"].keyName.Space;break;case "Subtract":f=B["default"].keyName.NumpadMinus;
break;case "Up":f=B["default"].keyName.UpArrow;break;default:f=f.key}return f}},{key:"browser",value:function(){var f=navigator.userAgent,k=f.match(/(opera|chrome|safari|firefox|msie|trident(?=\/))\/?\s*(\d+)/i)||[];if(/trident/i.test(k[1])){var m=/\brv[ :]+(\d+)/g.exec(f)||[];return{name:"ie",version:m[1]||""}}if("Chrome"===k[1]&&(m=f.match(/\b(OPR|Edge)\/(\d+)/),null!==m))return{name:m[1].replace("OPR","opera"),version:m[2]};k=k[2]?[k[1],k[2]]:[navigator.appName,navigator.appVersion,"-?"];null!==
(m=f.match(/version\/(\d+)/i))&&k.splice(1,1,m[1]);return{name:k[0].toLowerCase(),version:k[1]}}},{key:"isSeleniumBot",value:function(){return!0===window.navigator.webdriver}},{key:"isNegative",value:function(f){var k=1<arguments.length&&void 0!==arguments[1]?arguments[1]:"-",m=2<arguments.length&&void 0!==arguments[2]?arguments[2]:!0;return f===k?!0:""===f?!1:c.isNumber(f)?0>f:m?this.contains(f,k):this.isNegativeStrict(f,k)}},{key:"isNegativeStrict",value:function(f){var k=1<arguments.length&&void 0!==
arguments[1]?arguments[1]:"-";return f.charAt(0)===k}},{key:"isNegativeWithBrackets",value:function(f,k,m){return f.charAt(0)===k&&this.contains(f,m)}},{key:"isZeroOrHasNoValue",value:function(f){return!/[1-9]/g.test(f)}},{key:"setRawNegativeSign",value:function(f){return this.isNegativeStrict(f,"-")?f:"-".concat(f)}},{key:"replaceCharAt",value:function(f,k,m){return"".concat(f.substr(0,k)).concat(m).concat(f.substr(k+m.length))}},{key:"clampToRangeLimits",value:function(f,k){return Math.max(k.minimumValue,
Math.min(k.maximumValue,f))}},{key:"countNumberCharactersOnTheCaretLeftSide",value:function(f,k,m){m=new RegExp("[0-9".concat(m,"-]"));for(var y=0,d=0;d<k;d++)m.test(f[d])&&y++;return y}},{key:"findCaretPositionInFormattedNumber",value:function(f,k,m,y){var d=m.length,a=f.length,b,e=0;for(b=0;b<d&&e<a&&e<k;b++)(f[e]===m[b]||"."===f[e]&&m[b]===y)&&e++;return b}},{key:"countCharInText",value:function(f,k){for(var m=0,y=0;y<k.length;y++)k[y]===f&&m++;return m}},{key:"convertCharacterCountToIndexPosition",
value:function(f){return Math.max(f,f-1)}},{key:"getElementSelection",value:function(f){var k={};try{var m=this.isUndefined(f.selectionStart)}catch(d){m=!1}try{if(m){var y=window.getSelection().getRangeAt(0);k.start=y.startOffset;k.end=y.endOffset}else k.start=f.selectionStart,k.end=f.selectionEnd;k.length=k.end-k.start}catch(d){k.start=0,k.end=0,k.length=0}return k}},{key:"setElementSelection",value:function(f,k){var m=2<arguments.length&&void 0!==arguments[2]?arguments[2]:null;this.isUndefinedOrNullOrEmpty(m)&&
(m=k);if(this.isInputElement(f))f.setSelectionRange(k,m);else if(!c.isNull(f.firstChild)){var y=document.createRange();y.setStart(f.firstChild,k);y.setEnd(f.firstChild,m);m=window.getSelection();m.removeAllRanges();m.addRange(y)}}},{key:"throwError",value:function(f){throw Error(f);}},{key:"warning",value:function(f){(1<arguments.length&&void 0!==arguments[1]?arguments[1]:1)&&console.warn("Warning: ".concat(f))}},{key:"isWheelEvent",value:function(f){return f instanceof WheelEvent}},{key:"isWheelUpEvent",
value:function(f){this.isWheelEvent(f)&&!this.isUndefinedOrNullOrEmpty(f.deltaY)||this.throwError("The event passed as a parameter is not a valid wheel event, '".concat(f.type,"' given."));return 0>f.deltaY}},{key:"isWheelDownEvent",value:function(f){this.isWheelEvent(f)&&!this.isUndefinedOrNullOrEmpty(f.deltaY)||this.throwError("The event passed as a parameter is not a valid wheel event, '".concat(f.type,"' given."));return 0<f.deltaY}},{key:"isWheelEventWithZeroDeltaY",value:function(f){return this.isWheelEvent(f)&&
!this.isUndefinedOrNullOrEmpty(f.deltaY)&&0===f.deltaY}},{key:"forceDecimalPlaces",value:function(f,k){var m=String(f).split(".");m=K(m,2);var y=m[1];return y?"".concat(m[0],".").concat(y.substr(0,k)):f}},{key:"roundToNearest",value:function(f){var k=1<arguments.length&&void 0!==arguments[1]?arguments[1]:1E3;if(0===f)return 0;0===k&&this.throwError("The `stepPlace` used to round is equal to `0`. This value must not be equal to zero.");return Math.round(f/k)*k}},{key:"modifyAndRoundToNearestAuto",
value:function(f,k,m){f=Number(this.forceDecimalPlaces(f,m));var y=Math.abs(f);if(0<=y&&1>y){y=Math.pow(10,-m);if(0===f)return k?y:-y;var d=this.indexFirstNonZeroDecimalPlace(f);m=d>=m-1?y:Math.pow(10,-(d+1));return this.roundToNearest(k?f+m:f-m,m)}f=parseInt(f,10);m=Math.abs(f).toString().length;switch(m){case 1:m=0;break;case 2:case 3:m=1;break;case 4:case 5:m=2;break;default:m-=3}m=Math.pow(10,m);f=k?f+m:f-m;return 10>=f&&-10<=f?f:this.roundToNearest(f,m)}},{key:"addAndRoundToNearestAuto",value:function(f,
k){return this.modifyAndRoundToNearestAuto(f,!0,k)}},{key:"subtractAndRoundToNearestAuto",value:function(f,k){return this.modifyAndRoundToNearestAuto(f,!1,k)}},{key:"arabicToLatinNumbers",value:function(f){var k=1<arguments.length&&void 0!==arguments[1]?arguments[1]:!0,m=2<arguments.length&&void 0!==arguments[2]?arguments[2]:!1,y=3<arguments.length&&void 0!==arguments[3]?arguments[3]:!1;if(this.isNull(f))return f;var d=f.toString();if(""===d)return f;if(null===d.match(/[\u0660\u0661\u0662\u0663\u0664\u0665\u0666\u0667\u0668\u0669\u06f4\u06f5\u06f6]/g))return k&&
(d=Number(d)),d;m&&(d=d.replace(/\u066b/,"."));y&&(d=d.replace(/\u066c/g,""));d=d.replace(/[\u0660\u0661\u0662\u0663\u0664\u0665\u0666\u0667\u0668\u0669]/g,function(a){return a.charCodeAt(0)-1632}).replace(/[\u06f0\u06f1\u06f2\u06f3\u06f4\u06f5\u06f6\u06f7\u06f8\u06f9]/g,function(a){return a.charCodeAt(0)-1776});m=Number(d);if(isNaN(m))return m;k&&(d=m);return d}},{key:"triggerEvent",value:function(f){var k=1<arguments.length&&void 0!==arguments[1]?arguments[1]:document,m=2<arguments.length&&void 0!==
arguments[2]?arguments[2]:null,y=3<arguments.length&&void 0!==arguments[3]?arguments[3]:!0,d=4<arguments.length&&void 0!==arguments[4]?arguments[4]:!0;if(window.CustomEvent)var a=new CustomEvent(f,{detail:m,bubbles:y,cancelable:d});else a=document.createEvent("CustomEvent"),a.initCustomEvent(f,y,d,{detail:m});k.dispatchEvent(a)}},{key:"parseStr",value:function(f){var k={},m;0===f&&0>1/f&&(f="-0");f=f.toString();this.isNegativeStrict(f,"-")?(f=f.slice(1),k.s=-1):k.s=1;var y=f.indexOf(".");-1<y&&(f=
f.replace(".",""));0>y&&(y=f.length);var d=-1===f.search(/[1-9]/i)?f.length:f.search(/[1-9]/i);var a=f.length;if(d===a)k.e=0,k.c=[0];else{for(m=a-1;"0"===f.charAt(m);--m)--a;--a;k.e=y-d-1;k.c=[];for(y=0;d<=a;d+=1)k.c[y]=+f.charAt(d),y+=1}return k}},{key:"testMinMax",value:function(f,k){var m=k.c,y=f.c,d=k.s,a=f.s;k=k.e;f=f.e;if(!m[0]||!y[0])return m[0]?d:y[0]?-a:0;if(d!==a)return d;var b=0>d;if(k!==f)return k>f^b?1:-1;k=m.length;f=y.length;a=k<f?k:f;for(d=0;d<a;d+=1)if(m[d]!==y[d])return m[d]>y[d]^
b?1:-1;return k===f?0:k>f^b?1:-1}},{key:"randomString",value:function(){var f=0<arguments.length&&void 0!==arguments[0]?arguments[0]:5;return Math.random().toString(36).substr(2,f)}},{key:"domElement",value:function(f){return c.isString(f)?document.querySelector(f):f}},{key:"getElementValue",value:function(f){return"input"===f.tagName.toLowerCase()?f.value:this.text(f)}},{key:"setElementValue",value:function(f){var k=1<arguments.length&&void 0!==arguments[1]?arguments[1]:null;"input"===f.tagName.toLowerCase()?
f.value=k:f.textContent=k}},{key:"setInvalidState",value:function(f){var k=1<arguments.length&&void 0!==arguments[1]?arguments[1]:"Invalid";(""===k||this.isNull(k))&&this.throwError("Cannot set the invalid state with an empty message.");f.setCustomValidity(k)}},{key:"setValidState",value:function(f){f.setCustomValidity("")}},{key:"cloneObject",value:function(f){return w({},f)}},{key:"camelize",value:function(f){var k=1<arguments.length&&void 0!==arguments[1]?arguments[1]:"-",m=2<arguments.length&&
void 0!==arguments[2]?arguments[2]:!0,y=3<arguments.length&&void 0!==arguments[3]?arguments[3]:!0;if(this.isNull(f))return null;m&&(f=f.replace(/^data-/,""));k=f.split(k).map(function(d){return"".concat(d.charAt(0).toUpperCase()).concat(d.slice(1))});k=k.join("");y&&(k="".concat(k.charAt(0).toLowerCase()).concat(k.slice(1)));return k}},{key:"text",value:function(f){var k=f.nodeType;return k===Node.ELEMENT_NODE||k===Node.DOCUMENT_NODE||k===Node.DOCUMENT_FRAGMENT_NODE?f.textContent:k===Node.TEXT_NODE?
f.nodeValue:""}},{key:"setText",value:function(f,k){var m=f.nodeType;if(m===Node.ELEMENT_NODE||m===Node.DOCUMENT_NODE||m===Node.DOCUMENT_FRAGMENT_NODE)f.textContent=k}},{key:"filterOut",value:function(f,k){var m=this;return f.filter(function(y){return!m.isInArray(y,k)})}},{key:"trimPaddedZerosFromDecimalPlaces",value:function(f){f=String(f);if(""===f)return"";f=f.split(".");var k=K(f,2);f=k[0];k=k[1];if(this.isUndefinedOrNullOrEmpty(k))return f;k=k.replace(/0+$/g,"");return""===k?f:"".concat(f,".").concat(k)}},
{key:"getHoveredElement",value:function(){var f=q(document.querySelectorAll(":hover"));return f[f.length-1]}},{key:"arrayTrim",value:function(f,k){var m=f.length;if(0===m||k>m)return f;if(0>k)return[];f.length=parseInt(k,10);return f}},{key:"arrayUnique",value:function(){var f;return q(new Set((f=[]).concat.apply(f,arguments)))}},{key:"mergeMaps",value:function(){for(var f=arguments.length,k=Array(f),m=0;m<f;m++)k[m]=arguments[m];return new Map(k.reduce(function(y,d){return y.concat(q(d))},[]))}},
{key:"objectKeyLookup",value:function(f,k){f=Object.entries(f).find(function(y){return y[1]===k});var m=null;void 0!==f&&(m=f[0]);return m}},{key:"insertAt",value:function(f,k,m){f=String(f);if(m>f.length)throw Error("The given index is out of the string range.");if(1!==k.length)throw Error("The given string `char` should be only one character long.");return""===f&&0===m?k:"".concat(f.slice(0,m)).concat(k).concat(f.slice(m))}},{key:"scientificToDecimal",value:function(f){if(isNaN(Number(f)))return NaN;
f=String(f);if(!this.contains(f,"e")&&!this.contains(f,"E"))return f;f=f.split(/e/i);var k=K(f,2);f=k[0];var m=k[1];(k=0>f)&&(f=f.replace("-",""));var y=0>+m;y&&(m=m.replace("-",""));var d=f.split(/\./),a=K(d,2);d=a[0];a=a[1];y?(f=d.length>m?this.insertAt(d,".",d.length-m):"0.".concat("0".repeat(m-d.length)).concat(d),f="".concat(f).concat(a?a:"")):a?(f="".concat(d).concat(a),f=m<a.length?this.insertAt(f,".",+m+d.length):"".concat(f).concat("0".repeat(m-a.length))):(f=f.replace(".",""),f="".concat(f).concat("0".repeat(Number(m))));
k&&(f="-".concat(f));return f}}]);return c}()},"./src/AutoNumericOptions.js":function(n,z,C){C.r(z);C.d(z,{"default":function(){return q}});n=C("./src/AutoNumeric.js");n["default"].options={allowDecimalPadding:{always:!0,never:!1,floats:"floats"},alwaysAllowDecimalCharacter:{alwaysAllow:!0,doNotAllow:!1},caretPositionOnFocus:{start:"start",end:"end",decimalLeft:"decimalLeft",decimalRight:"decimalRight",doNoForceCaretPosition:null},createLocalList:{createList:!0,doNotCreateList:!1},currencySymbol:{none:"",
currencySign:"\u00a4",austral:"\u20b3",australCentavo:"\u00a2",baht:"\u0e3f",cedi:"\u20b5",cent:"\u00a2",colon:"\u20a1",cruzeiro:"\u20a2",dollar:"$",dong:"\u20ab",drachma:"\u20af",dram:"\u200b\u058f",european:"\u20a0",euro:"\u20ac",florin:"\u0192",franc:"\u20a3",guarani:"\u20b2",hryvnia:"\u20b4",kip:"\u20ad",att:"\u0ead\u0eb1\u0e94",lepton:"\u039b.",lira:"\u20ba",liraOld:"\u20a4",lari:"\u20be",mark:"\u2133",mill:"\u20a5",naira:"\u20a6",peseta:"\u20a7",peso:"\u20b1",pfennig:"\u20b0",pound:"\u00a3",
real:"R$ ",riel:"\u17db",ruble:"\u20bd",rupee:"\u20b9",rupeeOld:"\u20a8",shekel:"\u20aa",shekelAlt:"\u05e9\u05f4\u05d7\u200e\u200e",taka:"\u09f3",tenge:"\u20b8",togrog:"\u20ae",won:"\u20a9",yen:"\u00a5"},currencySymbolPlacement:{prefix:"p",suffix:"s"},decimalCharacter:{comma:",",dot:".",middleDot:"\u00b7",arabicDecimalSeparator:"\u066b",decimalSeparatorKeySymbol:"\u2396"},decimalCharacterAlternative:{none:null,comma:",",dot:"."},decimalPlaces:{none:0,one:1,two:2,three:3,four:4,five:5,six:6},decimalPlacesRawValue:{useDefault:null,
none:0,one:1,two:2,three:3,four:4,five:5,six:6},decimalPlacesShownOnBlur:{useDefault:null,none:0,one:1,two:2,three:3,four:4,five:5,six:6},decimalPlacesShownOnFocus:{useDefault:null,none:0,one:1,two:2,three:3,four:4,five:5,six:6},defaultValueOverride:{doNotOverride:null},digitalGroupSpacing:{two:"2",twoThree:"2t",twoScaled:"2s",three:"3",four:"4"},digitGroupSeparator:{comma:",",dot:".",normalSpace:" ",thinSpace:"\u2009",narrowNoBreakSpace:"\u202f",noBreakSpace:"\u00a0",noSeparator:"",apostrophe:"'",
arabicThousandsSeparator:"\u066c",dotAbove:"\u02d9",privateUseTwo:"\u2019"},divisorWhenUnfocused:{none:null,percentage:100,permille:1E3,basisPoint:1E4},emptyInputBehavior:{focus:"focus",press:"press",always:"always",zero:"zero",min:"min",max:"max","null":"null"},eventBubbles:{bubbles:!0,doesNotBubble:!1},eventIsCancelable:{isCancelable:!0,isNotCancelable:!1},failOnUnknownOption:{fail:!0,ignore:!1},formatOnPageLoad:{format:!0,doNotFormat:!1},formulaMode:{enabled:!0,disabled:!1},historySize:{verySmall:5,
small:10,medium:20,large:50,veryLarge:100,insane:Number.MAX_SAFE_INTEGER},invalidClass:"an-invalid",isCancellable:{cancellable:!0,notCancellable:!1},leadingZero:{allow:"allow",deny:"deny",keep:"keep"},maximumValue:{tenTrillions:"10000000000000",oneBillion:"1000000000",zero:"0"},minimumValue:{tenTrillions:"-10000000000000",oneBillion:"-1000000000",zero:"0"},modifyValueOnUpDownArrow:{modifyValue:!0,doNothing:!1},modifyValueOnWheel:{modifyValue:!0,doNothing:!1},negativeBracketsTypeOnBlur:{parentheses:"(,)",
brackets:"[,]",chevrons:"\x3c,\x3e",curlyBraces:"{,}",angleBrackets:"\u3008,\u3009",japaneseQuotationMarks:"\uff62,\uff63",halfBrackets:"\u2e24,\u2e25",whiteSquareBrackets:"\u27e6,\u27e7",quotationMarks:"\u2039,\u203a",guillemets:"\u00ab,\u00bb",none:null},negativePositiveSignPlacement:{prefix:"p",suffix:"s",left:"l",right:"r",none:null},negativeSignCharacter:{hyphen:"-",minus:"\u2212",heavyMinus:"\u2796",fullWidthHyphen:"\uff0d",circledMinus:"\u2296",squaredMinus:"\u229f",triangleMinus:"\u2a3a",
plusMinus:"\u00b1",minusPlus:"\u2213",dotMinus:"\u2238",minusTilde:"\u2242",not:"\u00ac"},negativePositiveSignBehavior:{toggle:!0,doNotToggle:!1},noEventListeners:{noEvents:!0,addEvents:!1},onInvalidPaste:{error:"error",ignore:"ignore",clamp:"clamp",truncate:"truncate",replace:"replace"},outputFormat:{string:"string",number:"number",dot:".",negativeDot:"-.",comma:",",negativeComma:"-,",dotNegative:".-",commaNegative:",-",none:null},overrideMinMaxLimits:{ceiling:"ceiling",floor:"floor",ignore:"ignore",
invalid:"invalid",doNotOverride:null},positiveSignCharacter:{plus:"+",fullWidthPlus:"\uff0b",heavyPlus:"\u2795",doublePlus:"\u29fa",triplePlus:"\u29fb",circledPlus:"\u2295",squaredPlus:"\u229e",trianglePlus:"\u2a39",plusMinus:"\u00b1",minusPlus:"\u2213",dotPlus:"\u2214",altHebrewPlus:"\ufb29",normalSpace:" ",thinSpace:"\u2009",narrowNoBreakSpace:"\u202f",noBreakSpace:"\u00a0"},rawValueDivisor:{none:null,percentage:100,permille:1E3,basisPoint:1E4},readOnly:{readOnly:!0,readWrite:!1},roundingMethod:{halfUpSymmetric:"S",
halfUpAsymmetric:"A",halfDownSymmetric:"s",halfDownAsymmetric:"a",halfEvenBankersRounding:"B",upRoundAwayFromZero:"U",downRoundTowardZero:"D",toCeilingTowardPositiveInfinity:"C",toFloorTowardNegativeInfinity:"F",toNearest05:"N05",toNearest05Alt:"CHF",upToNext05:"U05",downToNext05:"D05"},saveValueToSessionStorage:{save:!0,doNotSave:!1},selectNumberOnly:{selectNumbersOnly:!0,selectAll:!1},selectOnFocus:{select:!0,doNotSelect:!1},serializeSpaces:{plus:"+",percent:"%20"},showOnlyNumbersOnFocus:{onlyNumbers:!0,
showAll:!1},showPositiveSign:{show:!0,hide:!1},showWarnings:{show:!0,hide:!1},styleRules:{none:null,positiveNegative:{positive:"autoNumeric-positive",negative:"autoNumeric-negative"},range0To100With4Steps:{ranges:[{min:0,max:25,"class":"autoNumeric-red"},{min:25,max:50,"class":"autoNumeric-orange"},{min:50,max:75,"class":"autoNumeric-yellow"},{min:75,max:100,"class":"autoNumeric-green"}]},evenOdd:{userDefined:[{callback:function(w){return 0===w%2},classes:["autoNumeric-even","autoNumeric-odd"]}]},
rangeSmallAndZero:{userDefined:[{callback:function(w){return-1<=w&&0>w?0:0===Number(w)?1:0<w&&1>=w?2:null},classes:["autoNumeric-small-negative","autoNumeric-zero","autoNumeric-small-positive"]}]}},suffixText:{none:"",percentage:"%",permille:"\u2030",basisPoint:"\u2031"},symbolWhenUnfocused:{none:null,percentage:"%",permille:"\u2030",basisPoint:"\u2031"},unformatOnHover:{unformat:!0,doNotUnformat:!1},unformatOnSubmit:{unformat:!0,keepCurrentValue:!1},upDownStep:{progressive:"progressive"},valuesToStrings:{none:null,
zeroDash:{0:"-"},oneAroundZero:{"-1":"Min",1:"Max"}},watchExternalChanges:{watch:!0,doNotWatch:!1},wheelOn:{focus:"focus",hover:"hover"},wheelStep:{progressive:"progressive"}};(function(w){Object.getOwnPropertyNames(w).forEach(function(K){"valuesToStrings"===K?Object.getOwnPropertyNames(w.valuesToStrings).forEach(function(I){null!==w.valuesToStrings[I]&&Object.freeze(w.valuesToStrings[I])}):"styleRules"!==K&&null!==w[K]&&Object.freeze(w[K])});return Object.freeze(w)})(n["default"].options);Object.defineProperty(n["default"],
"options",{configurable:!1,writable:!1});var q={}},"./src/AutoNumericPredefinedOptions.js":function(n,z,C){C.r(z);C.d(z,{"default":function(){return p}});var q=C("./src/AutoNumeric.js"),w=C("./src/AutoNumericHelper.js");n={digitGroupSeparator:q["default"].options.digitGroupSeparator.dot,decimalCharacter:q["default"].options.decimalCharacter.comma,decimalCharacterAlternative:q["default"].options.decimalCharacterAlternative.dot,currencySymbol:"\u202f\u20ac",currencySymbolPlacement:q["default"].options.currencySymbolPlacement.suffix,
negativePositiveSignPlacement:q["default"].options.negativePositiveSignPlacement.prefix};z={digitGroupSeparator:q["default"].options.digitGroupSeparator.comma,decimalCharacter:q["default"].options.decimalCharacter.dot,currencySymbol:q["default"].options.currencySymbol.dollar,currencySymbolPlacement:q["default"].options.currencySymbolPlacement.prefix,negativePositiveSignPlacement:q["default"].options.negativePositiveSignPlacement.right};C={digitGroupSeparator:q["default"].options.digitGroupSeparator.comma,
decimalCharacter:q["default"].options.decimalCharacter.dot,currencySymbol:q["default"].options.currencySymbol.yen,currencySymbolPlacement:q["default"].options.currencySymbolPlacement.prefix,negativePositiveSignPlacement:q["default"].options.negativePositiveSignPlacement.right};w["default"].cloneObject(n).formulaMode=q["default"].options.formulaMode.enabled;var K=w["default"].cloneObject(n);K.minimumValue=0;var I=w["default"].cloneObject(n);I.maximumValue=0;I.negativePositiveSignPlacement=q["default"].options.negativePositiveSignPlacement.prefix;
var E=w["default"].cloneObject(n);E.digitGroupSeparator=q["default"].options.digitGroupSeparator.normalSpace;var x=w["default"].cloneObject(E);x.minimumValue=0;var A=w["default"].cloneObject(E);A.maximumValue=0;A.negativePositiveSignPlacement=q["default"].options.negativePositiveSignPlacement.prefix;var v=w["default"].cloneObject(n);v.currencySymbol=q["default"].options.currencySymbol.none;v.suffixText="\u202f".concat(q["default"].options.suffixText.percentage);v.wheelStep=1E-4;v.rawValueDivisor=
q["default"].options.rawValueDivisor.percentage;var B=w["default"].cloneObject(v);B.minimumValue=0;var H=w["default"].cloneObject(v);H.maximumValue=0;H.negativePositiveSignPlacement=q["default"].options.negativePositiveSignPlacement.prefix;var c=w["default"].cloneObject(v);c.decimalPlaces=3;var f=w["default"].cloneObject(B);f.decimalPlaces=3;var k=w["default"].cloneObject(H);k.decimalPlaces=3;w["default"].cloneObject(z).formulaMode=q["default"].options.formulaMode.enabled;var m=w["default"].cloneObject(z);
m.minimumValue=0;var y=w["default"].cloneObject(z);y.maximumValue=0;y.negativePositiveSignPlacement=q["default"].options.negativePositiveSignPlacement.prefix;var d=w["default"].cloneObject(y);d.negativeBracketsTypeOnBlur=q["default"].options.negativeBracketsTypeOnBlur.parentheses;var a=w["default"].cloneObject(z);a.currencySymbol=q["default"].options.currencySymbol.none;a.suffixText=q["default"].options.suffixText.percentage;a.wheelStep=1E-4;a.rawValueDivisor=q["default"].options.rawValueDivisor.percentage;
var b=w["default"].cloneObject(a);b.minimumValue=0;var e=w["default"].cloneObject(a);e.maximumValue=0;e.negativePositiveSignPlacement=q["default"].options.negativePositiveSignPlacement.prefix;var h=w["default"].cloneObject(a);h.decimalPlaces=3;var g=w["default"].cloneObject(b);g.decimalPlaces=3;var l=w["default"].cloneObject(e);l.decimalPlaces=3;w=w["default"].cloneObject(n);w.currencySymbol=q["default"].options.currencySymbol.lira;q["default"].predefinedOptions={euro:n,euroPos:K,euroNeg:I,euroSpace:E,
euroSpacePos:x,euroSpaceNeg:A,percentageEU2dec:v,percentageEU2decPos:B,percentageEU2decNeg:H,percentageEU3dec:c,percentageEU3decPos:f,percentageEU3decNeg:k,dollar:z,dollarPos:m,dollarNeg:y,dollarNegBrackets:d,percentageUS2dec:a,percentageUS2decPos:b,percentageUS2decNeg:e,percentageUS3dec:h,percentageUS3decPos:g,percentageUS3decNeg:l,French:n,Spanish:n,NorthAmerican:z,British:{digitGroupSeparator:q["default"].options.digitGroupSeparator.comma,decimalCharacter:q["default"].options.decimalCharacter.dot,
currencySymbol:q["default"].options.currencySymbol.pound,currencySymbolPlacement:q["default"].options.currencySymbolPlacement.prefix,negativePositiveSignPlacement:q["default"].options.negativePositiveSignPlacement.right},Swiss:{digitGroupSeparator:q["default"].options.digitGroupSeparator.apostrophe,decimalCharacter:q["default"].options.decimalCharacter.dot,currencySymbol:"\u202fCHF",currencySymbolPlacement:q["default"].options.currencySymbolPlacement.suffix,negativePositiveSignPlacement:q["default"].options.negativePositiveSignPlacement.prefix},
Japanese:C,Chinese:C,Brazilian:{digitGroupSeparator:q["default"].options.digitGroupSeparator.dot,decimalCharacter:q["default"].options.decimalCharacter.comma,currencySymbol:q["default"].options.currencySymbol.real,currencySymbolPlacement:q["default"].options.currencySymbolPlacement.prefix,negativePositiveSignPlacement:q["default"].options.negativePositiveSignPlacement.right},Turkish:w,dotDecimalCharCommaSeparator:{digitGroupSeparator:q["default"].options.digitGroupSeparator.comma,decimalCharacter:q["default"].options.decimalCharacter.dot},
commaDecimalCharDotSeparator:{digitGroupSeparator:q["default"].options.digitGroupSeparator.dot,decimalCharacter:q["default"].options.decimalCharacter.comma,decimalCharacterAlternative:q["default"].options.decimalCharacterAlternative.dot},integer:{decimalPlaces:0},integerPos:{minimumValue:q["default"].options.minimumValue.zero,decimalPlaces:0},integerNeg:{maximumValue:q["default"].options.maximumValue.zero,decimalPlaces:0},"float":{allowDecimalPadding:q["default"].options.allowDecimalPadding.never},
floatPos:{allowDecimalPadding:q["default"].options.allowDecimalPadding.never,minimumValue:q["default"].options.minimumValue.zero,maximumValue:q["default"].options.maximumValue.tenTrillions},floatNeg:{allowDecimalPadding:q["default"].options.allowDecimalPadding.never,minimumValue:q["default"].options.minimumValue.tenTrillions,maximumValue:q["default"].options.maximumValue.zero},numeric:{digitGroupSeparator:q["default"].options.digitGroupSeparator.noSeparator,decimalCharacter:q["default"].options.decimalCharacter.dot,
currencySymbol:q["default"].options.currencySymbol.none},numericPos:{digitGroupSeparator:q["default"].options.digitGroupSeparator.noSeparator,decimalCharacter:q["default"].options.decimalCharacter.dot,currencySymbol:q["default"].options.currencySymbol.none,minimumValue:q["default"].options.minimumValue.zero,maximumValue:q["default"].options.maximumValue.tenTrillions},numericNeg:{digitGroupSeparator:q["default"].options.digitGroupSeparator.noSeparator,decimalCharacter:q["default"].options.decimalCharacter.dot,
currencySymbol:q["default"].options.currencySymbol.none,minimumValue:q["default"].options.minimumValue.tenTrillions,maximumValue:q["default"].options.maximumValue.zero}};Object.getOwnPropertyNames(q["default"].predefinedOptions).forEach(function(r){Object.freeze(q["default"].predefinedOptions[r])});Object.freeze(q["default"].predefinedOptions);Object.defineProperty(q["default"],"predefinedOptions",{configurable:!1,writable:!1});var p={}},"./src/maths/ASTNode.js":function(n,z,C){function q(E){"@babel/helpers - typeof";
return q="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(x){return typeof x}:function(x){return x&&"function"==typeof Symbol&&x.constructor===Symbol&&x!==Symbol.prototype?"symbol":typeof x},q(E)}function w(E,x){for(var A=0;A<x.length;A++){var v=x[A];v.enumerable=v.enumerable||!1;v.configurable=!0;"value"in v&&(v.writable=!0);var B=Object,H=B.defineProperty;a:{var c=v.key;if("object"===q(c)&&null!==c){var f=c[Symbol.toPrimitive];if(void 0!==f){c=f.call(c,"string");if("object"!==
q(c))break a;throw new TypeError("@@toPrimitive must return a primitive value.");}c=String(c)}}c="symbol"===q(c)?c:String(c);H.call(B,E,c,v)}}function K(E,x,A){x&&w(E.prototype,x);A&&w(E,A);Object.defineProperty(E,"prototype",{writable:!1});return E}C.r(z);C.d(z,{"default":function(){return I}});var I=function(){function E(){if(!(this instanceof E))throw new TypeError("Cannot call a class as a function");}K(E,null,[{key:"createNode",value:function(x,A,v){var B=new E;B.type=x;B.left=A;B.right=v;return B}},
{key:"createUnaryNode",value:function(x){var A=new E;A.type="unaryMinus";A.left=x;A.right=null;return A}},{key:"createLeaf",value:function(x){var A=new E;A.type="number";A.value=x;return A}}]);return E}()},"./src/maths/Evaluator.js":function(n,z,C){function q(E){"@babel/helpers - typeof";return q="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(x){return typeof x}:function(x){return x&&"function"==typeof Symbol&&x.constructor===Symbol&&x!==Symbol.prototype?"symbol":typeof x},q(E)}
function w(E,x){for(var A=0;A<x.length;A++){var v=x[A];v.enumerable=v.enumerable||!1;v.configurable=!0;"value"in v&&(v.writable=!0);var B=Object,H=B.defineProperty;a:{var c=v.key;if("object"===q(c)&&null!==c){var f=c[Symbol.toPrimitive];if(void 0!==f){c=f.call(c,"string");if("object"!==q(c))break a;throw new TypeError("@@toPrimitive must return a primitive value.");}c=String(c)}}c="symbol"===q(c)?c:String(c);H.call(B,E,c,v)}}function K(E,x,A){x&&w(E.prototype,x);A&&w(E,A);Object.defineProperty(E,
"prototype",{writable:!1});return E}C.r(z);C.d(z,{"default":function(){return I}});var I=function(){function E(x){if(!(this instanceof E))throw new TypeError("Cannot call a class as a function");if(null===x)throw Error("Invalid AST");}K(E,[{key:"evaluate",value:function(x){if(void 0===x||null===x)throw Error("Invalid AST sub-tree");if("number"===x.type)return x.value;if("unaryMinus"===x.type)return-this.evaluate(x.left);var A=this.evaluate(x.left),v=this.evaluate(x.right);switch(x.type){case "op_+":return Number(A)+
Number(v);case "op_-":return A-v;case "op_*":return A*v;case "op_/":return A/v;default:throw Error("Invalid operator '".concat(x.type,"'"));}}}]);return E}()},"./src/maths/Lexer.js":function(n,z,C){function q(A){"@babel/helpers - typeof";return q="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(v){return typeof v}:function(v){return v&&"function"==typeof Symbol&&v.constructor===Symbol&&v!==Symbol.prototype?"symbol":typeof v},q(A)}function w(A,v){for(var B=0;B<v.length;B++){var H=
v[B];H.enumerable=H.enumerable||!1;H.configurable=!0;"value"in H&&(H.writable=!0);var c=Object,f=c.defineProperty;a:{var k=H.key;if("object"===q(k)&&null!==k){var m=k[Symbol.toPrimitive];if(void 0!==m){k=m.call(k,"string");if("object"!==q(k))break a;throw new TypeError("@@toPrimitive must return a primitive value.");}k=String(k)}}k="symbol"===q(k)?k:String(k);f.call(c,A,k,H)}}function K(A,v,B){v&&w(A.prototype,v);B&&w(A,B);Object.defineProperty(A,"prototype",{writable:!1});return A}C.r(z);C.d(z,{"default":function(){return x}});
var I=C("./src/AutoNumericHelper.js"),E=C("./src/maths/Token.js"),x=function(){function A(v){if(!(this instanceof A))throw new TypeError("Cannot call a class as a function");this.text=v;this.textLength=v.length;this.index=0;this.token=new E["default"]("Error",0,0)}K(A,[{key:"_skipSpaces",value:function(){for(;" "===this.text[this.index]&&this.index<=this.textLength;)this.index++}},{key:"getIndex",value:function(){return this.index}},{key:"getNextToken",value:function(){var v=0<arguments.length&&void 0!==
arguments[0]?arguments[0]:".";this._skipSpaces();if(this.textLength===this.index)return this.token.type="EOT",this.token;if(I["default"].isDigit(this.text[this.index]))return this.token.type="num",this.token.value=this._getNumber(v),this.token;this.token.type="Error";switch(this.text[this.index]){case "+":this.token.type="+";break;case "-":this.token.type="-";break;case "*":this.token.type="*";break;case "/":this.token.type="/";break;case "(":this.token.type="(";break;case ")":this.token.type=")"}if("Error"!==
this.token.type)this.token.symbol=this.text[this.index],this.index++;else throw Error("Unexpected token '".concat(this.token.symbol,"' at position '").concat(this.token.index,"' in the token function"));return this.token}},{key:"_getNumber",value:function(v){this._skipSpaces();for(var B=this.index;this.index<=this.textLength&&I["default"].isDigit(this.text[this.index]);)this.index++;for(this.text[this.index]===v&&this.index++;this.index<=this.textLength&&I["default"].isDigit(this.text[this.index]);)this.index++;
if(this.index===B)throw Error("No number has been found while it was expected");return this.text.substring(B,this.index).replace(v,".")}}]);return A}()},"./src/maths/Parser.js":function(n,z,C){function q(A){"@babel/helpers - typeof";return q="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(v){return typeof v}:function(v){return v&&"function"==typeof Symbol&&v.constructor===Symbol&&v!==Symbol.prototype?"symbol":typeof v},q(A)}function w(A,v){for(var B=0;B<v.length;B++){var H=v[B];
H.enumerable=H.enumerable||!1;H.configurable=!0;"value"in H&&(H.writable=!0);var c=Object,f=c.defineProperty;a:{var k=H.key;if("object"===q(k)&&null!==k){var m=k[Symbol.toPrimitive];if(void 0!==m){k=m.call(k,"string");if("object"!==q(k))break a;throw new TypeError("@@toPrimitive must return a primitive value.");}k=String(k)}}k="symbol"===q(k)?k:String(k);f.call(c,A,k,H)}}function K(A,v,B){v&&w(A.prototype,v);B&&w(A,B);Object.defineProperty(A,"prototype",{writable:!1});return A}C.r(z);C.d(z,{"default":function(){return x}});
var I=C("./src/maths/ASTNode.js"),E=C("./src/maths/Lexer.js"),x=function(){function A(v){var B=1<arguments.length&&void 0!==arguments[1]?arguments[1]:".";if(!(this instanceof A))throw new TypeError("Cannot call a class as a function");this.text=v;this.decimalCharacter=B;this.lexer=new E["default"](v);this.token=this.lexer.getNextToken(this.decimalCharacter);return this._exp()}K(A,[{key:"_exp",value:function(){var v=this._term(),B=this._moreExp();return I["default"].createNode("op_+",v,B)}},{key:"_moreExp",
value:function(){switch(this.token.type){case "+":this.token=this.lexer.getNextToken(this.decimalCharacter);var v=this._term();var B=this._moreExp();return I["default"].createNode("op_+",B,v);case "-":return this.token=this.lexer.getNextToken(this.decimalCharacter),v=this._term(),B=this._moreExp(),I["default"].createNode("op_-",B,v)}return I["default"].createLeaf(0)}},{key:"_term",value:function(){var v=this._factor(),B=this._moreTerms();return I["default"].createNode("op_*",v,B)}},{key:"_moreTerms",
value:function(){switch(this.token.type){case "*":this.token=this.lexer.getNextToken(this.decimalCharacter);var v=this._factor();var B=this._moreTerms();return I["default"].createNode("op_*",B,v);case "/":return this.token=this.lexer.getNextToken(this.decimalCharacter),v=this._factor(),B=this._moreTerms(),I["default"].createNode("op_/",B,v)}return I["default"].createLeaf(1)}},{key:"_factor",value:function(){switch(this.token.type){case "num":var v=this.token.value;this.token=this.lexer.getNextToken(this.decimalCharacter);
return I["default"].createLeaf(v);case "-":return this.token=this.lexer.getNextToken(this.decimalCharacter),v=this._factor(),I["default"].createUnaryNode(v);case "(":return this.token=this.lexer.getNextToken(this.decimalCharacter),v=this._exp(),this._match(")"),v;default:throw Error("Unexpected token '".concat(this.token.symbol,"' with type '").concat(this.token.type,"' at position '").concat(this.token.index,"' in the factor function"));}}},{key:"_match",value:function(v){var B=this.lexer.getIndex()-
1;if(this.text[B]===v)this.token=this.lexer.getNextToken(this.decimalCharacter);else throw Error("Unexpected token '".concat(this.token.symbol,"' at position '").concat(B,"' in the match function"));}}]);return A}()},"./src/maths/Token.js":function(n,z,C){function q(I){"@babel/helpers - typeof";return q="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(E){return typeof E}:function(E){return E&&"function"==typeof Symbol&&E.constructor===Symbol&&E!==Symbol.prototype?"symbol":typeof E},
q(I)}function w(I,E){for(var x=0;x<E.length;x++){var A=E[x];A.enumerable=A.enumerable||!1;A.configurable=!0;"value"in A&&(A.writable=!0);var v=Object,B=v.defineProperty;a:{var H=A.key;if("object"===q(H)&&null!==H){var c=H[Symbol.toPrimitive];if(void 0!==c){H=c.call(H,"string");if("object"!==q(H))break a;throw new TypeError("@@toPrimitive must return a primitive value.");}H=String(H)}}H="symbol"===q(H)?H:String(H);B.call(v,I,H,A)}}C.r(z);C.d(z,{"default":function(){return K}});var K=function(I,E,x){E&&
w(I.prototype,E);x&&w(I,x);Object.defineProperty(I,"prototype",{writable:!1});return I}(function v(E,x,A){if(!(this instanceof v))throw new TypeError("Cannot call a class as a function");this.type=E;this.value=x;this.symbol=A})}},G={};(function(){t.d=function(n,z){for(var C in z)t.o(z,C)&&!t.o(n,C)&&Object.defineProperty(n,C,{enumerable:!0,get:z[C]})}})();(function(){t.o=function(n,z){return Object.prototype.hasOwnProperty.call(n,z)}})();(function(){t.r=function(n){"undefined"!==typeof Symbol&&Symbol.toStringTag&&
Object.defineProperty(n,Symbol.toStringTag,{value:"Module"});Object.defineProperty(n,"__esModule",{value:!0})}})();var J={};(function(){t.r(J);t.d(J,{"default":function(){return z}});var n=t("./src/AutoNumeric.js");t("./src/AutoNumericEvents.js");t("./src/AutoNumericOptions.js");t("./src/AutoNumericDefaultSettings.js");t("./src/AutoNumericPredefinedOptions.js");var z=n["default"]})();return J=J["default"]}()});
PrimeFaces.widget.InputNumber=PrimeFaces.widget.BaseWidget.extend({init:function(t){this._super(t);this.input=$(this.jqId+"_input");this.hiddenInput=$(this.jqId+"_hinput");this.plugOptArray=t.pluginOptions;this.initialValue=t.valueToRender;this.disabled=t.disabled;if(1E-7<this.cfg.minimumValue||0>this.cfg.maximumValue)this.cfg.overrideMinMaxLimits="invalid";this.disabled&&(this.input.attr("disabled","disabled"),this.input.addClass("ui-state-disabled"),this.hiddenInput.attr("disabled","disabled"));
PrimeFaces.skinInput(this.input);this.autonumeric=new AutoNumeric(this.jqId+"_input",this.cfg);""!==this.initialValue&&(this.autonumeric.set(this.initialValue),this.autonumeric.rawValueOnFocus=this.initialValue);this.setValueToHiddenInput(this.getValue());this.input.data(PrimeFaces.CLIENT_ID_DATA,this.id);this.hiddenInput.data(PrimeFaces.CLIENT_ID_DATA,this.id);var D=this;PrimeFaces.queueTask(function(){D.wrapEvents()})},refresh:function(t){this._cleanup();this._super(t)},destroy:function(){this._super();
this._cleanup()},_cleanup:function(){this.autonumeric&&this.autonumeric.remove()},wrapEvents:function(){var t=this,D=this.input[0]?$._data(this.input[0],"events"):null,G=this.input.prop("onkeyup");!G&&D&&D.keyup&&(G=D.keyup[0].handler);this.input.prop("onkeyup",null).off("keyup").on("keyup.inputnumber",function(z){var C=z.key;if(z.ctrlKey&&["KeyX","KeyC","KeyV"].includes(z.code)||["Backspace","Enter","Delete"].includes(C)||PrimeFaces.utils.isPrintableKey(z))var q=t.copyValueToHiddenInput();if(G&&
!1===G.call(this,z))return q&&t.setValueToHiddenInput(q),!1});var J=this.input.prop("onchange");!J&&D&&D.change&&(J=D.change[0].handler);this.input.prop("onchange",null).off("change").on("change.inputnumber",function(z){var C=t.copyValueToHiddenInput();if(C===t.initialValue||""!==t.initialValue&&""!==C&&Number(C)===Number(t.initialValue))return!1;if(J&&!1===J.call(this,z))return t.setValueToHiddenInput(C),!1;t.initialValue=C});var n=this.input.prop("onkeydown");!n&&D&&D.keydown&&(n=D.keydown[0].handler);
this.input.prop("onkeydown",null).off("keydown").on("keydown.inputnumber",function(z){var C=t.copyValueToHiddenInput();if(n&&!1===n.call(this,z))return t.setValueToHiddenInput(C),!1});this.bindInputEvents()},bindInputEvents:function(){var t=this;this.input.off("blur.inputnumber").on("blur.inputnumber",function(D){if((D=AutoNumeric.getAutoNumericElement(this))&&this.value&&0<this.value.length){var G=this.value.trim();t.cfg.digitGroupSeparator&&(G=G.replaceAll(t.cfg.digitGroupSeparator,""));D.set(G,
null,!0);""!==D.rawValueOnFocus&&Number(D.rawValue)===Number(D.rawValueOnFocus)&&(D.rawValueOnFocus=D.rawValue)}t.copyValueToHiddenInput()})},copyValueToHiddenInput:function(){var t=this.hiddenInput.val(),D=this.getValue();(""===t^""===D||Number(t)!==Number(D))&&this.setValueToHiddenInput(D);return t},setValueToHiddenInput:function(t){this.hiddenInput.val(t).trigger("input.slider")},enable:function(){PrimeFaces.utils.enableInputWidget(this.input);PrimeFaces.utils.enableInputWidget(this.hiddenInput);
this.disabled=!1},disable:function(){PrimeFaces.utils.disableInputWidget(this.input);PrimeFaces.utils.disableInputWidget(this.hiddenInput);this.disabled=!0},setValue:function(t){this.autonumeric.set(t);t=this.getValue();this.hiddenInput.attr("value",t)},getValue:function(){var t=this.autonumeric.getNumericString();if(this.autonumeric.getSettings().allowDecimalPadding&&t&&0<parseInt(this.cfg.decimalPlaces,10)){if(-1===t.indexOf(".")){var D=this.cfg.decimalPlaces;t+="."}else D=t.length-t.indexOf(".")-
1,D=this.cfg.decimalPlaces-D;for(;0<D--;)t+="0"}t&&t.endsWith(this.cfg.decimalCharacter)&&(t=t.substring(0,t.length-1));return t}});