/*
 * The MIT License
 *
 * Copyright (c) 2009-2024 PrimeTek Informatics
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package org.primefaces.event;

import javax.faces.component.UIComponent;
import javax.faces.component.behavior.Behavior;

public class ItemSelectEvent extends AbstractAjaxBehaviorEvent {

    private static final long serialVersionUID = 1L;

    private int itemIndex;
    private int seriesIndex;
    private int dataSetIndex;
    private String data;

    public ItemSelectEvent(UIComponent source, Behavior behavior, int itemIndex, int index, String data) {
        super(source, behavior);
        this.itemIndex = itemIndex;
        this.dataSetIndex = index;
        this.seriesIndex = index;
        this.data = data;
    }

    @Deprecated
    public ItemSelectEvent(UIComponent source, Behavior behavior, int itemIndex, int index) {
        super(source, behavior);
        this.itemIndex = itemIndex;
        this.dataSetIndex = index;
        this.seriesIndex = index;
        this.data = null;
    }

    public int getItemIndex() {
        return itemIndex;
    }

    /**
     * Gets the index of series on JqPlot
     *
     * @return seriesIndex
     */
    public int getSeriesIndex() {
        return seriesIndex;
    }

    /**
     * Gets the index of dataSet on ChartJs
     *
     * @return dataSetIndex
     */
    public int getDataSetIndex() {
        return dataSetIndex;
    }

    /**
     * Gets the raw data value associated with this chart point.
     *
     * @return the raw data value
     */
    public String getData() {
        return data;
    }
}
