/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.application.resource;

import io.nayuki.qrcodegen.QrCode;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import javax.imageio.ImageIO;
import org.primefaces.application.resource.BaseDynamicContentHandler;
import org.primefaces.util.LangUtils;

public class QRCodeHandler
extends BaseDynamicContentHandler {
    @Override
    public void handle(FacesContext context) throws IOException {
        Map params = context.getExternalContext().getRequestParameterMap();
        ExternalContext externalContext = context.getExternalContext();
        String sessionKey = (String)params.get("pfdrid");
        Map session = externalContext.getSessionMap();
        Map barcodeMapping = (Map)session.get("primefaces.barcodeMapping");
        if (barcodeMapping == null) {
            return;
        }
        String value = (String)barcodeMapping.get(sessionKey);
        if (value == null) {
            return;
        }
        boolean cache = Boolean.parseBoolean((String)params.get("pfdrid_c"));
        QrCode qrCode = QrCode.encodeText((CharSequence)value, (QrCode.Ecc)this.getErrorCorrection((String)params.get("qrec")));
        if ("png".equals(params.get("fmt"))) {
            externalContext.setResponseContentType("image/png");
            ImageIO.write((RenderedImage)this.toImage(qrCode, 12, 0), "png", externalContext.getResponseOutputStream());
        } else {
            externalContext.setResponseContentType("image/svg+xml");
            externalContext.getResponseOutputWriter().write(this.toSvgString(qrCode, 0, "#FFFFFF", "#000000"));
        }
        this.handleCache(externalContext, cache);
        externalContext.setResponseStatus(200);
        externalContext.responseFlushBuffer();
        context.responseComplete();
    }

    protected QrCode.Ecc getErrorCorrection(String value) {
        switch (LangUtils.isNotBlank(value) ? value : "") {
            case "M": {
                return QrCode.Ecc.MEDIUM;
            }
            case "Q": {
                return QrCode.Ecc.QUARTILE;
            }
            case "H": {
                return QrCode.Ecc.HIGH;
            }
        }
        return QrCode.Ecc.LOW;
    }

    protected BufferedImage toImage(QrCode qr, int scale, int border) {
        return this.toImage(qr, scale, border, 0xFFFFFF, 0);
    }

    protected BufferedImage toImage(QrCode qr, int scale, int border, int lightColor, int darkColor) {
        Objects.requireNonNull(qr);
        if (scale <= 0 || border < 0) {
            throw new IllegalArgumentException("Value out of range");
        }
        if (border > 0x3FFFFFFF || (long)qr.size + (long)border * 2L > (long)(Integer.MAX_VALUE / scale)) {
            throw new IllegalArgumentException("Scale or border too large");
        }
        BufferedImage result = new BufferedImage((qr.size + border * 2) * scale, (qr.size + border * 2) * scale, 1);
        for (int y = 0; y < result.getHeight(); ++y) {
            for (int x = 0; x < result.getWidth(); ++x) {
                boolean color = qr.getModule(x / scale - border, y / scale - border);
                result.setRGB(x, y, color ? darkColor : lightColor);
            }
        }
        return result;
    }

    protected String toSvgString(QrCode qr, int border, String lightColor, String darkColor) {
        Objects.requireNonNull(qr);
        Objects.requireNonNull(lightColor);
        Objects.requireNonNull(darkColor);
        if (border < 0) {
            throw new IllegalArgumentException("Border must be non-negative");
        }
        long brd = border;
        StringBuilder sb = new StringBuilder().append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n").append("<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\" \"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\">\n").append(String.format("<svg xmlns=\"http://www.w3.org/2000/svg\" version=\"1.1\" viewBox=\"0 0 %1$d %1$d\" stroke=\"none\">", (long)qr.size + brd * 2L)).append("\n").append("\t<rect width=\"100%\" height=\"100%\" fill=\"" + lightColor + "\"/>\n").append("\t<path d=\"");
        for (int y = 0; y < qr.size; ++y) {
            for (int x = 0; x < qr.size; ++x) {
                if (!qr.getModule(x, y)) continue;
                if (x != 0 || y != 0) {
                    sb.append(" ");
                }
                sb.append(String.format("M%d,%dh1v1h-1z", (long)x + brd, (long)y + brd));
            }
        }
        return sb.append("\" fill=\"" + darkColor + "\"/>\n").append("</svg>\n").toString();
    }
}

