/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.clientwindow;

import jakarta.faces.FacesException;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.lifecycle.ClientWindow;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.primefaces.clientwindow.PrimeClientWindowUtils;
import org.primefaces.util.LangUtils;

public class PrimeClientWindow
extends ClientWindow {
    private String id;

    public Map<String, String> getQueryURLParameters(FacesContext context) {
        return Collections.emptyMap();
    }

    public String getId() {
        return this.id;
    }

    public void decode(FacesContext context) {
        this.id = (String)context.getExternalContext().getRequestParameterMap().get("jfwid");
        boolean post = PrimeClientWindowUtils.isPost(context);
        if (LangUtils.isBlank(this.id) && post) {
            this.id = (String)context.getExternalContext().getRequestParameterMap().get("jakarta.faces.ClientWindow");
        }
        if (LangUtils.isNotBlank(this.id)) {
            this.id = PrimeClientWindowUtils.secureWindowId(this.id);
        }
        if (LangUtils.isBlank(this.id)) {
            this.id = PrimeClientWindowUtils.generateNewWindowId();
            if (!post) {
                try {
                    String redirectUrl = this.constructInitialRedirectUrl(context);
                    PrimeClientWindowUtils.addInitialRedirectCookie(context, this.id);
                    context.getExternalContext().redirect(redirectUrl);
                }
                catch (IOException e) {
                    throw new FacesException("Could not send initial redirect!", (Throwable)e);
                }
                context.responseComplete();
            }
        }
    }

    protected String constructInitialRedirectUrl(FacesContext context) {
        ExternalContext externalContext = context.getExternalContext();
        Object url = externalContext.getRequestContextPath() + externalContext.getRequestServletPath();
        if (externalContext.getRequestPathInfo() != null) {
            url = (String)url + externalContext.getRequestPathInfo();
        }
        HashMap<String, List<String>> parameters = new HashMap<String, List<String>>();
        for (Map.Entry entry : externalContext.getRequestParameterValuesMap().entrySet()) {
            List values = parameters.computeIfAbsent((String)entry.getKey(), k -> new ArrayList(1));
            if (entry.getValue() == null) continue;
            values.addAll(Arrays.asList((String[])entry.getValue()));
        }
        parameters.put("jfwid", Arrays.asList(this.id));
        url = this.appendParameters(externalContext, (String)url, parameters);
        url = externalContext.getResponse() instanceof HttpServletResponse ? ((HttpServletResponse)externalContext.getResponse()).encodeURL((String)url) : externalContext.encodeResourceURL((String)url);
        return url;
    }

    protected String appendParameters(ExternalContext externalContext, String url, Map<String, List<String>> parameters) {
        StringBuilder urlBuilder = new StringBuilder(url);
        boolean existingParameters = url.contains("?");
        for (Map.Entry<String, List<String>> entry : parameters.entrySet()) {
            String name = entry.getKey();
            for (String value : entry.getValue()) {
                if (LangUtils.isEmpty(name) && LangUtils.isEmpty(value) || url.contains(name + "=" + value) || url.contains(name + "=" + this.encodeURLParameterValue(value, externalContext))) continue;
                if (!existingParameters) {
                    urlBuilder.append("?");
                    existingParameters = true;
                } else {
                    urlBuilder.append("&");
                }
                urlBuilder.append(this.encodeURLParameterValue(name, externalContext)).append("=").append(this.encodeURLParameterValue(value, externalContext));
            }
        }
        return urlBuilder.toString();
    }

    protected String encodeURLParameterValue(String value, ExternalContext externalContext) {
        try {
            return URLEncoder.encode(value, externalContext.getResponseCharacterEncoding());
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedOperationException("Encoding type=" + externalContext.getResponseCharacterEncoding() + " not supported", e);
        }
    }
}

