/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.audio;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import org.primefaces.component.audio.Audio;
import org.primefaces.component.audio.AudioType;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.shaded.commons.io.FilenameUtils;
import org.primefaces.util.HTML;
import org.primefaces.util.LangUtils;

public class AudioRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Audio media = (Audio)component;
        String clientId = media.getClientId(context);
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", (UIComponent)media);
        writer.writeAttribute("id", (Object)clientId, "id");
        this.renderPassThruAttributes(context, component, HTML.LABEL_ATTRS_WITHOUT_EVENTS);
        Object styleClass = media.getStyleClass();
        styleClass = styleClass == null ? "ui-media ui-audio" : "ui-media ui-audio " + (String)styleClass;
        writer.writeAttribute("class", styleClass, null);
        if (LangUtils.isNotBlank(media.getStyle())) {
            writer.writeAttribute("style", (Object)media.getStyle(), null);
        }
        this.encodeAudio(context, media);
        writer.endElement("div");
    }

    public void encodeAudio(FacesContext context, Audio media) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = media.getClientId(context) + "_audio";
        writer.startElement("audio", null);
        writer.writeAttribute("id", (Object)clientId, "id");
        this.renderPassThruAttributes(context, (UIComponent)media, HTML.MEDIA_ATTRS_WITH_EVENTS);
        AudioType player = this.resolvePlayer(context, media);
        writer.startElement("source", null);
        writer.writeAttribute("src", (Object)media.resolveSource(context, media), null);
        writer.writeAttribute("type", (Object)player.getMediaType(), null);
        writer.endElement("source");
        this.renderChildren(context, (UIComponent)media);
        writer.endElement("audio");
    }

    protected AudioType resolvePlayer(FacesContext context, Audio media) {
        if (LangUtils.isNotBlank(media.getPlayer())) {
            return AudioType.valueOf(media.getPlayer().toUpperCase());
        }
        if (media.getValue() instanceof String) {
            String extension = FilenameUtils.getExtension((String)media.getValue());
            for (AudioType mediaType : AudioType.values()) {
                if (!mediaType.getFileExtension().equalsIgnoreCase(extension)) continue;
                return mediaType;
            }
        }
        throw new IllegalArgumentException("Cannot resolve mediaplayer for audio component '" + media.getClientId(context) + "', cannot play source:" + String.valueOf(media.getValue()));
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

