/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.autoupdate;

import jakarta.faces.context.FacesContext;
import jakarta.faces.event.PhaseEvent;
import jakarta.faces.event.PhaseId;
import jakarta.faces.event.PhaseListener;
import java.util.List;
import java.util.Map;
import org.primefaces.component.autoupdate.AutoUpdateListener;
import org.primefaces.context.PrimeRequestContext;
import org.primefaces.util.LangUtils;

public class AutoUpdatePhaseListener
implements PhaseListener {
    private static final long serialVersionUID = 1L;

    public void afterPhase(PhaseEvent phaseEvent) {
    }

    public void beforePhase(PhaseEvent phaseEvent) {
        FacesContext context = phaseEvent.getFacesContext();
        if (!context.isPostback() || PrimeRequestContext.getCurrentInstance(context).isIgnoreAutoUpdate()) {
            return;
        }
        Map<String, List<String>> infos = AutoUpdateListener.getAutoUpdateComponentInfos(context);
        if (infos != null && !infos.isEmpty()) {
            for (Map.Entry<String, List<String>> entries : infos.entrySet()) {
                String clientId = entries.getKey();
                List<String> events = entries.getValue();
                if (events != null && !events.isEmpty() && !this.requestContainsEventToUpdate(context, events) || context.getPartialViewContext().getRenderIds().contains(clientId)) continue;
                context.getPartialViewContext().getRenderIds().add(clientId);
            }
        }
    }

    public PhaseId getPhaseId() {
        return PhaseId.RENDER_RESPONSE;
    }

    protected boolean requestContainsEventToUpdate(FacesContext context, List<String> events) {
        String update = (String)context.getExternalContext().getRequestParameterMap().get("jakarta.faces.partial.render");
        if (LangUtils.isBlank(update)) {
            return false;
        }
        for (String event : events) {
            if (!update.contains("@obs(" + event + ")")) continue;
            return true;
        }
        return false;
    }
}

