/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.avatar;

import jakarta.faces.FacesException;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.primefaces.component.avatar.Avatar;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.LangUtils;
import org.primefaces.util.SharedStringBuilder;

public class AvatarRenderer
extends CoreRenderer {
    private static final Pattern LETTER_PATTTERN = Pattern.compile("\\b[\\p{L}\\p{M}]", 256);
    private static final String GRAVATAR_URL = "https://www.gravatar.com/avatar/";
    private static final String SB_AVATAR = AvatarRenderer.class.getName() + "#avatar";

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Avatar avatar = (Avatar)component;
        ResponseWriter writer = context.getResponseWriter();
        String styleClass = this.getStyleClassBuilder(context).add("ui-avatar ui-widget").add(avatar.getStyleClass()).add("circle".equals(avatar.getShape()), "ui-avatar-circle").add("large".equals(avatar.getSize()), "ui-avatar-lg").add("xlarge".equals(avatar.getSize()), "ui-avatar-xl").add(avatar.isDynamicColor(), "ui-avatar-dynamic").add(avatar.isDynamicColor(), avatar.getLightness() > 50 ? "ui-avatar-light" : "ui-avatar-dark").build();
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)avatar.getClientId(context), "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        String label = this.calculateLabel(context, avatar);
        String style = avatar.getStyle();
        String title = avatar.getTitle();
        if (avatar.isDynamicColor() && label != null) {
            String colorCss = this.generateBackgroundColor(avatar);
            String string = style = style == null ? colorCss : colorCss + style;
        }
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        if (!LangUtils.isEmpty(title)) {
            writer.writeAttribute("title", (Object)title, null);
        }
        this.encodeDefaultContent(context, avatar, label);
        this.renderChildren(context, (UIComponent)avatar);
        writer.endElement("div");
    }

    protected void encodeDefaultContent(FacesContext context, Avatar avatar, String label) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        if (avatar.getGravatar() != null) {
            writer.startElement("img", null);
            writer.writeAttribute("src", (Object)this.generateGravatar(context, avatar), "src");
            writer.endElement("img");
        }
        if (LangUtils.isNotBlank(label)) {
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)"ui-avatar-text", "styleClass");
            writer.writeText((Object)label, "label");
            writer.endElement("span");
        } else if (avatar.getIcon() != null) {
            String iconStyleClass = this.getStyleClassBuilder(context).add("ui-avatar-icon").add(avatar.getIcon()).build();
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)iconStyleClass, "styleClass");
            writer.endElement("span");
        }
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected String calculateLabel(FacesContext context, Avatar avatar) {
        String value = avatar.getLabel();
        if (value == null || value.length() <= 2) {
            return value;
        }
        Matcher m = LETTER_PATTTERN.matcher(value);
        StringBuilder sb = SharedStringBuilder.get(context, SB_AVATAR);
        while (m.find()) {
            sb.append(m.group());
        }
        String initials = sb.toString();
        initials = LangUtils.isEmpty(initials) ? "" + value.charAt(0) : initials;
        return initials.length() == 1 ? initials : initials.charAt(0) + initials.substring(initials.length() - 1);
    }

    protected String generateBackgroundColor(Avatar avatar) {
        return String.format("background-color:hsla(%d,%d%%,%d%%,%d%%)", Math.abs(avatar.getLabel().hashCode() % 40 * 9), avatar.getSaturation(), avatar.getLightness(), avatar.getAlpha());
    }

    protected String generateGravatar(FacesContext context, Avatar avatar) {
        String url;
        String email = avatar.getGravatar();
        String config = avatar.getGravatarConfig();
        if (LangUtils.isBlank(config) && avatar.canFallback()) {
            config = "d=blank";
        }
        try {
            StringBuilder sb = SharedStringBuilder.get(context, SB_AVATAR);
            sb.append(GRAVATAR_URL);
            this.generateMailHash(sb, email);
            if (LangUtils.isNotBlank(config)) {
                sb.append('?').append(config);
            }
            url = sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new FacesException("Failed to generate Gravatar URL for value: " + email);
        }
        return url;
    }

    protected void generateMailHash(StringBuilder sb, String email) throws NoSuchAlgorithmException {
        byte[] digest;
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(email.getBytes(StandardCharsets.UTF_8));
        for (byte b : digest = md.digest()) {
            sb.append(String.format("%02x", b & 0xFF));
        }
    }
}

