/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.cache;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.primefaces.cache.CacheProvider;
import org.primefaces.component.cache.UICache;
import org.primefaces.context.PrimeApplicationContext;
import org.primefaces.context.PrimeRequestContext;
import org.primefaces.renderkit.CoreRenderer;

public class UICacheRenderer
extends CoreRenderer {
    private static final Logger LOGGER = Logger.getLogger(UICacheRenderer.class.getName());

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        UICache uiCache = (UICache)component;
        if (!uiCache.isDisabled()) {
            String output;
            boolean moveScriptsToBottom;
            if (LOGGER.isLoggable(Level.WARNING) && (moveScriptsToBottom = PrimeRequestContext.getCurrentInstance().getApplicationContext().getConfig().isMoveScriptsToBottom())) {
                this.logDevelopmentWarning(context, "Using p:cache in combination with PrimeFaces.MOVE_SCRIPTS_TO_BOTTOM may cause Javascript code to stop working.");
            }
            ResponseWriter writer = context.getResponseWriter();
            CacheProvider cacheProvider = PrimeApplicationContext.getCurrentInstance(context).getCacheProvider();
            String key = uiCache.getKey();
            String region = uiCache.getRegion();
            if (key == null) {
                key = uiCache.getClientId(context);
            }
            if (region == null) {
                region = context.getViewRoot().getViewId();
            }
            if ((output = (String)cacheProvider.get(region, key)) == null) {
                StringWriter stringWriter = new StringWriter();
                ResponseWriter clonedWriter = writer.cloneWithWriter((Writer)stringWriter);
                context.setResponseWriter(clonedWriter);
                this.renderChildren(context, (UIComponent)uiCache);
                output = stringWriter.getBuffer().toString();
                cacheProvider.put(region, key, output);
                context.setResponseWriter(writer);
                uiCache.setCacheSetInCurrentRequest(true);
            }
            writer.write(output);
        } else {
            this.renderChildren(context, (UIComponent)uiCache);
        }
    }

    public boolean getRendersChildren() {
        return true;
    }
}

