/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.chart;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import java.io.Writer;
import org.primefaces.component.chart.Chart;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.FacetUtils;
import org.primefaces.util.FastStringWriter;
import org.primefaces.util.LangUtils;
import org.primefaces.util.WidgetBuilder;

public class ChartRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        super.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Chart chart = (Chart)component;
        this.encodeMarkup(context, chart);
        this.encodeScript(context, chart);
    }

    protected void encodeMarkup(FacesContext context, Chart chart) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = chart.getClientId(context);
        String style = chart.getStyle();
        Object styleClass = chart.getStyleClass();
        String canvasStyle = chart.getCanvasStyle();
        String canvasStyleClass = chart.getCanvasStyleClass();
        styleClass = styleClass != null ? "ui-chart " + (String)styleClass : "ui-chart";
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", styleClass, "styleClass");
        if (LangUtils.isNotEmpty(style)) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        writer.startElement("canvas", null);
        writer.writeAttribute("id", (Object)(clientId + "_canvas"), null);
        writer.writeAttribute("role", (Object)"img", null);
        writer.writeAttribute("aria-label", (Object)chart.getAriaLabel(), null);
        if (LangUtils.isNotEmpty(canvasStyle)) {
            writer.writeAttribute("style", (Object)canvasStyle, null);
        }
        if (LangUtils.isNotEmpty(canvasStyleClass)) {
            writer.writeAttribute("class", (Object)canvasStyleClass, null);
        }
        writer.endElement("canvas");
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, Chart chart) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("Chart", chart).nativeAttr("config", this.renderConfig(context, chart)).nativeAttr("extender", chart.getExtender());
        this.encodeClientBehaviors(context, chart);
        wb.finish();
    }

    protected String renderConfig(FacesContext context, Chart chart) throws IOException {
        UIComponent facet = chart.getFacet("value");
        if (FacetUtils.shouldRenderFacet(facet)) {
            ResponseWriter originalWriter = context.getResponseWriter();
            FastStringWriter fsw = new FastStringWriter();
            ResponseWriter clonedWriter = originalWriter.cloneWithWriter((Writer)fsw);
            context.setResponseWriter(clonedWriter);
            facet.encodeAll(context);
            context.setResponseWriter(originalWriter);
            return fsw.toString();
        }
        return chart.getValue();
    }
}

