/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.column;

import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UINamingContainer;
import jakarta.faces.context.FacesContext;
import java.io.IOException;
import java.util.List;
import org.primefaces.component.celleditor.CellEditor;
import org.primefaces.component.column.ColumnBase;
import org.primefaces.util.ComponentTraversalUtils;
import org.primefaces.util.LangUtils;

public class Column
extends ColumnBase {
    public static final String COMPONENT_TYPE = "org.primefaces.component.Column";

    @Override
    public CellEditor getCellEditor() {
        return ComponentTraversalUtils.firstChildRendered(CellEditor.class, (UIComponent)this);
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    @Override
    public String getColumnKey() {
        return this.getClientId();
    }

    @Override
    public String getColumnKey(UIComponent parent, String rowIndex) {
        char separator = UINamingContainer.getSeparatorChar((FacesContext)this.getFacesContext());
        return this.getColumnKey().replace(parent.getId() + separator + rowIndex + separator, parent.getId() + separator);
    }

    public List getElements() {
        return this.getChildren();
    }

    @Override
    public int getElementsCount() {
        return this.getChildCount();
    }

    @Override
    public void renderChildren(FacesContext context) throws IOException {
        int childCount = this.getChildCount();
        if (childCount > 0) {
            for (int i = 0; i < childCount; ++i) {
                UIComponent child = (UIComponent)this.getChildren().get(i);
                child.encodeAll(context);
            }
        }
    }

    @Override
    public String getHeaderText() {
        String field;
        String headerText = super.getHeaderText();
        if (headerText == null && LangUtils.isNotBlank(field = this.getField())) {
            headerText = LangUtils.toCapitalCase(field);
        }
        return headerText;
    }
}

