/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.commandlink;

import jakarta.faces.FacesException;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIForm;
import jakarta.faces.component.behavior.ClientBehaviorContext;
import jakarta.faces.component.behavior.ClientBehaviorHolder;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.event.ActionEvent;
import jakarta.faces.event.FacesEvent;
import java.io.IOException;
import java.util.ArrayList;
import org.primefaces.component.api.ClientBehaviorRenderingMode;
import org.primefaces.component.commandlink.CommandLink;
import org.primefaces.context.PrimeRequestContext;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.CSVBuilder;
import org.primefaces.util.ComponentTraversalUtils;
import org.primefaces.util.HTML;
import org.primefaces.util.SharedStringBuilder;
import org.primefaces.util.WidgetBuilder;

public class CommandLinkRenderer
extends CoreRenderer {
    private static final String SB_BUILD_ONCLICK = CommandLinkRenderer.class.getName() + "#buildOnclick";

    public void decode(FacesContext context, UIComponent component) {
        CommandLink link = (CommandLink)component;
        if (link.isDisabled()) {
            return;
        }
        String param = component.getClientId(context);
        if (context.getExternalContext().getRequestParameterMap().containsKey(param)) {
            component.queueEvent((FacesEvent)new ActionEvent(component));
        }
        this.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        CommandLink link = (CommandLink)component;
        this.encodeMarkup(context, link);
        this.encodeScript(context, link);
    }

    protected void encodeMarkup(FacesContext context, CommandLink link) throws IOException {
        String request;
        String onclickBehaviors;
        ResponseWriter writer = context.getResponseWriter();
        String clientId = link.getClientId(context);
        Object label = link.getValue();
        String form = link.getForm();
        boolean ajax = link.isAjax();
        String styleClass = this.getStyleClassBuilder(context).add(link.isDisabled(), "ui-commandlink ui-widget ui-state-disabled", "ui-commandlink ui-widget").add(link.getStyleClass()).build();
        PrimeRequestContext requestContext = PrimeRequestContext.getCurrentInstance(context);
        boolean csvEnabled = requestContext.getApplicationContext().getConfig().isClientSideValidationEnabled() && link.isValidateClient();
        StringBuilder onclick = SharedStringBuilder.get(context, SB_BUILD_ONCLICK);
        if (link.getOnclick() != null) {
            onclick.append(link.getOnclick()).append(";");
        }
        if ((onclickBehaviors = this.getEventBehaviors(context, (ClientBehaviorHolder)link, "click", null)) != null) {
            onclick.append(onclickBehaviors);
        }
        writer.startElement("a", (UIComponent)link);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("href", (Object)"#", null);
        writer.writeAttribute("class", (Object)styleClass, null);
        writer.writeAttribute("aria-label", (Object)link.getAriaLabel(), null);
        if (!this.isValueBlank(form)) {
            writer.writeAttribute("data-pf-form", (Object)form, null);
        }
        if (ajax) {
            request = this.buildAjaxRequest(context, link);
        } else {
            UIForm uiForm = ComponentTraversalUtils.closestForm((UIComponent)link);
            if (uiForm == null) {
                throw new FacesException("Commandlink \"" + clientId + "\" must be inside a form component");
            }
            request = this.buildNonAjaxRequest(context, (UIComponent)link, (UIComponent)uiForm, clientId, true);
        }
        if (csvEnabled) {
            CSVBuilder csvb = requestContext.getCSVBuilder();
            request = csvb.init().source("this").ajax(ajax).process((UIComponent)link, link.getProcess()).update((UIComponent)link, link.getUpdate()).command(request).build();
        }
        onclick.append(request);
        if (onclick.length() > 0) {
            if (link.requiresConfirmation()) {
                writer.writeAttribute("data-pfconfirmcommand", (Object)onclick.toString(), null);
                writer.writeAttribute("onclick", (Object)link.getConfirmationScript(), "onclick");
            } else {
                writer.writeAttribute("onclick", (Object)onclick.toString(), "onclick");
            }
            this.renderPassThruAttributes(context, (UIComponent)link, HTML.LINK_WITHOUT_CLICK_ATTRS);
        } else {
            this.renderPassThruAttributes(context, (UIComponent)link, HTML.LINK_ATTRS);
        }
        if (link.isDisabled()) {
            writer.writeAttribute("tabindex", (Object)"-1", null);
        }
        ArrayList<ClientBehaviorContext.Parameter> behaviorParams = new ArrayList<ClientBehaviorContext.Parameter>(1);
        behaviorParams.add(new ClientBehaviorContext.Parameter("CLIENT_BEHAVIOR_RENDERING_MODE", (Object)ClientBehaviorRenderingMode.UNOBSTRUSIVE));
        String dialogReturnBehavior = this.getEventBehaviors(context, (ClientBehaviorHolder)link, "dialogReturn", behaviorParams);
        if (dialogReturnBehavior != null) {
            writer.writeAttribute("data-dialogreturn", (Object)dialogReturnBehavior, null);
        }
        if (label != null) {
            writer.writeText(label, "value");
        }
        this.renderChildren(context, (UIComponent)link);
        writer.endElement("a");
    }

    protected void encodeScript(FacesContext context, CommandLink link) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("CommandLink", link).attr("disableOnAjax", link.isDisableOnAjax(), true).attr("disabledAttr", link.isDisabled(), false);
        this.encodeClientBehaviors(context, (ClientBehaviorHolder)link);
        wb.finish();
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

