/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datatable;

import jakarta.el.ELContext;
import jakarta.el.MethodExpression;
import jakarta.el.ValueExpression;
import jakarta.faces.FacesException;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UINamingContainer;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.primefaces.component.api.DynamicColumn;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.celleditor.CellEditor;
import org.primefaces.component.column.Column;
import org.primefaces.component.columngroup.ColumnGroup;
import org.primefaces.component.columns.Columns;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.datatable.feature.DataTableFeature;
import org.primefaces.component.datatable.feature.DataTableFeatures;
import org.primefaces.component.headerrow.HeaderRow;
import org.primefaces.component.row.Row;
import org.primefaces.component.subtable.SubTable;
import org.primefaces.component.summaryrow.SummaryRow;
import org.primefaces.event.data.PostRenderEvent;
import org.primefaces.model.ColumnMeta;
import org.primefaces.model.SortMeta;
import org.primefaces.model.SortOrder;
import org.primefaces.renderkit.DataRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.FacetUtils;
import org.primefaces.util.LangUtils;
import org.primefaces.util.MessageFactory;
import org.primefaces.util.WidgetBuilder;

public class DataTableRenderer
extends DataRenderer {
    private static final Logger LOGGER = Logger.getLogger(DataTableRenderer.class.getName());

    public void decode(FacesContext context, UIComponent component) {
        DataTable table = (DataTable)component;
        for (DataTableFeature feature : DataTableFeatures.all()) {
            if (!feature.shouldDecode(context, table)) continue;
            feature.decode(context, table);
        }
        this.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        DataTable table = (DataTable)component;
        if (table.shouldEncodeFeature(context)) {
            for (DataTableFeature feature : DataTableFeatures.all()) {
                if (!feature.shouldEncode(context, table)) continue;
                feature.encode(context, this, table);
            }
            if (table.isFullUpdateRequest(context)) {
                this.render(context, table);
            }
        } else {
            this.render(context, table);
        }
        context.getApplication().publishEvent(context, PostRenderEvent.class, (Object)table);
    }

    protected void render(FacesContext context, DataTable table) throws IOException {
        this.preRender(context, table);
        this.encodeMarkup(context, table);
        this.encodeScript(context, table);
        if (table.isPaginator() && table.getRows() == 0) {
            LOGGER.log(Level.WARNING, "DataTable with paginator=true should also set the rows attribute. ClientId: {0}", table.getClientId());
        }
    }

    protected void preRender(FacesContext context, DataTable table) {
        table.getSortByAsMap();
        table.getFilterByAsMap();
        if (table.isMultiViewState()) {
            table.restoreMultiViewState();
        }
        if (table.isLiveScroll()) {
            table.setScrollOffset(0);
        }
        if (!table.loadLazyDataIfEnabled()) {
            if (table.isFilteringCurrentlyActive()) {
                DataTableFeatures.filterFeature().filter(context, table);
            }
            if (table.isSortingCurrentlyActive()) {
                DataTableFeatures.sortFeature().sort(context, table);
                table.setRowIndex(-1);
            }
        }
        if (table.isSelectionEnabled()) {
            DataTableFeatures.selectionFeature().decodeSelectionRowKeys(context, table);
        }
        if (table.isPaginator()) {
            table.calculateRows();
            table.calculateFirst();
        }
    }

    protected void encodeScript(FacesContext context, DataTable table) throws IOException {
        String widgetClass;
        String selectionMode = table.resolveSelectionMode();
        boolean isFrozenTable = table.getFrozenColumns() > 0;
        String string = widgetClass = isFrozenTable ? "FrozenDataTable" : "DataTable";
        if (isFrozenTable && !table.isScrollable()) {
            throw new FacesException("Frozen columns can only be used with a table set scrollable='true'.");
        }
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init(widgetClass, table);
        if (table.isPaginator()) {
            this.encodePaginatorConfig(context, table, wb);
        }
        wb.attr("selectionMode", selectionMode, null).attr("selectionPageOnly", table.isSelectionPageOnly(), true).attr("selectionRowMode", table.getSelectionRowMode(), "new").attr("nativeElements", table.isNativeElements(), false).attr("rowSelector", table.getRowSelector(), null).attr("disabledTextSelection", table.isSelectionTextDisabled(), true);
        if (table.isFilteringEnabled()) {
            wb.attr("filter", true).attr("filterEvent", table.getFilterEvent(), null).attr("filterDelay", table.getFilterDelay(), Integer.MAX_VALUE);
        }
        if (table.getRowExpansion() != null) {
            wb.attr("expansion", true).attr("rowExpandMode", table.getRowExpandMode());
        }
        if (table.isScrollable()) {
            wb.attr("scrollable", true).attr("liveScroll", table.isLiveScroll()).attr("scrollStep", table.getScrollRows()).attr("scrollLimit", table.getRowCount()).attr("scrollWidth", table.getScrollWidth(), null).attr("scrollHeight", table.getScrollHeight(), null).attr("frozenColumns", table.getFrozenColumns(), 0).attr("liveScrollBuffer", table.getLiveScrollBuffer()).attr("virtualScroll", table.isVirtualScroll()).attr("touchable", false, true);
        } else {
            wb.attr("touchable", ComponentUtils.isTouchable(context, table), true);
        }
        wb.attr("resizableColumns", table.isResizableColumns(), false).attr("liveResize", table.isLiveResize(), false).attr("draggableColumns", table.isDraggableColumns(), false).attr("resizeMode", table.getResizeMode(), "fit");
        wb.attr("draggableRows", table.isDraggableRows(), false).attr("rowDragSelector", table.getRowDragSelector(), null);
        if (table.isEditable()) {
            wb.attr("editable", true).attr("editMode", table.getEditMode()).attr("cellSeparator", table.getCellSeparator(), null).attr("saveOnCellBlur", table.isSaveOnCellBlur(), true).attr("cellEditMode", table.getCellEditMode(), "eager").attr("editInitEvent", table.getEditInitEvent()).attr("rowEditMode", table.getRowEditMode(), "eager");
        }
        if (table.isSortingEnabled()) {
            wb.attr("sorting", true);
            if (table.isMultiSort()) {
                wb.attr("multiSort", true).nativeAttr("sortMetaOrder", table.getSortMetaAsString(), null);
            }
            if (table.isAllowUnsorting()) {
                wb.attr("allowUnsorting", true);
            }
        }
        if (table.isStickyHeader()) {
            wb.attr("stickyHeader", true).attr("stickyTopAt", table.getStickyTopAt(), null);
        }
        wb.attr("tabindex", table.getTabindex(), "0").attr("reflow", table.isReflow(), false).attr("rowHover", table.isRowHover(), false).attr("clientCache", table.isClientCache(), false).attr("multiViewState", table.isMultiViewState(), false).attr("cellNavigation", table.isCellNavigation()).attr("partialUpdate", table.isPartialUpdate(), true).nativeAttr("groupColumnIndexes", table.getGroupedColumnIndexes(), null).callback("onRowClick", "function(row)", table.getOnRowClick());
        wb.attr("disableContextMenuIfEmpty", table.isDisableContextMenuIfEmpty());
        this.encodeClientBehaviors(context, table);
        wb.finish();
    }

    protected void encodeMarkup(FacesContext context, DataTable table) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = table.getClientId(context);
        boolean scrollable = table.isScrollable();
        boolean hasPaginator = table.isPaginator();
        boolean resizable = table.isResizableColumns();
        Object style = Objects.toString(table.getStyle(), "");
        String paginatorPosition = table.getPaginatorPosition();
        int frozenColumns = table.getFrozenColumns();
        boolean hasFrozenColumns = frozenColumns != 0;
        String summary = table.getSummary();
        if (table.isReflow()) {
            style = (String)style + ";visibility:hidden;";
        }
        String containerClass = this.getStyleClassBuilder(context).add("ui-datatable ui-widget").add(scrollable, "ui-datatable-scrollable").add(table.getStyleClass()).add(resizable, "ui-datatable-resizable").add(table.isStickyHeader(), "ui-datatable-sticky").add(ComponentUtils.isRTL(context, table), "ui-datatable-rtl").add(table.isReflow(), "ui-datatable-reflow").add(hasFrozenColumns, "ui-datatable-frozencolumn").add(table.isStripedRows(), "ui-datatable-striped").add(table.isShowGridlines(), "ui-datatable-gridlines").add("small".equals(table.getSize()), "ui-datatable-sm").add("large".equals(table.getSize()), "ui-datatable-lg").build();
        if (summary != null) {
            writer.startElement("span", null);
            writer.writeAttribute("id", (Object)(clientId + "_summary"), null);
            writer.writeAttribute("class", (Object)"ui-datatable-summary", null);
            writer.writeText((Object)summary, null);
            writer.endElement("span");
        }
        writer.startElement("div", (UIComponent)table);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)containerClass, "styleClass");
        if (LangUtils.isNotBlank((String)style)) {
            writer.writeAttribute("style", style, "style");
        }
        if (table.isReflow()) {
            this.encodeSortableHeaderOnReflow(context, table);
        }
        this.encodeFacet(context, table, table.getHeader(), "ui-datatable-header ui-widget-header ui-corner-top");
        if (hasPaginator && !"bottom".equalsIgnoreCase(paginatorPosition)) {
            this.encodePaginatorMarkup(context, table, "top");
        }
        if (scrollable) {
            this.encodeScrollableTable(context, table);
        } else {
            this.encodeRegularTable(context, table);
        }
        if (hasPaginator && !"top".equalsIgnoreCase(paginatorPosition)) {
            this.encodePaginatorMarkup(context, table, "bottom");
        }
        this.encodeFacet(context, table, table.getFooter(), "ui-datatable-footer ui-widget-header ui-corner-bottom");
        if (table.isSelectionEnabled()) {
            this.encodeStateHolder(context, table, table.getClientId(context) + "_selection", table.getSelectedRowKeysAsString());
        }
        if (table.isDraggableColumns()) {
            this.encodeStateHolder(context, table, table.getClientId(context) + "_columnOrder", table.getOrderedColumnKeys());
        }
        if (scrollable) {
            this.encodeStateHolder(context, table, table.getClientId(context) + "_scrollState", table.getScrollState());
        }
        if (resizable) {
            this.encodeStateHolder(context, table, table.getClientId(context) + "_resizableColumnState", table.getColumnsWidthForClientSide());
        }
        if (table.getRowExpansion() != null) {
            this.encodeStateHolder(context, table, table.getClientId(context) + "_rowExpansionState", null);
        }
        writer.endElement("div");
    }

    protected void encodeRegularTable(FacesContext context, DataTable table) throws IOException {
        String width;
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-datatable-tablewrapper", null);
        Object tableStyle = table.getTableStyle();
        if (table.isResizableColumns() && (width = table.getWidth()) != null) {
            tableStyle = tableStyle != null ? (String)tableStyle + ";width:" + width + "px" : "width:" + width + "px";
        }
        writer.startElement("table", null);
        writer.writeAttribute("role", (Object)"grid", null);
        if (LangUtils.isNotBlank((String)tableStyle)) {
            writer.writeAttribute("style", tableStyle, null);
        }
        if (LangUtils.isNotBlank(table.getTableStyleClass())) {
            writer.writeAttribute("class", (Object)table.getTableStyleClass(), null);
        }
        String summary = table.getSummary();
        String clientId = table.getClientId(context);
        if (summary != null) {
            writer.writeAttribute("summary", (Object)summary, null);
            writer.writeAttribute("aria-describedby", (Object)(clientId + "_summary"), null);
        }
        this.encodeThead(context, table);
        this.encodeTbody(context, table, false);
        this.encodeTFoot(context, table);
        writer.endElement("table");
        writer.endElement("div");
    }

    protected void encodeScrollableTable(FacesContext context, DataTable table) throws IOException {
        String tableStyle = table.getTableStyle();
        String tableStyleClass = table.getTableStyleClass();
        int frozenColumns = table.getFrozenColumns();
        boolean hasFrozenColumns = frozenColumns != 0;
        ResponseWriter writer = context.getResponseWriter();
        String clientId = table.getClientId(context);
        List<UIColumn> columns = table.getColumns();
        int columnsCount = columns.size();
        boolean isVirtualScroll = table.isVirtualScroll();
        if (hasFrozenColumns) {
            int lastFrozenColumn = 0;
            for (int i = 0; i < columnsCount; ++i) {
                UIColumn column = columns.get(i);
                if (column instanceof DynamicColumn) {
                    ((DynamicColumn)column).applyModel();
                }
                if (column.isRendered()) {
                    ++lastFrozenColumn;
                }
                if (lastFrozenColumn != frozenColumns) continue;
                lastFrozenColumn = i + 1;
                break;
            }
            writer.startElement("table", null);
            writer.writeAttribute("class", (Object)"ui-datatable-fs", null);
            writer.startElement("tbody", null);
            writer.startElement("tr", null);
            writer.startElement("td", null);
            writer.writeAttribute("class", (Object)"ui-datatable-frozenlayout-left", null);
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)"ui-datatable-frozen-container", null);
            this.encodeScrollAreaStart(context, table, "ui-widget-header ui-datatable-scrollable-header", "ui-datatable-scrollable-header-box", tableStyle, tableStyleClass);
            this.encodeThead(context, table, 0, lastFrozenColumn, clientId + "_frozenThead", "frozenHeader");
            this.encodeFrozenRows(context, table, 0, lastFrozenColumn);
            this.encodeScrollAreaEnd(context);
            if (isVirtualScroll) {
                this.encodeVirtualScrollBody(context, table, tableStyle, tableStyleClass, 0, lastFrozenColumn, clientId + "_frozenTbody");
            } else {
                this.encodeScrollBody(context, table, tableStyle, tableStyleClass, 0, lastFrozenColumn, clientId + "_frozenTbody");
            }
            this.encodeScrollAreaStart(context, table, "ui-widget-header ui-datatable-scrollable-footer", "ui-datatable-scrollable-footer-box", tableStyle, tableStyleClass);
            this.encodeTFoot(context, table, 0, lastFrozenColumn, clientId + "_frozenTfoot", "frozenFooter");
            this.encodeScrollAreaEnd(context);
            writer.endElement("div");
            writer.endElement("td");
            writer.startElement("td", null);
            writer.writeAttribute("class", (Object)"ui-datatable-frozenlayout-right", null);
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)"ui-datatable-scrollable-container", null);
            this.encodeScrollAreaStart(context, table, "ui-widget-header ui-datatable-scrollable-header", "ui-datatable-scrollable-header-box", tableStyle, tableStyleClass);
            this.encodeThead(context, table, lastFrozenColumn, columnsCount, clientId + "_scrollableThead", "scrollableHeader");
            this.encodeFrozenRows(context, table, lastFrozenColumn, columnsCount);
            this.encodeScrollAreaEnd(context);
            if (isVirtualScroll) {
                this.encodeVirtualScrollBody(context, table, tableStyle, tableStyleClass, lastFrozenColumn, columnsCount, clientId + "_scrollableTbody");
            } else {
                this.encodeScrollBody(context, table, tableStyle, tableStyleClass, lastFrozenColumn, columnsCount, clientId + "_scrollableTbody");
            }
            this.encodeScrollAreaStart(context, table, "ui-widget-header ui-datatable-scrollable-footer", "ui-datatable-scrollable-footer-box", tableStyle, tableStyleClass);
            this.encodeTFoot(context, table, lastFrozenColumn, columnsCount, clientId + "_scrollableTfoot", "scrollableFooter");
            this.encodeScrollAreaEnd(context);
            writer.endElement("div");
            writer.endElement("td");
            writer.endElement("tr");
            writer.endElement("tbody");
            writer.endElement("table");
        } else {
            this.encodeScrollAreaStart(context, table, "ui-widget-header ui-datatable-scrollable-header", "ui-datatable-scrollable-header-box", tableStyle, tableStyleClass);
            this.encodeThead(context, table);
            this.encodeFrozenRows(context, table, 0, columnsCount);
            this.encodeScrollAreaEnd(context);
            if (isVirtualScroll) {
                this.encodeVirtualScrollBody(context, table, tableStyle, tableStyleClass, 0, columnsCount, null);
            } else {
                this.encodeScrollBody(context, table, tableStyle, tableStyleClass, 0, columnsCount, null);
            }
            this.encodeScrollAreaStart(context, table, "ui-widget-header ui-datatable-scrollable-footer", "ui-datatable-scrollable-footer-box", tableStyle, tableStyleClass);
            this.encodeTFoot(context, table);
            this.encodeScrollAreaEnd(context);
        }
    }

    protected void encodeScrollAreaStart(FacesContext context, DataTable table, String containerClass, String containerBoxClass, String tableStyle, String tableStyleClass) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)containerClass, null);
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)containerBoxClass, null);
        writer.startElement("table", null);
        writer.writeAttribute("role", (Object)"grid", null);
        if (LangUtils.isNotBlank(tableStyle)) {
            writer.writeAttribute("style", (Object)tableStyle, null);
        }
        if (LangUtils.isNotBlank(tableStyleClass)) {
            writer.writeAttribute("class", (Object)tableStyleClass, null);
        }
    }

    protected void encodeScrollAreaEnd(FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.endElement("table");
        writer.endElement("div");
        writer.endElement("div");
    }

    protected void encodeScrollBody(FacesContext context, DataTable table, String tableStyle, String tableStyleClass, int columnStart, int columnEnd, String tbodyId) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Object scrollHeight = table.getScrollHeight();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-datatable-scrollable-body", null);
        writer.writeAttribute("tabindex", (Object)"-1", null);
        if (LangUtils.isNotBlank((String)scrollHeight)) {
            if (!this.endsWithLenghtUnit((String)scrollHeight)) {
                scrollHeight = (String)scrollHeight + "px";
            }
            if (((String)scrollHeight).indexOf(37) == -1) {
                writer.writeAttribute("style", (Object)("max-height:" + (String)scrollHeight), null);
            }
        }
        writer.startElement("table", null);
        writer.writeAttribute("role", (Object)"grid", null);
        if (LangUtils.isNotBlank(tableStyle)) {
            writer.writeAttribute("style", (Object)tableStyle, null);
        }
        if (LangUtils.isNotBlank(tableStyleClass)) {
            writer.writeAttribute("class", (Object)tableStyleClass, null);
        }
        this.encodeTbody(context, table, false, columnStart, columnEnd, tbodyId);
        writer.endElement("table");
        writer.endElement("div");
    }

    protected void encodeVirtualScrollBody(FacesContext context, DataTable table, String tableStyle, String tableStyleClass, int columnStart, int columnEnd, String tbodyId) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String scrollHeight = table.getScrollHeight();
        tableStyleClass = tableStyleClass == null ? "ui-datatable-virtualscroll-table" : (String)tableStyleClass + " ui-datatable-virtualscroll-table";
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-datatable-scrollable-body", null);
        writer.writeAttribute("tabindex", (Object)"-1", null);
        if (scrollHeight != null && scrollHeight.indexOf(37) == -1) {
            writer.writeAttribute("style", (Object)("max-height:" + scrollHeight + "px"), null);
        }
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-datatable-virtualscroll-wrapper", null);
        writer.startElement("table", null);
        writer.writeAttribute("role", (Object)"grid", null);
        if (LangUtils.isNotBlank((String)tableStyleClass)) {
            writer.writeAttribute("class", tableStyleClass, null);
        }
        if (LangUtils.isNotBlank(tableStyle)) {
            writer.writeAttribute("style", (Object)tableStyle, null);
        }
        this.encodeTbody(context, table, false, columnStart, columnEnd, tbodyId);
        writer.endElement("table");
        writer.endElement("div");
        writer.endElement("div");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void encodeColumnHeader(FacesContext context, DataTable table, UIColumn column) throws IOException {
        if (!column.isRendered()) {
            return;
        }
        ColumnMeta columnMeta = table.getColumnMeta().get(column.getColumnKey());
        ResponseWriter writer = context.getResponseWriter();
        String clientId = column.getContainerClientId(context);
        boolean sortable = table.isColumnSortable(context, column);
        boolean filterable = table.isColumnFilterable(context, column);
        boolean isGroupedColumn = column.isGroupRow();
        boolean selectionBox = column.isSelectionBox();
        SortMeta sortMeta = null;
        boolean resizable = table.isResizableColumns() && column.isResizable();
        boolean draggable = table.isDraggableColumns() && column.isDraggable();
        int responsivePriority = column.getResponsivePriority();
        boolean columnVisible = column.isVisible();
        if (columnMeta != null && columnMeta.getVisible() != null) {
            columnVisible = columnMeta.getVisible();
        }
        Object columnClass = this.getStyleClassBuilder(context).add("ui-state-default").add(sortable, "ui-sortable-column").add(filterable, "ui-filter-column").add(selectionBox, "ui-selection-column").add(isGroupedColumn, "ui-grouped-column").add(resizable, "ui-resizable-column").add(draggable, "ui-draggable-column").add(!column.isToggleable(), "ui-static-column").add(!columnVisible, "ui-helper-hidden").add(column.getStyleClass()).add(responsivePriority > 0, "ui-column-p-" + responsivePriority).build();
        if (sortable && (sortMeta = table.getSortByAsMap().get(column.getColumnKey())).isActive()) {
            columnClass = (String)columnClass + " ui-state-active";
        }
        Object style = column.getStyle();
        String width = column.getWidth();
        if (columnMeta != null && columnMeta.getWidth() != null) {
            width = columnMeta.getWidth();
        }
        if (width != null) {
            String unit = this.endsWithLenghtUnit(width) ? "" : "px";
            style = style != null ? (String)style + ";width:" + width + unit : "width:" + width + unit;
        }
        String ariaHeaderLabel = this.resolveColumnAriaHeaderText(context, column);
        UIComponent component = column instanceof UIComponent ? (UIComponent)column : null;
        writer.startElement("th", component);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", columnClass, null);
        writer.writeAttribute("aria-label", (Object)ariaHeaderLabel, null);
        writer.writeAttribute("scope", (Object)"col", null);
        if (component != null) {
            this.renderDynamicPassThruAttributes(context, component);
        }
        if (style != null) {
            writer.writeAttribute("style", style, null);
        }
        if (column.getRowspan() != 1) {
            writer.writeAttribute("rowspan", (Object)column.getRowspan(), null);
        }
        if (column.getColspan() != 1) {
            writer.writeAttribute("colspan", (Object)column.getColspan(), null);
        }
        if (filterable) {
            String filterPosition = column.getFilterPosition();
            if ("bottom".equals(filterPosition)) {
                this.encodeColumnHeaderContent(context, table, column, sortMeta);
                this.encodeFilter(context, table, column);
            } else {
                if (!"top".equals(filterPosition)) throw new FacesException(filterPosition + " is an invalid option for filterPosition, valid values are 'bottom' or 'top'.");
                this.encodeFilter(context, table, column);
                this.encodeColumnHeaderContent(context, table, column, sortMeta);
            }
        } else {
            this.encodeColumnHeaderContent(context, table, column, sortMeta);
        }
        if (selectionBox && "multiple".equalsIgnoreCase(table.getSelectionMode()) && table.isShowSelectAll()) {
            this.encodeCheckbox(context, table, table.isSelectAll(), false, "ui-chkbox ui-chkbox-all ui-widget", true);
        }
        writer.endElement("th");
    }

    protected String resolveDefaultSortIcon(SortMeta sortMeta) {
        SortOrder sortOrder = sortMeta.getOrder();
        String sortIcon = "ui-sortable-column-icon ui-icon ui-icon-carat-2-n-s";
        if (sortOrder.isAscending()) {
            sortIcon = "ui-sortable-column-icon ui-icon ui-icon ui-icon-carat-2-n-s ui-icon-triangle-1-n";
        } else if (sortOrder.isDescending()) {
            sortIcon = "ui-sortable-column-icon ui-icon ui-icon ui-icon-carat-2-n-s ui-icon-triangle-1-s";
        }
        return sortIcon;
    }

    protected void encodeColumnHeaderContent(FacesContext context, DataTable table, UIColumn column, SortMeta sortMeta) throws IOException {
        String sortIcon;
        ResponseWriter writer = context.getResponseWriter();
        UIComponent headerFacet = column.getFacet("header");
        String headerText = this.resolveColumnHeaderText(context, column);
        String titleStyleClass = this.getStyleClassBuilder(context).add("ui-column-title").add(this.isColumnAriaHeaderTextDefined(context, column), "ui-helper-hidden-accessible").build();
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)titleStyleClass, null);
        if (FacetUtils.shouldRenderFacet(headerFacet, table.isRenderEmptyFacets())) {
            headerFacet.encodeAll(context);
        } else if (headerText != null) {
            String title = column.getTitle();
            if (LangUtils.isNotBlank(title)) {
                writer.writeAttribute("title", (Object)title, null);
            }
            if (table.isEscapeText()) {
                writer.writeText((Object)headerText, "headerText");
            } else {
                writer.write(headerText);
            }
        }
        writer.endElement("span");
        if (sortMeta != null && (sortIcon = this.resolveDefaultSortIcon(sortMeta)) != null) {
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)sortIcon, null);
            writer.endElement("span");
            if (table.isMultiSort()) {
                writer.startElement("span", null);
                writer.writeAttribute("class", (Object)"ui-sortable-column-badge ui-helper-hidden", null);
                writer.endElement("span");
            }
        }
    }

    protected void encodeFilter(FacesContext context, DataTable table, UIColumn column) throws IOException {
        if (table.isGlobalFilterOnly()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        UIComponent filterFacet = column.getFacet("filter");
        if (!FacetUtils.shouldRenderFacet(filterFacet, table.isRenderEmptyFacets())) {
            this.encodeDefaultFilter(context, table, column, writer);
        } else {
            Object filterValue = table.getFilterValue(column);
            column.setFilterValueToValueHolder(context, filterValue);
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)"ui-column-customfilter", null);
            filterFacet.encodeAll(context);
            writer.endElement("div");
        }
    }

    protected void encodeDefaultFilter(FacesContext context, DataTable table, UIColumn column, ResponseWriter writer) throws IOException {
        String separator = String.valueOf(UINamingContainer.getSeparatorChar((FacesContext)context));
        boolean disableTabbing = table.getScrollWidth() != null;
        String filterId = column.getContainerClientId(context) + separator + "filter";
        Object filterValue = this.findFilterValueForColumn(context, table, column, filterId);
        String filterStyleClass = column.getFilterStyleClass();
        this.encodeFilterInput(column, writer, disableTabbing, filterId, filterStyleClass, filterValue);
    }

    protected void encodeFilterInput(UIColumn column, ResponseWriter writer, boolean disableTabbing, String filterId, String filterStyleClass, Object filterValue) throws IOException {
        filterStyleClass = filterStyleClass == null ? "ui-column-filter ui-inputfield ui-inputtext ui-widget ui-state-default ui-corner-all" : "ui-column-filter ui-inputfield ui-inputtext ui-widget ui-state-default ui-corner-all " + (String)filterStyleClass;
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)filterId, null);
        writer.writeAttribute("name", (Object)filterId, null);
        writer.writeAttribute("type", (Object)"search", null);
        writer.writeAttribute("class", filterStyleClass, null);
        writer.writeAttribute("value", filterValue, null);
        writer.writeAttribute("autocomplete", (Object)"off", null);
        if (disableTabbing) {
            writer.writeAttribute("tabindex", (Object)"-1", null);
        }
        if (column.getFilterStyle() != null) {
            writer.writeAttribute("style", (Object)column.getFilterStyle(), null);
        }
        if (column.getFilterMaxLength() != Integer.MAX_VALUE) {
            writer.writeAttribute("maxlength", (Object)column.getFilterMaxLength(), null);
        }
        if (LangUtils.isNotBlank(column.getFilterPlaceholder())) {
            writer.writeAttribute("placeholder", (Object)column.getFilterPlaceholder(), null);
        }
        writer.endElement("input");
    }

    protected Object findFilterValueForColumn(FacesContext context, DataTable table, UIColumn column, String filterId) {
        Object filterValue;
        if (table.isReset()) {
            filterValue = "";
        } else {
            filterValue = table.getFilterValue(column);
            if (filterValue == null) {
                Object columnFilterValue;
                Map params = context.getExternalContext().getRequestParameterMap();
                filterValue = params.containsKey(filterId) ? params.get(filterId) : ((columnFilterValue = column.getFilterValue()) == null ? "" : columnFilterValue.toString());
            }
        }
        return filterValue;
    }

    public void encodeColumnFooter(FacesContext context, DataTable table, UIColumn column) throws IOException {
        if (!column.isRendered()) {
            return;
        }
        ColumnMeta columnMeta = table.getColumnMeta().get(column.getColumnKey());
        ResponseWriter writer = context.getResponseWriter();
        int responsivePriority = column.getResponsivePriority();
        String style = column.getStyle();
        Object styleClass = column.getStyleClass();
        styleClass = styleClass == null ? "ui-state-default" : "ui-state-default " + (String)styleClass;
        boolean columnVisible = column.isVisible();
        if (columnMeta != null && columnMeta.getVisible() != null) {
            columnVisible = columnMeta.getVisible();
        }
        if (!columnVisible) {
            styleClass = (String)styleClass + " ui-helper-hidden";
        }
        if (responsivePriority > 0) {
            styleClass = (String)styleClass + " ui-column-p-" + responsivePriority;
        }
        writer.startElement("td", null);
        if (LangUtils.isNotBlank((String)styleClass)) {
            writer.writeAttribute("class", styleClass, null);
        }
        if (LangUtils.isNotBlank(style)) {
            writer.writeAttribute("style", (Object)style, null);
        }
        if (column.getRowspan() != 1) {
            writer.writeAttribute("rowspan", (Object)column.getRowspan(), null);
        }
        if (column.getColspan() != 1) {
            writer.writeAttribute("colspan", (Object)column.getColspan(), null);
        }
        UIComponent facet = column.getFacet("footer");
        String text = column.getFooterText();
        if (FacetUtils.shouldRenderFacet(facet, table.isRenderEmptyFacets())) {
            facet.encodeAll(context);
        } else if (text != null) {
            if (table.isEscapeText()) {
                writer.writeText((Object)text, "footerText");
            } else {
                writer.write(text);
            }
        }
        writer.endElement("td");
    }

    protected void encodeThead(FacesContext context, DataTable table) throws IOException {
        this.encodeThead(context, table, 0, table.getColumns().size(), null, null);
    }

    protected void encodeThead(FacesContext context, DataTable table, int columnStart, int columnEnd, String theadId, String columnGroupType) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        List<UIColumn> columns = table.getColumns();
        String theadClientId = theadId == null ? table.getClientId(context) + "_head" : theadId;
        String colGroupType = columnGroupType == null ? "header" : columnGroupType;
        ColumnGroup group = table.getColumnGroup(colGroupType);
        writer.startElement("thead", null);
        writer.writeAttribute("id", (Object)theadClientId, null);
        if (group != null && group.isRendered()) {
            context.getAttributes().put("org.primefaces.HELPER_RENDERER", "columnGroup");
            for (UIComponent child : group.getChildren()) {
                if (!child.isRendered()) continue;
                if (child instanceof Row) {
                    Row headerRow = (Row)child;
                    String rowClass = headerRow.getStyleClass();
                    String rowStyle = headerRow.getStyle();
                    writer.startElement("tr", null);
                    if (rowClass != null) {
                        writer.writeAttribute("class", (Object)rowClass, null);
                    }
                    if (rowStyle != null) {
                        writer.writeAttribute("style", (Object)rowStyle, null);
                    }
                    for (UIComponent headerRowChild : headerRow.getChildren()) {
                        if (headerRowChild instanceof Column) {
                            if (!headerRowChild.isRendered()) continue;
                            this.encodeColumnHeader(context, table, (Column)headerRowChild);
                            continue;
                        }
                        if (headerRowChild instanceof Columns) {
                            List<DynamicColumn> dynamicColumns = ((Columns)headerRowChild).getDynamicColumns();
                            for (DynamicColumn dynaColumn : dynamicColumns) {
                                dynaColumn.applyModel();
                                if (!dynaColumn.isRendered()) continue;
                                this.encodeColumnHeader(context, table, dynaColumn);
                            }
                            continue;
                        }
                        if (!headerRowChild.isRendered()) continue;
                        headerRowChild.encodeAll(context);
                    }
                    writer.endElement("tr");
                    continue;
                }
                child.encodeAll(context);
            }
            context.getAttributes().remove("org.primefaces.HELPER_RENDERER");
        } else {
            writer.startElement("tr", null);
            for (int i = columnStart; i < columnEnd; ++i) {
                UIColumn column = columns.get(i);
                if (column instanceof DynamicColumn) {
                    ((DynamicColumn)column).applyModel();
                }
                this.encodeColumnHeader(context, table, column);
            }
            writer.endElement("tr");
        }
        writer.endElement("thead");
    }

    public void encodeTbody(FacesContext context, DataTable table, boolean dataOnly) throws IOException {
        this.encodeTbody(context, table, dataOnly, 0, table.getColumns().size(), null);
    }

    public void encodeTbody(FacesContext context, DataTable table, boolean dataOnly, int columnStart, int columnEnd, String tbodyId) throws IOException {
        boolean hasData;
        int rowCountToRender;
        ResponseWriter writer = context.getResponseWriter();
        String rowIndexVar = table.getRowIndexVar();
        String clientId = table.getClientId(context);
        Map params = context.getExternalContext().getRequestParameterMap();
        int rows = table.getRows();
        int first = table.isClientCacheRequest(context) ? Integer.parseInt((String)params.get(clientId + "_first")) + rows : table.getFirst();
        int rowCount = table.getRowCount();
        if (table.isVirtualScroll()) {
            rowCountToRender = Math.min(table.getScrollRows() * 2, rowCount);
        } else if (table.isLiveScroll()) {
            rowCountToRender = rows == 0 ? table.getScrollRows() + table.getScrollOffset() : rows;
        } else {
            int n = rowCountToRender = rows == 0 ? rowCount : rows;
            if (rows > 0 && first % rows != 0) {
                this.logDevelopmentWarning(context, String.format("%s Invalid 'first' value %d is not divisible evenly by 'rows' %d", clientId, first, rows));
            }
        }
        int frozenRows = table.getFrozenRows();
        boolean bl = hasData = rowCount > 0;
        if (first == 0 && frozenRows > 0) {
            first += frozenRows;
        }
        if (!dataOnly) {
            Object tbodyClientId = tbodyId == null ? clientId + "_data" : tbodyId;
            writer.startElement("tbody", null);
            writer.writeAttribute("id", tbodyClientId, null);
            writer.writeAttribute("class", (Object)"ui-datatable-data ui-widget-content", null);
            if (table.isSelectionEnabled()) {
                writer.writeAttribute("tabindex", (Object)table.getTabindex(), null);
            }
        }
        if (hasData) {
            SubTable subTable = table.getSubTable();
            if (subTable != null) {
                this.encodeSubTable(context, table, subTable, first, first + rowCountToRender);
            } else {
                this.encodeRows(context, table, first, first + rowCountToRender, columnStart, columnEnd);
            }
        } else {
            writer.startElement("tr", null);
            writer.writeAttribute("class", (Object)"ui-widget-content ui-datatable-empty-message", null);
            writer.startElement("td", null);
            writer.writeAttribute("colspan", (Object)table.getColumnsCountWithSpan(), null);
            UIComponent emptyFacet = table.getFacet("emptyMessage");
            if (FacetUtils.shouldRenderFacet(emptyFacet, table.isRenderEmptyFacets())) {
                emptyFacet.encodeAll(context);
            } else {
                String emptyMessage = table.getEmptyMessage();
                writer.writeText((Object)emptyMessage, "emptyMessage");
            }
            writer.endElement("td");
            writer.endElement("tr");
        }
        if (!dataOnly) {
            writer.endElement("tbody");
        }
        table.setRowIndex(-1);
        if (rowIndexVar != null) {
            context.getExternalContext().getRequestMap().remove(rowIndexVar);
        }
    }

    protected void encodeRows(FacesContext context, DataTable table, int first, int last, int columnStart, int columnEnd) throws IOException {
        List<SummaryRow> summaryRows = table.getSummaryRows();
        HeaderRow headerRow = table.getHeaderRow();
        SortMeta sort = table.getHighestPriorityActiveSortMeta();
        boolean encodeHeaderRow = headerRow != null && headerRow.isEnabled() && sort != null;
        boolean encodeSummaryRow = !summaryRows.isEmpty() && sort != null;
        for (int i = first; i < last; ++i) {
            table.setRowIndex(i);
            if (!table.isRowAvailable()) break;
            if (encodeHeaderRow && (i == first || !this.isInSameGroup(context, table, i, -1, sort.getSortBy(), false))) {
                this.encodeHeaderRow(context, table, headerRow);
            }
            this.encodeRow(context, table, i, columnStart, columnEnd);
            if (!encodeSummaryRow || this.isInSameGroup(context, table, i, 1, sort.getSortBy(), i == last - 1)) continue;
            this.encodeSummaryRow(context, summaryRows, sort);
        }
    }

    protected void encodeFrozenRows(FacesContext context, DataTable table, int columnStart, int columnEnd) throws IOException {
        int frozenRows = table.getFrozenRows();
        if (frozenRows == 0) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("tbody", null);
        writer.writeAttribute("class", (Object)"ui-datatable-data ui-widget-content", null);
        for (int i = 0; i < frozenRows; ++i) {
            table.setRowIndex(i);
            this.encodeRow(context, table, i, columnStart, columnEnd);
        }
        writer.endElement("tbody");
    }

    protected void encodeSummaryRow(FacesContext context, List<SummaryRow> summaryRows, SortMeta sort) throws IOException {
        for (int i = 0; i < summaryRows.size(); ++i) {
            SummaryRow summaryRow = summaryRows.get(i);
            MethodExpression me = summaryRow.getListener();
            if (me != null) {
                me.invoke(context.getELContext(), new Object[]{sort.getSortBy()});
            }
            summaryRow.encodeAll(context);
        }
    }

    protected void encodeHeaderRow(FacesContext context, DataTable table, HeaderRow headerRow) throws IOException {
        headerRow.encodeAll(context);
    }

    public boolean encodeRow(FacesContext context, DataTable table, int rowIndex) throws IOException {
        return this.encodeRow(context, table, rowIndex, 0, table.getColumns().size());
    }

    public boolean encodeRow(FacesContext context, DataTable table, int rowIndex, int columnStart, int columnEnd) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        boolean selectionEnabled = table.isSelectionEnabled();
        boolean rowExpansionAvailable = table.getRowExpansion() != null;
        String rowKey = null;
        List<UIColumn> columns = table.getColumns();
        HeaderRow headerRow = table.getHeaderRow();
        if (selectionEnabled || rowExpansionAvailable) {
            rowKey = table.getRowKey(table.getRowData());
        }
        boolean selected = selectionEnabled && table.getSelectedRowKeys().contains(rowKey);
        boolean disabled = table.isSelectionDisabled();
        boolean allowSelection = selectionEnabled && !disabled;
        boolean expanded = table.isExpandedRow() || rowExpansionAvailable && table.getExpandedRowKeys().contains(rowKey);
        String rowStyleClass = this.getStyleClassBuilder(context).add("ui-widget-content").add(rowIndex % 2 == 0, "ui-datatable-even", "ui-datatable-odd").add(allowSelection, "ui-datatable-selectable").add(selected, "ui-state-highlight").add(table.isEditingRow(), "ui-row-editing").add(table.getRowStyleClass()).add(expanded, "ui-expanded-row").build();
        writer.startElement("tr", null);
        writer.writeAttribute("data-ri", (Object)rowIndex, null);
        if (rowKey != null) {
            writer.writeAttribute("data-rk", (Object)rowKey, null);
        }
        if (LangUtils.isNotBlank(rowStyleClass)) {
            writer.writeAttribute("class", (Object)rowStyleClass, null);
        }
        if (LangUtils.isNotBlank(table.getRowTitle())) {
            writer.writeAttribute("title", (Object)table.getRowTitle(), null);
        }
        if (selectionEnabled) {
            writer.writeAttribute("aria-selected", (Object)String.valueOf(selected), null);
        }
        if (headerRow != null && !headerRow.isExpanded()) {
            writer.writeAttribute("style", (Object)"display: none;", null);
        }
        for (int i = columnStart; i < columnEnd; ++i) {
            UIColumn column = columns.get(i);
            if (column instanceof Column) {
                this.encodeCell(context, table, column, selected, allowSelection, rowIndex);
                continue;
            }
            if (!(column instanceof DynamicColumn)) continue;
            DynamicColumn dynamicColumn = (DynamicColumn)column;
            dynamicColumn.applyModel();
            this.encodeCell(context, table, dynamicColumn, false, allowSelection, rowIndex);
        }
        writer.endElement("tr");
        if (expanded) {
            DataTableFeatures.rowExpandFeature().encodeExpansion(context, this, table, rowIndex);
        }
        return true;
    }

    protected void encodeCell(FacesContext context, DataTable table, UIColumn column, boolean selected, boolean rowSelectionEnabled, int rowIndex) throws IOException {
        UIComponent component;
        if (!column.isRendered()) {
            return;
        }
        ColumnMeta columnMeta = table.getColumnMeta().get(column.getColumnKey((UIComponent)table, rowIndex));
        boolean columnVisible = column.isVisible();
        if (columnMeta != null && columnMeta.getVisible() != null) {
            columnVisible = columnMeta.getVisible();
        }
        ResponseWriter writer = context.getResponseWriter();
        boolean columnSelectionEnabled = column.isSelectionBox();
        boolean isGroupedColumn = column.isGroupRow();
        CellEditor editor = column.getCellEditor();
        boolean editorEnabled = editor != null && editor.isRendered();
        int responsivePriority = column.getResponsivePriority();
        String title = column.getTitle();
        String style = column.getStyle();
        String styleClass = this.getStyleClassBuilder(context).add(columnSelectionEnabled, "ui-selection-column").add(isGroupedColumn, "ui-grouped-column").add(editorEnabled && editor.isDisabled(), "ui-cell-editor-disabled").add(editorEnabled && !editor.isDisabled(), "ui-editable-column").add(!column.isSelectRow(), "ui-column-unselectable").add(!columnVisible, "ui-helper-hidden").add(column.getStyleClass()).add(responsivePriority > 0, "ui-column-p-" + responsivePriority).build();
        int colspan = column.getColspan();
        int rowspan = column.getRowspan();
        writer.startElement("td", null);
        writer.writeAttribute("role", (Object)"gridcell", null);
        if (colspan != 1) {
            writer.writeAttribute("colspan", (Object)colspan, null);
        }
        if (rowspan != 1) {
            writer.writeAttribute("rowspan", (Object)rowspan, null);
        }
        if (LangUtils.isNotBlank(style)) {
            writer.writeAttribute("style", (Object)style, null);
        }
        if (LangUtils.isNotBlank(styleClass)) {
            writer.writeAttribute("class", (Object)styleClass, null);
        }
        if (LangUtils.isNotBlank(title)) {
            writer.writeAttribute("title", (Object)title, null);
        }
        UIComponent uIComponent = component = column instanceof UIComponent ? (UIComponent)column : null;
        if (component != null) {
            this.renderDynamicPassThruAttributes(context, component);
        }
        if (columnSelectionEnabled) {
            this.encodeColumnSelection(context, table, column, selected, rowSelectionEnabled);
        }
        if (this.hasColumnDefaultRendering(table, column)) {
            this.encodeDefaultFieldCell(context, table, column, writer);
        } else if (column instanceof DynamicColumn) {
            this.encodeDynamicCell(context, table, column);
        } else {
            column.renderChildren(context);
        }
        writer.endElement("td");
    }

    protected void encodeDynamicCell(FacesContext context, DataTable table, UIColumn column) throws IOException {
        column.encodeAll(context);
    }

    protected void encodeDefaultFieldCell(FacesContext context, DataTable table, UIColumn column, ResponseWriter writer) throws IOException {
        String value = table.getConvertedFieldValue(context, column);
        if (value != null) {
            writer.writeText((Object)value, null);
        }
    }

    protected void encodeTFoot(FacesContext context, DataTable table) throws IOException {
        this.encodeTFoot(context, table, 0, table.getColumns().size(), null, null);
    }

    protected void encodeTFoot(FacesContext context, DataTable table, int columnStart, int columnEnd, String tfootId, String columnGroupType) throws IOException {
        boolean shouldRenderFooter;
        ResponseWriter writer = context.getResponseWriter();
        List<UIColumn> columns = table.getColumns();
        String tfootClientId = tfootId == null ? table.getClientId(context) + "_foot" : tfootId;
        String colGroupType = columnGroupType == null ? "footer" : columnGroupType;
        ColumnGroup group = table.getColumnGroup(colGroupType);
        boolean hasFooterColumn = table.hasFooterColumn();
        boolean bl = shouldRenderFooter = hasFooterColumn || group != null;
        if (!shouldRenderFooter) {
            return;
        }
        writer.startElement("tfoot", null);
        writer.writeAttribute("id", (Object)tfootClientId, null);
        if (group != null && group.isRendered()) {
            context.getAttributes().put("org.primefaces.HELPER_RENDERER", "columnGroup");
            for (UIComponent child : group.getChildren()) {
                if (!child.isRendered()) continue;
                if (child instanceof Row) {
                    Row footerRow = (Row)child;
                    String rowClass = footerRow.getStyleClass();
                    String rowStyle = footerRow.getStyle();
                    writer.startElement("tr", null);
                    if (rowClass != null) {
                        writer.writeAttribute("class", (Object)rowClass, null);
                    }
                    if (rowStyle != null) {
                        writer.writeAttribute("style", (Object)rowStyle, null);
                    }
                    for (UIComponent footerRowChild : footerRow.getChildren()) {
                        if (!footerRowChild.isRendered()) continue;
                        if (footerRowChild instanceof Column) {
                            this.encodeColumnFooter(context, table, (Column)footerRowChild);
                            continue;
                        }
                        if (footerRowChild instanceof Columns) {
                            List<DynamicColumn> dynamicColumns = ((Columns)footerRowChild).getDynamicColumns();
                            for (DynamicColumn dynaColumn : dynamicColumns) {
                                dynaColumn.applyModel();
                                this.encodeColumnFooter(context, table, dynaColumn);
                            }
                            continue;
                        }
                        footerRowChild.encodeAll(context);
                    }
                    writer.endElement("tr");
                    continue;
                }
                child.encodeAll(context);
            }
            context.getAttributes().remove("org.primefaces.HELPER_RENDERER");
        } else if (table.hasFooterColumn()) {
            writer.startElement("tr", null);
            for (int i = columnStart; i < columnEnd; ++i) {
                UIColumn column = columns.get(i);
                if (column instanceof Column) {
                    this.encodeColumnFooter(context, table, column);
                    continue;
                }
                if (!(column instanceof DynamicColumn)) continue;
                DynamicColumn dynamicColumn = (DynamicColumn)column;
                dynamicColumn.applyModel();
                this.encodeColumnFooter(context, table, dynamicColumn);
            }
            writer.endElement("tr");
        }
        writer.endElement("tfoot");
    }

    protected void encodeFacet(FacesContext context, DataTable table, UIComponent facet, String styleClass) throws IOException {
        if (!FacetUtils.shouldRenderFacet(facet, table.isRenderEmptyFacets())) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        if (LangUtils.isNotBlank(styleClass)) {
            writer.writeAttribute("class", (Object)styleClass, null);
        }
        facet.encodeAll(context);
        writer.endElement("div");
    }

    protected void encodeStateHolder(FacesContext context, DataTable table, String id, String value) throws IOException {
        this.renderHiddenInput(context, id, value, false);
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void encodeRadio(FacesContext context, DataTable table, boolean checked, boolean disabled) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        if (table.isNativeElements()) {
            this.encodeNativeRadio(context, table, checked, disabled);
        } else {
            String iconClass = checked ? "ui-radiobutton-icon ui-icon ui-icon-bullet ui-c" : "ui-radiobutton-icon ui-icon ui-icon-blank ui-c";
            String boxClass = this.getStyleClassBuilder(context).add("ui-radiobutton-box ui-widget ui-corner-all ui-state-default").add(disabled, "ui-state-disabled").add(checked, "ui-state-active").build();
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)"ui-radiobutton ui-widget", null);
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)"ui-helper-hidden-accessible", null);
            this.encodeNativeRadio(context, table, checked, disabled);
            writer.endElement("div");
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)boxClass, null);
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)iconClass, null);
            writer.endElement("span");
            writer.endElement("div");
            writer.endElement("div");
        }
    }

    protected void encodeColumnSelection(FacesContext context, DataTable table, UIColumn column, boolean selected, boolean rowSelectionEnabled) throws IOException {
        String selectionMode = table.getSelectionMode();
        if ("single".equalsIgnoreCase(selectionMode)) {
            this.encodeRadio(context, table, selected, !rowSelectionEnabled);
        } else if ("multiple".equalsIgnoreCase(selectionMode)) {
            this.encodeCheckbox(context, table, selected, !rowSelectionEnabled, "ui-chkbox ui-widget", false);
        } else {
            throw new FacesException("Invalid column selection mode:" + selectionMode);
        }
    }

    protected void encodeCheckbox(FacesContext context, DataTable table, boolean checked, boolean disabled, String styleClass, boolean isHeaderCheckbox) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        if (table.isNativeElements()) {
            this.encodeNativeCheckbox(context, table, checked, disabled);
        } else {
            String ariaRowLabel = table.getAriaRowLabel();
            String boxClass = this.getStyleClassBuilder(context).add("ui-chkbox-box ui-widget ui-corner-all ui-state-default").add(disabled, "ui-state-disabled").add(checked, "ui-state-active").build();
            String iconClass = checked ? "ui-chkbox-icon ui-icon ui-icon-check ui-c" : "ui-chkbox-icon ui-icon ui-icon-blank ui-c";
            String rowKey = isHeaderCheckbox ? "head" : table.getRowKey();
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)styleClass, "styleClass");
            writer.startElement("div", null);
            writer.writeAttribute("id", (Object)(table.getClientId(context) + "_" + String.valueOf(rowKey) + "_checkbox"), null);
            writer.writeAttribute("role", (Object)"checkbox", null);
            writer.writeAttribute("tabindex", (Object)(disabled ? "-1" : "0"), null);
            writer.writeAttribute("aria-label", (Object)ariaRowLabel, null);
            writer.writeAttribute("aria-checked", (Object)String.valueOf(checked), null);
            if (disabled) {
                writer.writeAttribute("aria-disabled", (Object)"true", null);
            }
            writer.writeAttribute("class", (Object)boxClass, null);
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)iconClass, null);
            writer.endElement("span");
            writer.endElement("div");
            writer.endElement("div");
        }
    }

    protected void encodeNativeCheckbox(FacesContext context, DataTable table, boolean checked, boolean disabled) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String ariaRowLabel = table.getAriaRowLabel();
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"checkbox", null);
        writer.writeAttribute("name", (Object)(table.getClientId(context) + "_checkbox"), null);
        writer.writeAttribute("aria-label", (Object)ariaRowLabel, null);
        writer.writeAttribute("aria-checked", (Object)String.valueOf(checked), null);
        if (checked) {
            writer.writeAttribute("checked", (Object)"checked", null);
        }
        if (disabled) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        writer.endElement("input");
    }

    protected void encodeNativeRadio(FacesContext context, DataTable table, boolean checked, boolean disabled) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String ariaRowLabel = table.getAriaRowLabel();
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"radio", null);
        writer.writeAttribute("name", (Object)(table.getClientId(context) + "_radio"), null);
        writer.writeAttribute("aria-label", (Object)ariaRowLabel, null);
        if (checked) {
            writer.writeAttribute("checked", (Object)"checked", null);
        }
        if (disabled) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        writer.endElement("input");
    }

    protected void encodeSubTable(FacesContext context, DataTable table, SubTable subTable, int first, int last) throws IOException {
        for (int i = first; i < last; ++i) {
            table.setRowIndex(i);
            if (!table.isRowAvailable()) break;
            subTable.encodeAll(context);
        }
    }

    protected boolean isInSameGroup(FacesContext context, DataTable table, int currentRowIndex, int step, ValueExpression groupByVE, boolean loadFirstRowOfNextPage) {
        Object nextGroupByData;
        ELContext elContext = context.getELContext();
        Object currentGroupByData = groupByVE.getValue(elContext);
        int nextRowIndex = currentRowIndex + step;
        if (loadFirstRowOfNextPage && table.isLazy()) {
            Object nextRowData = table.getLazyDataModel().loadOne(nextRowIndex, table.getActiveSortMeta(), table.getActiveFilterMeta());
            if (nextRowData == null) {
                return false;
            }
            nextGroupByData = ComponentUtils.executeInRequestScope(context, table.getVar(), nextRowData, () -> groupByVE.getValue(elContext));
        } else {
            table.setRowIndex(nextRowIndex);
            if (!table.isRowAvailable()) {
                table.setRowIndex(currentRowIndex);
                return false;
            }
            nextGroupByData = groupByVE.getValue(elContext);
            table.setRowIndex(currentRowIndex);
        }
        return Objects.equals(nextGroupByData, currentGroupByData);
    }

    protected void encodeSortableHeaderOnReflow(FacesContext context, DataTable table) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Map<SortMeta, String> headers = this.getSortableColumnHeaders(context, table);
        if (!headers.isEmpty()) {
            String reflowId = table.getContainerClientId(context) + "_reflowDD";
            writer.startElement("label", null);
            writer.writeAttribute("id", (Object)(reflowId + "_label"), null);
            writer.writeAttribute("for", (Object)reflowId, null);
            writer.writeAttribute("class", (Object)"ui-reflow-label", null);
            writer.writeText((Object)MessageFactory.getMessage("primefaces.datatable.SORT_LABEL", new Object[0]), null);
            writer.endElement("label");
            writer.startElement("select", null);
            writer.writeAttribute("id", (Object)reflowId, null);
            writer.writeAttribute("name", (Object)reflowId, null);
            writer.writeAttribute("class", (Object)"ui-reflow-dropdown ui-state-default", null);
            writer.writeAttribute("autocomplete", (Object)"off", null);
            for (Map.Entry<SortMeta, String> header : headers.entrySet()) {
                for (int sortOrder = 0; sortOrder < 2; ++sortOrder) {
                    String sortOrderLabel = sortOrder == 0 ? MessageFactory.getMessage("primefaces.datatable.SORT_ASC", new Object[0]) : MessageFactory.getMessage("primefaces.datatable.SORT_DESC", new Object[0]);
                    writer.startElement("option", null);
                    writer.writeAttribute("value", (Object)(header.getKey().getColumnKey() + "_" + sortOrder), null);
                    writer.writeAttribute("data-columnkey", (Object)header.getKey().getColumnKey(), null);
                    writer.writeAttribute("data-sortorder", (Object)sortOrder, null);
                    writer.writeText((Object)(header.getValue() + " " + sortOrderLabel), null);
                    writer.endElement("option");
                }
            }
            writer.endElement("select");
        }
    }

    protected Map<SortMeta, String> getSortableColumnHeaders(FacesContext context, DataTable table) {
        AtomicReference<Object> headerLabel = new AtomicReference<Object>(null);
        Map<String, SortMeta> sortByAsMap = table.getSortByAsMap();
        LinkedHashMap<SortMeta, String> headers = new LinkedHashMap<SortMeta, String>(sortByAsMap.size());
        for (SortMeta sortMeta : sortByAsMap.values()) {
            if (sortMeta.isHeaderRow()) continue;
            headerLabel.set(null);
            table.invokeOnColumn(sortMeta.getColumnKey(), column -> {
                String label = this.resolveColumnAriaHeaderText(context, (UIColumn)column);
                headerLabel.set(label);
            });
            headers.put(sortMeta, headerLabel.get());
        }
        return headers;
    }

    protected boolean hasColumnDefaultRendering(DataTable table, UIColumn column) {
        return column.getChildren().isEmpty() && (table.getSortByAsMap().containsKey(column.getColumnKey()) || table.getFilterByAsMap().containsKey(column.getColumnKey()) || LangUtils.isNotBlank(column.getField()));
    }
}

