/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datepicker;

import jakarta.faces.application.FacesMessage;
import jakarta.faces.application.ResourceDependencies;
import jakarta.faces.application.ResourceDependency;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.AjaxBehaviorEvent;
import jakarta.faces.event.FacesEvent;
import jakarta.faces.event.PhaseId;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.YearMonth;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.primefaces.component.api.UICalendar;
import org.primefaces.component.datepicker.DatePickerBase;
import org.primefaces.event.DateViewChangeEvent;
import org.primefaces.event.SelectEvent;
import org.primefaces.model.datepicker.DateMetadata;
import org.primefaces.model.datepicker.DateMetadataModel;
import org.primefaces.util.CalendarUtils;
import org.primefaces.util.ComponentUtils;

@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="components.css"), @ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="jquery/jquery-plugins.js"), @ResourceDependency(library="primefaces", name="core.js"), @ResourceDependency(library="primefaces", name="components.js"), @ResourceDependency(library="primefaces", name="inputmask/inputmask.js"), @ResourceDependency(library="primefaces", name="datepicker/datepicker.js")})
public class DatePicker
extends DatePickerBase {
    public static final String COMPONENT_TYPE = "org.primefaces.component.DatePicker";
    public static final String CONTAINER_EXTENSION_CLASS = "p-datepicker";
    private Map<String, AjaxBehaviorEvent> customEvents = new HashMap<String, AjaxBehaviorEvent>(1);

    @Override
    public Collection<String> getEventNames() {
        return CALENDAR_EVENT_NAMES;
    }

    @Override
    public Collection<String> getUnobstrusiveEventNames() {
        return UNOBSTRUSIVE_EVENT_NAMES;
    }

    public void queueEvent(FacesEvent event) {
        FacesContext context = this.getFacesContext();
        if (ComponentUtils.isRequestSource((UIComponent)this, context) && event instanceof AjaxBehaviorEvent) {
            Map params = context.getExternalContext().getRequestParameterMap();
            String eventName = (String)params.get("jakarta.faces.behavior.event");
            String clientId = this.getClientId(context);
            AjaxBehaviorEvent behaviorEvent = (AjaxBehaviorEvent)event;
            if (eventName != null) {
                if ("dateSelect".equals(eventName) || "close".equals(eventName)) {
                    this.customEvents.put(eventName, (AjaxBehaviorEvent)event);
                } else if ("viewChange".equals(eventName)) {
                    int month = Integer.parseInt((String)params.get(clientId + "_month"));
                    int year = Integer.parseInt((String)params.get(clientId + "_year"));
                    DateViewChangeEvent dateViewChangeEvent = new DateViewChangeEvent((UIComponent)this, behaviorEvent.getBehavior(), month, year);
                    dateViewChangeEvent.setPhaseId(behaviorEvent.getPhaseId());
                    super.queueEvent((FacesEvent)dateViewChangeEvent);
                } else {
                    super.queueEvent(event);
                }
            }
        } else {
            super.queueEvent(event);
        }
    }

    public void validate(FacesContext context) {
        super.validate(context);
        if (this.isValid() && ComponentUtils.isRequestSource((UIComponent)this, context) && this.customEvents != null) {
            for (Map.Entry<String, AjaxBehaviorEvent> event : this.customEvents.entrySet()) {
                SelectEvent<Object> selectEvent = new SelectEvent<Object>((UIComponent)this, event.getValue().getBehavior(), this.getValue());
                if (event.getValue().getPhaseId().equals(PhaseId.APPLY_REQUEST_VALUES)) {
                    selectEvent.setPhaseId(PhaseId.PROCESS_VALIDATIONS);
                } else {
                    selectEvent.setPhaseId(PhaseId.INVOKE_APPLICATION);
                }
                super.queueEvent(selectEvent);
            }
        }
    }

    protected void validateValue(FacesContext context, Object value) {
        super.validateValue(context, value);
        if (this.isValid() && !DatePicker.isEmpty((Object)value)) {
            UICalendar.ValidationResult validationResult = this.validateValueInternal(context, value);
            if (!this.isValid()) {
                this.createFacesMessageFromValidationResult(context, validationResult);
            }
        }
    }

    protected UICalendar.ValidationResult validateValueInternal(FacesContext context, Object value) {
        if (this.isTimeOnly()) {
            LocalTime timeValue = CalendarUtils.getObjectAsLocalTime(context, this, value);
            return this.validateTimeOnlyValue(context, timeValue);
        }
        UICalendar.ValidationResult validationResult = UICalendar.ValidationResult.OK;
        if (value instanceof LocalDate) {
            validationResult = this.validateDateValue(context, (LocalDate)value);
        } else if (value instanceof LocalDateTime) {
            validationResult = this.isShowTime() ? this.validateDateValue(context, ((LocalDateTime)value).toLocalDate(), ((LocalDateTime)value).toLocalTime()) : this.validateDateValue(context, ((LocalDateTime)value).toLocalDate());
        } else if (value instanceof YearMonth) {
            validationResult = this.validateDateValue(context, ((YearMonth)value).atDay(1));
        } else if (value instanceof Date) {
            if (this.isShowTime()) {
                ZoneId zoneId = CalendarUtils.calculateZoneId(this.getTimeZone());
                validationResult = this.validateDateValue(context, CalendarUtils.convertDate2LocalDate((Date)value, zoneId), CalendarUtils.convertDate2LocalTime((Date)value, zoneId));
            } else {
                validationResult = this.validateDateValue(context, CalendarUtils.convertDate2LocalDate((Date)value, CalendarUtils.calculateZoneId(this.getTimeZone())));
            }
        } else if ((!(value instanceof List) || !this.getSelectionMode().equals("multiple")) && value instanceof List && this.getSelectionMode().equals("range")) {
            List rangeValues = (List)value;
            if (rangeValues.get(0) instanceof Comparable) {
                Comparable startDate = (Comparable)rangeValues.get(0);
                validationResult = this.validateValueInternal(context, startDate);
                if (this.isValid() && rangeValues.size() > 1) {
                    Comparable endDate = (Comparable)rangeValues.get(1);
                    validationResult = this.validateValueInternal(context, endDate);
                    if (this.isValid() && startDate.compareTo(endDate) > 0) {
                        this.setValid(false);
                        validationResult = UICalendar.ValidationResult.INVALID_RANGE_DATES_SEQUENTIAL;
                    }
                }
            } else {
                Object firstValue = rangeValues.get(0);
                this.setValid(false);
                if (firstValue == null) {
                    FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, "First date in range cannot be null", null);
                    context.addMessage(this.getClientId(context), message);
                } else {
                    FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, firstValue.getClass().getTypeName() + " not supported", null);
                    context.addMessage(this.getClientId(context), message);
                }
            }
        }
        return validationResult;
    }

    protected UICalendar.ValidationResult validateDateValue(FacesContext context, LocalDate date) {
        return this.validateDateValue(context, date, null);
    }

    protected UICalendar.ValidationResult validateDateValue(FacesContext context, LocalDate date, LocalTime timePart) {
        List<Integer> disabledDays;
        List enabledDates;
        List disabledDates;
        LocalDate minDate = CalendarUtils.getObjectAsLocalDate(context, this, this.getMindate());
        LocalDate maxDate = CalendarUtils.getObjectAsLocalDate(context, this, this.getMaxdate());
        LocalTime minTime = null;
        LocalTime maxTime = null;
        if (timePart != null) {
            minTime = CalendarUtils.getObjectAsLocalTime(context, this, this.getMindate());
            maxTime = CalendarUtils.getObjectAsLocalTime(context, this, this.getMaxdate());
        }
        if (minDate != null && (date.isBefore(minDate) || minTime != null && date.equals(minDate) && timePart.isBefore(minTime))) {
            this.setValid(false);
            if (maxDate != null) {
                return UICalendar.ValidationResult.INVALID_OUT_OF_RANGE;
            }
            return UICalendar.ValidationResult.INVALID_MIN_DATE;
        }
        if (this.isValid() && maxDate != null && (date.isAfter(maxDate) || maxTime != null && date.equals(maxDate) && timePart.isAfter(maxTime))) {
            this.setValid(false);
            if (minDate != null) {
                return UICalendar.ValidationResult.INVALID_OUT_OF_RANGE;
            }
            return UICalendar.ValidationResult.INVALID_MAX_DATE;
        }
        if (this.isValid() && (disabledDates = this.getDisabledDates()) != null) {
            for (Object disabledDate : disabledDates) {
                if (disabledDate instanceof LocalDate) {
                    if (!((LocalDate)disabledDate).isEqual(date)) continue;
                    this.setValid(false);
                    return UICalendar.ValidationResult.INVALID_DISABLED_DATE;
                }
                if (!(disabledDate instanceof Date)) continue;
                Calendar c = Calendar.getInstance(TimeZone.getTimeZone(CalendarUtils.calculateZoneId(this.getTimeZone())), this.calculateLocale(context));
                c.setTime((Date)disabledDate);
                if (date.getYear() != c.get(1) || date.getMonthValue() != c.get(2) + 1 || date.getDayOfMonth() != c.get(5)) continue;
                this.setValid(false);
                return UICalendar.ValidationResult.INVALID_DISABLED_DATE;
            }
        }
        if (this.isValid() && (enabledDates = this.getEnabledDates()) != null && !enabledDates.isEmpty()) {
            boolean localValid = false;
            for (Object enabledDate : enabledDates) {
                if (enabledDate instanceof LocalDate) {
                    if (!((LocalDate)enabledDate).isEqual(date)) continue;
                    localValid = true;
                    break;
                }
                if (!(enabledDate instanceof Date)) continue;
                Calendar c = Calendar.getInstance(TimeZone.getTimeZone(CalendarUtils.calculateZoneId(this.getTimeZone())), this.calculateLocale(context));
                c.setTime((Date)enabledDate);
                if (date.getYear() != c.get(1) || date.getMonthValue() != c.get(2) + 1 || date.getDayOfMonth() != c.get(5)) continue;
                localValid = true;
                break;
            }
            if (!localValid) {
                this.setValid(false);
                return UICalendar.ValidationResult.INVALID_DISABLED_DATE;
            }
        }
        if (this.isValid() && (disabledDays = this.getDisabledDays()) != null && disabledDays.contains(date.getDayOfWeek().getValue())) {
            this.setValid(false);
            return UICalendar.ValidationResult.INVALID_DISABLED_DATE;
        }
        return UICalendar.ValidationResult.OK;
    }

    protected UICalendar.ValidationResult validateTimeOnlyValue(FacesContext context, LocalTime time) {
        LocalTime minTime = CalendarUtils.getObjectAsLocalTime(context, this, this.getMindate());
        LocalTime maxTime = CalendarUtils.getObjectAsLocalTime(context, this, this.getMaxdate());
        if (minTime != null && !time.equals(minTime) && time.isBefore(minTime)) {
            this.setValid(false);
            if (maxTime != null) {
                return UICalendar.ValidationResult.INVALID_OUT_OF_RANGE;
            }
            return UICalendar.ValidationResult.INVALID_MIN_DATE;
        }
        if (this.isValid() && maxTime != null && !time.equals(maxTime) && time.isAfter(maxTime)) {
            this.setValid(false);
            if (minTime != null) {
                return UICalendar.ValidationResult.INVALID_OUT_OF_RANGE;
            }
            return UICalendar.ValidationResult.INVALID_MAX_DATE;
        }
        return UICalendar.ValidationResult.OK;
    }

    public Object saveState(FacesContext context) {
        if (this.customEvents != null) {
            this.customEvents.clear();
        }
        return super.saveState(context);
    }

    protected List<Object> getInitialDisabledDates(FacesContext context) {
        ArrayList<LocalDate> disabledDates = this.getDisabledDates();
        if (disabledDates != null) {
            return disabledDates;
        }
        DateMetadataModel model = this.getModel();
        if (model != null) {
            disabledDates = new ArrayList<LocalDate>();
            for (Map.Entry<LocalDate, DateMetadata> entry : model.getDateMetadata().entrySet()) {
                if (!entry.getValue().isDisabled()) continue;
                disabledDates.add(entry.getKey());
            }
        }
        return disabledDates;
    }

    protected List<Object> getInitialEnabledDates(FacesContext context) {
        ArrayList<LocalDate> enabledDates = this.getEnabledDates();
        DateMetadataModel model = this.getModel();
        if (model != null) {
            enabledDates = new ArrayList<LocalDate>();
            for (Map.Entry<LocalDate, DateMetadata> entry : model.getDateMetadata().entrySet()) {
                if (!entry.getValue().isEnabled()) continue;
                enabledDates.add(entry.getKey());
            }
        }
        return enabledDates;
    }
}

