/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.diagram;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.primefaces.component.diagram.Diagram;
import org.primefaces.model.diagram.Connection;
import org.primefaces.model.diagram.DiagramModel;
import org.primefaces.model.diagram.Element;
import org.primefaces.model.diagram.connector.Connector;
import org.primefaces.model.diagram.endpoint.EndPoint;
import org.primefaces.model.diagram.overlay.Overlay;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.FacetUtils;
import org.primefaces.util.SharedStringBuilder;
import org.primefaces.util.WidgetBuilder;

public class DiagramRenderer
extends CoreRenderer {
    private static final String SB_DIAGRAM = CoreRenderer.class.getName() + "#diagram";

    public void decode(FacesContext context, UIComponent component) {
        Diagram diagram = (Diagram)component;
        if (diagram.isConnectRequest(context)) {
            this.decodeNewConnection(context, diagram);
        } else if (diagram.isDisconnectRequest(context)) {
            this.decodeDisconnection(context, diagram);
        } else if (diagram.isConnectionChangeRequest(context)) {
            this.decodeConnectionChange(context, diagram);
        } else if (diagram.isPositionChangeRequest(context)) {
            this.decodePositionChange(context, diagram);
        }
        this.decodeBehaviors(context, component);
    }

    private void decodeNewConnection(FacesContext context, Diagram diagram) {
        Connection connection;
        if (context.getExternalContext().getRequestParameterMap().containsKey(diagram.getClientId(context) + "_connectionChanged")) {
            return;
        }
        DiagramModel model = (DiagramModel)diagram.getValue();
        if (model != null && (connection = this.decodeConnection(context, diagram, true)) != null) {
            model.connect(connection);
        }
    }

    private void decodeDisconnection(FacesContext context, Diagram diagram) {
        Connection connection;
        DiagramModel model = (DiagramModel)diagram.getValue();
        if (model != null && (connection = this.decodeConnection(context, diagram, false)) != null) {
            model.disconnect(connection);
        }
    }

    private void decodeConnectionChange(FacesContext context, Diagram diagram) {
        DiagramModel model = (DiagramModel)diagram.getValue();
        if (model != null) {
            Map params = context.getExternalContext().getRequestParameterMap();
            String clientId = diagram.getClientId(context);
            Element originalSourceElement = model.findElement((String)params.get(clientId + "_originalSourceId"));
            Element newSourceElement = model.findElement((String)params.get(clientId + "_newSourceId"));
            Element originalTargetElement = model.findElement((String)params.get(clientId + "_originalTargetId"));
            Element newTargetElement = model.findElement((String)params.get(clientId + "_newTargetId"));
            EndPoint originalSourceEndPoint = model.findEndPoint(originalSourceElement, (String)params.get(clientId + "_originalSourceEndPointId"));
            EndPoint newSourceEndPoint = model.findEndPoint(newSourceElement, (String)params.get(clientId + "_newSourceEndPointId"));
            EndPoint originalTargetEndPoint = model.findEndPoint(originalTargetElement, (String)params.get(clientId + "_originalTargetEndPointId"));
            EndPoint newTargetEndPoint = model.findEndPoint(newTargetElement, (String)params.get(clientId + "_newTargetEndPointId"));
            model.disconnect(this.findConnection(model, originalSourceEndPoint, originalTargetEndPoint));
            model.connect(new Connection(newSourceEndPoint, newTargetEndPoint));
        }
    }

    private void decodePositionChange(FacesContext context, Diagram diagram) {
        DiagramModel model = (DiagramModel)diagram.getValue();
        if (model != null) {
            Map params = context.getExternalContext().getRequestParameterMap();
            String clientId = diagram.getClientId(context);
            Element element = model.findElement((String)params.get(clientId + "_elementId"));
            String[] position = ((String)params.get(clientId + "_position")).split(",");
            if (element != null) {
                element.setX(position[0] + "px");
                element.setY(position[1] + "px");
            }
        }
    }

    private Connection decodeConnection(FacesContext context, Diagram diagram, boolean createNew) {
        DiagramModel model = (DiagramModel)diagram.getValue();
        Connection connection = null;
        if (model != null) {
            Map params = context.getExternalContext().getRequestParameterMap();
            String clientId = diagram.getClientId(context);
            Element sourceElement = model.findElement((String)params.get(clientId + "_sourceId"));
            Element targetElement = model.findElement((String)params.get(clientId + "_targetId"));
            EndPoint sourceEndPoint = model.findEndPoint(sourceElement, (String)params.get(clientId + "_sourceEndPointId"));
            EndPoint targetEndPoint = model.findEndPoint(targetElement, (String)params.get(clientId + "_targetEndPointId"));
            connection = createNew ? new Connection(sourceEndPoint, targetEndPoint) : this.findConnection(model, sourceEndPoint, targetEndPoint);
        }
        return connection;
    }

    private Connection findConnection(DiagramModel model, EndPoint source, EndPoint target) {
        List<Connection> connections;
        Connection connection = null;
        if (model != null && (connections = model.getConnections()) != null) {
            int connectionsSize = connections.size();
            for (int i = 0; i < connectionsSize; ++i) {
                Connection conn = connections.get(i);
                if (!conn.getSource().equals(source) || !conn.getTarget().equals(target)) continue;
                connection = conn;
                break;
            }
        }
        return connection;
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Diagram diagram = (Diagram)component;
        this.encodeMarkup(context, diagram);
        this.encodeScript(context, diagram);
    }

    protected void encodeScript(FacesContext context, Diagram diagram) throws IOException {
        String clientId = diagram.getClientId(context);
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("Diagram", diagram);
        DiagramModel model = (DiagramModel)diagram.getValue();
        if (model != null) {
            this.encodeDefaults(wb, model);
            this.encodeEndPoints(wb, model, clientId);
            this.encodeConnections(wb, model);
        }
        this.encodeClientBehaviors(context, diagram);
        wb.finish();
    }

    protected void encodeDefaults(WidgetBuilder wb, DiagramModel model) throws IOException {
        int maxConnections;
        StringBuilder sb = SharedStringBuilder.get(SB_DIAGRAM);
        Connector defaultConnector = model.getDefaultConnector();
        if (defaultConnector != null) {
            String paintStyle = defaultConnector.getPaintStyle();
            String hoverPaintStyle = defaultConnector.getHoverPaintStyle();
            wb.append(",defaultConnector:").append(defaultConnector.toJS(sb));
            wb.append(",containment:").append("" + model.isContainment());
            if (paintStyle != null) {
                wb.append(",paintStyle:").append(paintStyle);
            }
            if (hoverPaintStyle != null) {
                wb.append(",hoverPaintStyle:").append(hoverPaintStyle);
            }
            sb.setLength(0);
        }
        this.encodeOverlays(wb, model.getDefaultConnectionOverlays(), "connectionOverlays");
        if (!model.isConnectionsDetachable()) {
            wb.append(",connectionsDetachable:false");
        }
        if ((maxConnections = model.getMaxConnections()) != 0) {
            wb.append(",maxConnections:").append(maxConnections);
        }
    }

    protected void encodeEndPoints(WidgetBuilder wb, DiagramModel model, String clientId) throws IOException {
        List<Element> elements = model.getElements();
        if (elements != null && !elements.isEmpty()) {
            int elementsSize = elements.size();
            wb.append(",endPoints:[");
            for (int i = 0; i < elementsSize; ++i) {
                Element element = elements.get(i);
                String elementClientId = clientId + "-" + element.getId();
                List<EndPoint> endPoints = element.getEndPoints();
                if (endPoints != null && !endPoints.isEmpty()) {
                    int endPointsSize = endPoints.size();
                    for (int j = 0; j < endPointsSize; ++j) {
                        EndPoint endPoint = endPoints.get(j);
                        this.encodeEndPoint(wb, endPoint, elementClientId);
                        if (j >= endPointsSize - 1) continue;
                        wb.append(",");
                    }
                }
                if (i >= elementsSize - 1) continue;
                wb.append(",");
            }
            wb.append("]");
        }
    }

    protected void encodeEndPoint(WidgetBuilder wb, EndPoint endPoint, String elementClientId) throws IOException {
        String type = endPoint.getType();
        StringBuilder sb = SharedStringBuilder.get(SB_DIAGRAM);
        String styleClass = endPoint.getStyleClass();
        String hoverStyleClass = endPoint.getHoverStyleClass();
        String style = endPoint.getStyle();
        String hoverStyle = endPoint.getHoverStyle();
        int maxConnections = endPoint.getMaxConnections();
        String scope = endPoint.getScope();
        wb.append("{uuid:'").append(endPoint.getId()).append("'").append(",element:'").append(elementClientId).append("'").append(",anchor:'").append(endPoint.getAnchor().toString()).append("'");
        if (maxConnections != 1) {
            wb.append(",maxConnections:").append(maxConnections);
        }
        if (style != null) {
            wb.append(",paintStyle:").append(style);
        }
        if (hoverStyle != null) {
            wb.append(",hoverPaintStyle:").append(hoverStyle);
        }
        if (endPoint.isSource()) {
            wb.append(",isSource:true");
        }
        if (endPoint.isTarget()) {
            wb.append(",isTarget:true");
        }
        if (styleClass != null) {
            wb.append(",cssClass:'").append(styleClass).append("'");
        }
        if (hoverStyleClass != null) {
            wb.append(",hoverClass:'").append(hoverStyleClass).append("'");
        }
        if (scope != null) {
            wb.append(",scope:'").append(scope).append("'");
        }
        if (type != null) {
            wb.append(",endpoint:").append(endPoint.toJS(sb));
        }
        this.encodeOverlays(wb, endPoint.getOverlays(), "overlays");
        wb.append("}");
    }

    protected void encodeConnections(WidgetBuilder wb, DiagramModel model) throws IOException {
        List<Connection> connections = model.getConnections();
        if (connections != null && !connections.isEmpty()) {
            int connectionsSize = connections.size();
            wb.append(",connections:[");
            for (int i = 0; i < connectionsSize; ++i) {
                Connection connection = connections.get(i);
                StringBuilder sb = SharedStringBuilder.get(SB_DIAGRAM);
                Connector connector = connection.getConnector();
                List<Overlay> overlays = connection.getOverlays();
                wb.append("{uuids:['").append(connection.getSource().getId()).append("'").append(",'").append(connection.getTarget().getId()).append("']");
                if (connector != null && connector.getType() != null) {
                    wb.append(",connector:").append(connector.toJS(sb));
                    String paintStyle = connector.getPaintStyle();
                    String hoverPaintStyle = connector.getHoverPaintStyle();
                    if (paintStyle != null) {
                        wb.append(",paintStyle:").append(paintStyle);
                    }
                    if (hoverPaintStyle != null) {
                        wb.append(",hoverPaintStyle:").append(hoverPaintStyle);
                    }
                }
                if (!connection.isDetachable()) {
                    wb.append(",detachable:false");
                }
                this.encodeOverlays(wb, overlays, "overlays");
                wb.append("}");
                if (i >= connectionsSize - 1) continue;
                wb.append(",");
            }
            wb.append("]");
        }
    }

    protected void encodeOverlays(WidgetBuilder wb, List<Overlay> overlays, String propertyName) throws IOException {
        StringBuilder sb = SharedStringBuilder.get(SB_DIAGRAM);
        if (overlays != null && !overlays.isEmpty()) {
            int overlaysSize = overlays.size();
            wb.append(",").append(propertyName).append(":[");
            for (int j = 0; j < overlaysSize; ++j) {
                Overlay overlay = overlays.get(j);
                sb.setLength(0);
                wb.append(overlay.toJS(sb));
                if (j >= overlaysSize - 1) continue;
                wb.append(",");
            }
            wb.append("]");
        }
    }

    protected void encodeMarkup(FacesContext context, Diagram diagram) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        DiagramModel model = (DiagramModel)diagram.getValue();
        String clientId = diagram.getClientId(context);
        String style = diagram.getStyle();
        Object styleClass = diagram.getStyleClass();
        styleClass = styleClass == null ? "ui-diagram ui-widget" : "ui-diagram ui-widget " + (String)styleClass;
        UIComponent elementFacet = diagram.getFacet("element");
        Map requestMap = context.getExternalContext().getRequestMap();
        String var = diagram.getVar();
        writer.startElement("div", (UIComponent)diagram);
        writer.writeAttribute("id", (Object)diagram.getClientId(context), null);
        writer.writeAttribute("class", styleClass, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        if (model != null) {
            List<Element> elements = model.getElements();
            if (elements != null && !elements.isEmpty()) {
                for (int i = 0; i < elements.size(); ++i) {
                    Element element = elements.get(i);
                    Object elementClass = element.getStyleClass();
                    Object object = elementClass = elementClass == null ? "ui-diagram-element" : "ui-diagram-element " + (String)elementClass;
                    if (element.isDraggable()) {
                        elementClass = (String)elementClass + " ui-diagram-draggable";
                    }
                    Object data = element.getData();
                    String x = element.getX();
                    String y = element.getY();
                    String coords = "left:" + x + ";top:" + y;
                    String title = element.getTitle();
                    writer.startElement("div", null);
                    writer.writeAttribute("id", (Object)(clientId + "-" + element.getId()), null);
                    writer.writeAttribute("class", elementClass, null);
                    writer.writeAttribute("style", (Object)coords, null);
                    writer.writeAttribute("data-tooltip", (Object)title, null);
                    if (var != null) {
                        requestMap.put(var, data);
                    }
                    if (FacetUtils.shouldRenderFacet(elementFacet)) {
                        elementFacet.encodeAll(context);
                    } else if (data != null) {
                        writer.writeText(data, null);
                    }
                    writer.endElement("div");
                }
            }
            if (var != null) {
                requestMap.remove(var);
            }
        }
        writer.endElement("div");
    }
}

