/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.dialog;

import jakarta.el.ELContext;
import jakarta.el.ValueExpression;
import jakarta.faces.application.ResourceDependencies;
import jakarta.faces.application.ResourceDependency;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.AjaxBehaviorEvent;
import jakarta.faces.event.BehaviorEvent;
import jakarta.faces.event.FacesEvent;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import org.primefaces.component.dialog.DialogBase;
import org.primefaces.el.ValueExpressionAnalyzer;
import org.primefaces.event.CloseEvent;
import org.primefaces.event.MoveEvent;
import org.primefaces.event.ResizeEvent;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.MapBuilder;

@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="components.css"), @ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="jquery/jquery-plugins.js"), @ResourceDependency(library="primefaces", name="core.js"), @ResourceDependency(library="primefaces", name="components.js")})
public class Dialog
extends DialogBase {
    public static final String COMPONENT_TYPE = "org.primefaces.component.Dialog";
    public static final String CONTAINER_CLASS = "ui-dialog ui-widget ui-widget-content ui-corner-all ui-shadow ui-hidden-container";
    public static final String TITLE_BAR_CLASS = "ui-dialog-titlebar ui-widget-header ui-helper-clearfix ui-corner-top";
    public static final String TITLE_CLASS = "ui-dialog-title";
    public static final String TITLE_BAR_CLOSE_CLASS = "ui-dialog-titlebar-icon ui-dialog-titlebar-close ui-corner-all";
    public static final String CLOSE_ICON_CLASS = "ui-icon ui-icon-closethick";
    public static final String TITLE_BAR_MINIMIZE_CLASS = "ui-dialog-titlebar-icon ui-dialog-titlebar-minimize ui-corner-all";
    public static final String MINIMIZE_ICON_CLASS = "ui-icon ui-icon-minus";
    public static final String TITLE_BAR_MAXIMIZE_CLASS = "ui-dialog-titlebar-icon ui-dialog-titlebar-maximize ui-corner-all";
    public static final String MAXIMIZE_ICON_CLASS = "ui-icon ui-icon-extlink";
    public static final String CONTENT_CLASS = "ui-dialog-content ui-widget-content";
    public static final String FOOTER_CLASS = "ui-dialog-footer ui-widget-content";
    private static final String DEFAULT_EVENT = "close";
    private static final Map<String, Class<? extends BehaviorEvent>> BEHAVIOR_EVENT_MAPPING = MapBuilder.builder().put("close", CloseEvent.class).put("minimize", null).put("maximize", null).put("move", MoveEvent.class).put("restoreMinimize", null).put("restoreMaximize", null).put("open", null).put("loadContent", null).put("resizeStart", ResizeEvent.class).put("resizeStop", ResizeEvent.class).build();
    private static final Collection<String> EVENT_NAMES = BEHAVIOR_EVENT_MAPPING.keySet();

    @Override
    public Map<String, Class<? extends BehaviorEvent>> getBehaviorEventMapping() {
        return BEHAVIOR_EVENT_MAPPING;
    }

    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    public String getDefaultEventName() {
        return DEFAULT_EVENT;
    }

    public void queueEvent(FacesEvent event) {
        FacesContext context = this.getFacesContext();
        if (ComponentUtils.isRequestSource((UIComponent)this, context) && event instanceof AjaxBehaviorEvent) {
            Map params = context.getExternalContext().getRequestParameterMap();
            String eventName = (String)params.get("jakarta.faces.behavior.event");
            AjaxBehaviorEvent ajaxBehaviorEvent = (AjaxBehaviorEvent)event;
            String clientId = this.getClientId(context);
            if (DEFAULT_EVENT.equals(eventName)) {
                this.setVisible(false);
                CloseEvent closeEvent = new CloseEvent((UIComponent)this, ((AjaxBehaviorEvent)event).getBehavior());
                closeEvent.setPhaseId(ajaxBehaviorEvent.getPhaseId());
                super.queueEvent((FacesEvent)closeEvent);
            } else if ("move".equals(eventName)) {
                int top = Double.valueOf((String)params.get(clientId + "_top")).intValue();
                int left = Double.valueOf((String)params.get(clientId + "_left")).intValue();
                MoveEvent moveEvent = new MoveEvent((UIComponent)this, ((AjaxBehaviorEvent)event).getBehavior(), top, left);
                moveEvent.setPhaseId(ajaxBehaviorEvent.getPhaseId());
                super.queueEvent((FacesEvent)moveEvent);
            } else if ("resizeStart".equals(eventName) || "resizeStop".equals(eventName)) {
                int width = Double.valueOf((String)params.get(clientId + "_width")).intValue();
                int height = Double.valueOf((String)params.get(clientId + "_height")).intValue();
                ResizeEvent resizeEvent = new ResizeEvent((UIComponent)this, ((AjaxBehaviorEvent)event).getBehavior(), width, height);
                resizeEvent.setPhaseId(ajaxBehaviorEvent.getPhaseId());
                super.queueEvent((FacesEvent)resizeEvent);
            } else {
                super.queueEvent(event);
            }
        } else {
            super.queueEvent(event);
        }
    }

    public void processDecodes(FacesContext context) {
        if (ComponentUtils.isRequestSource((UIComponent)this, context)) {
            this.decode(context);
        } else {
            super.processDecodes(context);
        }
    }

    public void processValidators(FacesContext context) {
        if (!ComponentUtils.isRequestSource((UIComponent)this, context)) {
            super.processValidators(context);
        }
    }

    public void processUpdates(FacesContext context) {
        if (!ComponentUtils.isRequestSource((UIComponent)this, context)) {
            super.processUpdates(context);
        } else {
            ELContext elContext = context.getELContext();
            ValueExpression expr = ValueExpressionAnalyzer.getExpression(elContext, this.getValueExpression(DialogBase.PropertyKeys.visible.toString()), true);
            if (expr != null && !expr.isReadOnly(elContext)) {
                expr.setValue(elContext, (Object)this.isVisible());
                this.getStateHelper().remove((Serializable)((Object)DialogBase.PropertyKeys.visible));
            }
        }
    }

    public boolean isContentLoadRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_contentLoad");
    }
}

