/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.export;

import jakarta.el.ELContext;
import jakarta.el.MethodExpression;
import jakarta.el.ValueExpression;
import jakarta.faces.FacesException;
import jakarta.faces.component.StateHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.ActionEvent;
import jakarta.faces.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.primefaces.PrimeFaces;
import org.primefaces.component.export.DataExporters;
import org.primefaces.component.export.ExportConfiguration;
import org.primefaces.component.export.Exporter;
import org.primefaces.component.export.ExporterOptions;
import org.primefaces.expression.SearchExpressionUtils;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.LangUtils;
import org.primefaces.util.ResourceUtils;

public class DataExporter
implements ActionListener,
StateHolder {
    private ValueExpression target;
    private ValueExpression type;
    private ValueExpression fileName;
    private ValueExpression encoding;
    private ValueExpression pageOnly;
    private ValueExpression selectionOnly;
    private ValueExpression visibleOnly;
    private ValueExpression exportHeader;
    private ValueExpression exportFooter;
    private MethodExpression preProcessor;
    private MethodExpression postProcessor;
    private ValueExpression options;
    private MethodExpression onTableRender;
    private MethodExpression onRowExport;
    private ValueExpression exporter;
    private ValueExpression bufferSize;

    public DataExporter() {
        ResourceUtils.addComponentResource(FacesContext.getCurrentInstance(), "filedownload/filedownload.js");
    }

    public void processAction(ActionEvent event) {
        FacesContext context = FacesContext.getCurrentInstance();
        ELContext elContext = context.getELContext();
        String tables = (String)this.target.getValue(elContext);
        String exportAs = (String)this.type.getValue(elContext);
        String outputFileName = (String)this.fileName.getValue(elContext);
        String encodingType = StandardCharsets.UTF_8.name();
        if (this.encoding != null) {
            encodingType = (String)this.encoding.getValue(elContext);
        }
        boolean isPageOnly = false;
        if (this.pageOnly != null) {
            isPageOnly = this.pageOnly.isLiteralText() ? Boolean.parseBoolean(this.pageOnly.getValue(context.getELContext()).toString()) : (Boolean)this.pageOnly.getValue(context.getELContext());
        }
        boolean isSelectionOnly = false;
        if (this.selectionOnly != null) {
            isSelectionOnly = this.selectionOnly.isLiteralText() ? Boolean.parseBoolean(this.selectionOnly.getValue(context.getELContext()).toString()) : (Boolean)this.selectionOnly.getValue(context.getELContext());
        }
        boolean isVisibleOnly = false;
        if (this.visibleOnly != null) {
            isVisibleOnly = this.visibleOnly.isLiteralText() ? Boolean.parseBoolean(this.visibleOnly.getValue(context.getELContext()).toString()) : (Boolean)this.visibleOnly.getValue(context.getELContext());
        }
        boolean isExportHeader = true;
        if (this.exportHeader != null) {
            isExportHeader = this.exportHeader.isLiteralText() ? Boolean.parseBoolean(this.exportHeader.getValue(context.getELContext()).toString()) : (Boolean)this.exportHeader.getValue(context.getELContext());
        }
        boolean isExportFooter = true;
        if (this.exportFooter != null) {
            isExportFooter = this.exportFooter.isLiteralText() ? Boolean.parseBoolean(this.exportFooter.getValue(context.getELContext()).toString()) : (Boolean)this.exportFooter.getValue(context.getELContext());
        }
        ExporterOptions exporterOptions = null;
        if (this.options != null) {
            exporterOptions = (ExporterOptions)this.options.getValue(elContext);
        }
        Object customExporterInstance = null;
        if (this.exporter != null) {
            customExporterInstance = this.exporter.getValue(elContext);
        }
        Integer bufferSizeTmp = null;
        if (this.bufferSize != null) {
            bufferSizeTmp = (Integer)this.bufferSize.getValue(elContext);
        }
        try {
            OutputStream outputStream;
            List<UIComponent> components = SearchExpressionUtils.contextlessResolveComponents(context, event.getComponent(), tables);
            Class<? extends UIComponent> targetClass = this.guessTargetClass(components);
            Exporter exporterInstance = this.getExporter(exportAs, customExporterInstance, targetClass);
            ExternalContext externalContext = context.getExternalContext();
            String filenameWithExtension = outputFileName + exporterInstance.getFileExtension();
            Object contentType = exporterInstance.getContentType();
            if (((String)contentType).startsWith("text/") && LangUtils.isNotBlank(encodingType)) {
                contentType = (String)contentType + "; charset=" + encodingType;
            }
            if (PrimeFaces.current().isAjaxRequest()) {
                outputStream = new ByteArrayOutputStream();
            } else {
                outputStream = context.getExternalContext().getResponseOutputStream();
                externalContext.setResponseContentType((String)contentType);
                this.setResponseHeader(externalContext, ComponentUtils.createContentDisposition("attachment", filenameWithExtension));
                this.addResponseCookie(context);
            }
            ExportConfiguration config = ExportConfiguration.builder().encodingType(encodingType).pageOnly(isPageOnly).selectionOnly(isSelectionOnly).visibleOnly(isVisibleOnly).exportHeader(isExportHeader).exportFooter(isExportFooter).options(exporterOptions).preProcessor(this.preProcessor).postProcessor(this.postProcessor).onTableRender(this.onTableRender).onRowExport(this.onRowExport).outputStream(outputStream).bufferSize(bufferSizeTmp).build();
            exporterInstance.export(context, components, config);
            if (PrimeFaces.current().isAjaxRequest()) {
                this.ajaxDownload(filenameWithExtension, ((ByteArrayOutputStream)outputStream).toByteArray(), (String)contentType, context);
            } else {
                context.responseComplete();
            }
        }
        catch (IOException e) {
            throw new FacesException((Throwable)e);
        }
    }

    protected Class<? extends UIComponent> guessTargetClass(List<UIComponent> targets) {
        Objects.requireNonNull(targets, DataExporter.class.getSimpleName() + " expects at least one target");
        Set classes = targets.stream().map(Object::getClass).collect(Collectors.toSet());
        if (classes.size() > 1) {
            throw new IllegalArgumentException(DataExporter.class.getSimpleName() + "#target should all be the same type");
        }
        return (Class)classes.iterator().next();
    }

    @Deprecated
    protected Exporter getExporter(String exportAs, Object customExporterInstance, Class<? extends UIComponent> targetClass) {
        if (customExporterInstance != null) {
            Logger.getLogger(DataExporter.class.getName()).warning("DataExporter#exporter will be removed in future release. Use DataExporters#register() method instead");
            if (customExporterInstance instanceof Exporter) {
                return (Exporter)customExporterInstance;
            }
            throw new FacesException("Component " + this.getClass().getName() + " customExporterInstance=" + customExporterInstance.getClass().getName() + " does not implement Exporter!");
        }
        return DataExporters.get(targetClass, exportAs);
    }

    private void ajaxDownload(String filenameWithExtension, byte[] content, String contentType, FacesContext context) {
        String base64 = Base64.getEncoder().withoutPadding().encodeToString(content);
        String data = "data:" + contentType + ";base64," + base64;
        String monitorKeyCookieName = ResourceUtils.getMonitorKeyCookieName(context, null);
        PrimeFaces.current().executeScript(String.format("PrimeFaces.download('%s', '%s', '%s', '%s')", data, contentType, filenameWithExtension, monitorKeyCookieName));
    }

    protected void setResponseHeader(ExternalContext externalContext, String contentDisposition) {
        ResourceUtils.addNoCacheControl(externalContext);
        externalContext.setResponseHeader("Content-disposition", contentDisposition);
    }

    protected void addResponseCookie(FacesContext context) {
        String monitorKeyCookieName = ResourceUtils.getMonitorKeyCookieName(context, null);
        ResourceUtils.addResponseCookie(context, monitorKeyCookieName, "true", null);
    }

    public boolean isTransient() {
        return false;
    }

    public void setTransient(boolean value) {
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.target = (ValueExpression)values[0];
        this.type = (ValueExpression)values[1];
        this.fileName = (ValueExpression)values[2];
        this.pageOnly = (ValueExpression)values[3];
        this.selectionOnly = (ValueExpression)values[4];
        this.visibleOnly = (ValueExpression)values[5];
        this.exportHeader = (ValueExpression)values[6];
        this.exportFooter = (ValueExpression)values[7];
        this.preProcessor = (MethodExpression)values[8];
        this.postProcessor = (MethodExpression)values[9];
        this.encoding = (ValueExpression)values[10];
        this.options = (ValueExpression)values[11];
        this.onTableRender = (MethodExpression)values[12];
        this.exporter = (ValueExpression)values[13];
        this.onRowExport = (MethodExpression)values[14];
        this.bufferSize = (ValueExpression)values[15];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{this.target, this.type, this.fileName, this.pageOnly, this.selectionOnly, this.visibleOnly, this.exportHeader, this.exportFooter, this.preProcessor, this.postProcessor, this.encoding, this.options, this.onTableRender, this.exporter, this.onRowExport, this.bufferSize};
        return values;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final DataExporter exporter = new DataExporter();

        Builder() {
        }

        public Builder target(ValueExpression target) {
            this.exporter.target = target;
            return this;
        }

        public Builder type(ValueExpression type) {
            this.exporter.type = type;
            return this;
        }

        public Builder fileName(ValueExpression fileName) {
            this.exporter.fileName = fileName;
            return this;
        }

        public Builder encoding(ValueExpression encoding) {
            this.exporter.encoding = encoding;
            return this;
        }

        public Builder pageOnly(ValueExpression pageOnly) {
            this.exporter.pageOnly = pageOnly;
            return this;
        }

        public Builder selectionOnly(ValueExpression selectionOnly) {
            this.exporter.selectionOnly = selectionOnly;
            return this;
        }

        public Builder visibleOnly(ValueExpression visibleOnly) {
            this.exporter.visibleOnly = visibleOnly;
            return this;
        }

        public Builder exportHeader(ValueExpression exportHeader) {
            this.exporter.exportHeader = exportHeader;
            return this;
        }

        public Builder exportFooter(ValueExpression exportFooter) {
            this.exporter.exportFooter = exportFooter;
            return this;
        }

        public Builder preProcessor(MethodExpression preProcessor) {
            this.exporter.preProcessor = preProcessor;
            return this;
        }

        public Builder postProcessor(MethodExpression postProcessor) {
            this.exporter.postProcessor = postProcessor;
            return this;
        }

        public Builder options(ValueExpression options) {
            this.exporter.options = options;
            return this;
        }

        public Builder onTableRender(MethodExpression onTableRender) {
            this.exporter.onTableRender = onTableRender;
            return this;
        }

        @Deprecated
        public Builder exporter(ValueExpression exporter) {
            this.exporter.exporter = exporter;
            return this;
        }

        public Builder onRowExport(MethodExpression onRowExport) {
            this.exporter.onRowExport = onRowExport;
            return this;
        }

        public Builder bufferSize(ValueExpression bufferSize) {
            this.exporter.bufferSize = bufferSize;
            return this;
        }

        public DataExporter build() {
            return this.exporter;
        }
    }
}

