/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.export;

import jakarta.el.ELException;
import jakarta.el.MethodExpression;
import jakarta.el.ValueExpression;
import jakarta.faces.component.ActionSource;
import jakarta.faces.component.UIComponent;
import jakarta.faces.event.ActionListener;
import jakarta.faces.view.facelets.ComponentHandler;
import jakarta.faces.view.facelets.FaceletContext;
import jakarta.faces.view.facelets.TagAttribute;
import jakarta.faces.view.facelets.TagConfig;
import jakarta.faces.view.facelets.TagHandler;
import org.primefaces.component.export.DataExporter;

public class DataExporterTagHandler
extends TagHandler {
    private final TagAttribute target = this.getRequiredAttribute("target");
    private final TagAttribute type = this.getRequiredAttribute("type");
    private final TagAttribute fileName = this.getRequiredAttribute("fileName");
    private final TagAttribute pageOnly = this.getAttribute("pageOnly");
    private final TagAttribute selectionOnly = this.getAttribute("selectionOnly");
    private final TagAttribute visibleOnly = this.getAttribute("visibleOnly");
    private final TagAttribute exportHeader = this.getAttribute("exportHeader");
    private final TagAttribute exportFooter = this.getAttribute("exportFooter");
    private final TagAttribute preProcessor;
    private final TagAttribute postProcessor;
    private final TagAttribute encoding = this.getAttribute("encoding");
    private final TagAttribute options;
    private final TagAttribute onTableRender;
    private final TagAttribute exporter;
    private final TagAttribute onRowExport;
    private final TagAttribute bufferSize;

    public DataExporterTagHandler(TagConfig tagConfig) {
        super(tagConfig);
        this.preProcessor = this.getAttribute("preProcessor");
        this.postProcessor = this.getAttribute("postProcessor");
        this.options = this.getAttribute("options");
        this.onTableRender = this.getAttribute("onTableRender");
        this.exporter = this.getAttribute("exporter");
        this.onRowExport = this.getAttribute("onRowExport");
        this.bufferSize = this.getAttribute("bufferSize");
    }

    public void apply(FaceletContext faceletContext, UIComponent parent) throws ELException {
        if (!ComponentHandler.isNew((UIComponent)parent)) {
            return;
        }
        ValueExpression targetVE = this.target.getValueExpression(faceletContext, Object.class);
        ValueExpression typeVE = this.type.getValueExpression(faceletContext, Object.class);
        ValueExpression fileNameVE = this.fileName.getValueExpression(faceletContext, Object.class);
        ValueExpression pageOnlyVE = null;
        ValueExpression selectionOnlyVE = null;
        ValueExpression visibleOnlyVE = null;
        ValueExpression exportHeaderVE = null;
        ValueExpression exportFooterVE = null;
        ValueExpression encodingVE = null;
        MethodExpression preProcessorME = null;
        MethodExpression postProcessorME = null;
        ValueExpression optionsVE = null;
        MethodExpression onTableRenderME = null;
        ValueExpression exporterVE = null;
        MethodExpression onRowExportME = null;
        ValueExpression bufferSizeVE = null;
        if (this.encoding != null) {
            encodingVE = this.encoding.getValueExpression(faceletContext, Object.class);
        }
        if (this.pageOnly != null) {
            pageOnlyVE = this.pageOnly.getValueExpression(faceletContext, Object.class);
        }
        if (this.selectionOnly != null) {
            selectionOnlyVE = this.selectionOnly.getValueExpression(faceletContext, Object.class);
        }
        if (this.visibleOnly != null) {
            visibleOnlyVE = this.visibleOnly.getValueExpression(faceletContext, Object.class);
        }
        if (this.exportHeader != null) {
            exportHeaderVE = this.exportHeader.getValueExpression(faceletContext, Object.class);
        }
        if (this.exportFooter != null) {
            exportFooterVE = this.exportFooter.getValueExpression(faceletContext, Object.class);
        }
        if (this.preProcessor != null) {
            preProcessorME = this.preProcessor.getMethodExpression(faceletContext, null, new Class[]{Object.class});
        }
        if (this.postProcessor != null) {
            postProcessorME = this.postProcessor.getMethodExpression(faceletContext, null, new Class[]{Object.class});
        }
        if (this.options != null) {
            optionsVE = this.options.getValueExpression(faceletContext, Object.class);
        }
        if (this.onTableRender != null) {
            onTableRenderME = this.onTableRender.getMethodExpression(faceletContext, null, new Class[]{Object.class, Object.class});
        }
        if (this.exporter != null) {
            exporterVE = this.exporter.getValueExpression(faceletContext, Object.class);
        }
        if (this.onRowExport != null) {
            onRowExportME = this.onRowExport.getMethodExpression(faceletContext, null, new Class[]{Object.class});
        }
        if (this.bufferSize != null) {
            bufferSizeVE = this.bufferSize.getValueExpression(faceletContext, Integer.class);
        }
        ActionSource actionSource = (ActionSource)parent;
        DataExporter dataExporter = DataExporter.builder().target(targetVE).type(typeVE).fileName(fileNameVE).encoding(encodingVE).exporter(exporterVE).exportFooter(exportFooterVE).exportHeader(exportHeaderVE).onTableRender(onTableRenderME).options(optionsVE).pageOnly(pageOnlyVE).postProcessor(postProcessorME).preProcessor(preProcessorME).selectionOnly(selectionOnlyVE).visibleOnly(visibleOnlyVE).onRowExport(onRowExportME).bufferSize(bufferSizeVE).build();
        actionSource.addActionListener((ActionListener)dataExporter);
    }
}

