/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.fieldset;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import java.util.Map;
import org.primefaces.component.fieldset.Fieldset;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.FacetUtils;
import org.primefaces.util.WidgetBuilder;

public class FieldsetRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        String clientId;
        String toggleStateParam;
        Fieldset fieldset = (Fieldset)component;
        Map params = context.getExternalContext().getRequestParameterMap();
        if (params.containsKey(toggleStateParam = (clientId = fieldset.getClientId(context)) + "_collapsed")) {
            fieldset.setCollapsed(Boolean.parseBoolean((String)params.get(toggleStateParam)));
        }
        this.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Fieldset fieldset = (Fieldset)component;
        if (fieldset.isContentLoadRequest(context)) {
            this.renderChildren(context, (UIComponent)fieldset);
        } else {
            this.encodeMarkup(context, fieldset);
            this.encodeScript(context, fieldset);
        }
    }

    protected void encodeMarkup(FacesContext context, Fieldset fieldset) throws IOException {
        Object styleClass;
        ResponseWriter writer = context.getResponseWriter();
        String clientId = fieldset.getClientId(context);
        String widgetVar = fieldset.resolveWidgetVar(context);
        boolean toggleable = fieldset.isToggleable();
        String title = fieldset.getTitle();
        Object object = styleClass = toggleable ? "ui-fieldset ui-widget ui-widget-content ui-corner-all ui-hidden-container ui-fieldset-toggleable" : "ui-fieldset ui-widget ui-widget-content ui-corner-all ui-hidden-container";
        if (fieldset.isCollapsed()) {
            styleClass = (String)styleClass + " ui-hidden-container";
        }
        if (fieldset.getStyleClass() != null) {
            styleClass = (String)styleClass + " " + fieldset.getStyleClass();
        }
        writer.startElement("fieldset", (UIComponent)fieldset);
        if (title != null) {
            writer.writeAttribute("title", (Object)fieldset.getTitle(), null);
        }
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", styleClass, "styleClass");
        if (fieldset.getStyle() != null) {
            writer.writeAttribute("style", (Object)fieldset.getStyle(), "style");
        }
        writer.writeAttribute("data-widget", (Object)widgetVar, null);
        this.renderDynamicPassThruAttributes(context, (UIComponent)fieldset);
        this.encodeLegend(context, fieldset);
        this.encodeContent(context, fieldset);
        if (toggleable) {
            this.encodeStateHolder(context, fieldset);
        }
        writer.endElement("fieldset");
    }

    protected void encodeContent(FacesContext context, Fieldset fieldset) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-fieldset-content", null);
        if (fieldset.isCollapsed()) {
            writer.writeAttribute("style", (Object)"display:none", null);
        }
        if (!fieldset.isDynamic()) {
            this.renderChildren(context, (UIComponent)fieldset);
        }
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, Fieldset fieldset) throws IOException {
        boolean toggleable = fieldset.isToggleable();
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("Fieldset", fieldset);
        if (toggleable) {
            wb.attr("toggleable", true).attr("dynamic", fieldset.isDynamic(), false).attr("collapsed", fieldset.isCollapsed()).attr("toggleSpeed", fieldset.getToggleSpeed());
        }
        this.encodeClientBehaviors(context, fieldset);
        wb.finish();
    }

    protected void encodeLegend(FacesContext context, Fieldset fieldset) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String legendText = fieldset.getLegend();
        UIComponent legend = fieldset.getFacet("legend");
        boolean renderFacet = FacetUtils.shouldRenderFacet(legend);
        if (renderFacet || legendText != null) {
            writer.startElement("legend", null);
            writer.writeAttribute("class", (Object)"ui-fieldset-legend ui-corner-all ui-state-default", null);
            if (fieldset.isToggleable()) {
                writer.writeAttribute("tabindex", (Object)fieldset.getTabindex(), null);
                String togglerClass = fieldset.isCollapsed() ? "ui-fieldset-toggler ui-icon ui-icon-plusthick" : "ui-fieldset-toggler ui-icon ui-icon-minusthick";
                writer.startElement("span", null);
                writer.writeAttribute("class", (Object)togglerClass, null);
                writer.endElement("span");
            }
            if (renderFacet) {
                legend.encodeAll(context);
            } else if (fieldset.isEscape()) {
                writer.writeText((Object)legendText, "value");
            } else {
                writer.write(legendText);
            }
            writer.endElement("legend");
        }
    }

    protected void encodeStateHolder(FacesContext context, Fieldset fieldset) throws IOException {
        String name = fieldset.getClientId(context) + "_collapsed";
        this.renderHiddenInput(context, name, String.valueOf(fieldset.isCollapsed()), false);
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

