/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.fileupload;

import jakarta.faces.component.EditableValueHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.convert.ConverterException;
import java.io.IOException;
import java.util.Arrays;
import org.primefaces.component.fileupload.FileUpload;
import org.primefaces.component.fileupload.FileUploadDecoder;
import org.primefaces.context.PrimeApplicationContext;
import org.primefaces.expression.SearchExpressionUtils;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.LangUtils;
import org.primefaces.util.StyleClassBuilder;
import org.primefaces.util.WidgetBuilder;
import org.primefaces.validate.ClientValidator;
import org.primefaces.validate.FileValidator;

public class FileUploadRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        FileUpload fileUpload = (FileUpload)component;
        if (fileUpload.isDisabled()) {
            return;
        }
        if (!context.getExternalContext().getRequestContentType().toLowerCase().startsWith("multipart/")) {
            this.logDevelopmentWarning(context, "Decoding FileUpload requires enctype \"multipart/form-data\" for clientId: " + component.getClientId(context));
            return;
        }
        PrimeApplicationContext applicationContext = PrimeApplicationContext.getCurrentInstance(context);
        FileUploadDecoder decoder = applicationContext.getFileUploadDecoder();
        decoder.decode(context, fileUpload);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        FileUpload fileUpload = (FileUpload)component;
        this.encodeMarkup(context, fileUpload);
        this.encodeScript(context, fileUpload);
    }

    protected void encodeScript(FacesContext context, FileUpload fileUpload) throws IOException {
        String update = fileUpload.getUpdate();
        String process = fileUpload.getProcess();
        WidgetBuilder wb = this.getWidgetBuilder(context);
        if (fileUpload.getMode().equals("advanced")) {
            PrimeApplicationContext pfContext = PrimeApplicationContext.getCurrentInstance(context);
            wb.init("FileUpload", fileUpload).attr("dnd", fileUpload.isDragDropSupport(), true).attr("previewWidth", fileUpload.getPreviewWidth(), 80).attr("sequentialUploads", fileUpload.isSequential(), false).attr("maxChunkSize", fileUpload.getMaxChunkSize().longValue(), 0.0).attr("maxRetries", fileUpload.getMaxRetries(), 30).attr("retryTimeout", fileUpload.getRetryTimeout(), 1000).attr("resumeContextPath", pfContext.getFileUploadResumeUrl(), null).callback("onAdd", "function(file, callback)", fileUpload.getOnAdd()).callback("oncancel", "function()", fileUpload.getOncancel()).callback("onupload", "function()", fileUpload.getOnupload());
        } else {
            wb.init("SimpleFileUpload", fileUpload).attr("skinSimple", fileUpload.isSkinSimple(), false).attr("displayFilename", fileUpload.isDisplayFilename());
        }
        wb.attr("mode", fileUpload.getMode()).attr("auto", fileUpload.isAuto(), false).attr("update", SearchExpressionUtils.resolveClientIdsForClientSide(context, (UIComponent)fileUpload, update)).attr("process", SearchExpressionUtils.resolveClientIdsForClientSide(context, (UIComponent)fileUpload, process)).attr("global", fileUpload.isGlobal(), true).attr("disabled", fileUpload.isDisabled(), false).attr("messageTemplate", fileUpload.getMessageTemplate(), null).attr("dropZone", SearchExpressionUtils.resolveClientIdsForClientSide(context, (UIComponent)fileUpload, fileUpload.getDropZone())).callback("onstart", "function()", fileUpload.getOnstart()).callback("onerror", "function()", fileUpload.getOnerror()).callback("oncomplete", "function(args)", fileUpload.getOncomplete()).callback("onvalidationfailure", "function(msg)", fileUpload.getOnvalidationfailure());
        wb.finish();
    }

    protected void encodeMarkup(FacesContext context, FileUpload fileUpload) throws IOException {
        if (fileUpload.getMode().equals("simple")) {
            this.encodeSimpleMarkup(context, fileUpload);
        } else {
            this.encodeAdvancedMarkup(context, fileUpload);
        }
    }

    protected void encodeAdvancedMarkup(FacesContext context, FileUpload fileUpload) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = fileUpload.getClientId(context);
        String style = fileUpload.getStyle();
        String styleClass = this.getStyleClassBuilder(context).add("ui-fileupload ui-widget ui-fileupload-responsive").add(fileUpload.getStyleClass()).add(fileUpload.getDropZone() != null, "ui-fileupload-withdropzone").build();
        boolean disabled = fileUpload.isDisabled();
        writer.startElement("div", (UIComponent)fileUpload);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        writer.startElement("div", (UIComponent)fileUpload);
        writer.writeAttribute("class", (Object)"ui-fileupload-buttonbar ui-widget-header ui-corner-top", null);
        this.encodeChooseButton(context, fileUpload, disabled);
        if (!fileUpload.isAuto()) {
            StyleClassBuilder uploadCssClassBuilder = this.getStyleClassBuilder(context).add("ui-fileupload-upload").add(fileUpload.getUploadButtonStyleClass());
            this.encodeButton(context, fileUpload.getUploadLabel(), uploadCssClassBuilder, fileUpload.getUploadIcon(), fileUpload.getUploadButtonTitle());
            StyleClassBuilder cancelCssClassBuilder = this.getStyleClassBuilder(context).add("ui-fileupload-cancel").add(fileUpload.getCancelButtonStyleClass());
            this.encodeButton(context, fileUpload.getCancelLabel(), cancelCssClassBuilder, fileUpload.getCancelIcon(), fileUpload.getCancelButtonTitle());
        }
        writer.endElement("div");
        this.renderChildren(context, (UIComponent)fileUpload);
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-fileupload-content ui-widget-content ui-corner-bottom", null);
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-fileupload-files", null);
        writer.startElement("div", null);
        writer.endElement("div");
        writer.endElement("div");
        writer.endElement("div");
        writer.endElement("div");
    }

    protected void encodeSimpleMarkup(FacesContext context, FileUpload fileUpload) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = fileUpload.getClientId(context);
        String style = fileUpload.getStyle();
        Object styleClass = fileUpload.getStyleClass();
        String label = fileUpload.getLabel();
        if (fileUpload.isSkinSimple()) {
            styleClass = styleClass == null ? "ui-fileupload-simple ui-widget" : "ui-fileupload-simple ui-widget " + (String)styleClass;
            styleClass = this.isValueBlank(label) ? "ui-fileupload-icon-only " + (String)styleClass : styleClass;
            Object buttonClass = "ui-button ui-widget ui-state-default ui-corner-all ui-button-text-icon-left";
            if (fileUpload.isDisabled()) {
                buttonClass = (String)buttonClass + " ui-state-disabled";
            }
            writer.startElement("span", (UIComponent)fileUpload);
            writer.writeAttribute("id", (Object)clientId, "id");
            writer.writeAttribute("class", styleClass, "styleClass");
            if (style != null) {
                writer.writeAttribute("style", (Object)style, "style");
            }
            writer.startElement("span", null);
            writer.writeAttribute("class", buttonClass, null);
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)("ui-button-icon-left ui-icon ui-c " + fileUpload.getChooseIcon()), null);
            writer.endElement("span");
            writer.startElement("span", null);
            writer.writeAttribute("id", (Object)(clientId + "_label"), null);
            writer.writeAttribute("class", (Object)"ui-button-text ui-c", null);
            if (this.isValueBlank(label)) {
                writer.write("&nbsp;");
            } else {
                writer.writeText((Object)label, "value");
            }
            writer.endElement("span");
            this.encodeInputField(context, fileUpload, clientId, null);
            writer.endElement("span");
            writer.startElement("span", (UIComponent)fileUpload);
            writer.writeAttribute("class", (Object)"ui-fileupload-filename", null);
            writer.endElement("span");
            writer.endElement("span");
        } else {
            this.encodeSimpleInputField(context, fileUpload, clientId, style, (String)styleClass);
        }
    }

    protected void encodeChooseButton(FacesContext context, FileUpload fileUpload, boolean disabled) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = fileUpload.getClientId(context);
        String label = fileUpload.getLabel();
        String tabindex = disabled ? "-1" : "0";
        String cssClass = this.getStyleClassBuilder(context).add("ui-button ui-widget ui-state-default ui-corner-all ui-button-text-icon-left").add("ui-fileupload-choose").add(this.isValueBlank(label), "ui-fileupload-icon-only").add(fileUpload.getChooseButtonStyleClass()).add(disabled, "ui-state-disabled").build();
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)cssClass, null);
        writer.writeAttribute("tabindex", (Object)tabindex, null);
        writer.writeAttribute("aria-labelledby", (Object)(clientId + "_label"), null);
        String chooseButtonTitle = fileUpload.getChooseButtonTitle();
        if (chooseButtonTitle != null) {
            writer.writeAttribute("title", (Object)chooseButtonTitle, null);
        }
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)("ui-button-icon-left ui-icon ui-c " + fileUpload.getChooseIcon()), null);
        writer.endElement("span");
        writer.startElement("span", null);
        writer.writeAttribute("id", (Object)(clientId + "_label"), null);
        writer.writeAttribute("class", (Object)"ui-button-text ui-c", null);
        if (this.isValueBlank(label)) {
            writer.write("&nbsp;");
        } else {
            writer.writeText((Object)label, "value");
        }
        writer.endElement("span");
        if (!disabled) {
            this.encodeInputField(context, fileUpload, clientId, "-1");
        }
        writer.endElement("span");
    }

    protected void encodeInputField(FacesContext context, FileUpload fileUpload, String clientId, String tabIndex) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String inputId = clientId + "_input";
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"file", null);
        writer.writeAttribute("id", (Object)inputId, null);
        writer.writeAttribute("name", (Object)inputId, null);
        writer.writeAttribute("aria-hidden", (Object)"true", null);
        if (LangUtils.isNotBlank(tabIndex)) {
            writer.writeAttribute("tabindex", (Object)tabIndex, null);
        }
        if (fileUpload.isMultiple()) {
            writer.writeAttribute("multiple", (Object)"multiple", null);
        }
        if (fileUpload.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", "disabled");
        }
        if (fileUpload.getAccept() != null) {
            writer.writeAttribute("accept", (Object)fileUpload.getAccept(), null);
        }
        if (fileUpload.getTitle() != null) {
            writer.writeAttribute("title", (Object)fileUpload.getTitle(), null);
        }
        this.renderValidation(context, fileUpload);
        this.renderDynamicPassThruAttributes(context, (UIComponent)fileUpload);
        writer.endElement("input");
    }

    protected void encodeSimpleInputField(FacesContext context, FileUpload fileUpload, String clientId, String style, String styleClass) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"file", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("name", (Object)clientId, null);
        writer.writeAttribute("aria-hidden", (Object)"true", null);
        if (fileUpload.isMultiple()) {
            writer.writeAttribute("multiple", (Object)"multiple", null);
        }
        if (fileUpload.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", "disabled");
        }
        if (fileUpload.getAccept() != null) {
            writer.writeAttribute("accept", (Object)fileUpload.getAccept(), null);
        }
        if (fileUpload.getTitle() != null) {
            writer.writeAttribute("title", (Object)fileUpload.getTitle(), null);
        }
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)styleClass, "styleClass");
        }
        this.renderValidation(context, fileUpload);
        this.renderDynamicPassThruAttributes(context, (UIComponent)fileUpload);
        writer.endElement("input");
    }

    protected void encodeButton(FacesContext context, String label, StyleClassBuilder styleClassBuilder, String icon, String title) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String cssClass = styleClassBuilder.add("ui-button ui-widget ui-state-default ui-corner-all ui-button-text-icon-left").add("ui-state-disabled").add(this.isValueBlank(label), "ui-fileupload-icon-only").build();
        writer.startElement("button", null);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute("class", (Object)cssClass, null);
        writer.writeAttribute("disabled", (Object)"disabled", null);
        if (title != null) {
            writer.writeAttribute("title", (Object)title, null);
        }
        String iconClass = "ui-button-icon-left ui-icon ui-c";
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)(iconClass + " " + icon), null);
        writer.endElement("span");
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-button-text ui-c", null);
        if (this.isValueBlank(label)) {
            writer.write("&nbsp;");
        } else {
            writer.writeText((Object)label, "value");
        }
        writer.endElement("span");
        writer.endElement("button");
    }

    protected void renderValidation(FacesContext context, FileUpload fileUpload) throws IOException {
        boolean hasFileValidator = Arrays.stream(fileUpload.getValidators()).anyMatch(v -> v instanceof FileValidator);
        if (hasFileValidator) {
            this.renderValidationMetadata(context, (EditableValueHolder)fileUpload, new ClientValidator[0]);
        } else {
            String allowTypes;
            long sizeLimit;
            FileValidator fileValidator = new FileValidator();
            int fileLimit = fileUpload.getFileLimit();
            if (fileLimit != Integer.MAX_VALUE) {
                fileValidator.setFileLimit(fileLimit);
            }
            if ((sizeLimit = fileUpload.getSizeLimit().longValue()) != Long.MAX_VALUE) {
                fileValidator.setSizeLimit(sizeLimit);
            }
            if (LangUtils.isNotBlank(allowTypes = fileUpload.getAllowTypes())) {
                fileValidator.setAllowTypes(allowTypes);
            }
            this.renderValidationMetadata(context, (EditableValueHolder)fileUpload, fileValidator);
        }
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        FileUpload fileUpload = (FileUpload)component;
        if (fileUpload.getMode().equals("simple") && submittedValue != null && submittedValue.equals("")) {
            return null;
        }
        return submittedValue;
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

