/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.fileupload;

import jakarta.faces.context.FacesContext;
import jakarta.servlet.MultipartConfigElement;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.Part;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.primefaces.component.fileupload.AbstractFileUploadDecoder;
import org.primefaces.component.fileupload.FileUpload;
import org.primefaces.model.file.NativeUploadedFile;
import org.primefaces.model.file.UploadedFile;
import org.primefaces.util.FileUploadUtils;
import org.primefaces.util.LangUtils;

public class NativeFileUploadDecoder
extends AbstractFileUploadDecoder<HttpServletRequest> {
    @Override
    public String getName() {
        return "native";
    }

    @Override
    protected List<UploadedFile> createUploadedFiles(HttpServletRequest request, FileUpload fileUpload, String inputToDecodeId) throws IOException, ServletException {
        Long sizeLimit = fileUpload.getSizeLimit();
        Collection parts = request.getParts();
        return StreamSupport.stream(parts.spliterator(), false).filter(p -> p != null && p.getName().equals(inputToDecodeId)).filter(p -> LangUtils.isNotBlank(p.getSubmittedFileName())).map(p -> new NativeUploadedFile((Part)p, sizeLimit, null)).collect(Collectors.toList());
    }

    @Override
    protected UploadedFile createUploadedFile(HttpServletRequest request, FileUpload fileUpload, String inputToDecodeId) throws IOException, ServletException {
        Part part = request.getPart(inputToDecodeId);
        if (part == null || LangUtils.isBlank(part.getSubmittedFileName())) {
            return null;
        }
        return new NativeUploadedFile(part, fileUpload.getSizeLimit(), FileUploadUtils.getWebkitRelativePath(request));
    }

    @Override
    protected HttpServletRequest getRequest(FacesContext ctxt) {
        return (HttpServletRequest)ctxt.getExternalContext().getRequest();
    }

    @Override
    public String getUploadDirectory(HttpServletRequest request) {
        return Collections.list(request.getAttributeNames()).stream().map(arg_0 -> ((HttpServletRequest)request).getAttribute(arg_0)).filter(MultipartConfigElement.class::isInstance).map(MultipartConfigElement.class::cast).findFirst().map(MultipartConfigElement::getLocation).orElse(super.getUploadDirectory(request));
    }
}

