/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.galleria;

import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIPanel;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.primefaces.component.api.IterationStatus;
import org.primefaces.component.galleria.Galleria;
import org.primefaces.model.ResponsiveOption;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.FacetUtils;
import org.primefaces.util.WidgetBuilder;

public class GalleriaRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Galleria galleria = (Galleria)component;
        this.encodeMarkup(context, (UIComponent)galleria);
        this.encodeScript(context, (UIComponent)galleria);
    }

    public void encodeMarkup(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Galleria galleria = (Galleria)component;
        String style = galleria.getStyle();
        Object styleClass = galleria.getStyleClass();
        styleClass = styleClass == null ? "ui-galleria ui-widget ui-widget-content ui-corner-all" : "ui-galleria ui-widget ui-widget-content ui-corner-all " + (String)styleClass;
        writer.startElement("div", component);
        writer.writeAttribute("id", (Object)galleria.getClientId(context), "id");
        writer.writeAttribute("tabindex", (Object)galleria.getTabindex(), null);
        writer.writeAttribute("class", styleClass, "styleClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        this.encodeHeader(context, galleria);
        this.encodeContent(context, galleria);
        this.encodeFooter(context, galleria);
        writer.endElement("div");
    }

    protected void encodeHeader(FacesContext context, Galleria galleria) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        UIComponent facet = galleria.getFacet("header");
        boolean shouldRenderFacet = FacetUtils.shouldRenderFacet(facet);
        if (shouldRenderFacet) {
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)"ui-galleria-header", null);
            facet.encodeAll(context);
            writer.endElement("div");
        }
    }

    public void encodeContent(FacesContext context, Galleria galleria) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-galleria-content", null);
        this.encodeItems(context, galleria);
        this.encodeCaptions(context, galleria);
        this.encodeIndicators(context, galleria);
        this.encodeThumbnails(context, galleria);
        writer.endElement("div");
    }

    protected void encodeFooter(FacesContext context, Galleria galleria) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        UIComponent facet = galleria.getFacet("footer");
        boolean shouldRenderFacet = FacetUtils.shouldRenderFacet(facet);
        if (shouldRenderFacet) {
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)"ui-galleria-footer", null);
            facet.encodeAll(context);
            writer.endElement("div");
        }
    }

    public void encodeItems(FacesContext context, Galleria galleria) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("ul", null);
        writer.writeAttribute("class", (Object)"ui-galleria-items", null);
        if (galleria.isRepeating()) {
            Map requestMap = context.getExternalContext().getRequestMap();
            int rowCount = galleria.getRowCount();
            String varStatus = galleria.getVarStatus();
            Object varStatusBackup = varStatus == null ? null : (Object)requestMap.get(varStatus);
            for (int i = 0; i < rowCount; ++i) {
                galleria.setIndex(i);
                IterationStatus status = new IterationStatus(i == 0, i == rowCount - 1, i, i, 0, rowCount - 1, 1);
                if (varStatus != null) {
                    requestMap.put(varStatus, status);
                }
                writer.startElement("li", null);
                writer.writeAttribute("class", (Object)"ui-galleria-item", null);
                this.renderChildren(context, (UIComponent)galleria);
                writer.endElement("li");
            }
            galleria.setIndex(-1);
            if (varStatus != null) {
                if (varStatusBackup == null) {
                    requestMap.remove(varStatus);
                } else {
                    requestMap.put(varStatus, varStatusBackup);
                }
            }
        } else {
            for (UIComponent kid : galleria.getChildren()) {
                if (!kid.isRendered()) continue;
                writer.startElement("li", null);
                writer.writeAttribute("class", (Object)"ui-galleria-item", null);
                this.renderChild(context, kid);
                writer.endElement("li");
            }
        }
        writer.endElement("ul");
    }

    public void encodeCaptions(FacesContext context, Galleria galleria) throws IOException {
        UIComponent facet = galleria.getFacet("caption");
        boolean shouldRenderFacet = FacetUtils.shouldRenderFacet(facet);
        if (galleria.isShowCaption() && shouldRenderFacet) {
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("ul", null);
            writer.writeAttribute("class", (Object)"ui-galleria-caption-items", null);
            writer.writeAttribute("style", (Object)"display: none", null);
            if (galleria.isRepeating()) {
                for (int i = 0; i < galleria.getRowCount(); ++i) {
                    galleria.setIndex(i);
                    this.encodeCaption(context, galleria, galleria.getFacet("caption"), true);
                }
                galleria.setIndex(-1);
            } else if (facet instanceof UIPanel) {
                for (UIComponent kid : facet.getChildren()) {
                    if (!kid.isRendered()) continue;
                    this.encodeCaption(context, galleria, kid, false);
                }
            } else {
                this.encodeCaption(context, galleria, facet, false);
            }
            writer.endElement("ul");
        }
    }

    public void encodeCaption(FacesContext context, Galleria galleria, UIComponent child, boolean hasVar) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("li", null);
        writer.writeAttribute("class", (Object)"ui-galleria-caption-item", null);
        if (hasVar) {
            child.encodeAll(context);
        } else {
            this.renderChild(context, child);
        }
        writer.endElement("li");
    }

    public void encodeIndicators(FacesContext context, Galleria galleria) throws IOException {
        UIComponent facet = galleria.getFacet("indicator");
        boolean shouldRenderFacet = FacetUtils.shouldRenderFacet(facet);
        if (galleria.isShowIndicators() && shouldRenderFacet) {
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("ul", null);
            writer.writeAttribute("class", (Object)"ui-galleria-indicators", null);
            if (galleria.isRepeating()) {
                Map requestMap = context.getExternalContext().getRequestMap();
                int rowCount = galleria.getRowCount();
                String varStatus = galleria.getVarStatus();
                Object varStatusBackup = varStatus == null ? null : (Object)requestMap.get(varStatus);
                for (int i = 0; i < rowCount; ++i) {
                    galleria.setIndex(i);
                    IterationStatus status = new IterationStatus(i == 0, i == rowCount - 1, i, i, 0, rowCount - 1, 1);
                    if (varStatus != null) {
                        requestMap.put(varStatus, status);
                    }
                    this.encodeIndicator(context, galleria, galleria.getFacet("indicator"), true);
                }
                galleria.setIndex(-1);
                if (varStatus != null) {
                    if (varStatusBackup == null) {
                        requestMap.remove(varStatus);
                    } else {
                        requestMap.put(varStatus, varStatusBackup);
                    }
                }
            } else if (facet instanceof UIPanel) {
                for (UIComponent kid : facet.getChildren()) {
                    if (!kid.isRendered()) continue;
                    this.encodeIndicator(context, galleria, kid, false);
                }
            } else {
                this.encodeIndicator(context, galleria, facet, false);
            }
            writer.endElement("ul");
        }
    }

    public void encodeIndicator(FacesContext context, Galleria galleria, UIComponent child, boolean hasVar) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("li", null);
        writer.writeAttribute("class", (Object)"ui-galleria-indicator", null);
        if (hasVar) {
            child.encodeAll(context);
        } else {
            this.renderChild(context, child);
        }
        writer.endElement("li");
    }

    public void encodeThumbnails(FacesContext context, Galleria galleria) throws IOException {
        UIComponent facet = galleria.getFacet("thumbnail");
        boolean shouldRenderFacet = FacetUtils.shouldRenderFacet(facet);
        if (galleria.isShowThumbnails() && shouldRenderFacet) {
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)"ui-galleria-thumbnail-items", null);
            if (galleria.isRepeating()) {
                for (int i = 0; i < galleria.getRowCount(); ++i) {
                    galleria.setIndex(i);
                    this.encodeThumbnail(context, galleria, galleria.getFacet("thumbnail"), true);
                }
                galleria.setIndex(-1);
            } else if (facet instanceof UIPanel) {
                for (UIComponent kid : facet.getChildren()) {
                    if (!kid.isRendered()) continue;
                    this.encodeThumbnail(context, galleria, kid, false);
                }
            } else {
                this.encodeThumbnail(context, galleria, facet, false);
            }
            writer.endElement("div");
        }
    }

    public void encodeThumbnail(FacesContext context, Galleria galleria, UIComponent child, boolean hasVar) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-galleria-thumbnail-item", null);
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-galleria-thumbnail-item-content", null);
        if (hasVar) {
            child.encodeAll(context);
        } else {
            this.renderChild(context, child);
        }
        writer.endElement("div");
        writer.endElement("div");
    }

    public void encodeScript(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Galleria galleria = (Galleria)component;
        WidgetBuilder wb = this.getWidgetBuilder(context);
        List<ResponsiveOption> responsiveOptions = galleria.getResponsiveOptions();
        wb.init("Galleria", galleria);
        wb.attr("activeIndex", galleria.getActiveIndex(), 0).attr("fullScreen", galleria.isFullScreen(), false).attr("closeIcon", galleria.getCloseIcon(), null).attr("numVisible", galleria.getNumVisible(), 3).attr("showThumbnails", galleria.isShowThumbnails(), true).attr("showIndicators", galleria.isShowIndicators(), false).attr("showIndicatorsOnItem", galleria.isShowIndicatorsOnItem(), false).attr("showCaption", galleria.isShowCaption(), false).attr("showItemNavigators", galleria.isShowItemNavigators(), false).attr("showThumbnailNavigators", galleria.isShowThumbnailNavigators(), true).attr("showItemNavigatorsOnHover", galleria.isShowItemNavigatorsOnHover(), false).attr("changeItemOnIndicatorHover", galleria.isChangeItemOnIndicatorHover(), false).attr("circular", galleria.isCircular(), false).attr("autoPlay", galleria.isAutoPlay(), false).attr("transitionInterval", galleria.getTransitionInterval(), 4000).attr("thumbnailsPosition", galleria.getThumbnailsPosition(), "bottom").attr("verticalViewPortHeight", galleria.getVerticalViewPortHeight(), "450px").attr("indicatorsPosition", galleria.getIndicatorsPosition(), "bottom");
        if (responsiveOptions != null) {
            writer.write(",responsiveOptions:[");
            Iterator<ResponsiveOption> it = responsiveOptions.iterator();
            while (it.hasNext()) {
                it.next().encode((Writer)writer);
                if (!it.hasNext()) continue;
                writer.write(",");
            }
            writer.write("]");
        }
        wb.finish();
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

