/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.inputswitch;

import jakarta.faces.component.EditableValueHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import org.primefaces.component.inputswitch.InputSwitch;
import org.primefaces.renderkit.InputRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.HTML;
import org.primefaces.util.WidgetBuilder;
import org.primefaces.validate.ClientValidator;

@Deprecated(since="10.0", forRemoval=true)
public class InputSwitchRenderer
extends InputRenderer {
    public void decode(FacesContext context, UIComponent component) {
        InputSwitch inputSwitch = (InputSwitch)component;
        if (!this.shouldDecode(inputSwitch)) {
            return;
        }
        this.decodeBehaviors(context, (UIComponent)inputSwitch);
        String clientId = inputSwitch.getClientId(context);
        String submittedValue = (String)context.getExternalContext().getRequestParameterMap().get(clientId + "_input");
        boolean checked = this.isChecked(submittedValue);
        inputSwitch.setSubmittedValue(checked);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        InputSwitch inputSwitch = (InputSwitch)component;
        this.encodeMarkup(context, inputSwitch);
        this.encodeScript(context, inputSwitch);
    }

    protected void encodeMarkup(FacesContext context, InputSwitch inputSwitch) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        boolean checked = Boolean.parseBoolean(ComponentUtils.getValueToRender(context, (UIComponent)inputSwitch));
        boolean showLabels = inputSwitch.isShowLabels();
        String clientId = inputSwitch.getClientId(context);
        String style = inputSwitch.getStyle();
        Object styleClass = inputSwitch.getStyleClass();
        styleClass = styleClass == null ? "ui-inputswitch ui-widget ui-widget-content ui-corner-all" : "ui-inputswitch ui-widget ui-widget-content ui-corner-all " + (String)styleClass;
        Object object = styleClass = checked ? (String)styleClass + " ui-inputswitch-checked" : styleClass;
        if (inputSwitch.isDisabled()) {
            styleClass = (String)styleClass + " ui-state-disabled";
        }
        writer.startElement("div", (UIComponent)inputSwitch);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", styleClass, "styleClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        this.encodeOption(context, inputSwitch.getOffLabel(), "ui-inputswitch-off", showLabels);
        this.encodeOption(context, inputSwitch.getOnLabel(), "ui-inputswitch-on ui-state-active", showLabels);
        this.encodeHandle(context);
        this.encodeInput(context, inputSwitch, clientId, checked);
        writer.endElement("div");
    }

    protected void encodeOption(FacesContext context, String label, String styleClass, boolean showLabels) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)styleClass, null);
        writer.startElement("span", null);
        if (showLabels) {
            if (label != null) {
                writer.writeText((Object)label, null);
            }
        } else {
            writer.write("&nbsp;");
        }
        writer.endElement("span");
        writer.endElement("div");
    }

    protected void encodeHandle(FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-inputswitch-handle ui-state-default ", null);
        writer.endElement("div");
    }

    protected void encodeInput(FacesContext context, InputSwitch inputSwitch, String clientId, boolean checked) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String inputId = clientId + "_input";
        writer.startElement("div", (UIComponent)inputSwitch);
        writer.writeAttribute("class", (Object)"ui-helper-hidden-accessible", null);
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)inputId, "id");
        writer.writeAttribute("name", (Object)inputId, null);
        writer.writeAttribute("type", (Object)"checkbox", null);
        if (checked) {
            writer.writeAttribute("checked", (Object)"checked", null);
        }
        this.renderValidationMetadata(context, (EditableValueHolder)inputSwitch, new ClientValidator[0]);
        this.renderAccessibilityAttributes(context, inputSwitch);
        this.renderPassThruAttributes(context, (UIComponent)inputSwitch, HTML.TAB_INDEX);
        this.renderOnchange(context, (UIComponent)inputSwitch);
        this.renderDomEvents(context, (UIComponent)inputSwitch, HTML.BLUR_FOCUS_EVENTS);
        writer.endElement("input");
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, InputSwitch inputSwitch) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("InputSwitch", inputSwitch).attr("showLabels", inputSwitch.isShowLabels()).attr("onLabel", inputSwitch.getOnLabel(), null).attr("offLabel", inputSwitch.getOffLabel(), null).finish();
    }

    protected boolean isChecked(String value) {
        return value != null && ("on".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value) || "true".equalsIgnoreCase(value));
    }
}

