/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.knob;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.convert.ConverterException;
import java.awt.Color;
import java.io.IOException;
import org.primefaces.component.knob.Knob;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.LangUtils;
import org.primefaces.util.WidgetBuilder;

public class KnobRenderer
extends CoreRenderer {
    public static final String RENDERER_TYPE = "org.primefaces.component.KnobRenderer";

    public static final String colorToHex(Color color) {
        Object green;
        Object blue;
        Object red = Integer.toHexString(color.getRed());
        if (((String)red).length() < 2) {
            red = "0" + (String)red;
        }
        if (((String)(blue = Integer.toHexString(color.getBlue()))).length() < 2) {
            blue = "0" + (String)blue;
        }
        if (((String)(green = Integer.toHexString(color.getGreen()))).length() < 2) {
            green = "0" + (String)green;
        }
        return "#" + (String)red + (String)green + (String)blue;
    }

    public void decode(FacesContext context, UIComponent component) {
        int submittedInt;
        this.decodeBehaviors(context, component);
        String submittedValue = (String)context.getExternalContext().getRequestParameterMap().get(component.getClientId(context) + "_hidden");
        Knob knob = (Knob)component;
        if (!(LangUtils.isEmpty(submittedValue) || (submittedInt = Integer.parseInt(submittedValue)) >= knob.getMin() && submittedInt <= knob.getMax())) {
            return;
        }
        knob.setSubmittedValue(submittedValue);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.encodeMarkup(context, (Knob)component);
        this.encodeScript(context, (Knob)component);
    }

    private void encodeMarkup(FacesContext context, Knob knob) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Object value = knob.getValue() != null ? knob.getValue() : Integer.valueOf(0);
        writer.startElement("input", (UIComponent)knob);
        writer.writeAttribute("id", (Object)knob.getClientId(), null);
        writer.writeAttribute("name", (Object)knob.getClientId(), null);
        writer.writeAttribute("disabled", (Object)true, null);
        writer.writeAttribute("value", (Object)value.toString(), null);
        writer.writeAttribute("data-min", (Object)knob.getMin(), null);
        writer.writeAttribute("data-step", (Object)knob.getStep(), null);
        writer.writeAttribute("data-max", (Object)knob.getMax(), null);
        writer.writeAttribute("data-displayInput", (Object)Boolean.toString(knob.isShowLabel()), null);
        writer.writeAttribute("data-readOnly", (Object)Boolean.toString(knob.isDisabled()), null);
        writer.writeAttribute("data-cursor", (Object)Boolean.toString(knob.isCursor()), null);
        writer.writeAttribute("data-linecap", (Object)knob.getLineCap(), "butt");
        if (knob.getThickness() != null) {
            writer.writeAttribute("data-thickness", (Object)knob.getThickness(), null);
        }
        if (knob.getWidth() != null) {
            writer.writeAttribute("data-width", (Object)knob.getWidth().toString(), null);
        }
        if (knob.getHeight() != null) {
            writer.writeAttribute("data-height", (Object)knob.getHeight().toString(), null);
        }
        writer.writeAttribute("class", (Object)"knob", null);
        writer.endElement("input");
        this.renderHiddenInput(context, knob.getClientId() + "_hidden", value.toString(), knob.isDisabled());
    }

    private void encodeScript(FacesContext context, Knob knob) throws IOException {
        String styleClass = knob.getStyleClass() != null ? "ui-knob " + knob.getStyleClass() : "ui-knob";
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("Knob", knob);
        wb.attr("labelTemplate", knob.getLabelTemplate()).attr("colorTheme", knob.getColorTheme()).attr("styleClass", styleClass).callback("onchange", "function(value)", knob.getOnchange());
        if (knob.getForegroundColor() != null) {
            String fg = knob.getForegroundColor() instanceof Color ? KnobRenderer.colorToHex((Color)knob.getForegroundColor()) : knob.getForegroundColor().toString();
            wb.attr("fgColor", fg);
        }
        if (knob.getBackgroundColor() != null) {
            String bg = knob.getBackgroundColor() instanceof Color ? KnobRenderer.colorToHex((Color)knob.getBackgroundColor()) : knob.getBackgroundColor().toString();
            wb.attr("bgColor", bg);
        }
        this.encodeClientBehaviors(context, knob);
        wb.finish();
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        if (submittedValue == null) {
            submittedValue = 0;
        }
        try {
            return submittedValue instanceof Integer ? submittedValue : Integer.valueOf(Integer.parseInt(submittedValue.toString()));
        }
        catch (NumberFormatException e) {
            throw new ConverterException((Throwable)e);
        }
    }
}

