/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.lifecycle;

import jakarta.faces.context.FacesContext;
import jakarta.faces.event.PhaseEvent;
import jakarta.faces.event.PhaseId;
import jakarta.faces.event.PhaseListener;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.primefaces.component.lifecycle.PhaseInfo;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.LangUtils;

public class LifecyclePhaseListener
implements PhaseListener {
    private static final long serialVersionUID = 1L;

    public static PhaseInfo getPhaseInfo(PhaseId id, FacesContext facesContext) {
        String viewId;
        Map session = facesContext.getExternalContext().getSessionMap();
        Map storePerView = (Map)session.computeIfAbsent(LifecyclePhaseListener.class.getName(), k -> new HashMap());
        LinkedHashMap store = storePerView.computeIfAbsent(viewId = ComponentUtils.calculateViewId(facesContext), k -> new LinkedHashMap());
        PhaseInfo phaseInfo = (PhaseInfo)store.get(id.getOrdinal());
        if (phaseInfo == null) {
            phaseInfo = new PhaseInfo();
            phaseInfo.setPhase(id.getOrdinal());
            store.put(id.getOrdinal(), phaseInfo);
        }
        return phaseInfo;
    }

    public void beforePhase(PhaseEvent event) {
        if (this.isGetLifecycleInfoRequest(event.getFacesContext())) {
            return;
        }
        PhaseInfo phaseInfo = LifecyclePhaseListener.getPhaseInfo(event.getPhaseId(), event.getFacesContext());
        phaseInfo.setStart(System.currentTimeMillis());
        if (event.getPhaseId() == PhaseId.RESTORE_VIEW) {
            PhaseInfo anyPhaseInfo = LifecyclePhaseListener.getPhaseInfo(PhaseId.ANY_PHASE, event.getFacesContext());
            anyPhaseInfo.setStart(System.currentTimeMillis());
        }
    }

    public void afterPhase(PhaseEvent event) {
        if (this.isGetLifecycleInfoRequest(event.getFacesContext())) {
            return;
        }
        PhaseInfo phaseInfo = LifecyclePhaseListener.getPhaseInfo(event.getPhaseId(), event.getFacesContext());
        phaseInfo.setEnd(System.currentTimeMillis());
        phaseInfo.setDuration(phaseInfo.getEnd() - phaseInfo.getStart());
        if (event.getPhaseId() == PhaseId.RENDER_RESPONSE) {
            PhaseInfo anyPhaseInfo = LifecyclePhaseListener.getPhaseInfo(PhaseId.ANY_PHASE, event.getFacesContext());
            anyPhaseInfo.setEnd(System.currentTimeMillis());
            anyPhaseInfo.setDuration(anyPhaseInfo.getEnd() - anyPhaseInfo.getStart());
        }
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }

    protected boolean isGetLifecycleInfoRequest(FacesContext facesContext) {
        if (!facesContext.getPartialViewContext().isAjaxRequest()) {
            return false;
        }
        String source = (String)facesContext.getExternalContext().getRequestParameterMap().get("jakarta.faces.source");
        if (LangUtils.isBlank(source)) {
            return false;
        }
        return facesContext.getExternalContext().getRequestParameterMap().containsKey(source + "_getlifecycleinfo");
    }
}

