/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.link;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import org.primefaces.component.link.Link;
import org.primefaces.renderkit.OutcomeTargetRenderer;
import org.primefaces.util.HTML;
import org.primefaces.util.LangUtils;

public class LinkRenderer
extends OutcomeTargetRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Link link = (Link)component;
        boolean shouldWriteId = this.shouldWriteId((UIComponent)link);
        boolean disabled = link.isDisabled();
        String style = link.getStyle();
        String defaultStyleClass = disabled ? "ui-link ui-widget ui-state-disabled" : "ui-link ui-widget";
        String styleClass = link.getStyleClass();
        String string = styleClass = styleClass == null ? defaultStyleClass : defaultStyleClass + " " + styleClass;
        if (disabled) {
            writer.startElement("span", (UIComponent)link);
            if (shouldWriteId) {
                writer.writeAttribute("id", (Object)link.getClientId(context), "id");
            }
            writer.writeAttribute("class", (Object)styleClass, "styleClass");
            if (style != null) {
                writer.writeAttribute("style", (Object)style, "style");
            }
            this.renderContent(context, link);
            writer.endElement("span");
        } else {
            String targetURL = this.getTargetURL(context, link);
            if (LangUtils.isBlank(targetURL)) {
                targetURL = "#";
            }
            writer.startElement("a", (UIComponent)link);
            if (shouldWriteId) {
                writer.writeAttribute("id", (Object)link.getClientId(context), "id");
            }
            writer.writeAttribute("href", (Object)targetURL, null);
            writer.writeAttribute("class", (Object)styleClass, "styleClass");
            this.renderPassThruAttributes(context, (UIComponent)link, HTML.LINK_ATTRS_WITHOUT_EVENTS);
            this.renderDomEvents(context, (UIComponent)link, HTML.OUTPUT_EVENTS);
            this.renderContent(context, link);
            writer.endElement("a");
        }
    }

    protected void renderContent(FacesContext context, Link link) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Object value = link.getValue();
        if (value != null) {
            if (link.isEscape()) {
                writer.writeText(value, "value");
            } else {
                writer.write(value.toString());
            }
        } else {
            this.renderChildren(context, (UIComponent)link);
        }
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

