/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.organigram;

import jakarta.faces.FacesException;
import jakarta.faces.application.ResourceDependencies;
import jakarta.faces.application.ResourceDependency;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.AjaxBehaviorEvent;
import jakarta.faces.event.BehaviorEvent;
import jakarta.faces.event.FacesEvent;
import java.util.Collection;
import java.util.Map;
import org.primefaces.component.organigram.OrganigramBase;
import org.primefaces.component.organigram.OrganigramHelper;
import org.primefaces.event.organigram.AbstractOrganigramNodeEvent;
import org.primefaces.event.organigram.OrganigramNodeCollapseEvent;
import org.primefaces.event.organigram.OrganigramNodeDragDropEvent;
import org.primefaces.event.organigram.OrganigramNodeExpandEvent;
import org.primefaces.event.organigram.OrganigramNodeSelectEvent;
import org.primefaces.model.OrganigramNode;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.MapBuilder;

@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="components.css"), @ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="jquery/jquery-plugins.js"), @ResourceDependency(library="primefaces", name="core.js"), @ResourceDependency(library="primefaces", name="organigram/organigram.js"), @ResourceDependency(library="primefaces", name="organigram/organigram.css")})
public class Organigram
extends OrganigramBase {
    public static final String COMPONENT_TYPE = "org.primefaces.component.Organigram";
    private static final String DEFAULT_EVENT = "select";
    private static final Map<String, Class<? extends BehaviorEvent>> BEHAVIOR_EVENT_MAPPING = MapBuilder.builder().put("select", OrganigramNodeSelectEvent.class).put("expand", OrganigramNodeExpandEvent.class).put("collapse", OrganigramNodeCollapseEvent.class).put("dragdrop", OrganigramNodeDragDropEvent.class).put("contextmenu", OrganigramNodeSelectEvent.class).build();
    private static final Collection<String> EVENT_NAMES = BEHAVIOR_EVENT_MAPPING.keySet();

    @Override
    public Map<String, Class<? extends BehaviorEvent>> getBehaviorEventMapping() {
        return BEHAVIOR_EVENT_MAPPING;
    }

    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    public String getDefaultEventName() {
        return DEFAULT_EVENT;
    }

    public void queueEvent(FacesEvent event) {
        FacesContext context = this.getFacesContext();
        if (ComponentUtils.isRequestSource((UIComponent)this, context) && event instanceof AjaxBehaviorEvent) {
            Map params = context.getExternalContext().getRequestParameterMap();
            String eventName = (String)params.get("jakarta.faces.behavior.event");
            String clientId = this.getClientId(context);
            AbstractOrganigramNodeEvent wrapperEvent = null;
            AjaxBehaviorEvent behaviorEvent = (AjaxBehaviorEvent)event;
            if ("expand".equals(eventName)) {
                OrganigramNode node = this.findTreeNode(this.getValue(), (String)params.get(clientId + "_expandNode"));
                node.setExpanded(true);
                wrapperEvent = new OrganigramNodeExpandEvent((UIComponent)this, behaviorEvent.getBehavior(), node);
            } else if ("collapse".equals(eventName)) {
                OrganigramNode node = this.findTreeNode(this.getValue(), (String)params.get(clientId + "_collapseNode"));
                node.setExpanded(false);
                wrapperEvent = new OrganigramNodeCollapseEvent((UIComponent)this, behaviorEvent.getBehavior(), node);
            } else if (DEFAULT_EVENT.equals(eventName) || "contextmenu".equals(eventName)) {
                OrganigramNode node = this.findTreeNode(this.getValue(), (String)params.get(clientId + "_selectNode"));
                wrapperEvent = new OrganigramNodeSelectEvent((UIComponent)this, behaviorEvent.getBehavior(), node);
            } else if ("dragdrop".equals(eventName)) {
                OrganigramNode dragNode = this.findTreeNode(this.getValue(), (String)params.get(clientId + "_dragNode"));
                OrganigramNode dropNode = this.findTreeNode(this.getValue(), (String)params.get(clientId + "_dropNode"));
                if (dragNode != null && dropNode != null) {
                    OrganigramNode sourceNode = dragNode.getParent();
                    if (sourceNode != null) {
                        sourceNode.getChildren().remove(dragNode);
                    }
                    dragNode.setParent(dropNode);
                    wrapperEvent = new OrganigramNodeDragDropEvent((UIComponent)this, behaviorEvent.getBehavior(), dragNode, dropNode, sourceNode);
                }
            }
            if (wrapperEvent == null) {
                throw new FacesException("Component " + this.getClass().getName() + " does not support event " + eventName + "!");
            }
            wrapperEvent.setPhaseId(behaviorEvent.getPhaseId());
            super.queueEvent((FacesEvent)wrapperEvent);
        } else {
            super.queueEvent(event);
        }
    }

    public OrganigramNode findTreeNode(OrganigramNode searchRoot, String rowKey) {
        if ("root".equals(rowKey)) {
            return this.getValue();
        }
        return OrganigramHelper.findTreeNode(searchRoot, rowKey);
    }
}

