/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.organigram;

import jakarta.el.ValueExpression;
import jakarta.faces.FacesException;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.primefaces.component.organigram.Organigram;
import org.primefaces.component.organigram.OrganigramHelper;
import org.primefaces.component.organigramnode.UIOrganigramNode;
import org.primefaces.model.OrganigramNode;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.WidgetBuilder;

public class OrganigramRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        Organigram organigram = (Organigram)component;
        this.decodeSelection(context, organigram);
        this.decodeBehaviors(context, component);
    }

    protected void decodeSelection(FacesContext context, Organigram organigram) {
        if (ComponentUtils.isRequestSource((UIComponent)organigram, context)) {
            Map params;
            String rowKey;
            boolean selectionEnabled;
            boolean bl = selectionEnabled = organigram.getValueExpression("selection") != null;
            if (selectionEnabled && !this.isValueBlank(rowKey = (String)(params = context.getExternalContext().getRequestParameterMap()).get(organigram.getClientId(context) + "_selectNode"))) {
                OrganigramNode node = organigram.findTreeNode(organigram.getValue(), rowKey);
                this.assignSelection(context, organigram, node);
            }
        }
    }

    protected void assignSelection(FacesContext context, Organigram organigram, OrganigramNode node) {
        ValueExpression ve = organigram.getValueExpression("selection");
        ve.setValue(context.getELContext(), (Object)node);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Organigram organigram = (Organigram)component;
        this.encodeMarkup(context, organigram);
        this.encodeScript(context, organigram);
    }

    protected void encodeMarkup(FacesContext context, Organigram organigram) throws IOException {
        OrganigramNode node;
        ResponseWriter writer = context.getResponseWriter();
        String clientId = organigram.getClientId(context);
        OrganigramNode root = organigram.getValue();
        Map<String, UIOrganigramNode> nodeMapping = this.lookupNodeMapping(organigram);
        boolean selectionEnabled = organigram.getValueExpression("selection") != null;
        OrganigramNode selection = null;
        if (selectionEnabled && (selection = organigram.getSelection()) != null && (node = OrganigramHelper.findTreeNode(organigram.getValue(), selection)) == null) {
            selection = null;
            this.assignSelection(context, organigram, null);
        }
        if (root != null) {
            if (root.getRowKey() == null) {
                root.setRowKey("root");
            }
            OrganigramHelper.buildRowKeys(root);
        }
        Object styleClass = "ui-widget ui-organigram";
        if (organigram.getStyleClass() != null) {
            styleClass = (String)styleClass + " " + organigram.getStyleClass();
        }
        writer.startElement("div", (UIComponent)organigram);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", styleClass, null);
        if (organigram.getStyle() != null) {
            writer.writeAttribute("style", (Object)organigram.getStyle(), null);
        }
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)(clientId + "_target"), null);
        writer.writeAttribute("class", (Object)"target", null);
        writer.endElement("div");
        writer.startElement("ul", null);
        writer.writeAttribute("id", (Object)(clientId + "_source"), null);
        this.renderNode(context, writer, nodeMapping, organigram, root, selection, selectionEnabled);
        writer.endElement("ul");
        writer.endElement("div");
    }

    protected void renderNode(FacesContext context, ResponseWriter writer, Map<String, UIOrganigramNode> nodeMapping, Organigram organigram, OrganigramNode node, OrganigramNode selection, boolean selectionEnabled) throws IOException {
        String styleClass;
        Map requestMap = context.getExternalContext().getRequestMap();
        if (node == null) {
            return;
        }
        UIOrganigramNode uiNode = nodeMapping.get(node.getType());
        if (uiNode == null) {
            throw new FacesException("Unsupported tree node type:" + node.getType());
        }
        requestMap.put(organigram.getVar(), node);
        writer.startElement("li", null);
        writer.writeAttribute("data-rowkey", (Object)node.getRowKey(), null);
        if (node.getParent() != null) {
            writer.writeAttribute("data-parent-rowkey", (Object)node.getParent().getRowKey(), null);
        }
        if (!this.isValueBlank(uiNode.getStyle())) {
            writer.writeAttribute("style", (Object)uiNode.getStyle(), null);
        }
        if (!this.isValueBlank(styleClass = this.buildNodeStyleClass(node, uiNode, selectionEnabled, selection))) {
            writer.writeAttribute("class", (Object)styleClass, null);
        }
        if (node.isCollapsible()) {
            if (!this.isValueBlank(uiNode.getCollapsedIcon())) {
                writer.writeAttribute("data-collapsed-icon", (Object)uiNode.getCollapsedIcon(), null);
            }
            if (!this.isValueBlank(uiNode.getExpandedIcon())) {
                writer.writeAttribute("data-expanded-icon", (Object)uiNode.getExpandedIcon(), null);
            }
        }
        if (!this.isValueBlank(uiNode.getIcon())) {
            writer.writeAttribute("data-icon", (Object)uiNode.getIcon(), null);
            if (!this.isValueBlank(uiNode.getIconPos())) {
                writer.writeAttribute("data-icon-pos", (Object)uiNode.getIconPos(), null);
            }
        }
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-organigram-node-content", null);
        uiNode.encodeAll(context);
        writer.endElement("div");
        requestMap.remove(organigram.getVar());
        if (node.getChildren() != null && node.getChildCount() > 0) {
            writer.startElement("ul", null);
            for (OrganigramNode childNode : node.getChildren()) {
                this.renderNode(context, writer, nodeMapping, organigram, childNode, selection, selectionEnabled);
            }
            writer.endElement("ul");
        }
        writer.endElement("li");
    }

    protected void encodeScript(FacesContext context, Organigram organigram) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("Organigram", organigram).attr("zoom", organigram.isZoom()).attr("leafNodeConnectorHeight", organigram.getLeafNodeConnectorHeight()).attr("autoScrollToSelection", organigram.isAutoScrollToSelection());
        this.encodeClientBehaviors(context, organigram);
        wb.finish();
    }

    protected Map<String, UIOrganigramNode> lookupNodeMapping(Organigram organigram) {
        HashMap<String, UIOrganigramNode> nodes = new HashMap<String, UIOrganigramNode>();
        for (UIComponent child : organigram.getChildren()) {
            UIOrganigramNode node = (UIOrganigramNode)child;
            nodes.put(node.getType(), node);
        }
        return nodes;
    }

    protected String buildNodeStyleClass(OrganigramNode node, UIOrganigramNode uiNode, boolean selectionEnabled, OrganigramNode selection) {
        Object styleClass = "";
        if (node.isDraggable()) {
            styleClass = (String)styleClass + " draggable";
        }
        if (node.isDroppable()) {
            styleClass = (String)styleClass + " droppable";
        }
        if (node.isLeaf()) {
            styleClass = (String)styleClass + " leaf";
        }
        if (uiNode.isSkipLeafHandling()) {
            styleClass = (String)styleClass + " skip-leaf";
        }
        if (selectionEnabled && node.isSelectable()) {
            styleClass = (String)styleClass + " selectable";
            if (selection != null && selection.equals(node)) {
                styleClass = (String)styleClass + " selected";
            }
        }
        if (node.isCollapsible()) {
            styleClass = (String)styleClass + " collapsible";
            if (!node.isExpanded()) {
                styleClass = (String)styleClass + " collapsed";
            }
        }
        if (!this.isValueBlank(uiNode.getStyleClass())) {
            styleClass = (String)styleClass + " " + uiNode.getStyleClass();
        }
        if (!this.isValueBlank(node.getType())) {
            styleClass = (String)styleClass + " " + node.getType();
        }
        return ((String)styleClass).trim();
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

