/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.outputpanel;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import java.util.Map;
import org.primefaces.component.outputpanel.OutputPanel;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.FacetUtils;
import org.primefaces.util.WidgetBuilder;

public class OutputPanelRenderer
extends CoreRenderer {
    private static final String BLOCK = "div";
    private static final String INLINE = "span";

    public void decode(FacesContext context, UIComponent component) {
        String clientId;
        OutputPanel panel = (OutputPanel)component;
        Map params = context.getExternalContext().getRequestParameterMap();
        if (params.containsKey((clientId = panel.getClientId()) + "_load")) {
            this.decodeBehaviors(context, component);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        OutputPanel panel = (OutputPanel)component;
        if (panel.isContentLoadRequest(context)) {
            this.renderChildren(context, (UIComponent)panel);
        } else {
            this.encodeMarkup(context, panel);
            if (this.isDeferredNecessary(context, panel)) {
                this.encodeScript(context, panel);
            }
        }
    }

    public void encodeMarkup(FacesContext context, OutputPanel panel) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String tag = panel.getLayout().equals("block") ? BLOCK : INLINE;
        String clientId = panel.getClientId(context);
        String style = panel.getStyle();
        Object styleClass = panel.getStyleClass();
        styleClass = styleClass == null ? "ui-outputpanel ui-widget" : "ui-outputpanel ui-widget " + (String)styleClass;
        writer.startElement(tag, (UIComponent)panel);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", styleClass, "styleClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)panel.getStyle(), "style");
        }
        if (this.isDeferredNecessary(context, panel)) {
            UIComponent loadingFacet = panel.getFacet("loading");
            if (FacetUtils.shouldRenderFacet(loadingFacet)) {
                loadingFacet.encodeAll(context);
            } else {
                this.renderLoading(context, panel);
            }
        } else {
            this.renderChildren(context, (UIComponent)panel);
        }
        writer.endElement(tag);
    }

    protected void encodeScript(FacesContext context, OutputPanel panel) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("OutputPanel", panel);
        wb.attr("deferred", true).attr("deferredMode", panel.getDeferredMode());
        this.encodeClientBehaviors(context, panel);
        wb.finish();
    }

    protected void renderLoading(FacesContext context, OutputPanel panel) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("i", null);
        writer.writeAttribute("class", (Object)"ui-outputpanel-loading ui-icon pi pi-spin pi-spinner", null);
        writer.endElement("i");
    }

    protected boolean isDeferredNecessary(FacesContext context, OutputPanel panel) {
        if (!panel.isDeferred()) {
            return false;
        }
        if (panel.isLoaded() != null) {
            return panel.isLoaded() == false;
        }
        return !context.getPartialViewContext().isAjaxRequest();
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

