/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.panel;

import jakarta.el.ELContext;
import jakarta.el.ValueExpression;
import jakarta.faces.application.ResourceDependencies;
import jakarta.faces.application.ResourceDependency;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.AjaxBehaviorEvent;
import jakarta.faces.event.BehaviorEvent;
import jakarta.faces.event.FacesEvent;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import org.primefaces.PrimeFaces;
import org.primefaces.component.menu.Menu;
import org.primefaces.component.panel.PanelBase;
import org.primefaces.component.panel.PanelState;
import org.primefaces.el.ValueExpressionAnalyzer;
import org.primefaces.event.CloseEvent;
import org.primefaces.event.ToggleEvent;
import org.primefaces.model.Visibility;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.FacetUtils;
import org.primefaces.util.MapBuilder;

@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="components.css"), @ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="jquery/jquery-plugins.js"), @ResourceDependency(library="primefaces", name="core.js"), @ResourceDependency(library="primefaces", name="components.js")})
public class Panel
extends PanelBase {
    public static final String COMPONENT_TYPE = "org.primefaces.component.Panel";
    public static final String PANEL_CLASS = "ui-panel ui-widget ui-widget-content ui-corner-all";
    public static final String PANEL_TITLEBAR_CLASS = "ui-panel-titlebar ui-widget-header ui-helper-clearfix ui-corner-all";
    public static final String PANEL_TITLE_CLASS = "ui-panel-title";
    public static final String PANEL_TITLE_ICON_CLASS = "ui-panel-titlebar-icon ui-corner-all ui-state-default";
    public static final String PANEL_CONTENT_CLASS = "ui-panel-content ui-widget-content";
    public static final String PANEL_FOOTER_CLASS = "ui-panel-footer ui-widget-content";
    public static final String PANEL_ACTIONS_CLASS = "ui-panel-actions";
    private static final Map<String, Class<? extends BehaviorEvent>> BEHAVIOR_EVENT_MAPPING = MapBuilder.builder().put("toggle", ToggleEvent.class).put("close", CloseEvent.class).build();
    private static final Collection<String> EVENT_NAMES = BEHAVIOR_EVENT_MAPPING.keySet();

    @Override
    public Map<String, Class<? extends BehaviorEvent>> getBehaviorEventMapping() {
        return BEHAVIOR_EVENT_MAPPING;
    }

    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    public Menu getOptionsMenu() {
        UIComponent optionsFacet = this.getFacet("options");
        if (FacetUtils.shouldRenderFacet(optionsFacet)) {
            if (optionsFacet instanceof Menu) {
                return (Menu)optionsFacet;
            }
            return (Menu)optionsFacet.getChildren().get(0);
        }
        return null;
    }

    public void queueEvent(FacesEvent event) {
        FacesContext context = this.getFacesContext();
        Map params = context.getExternalContext().getRequestParameterMap();
        String eventName = (String)params.get("jakarta.faces.behavior.event");
        String clientId = this.getClientId(context);
        if (ComponentUtils.isRequestSource((UIComponent)this, context)) {
            AjaxBehaviorEvent behaviorEvent = (AjaxBehaviorEvent)event;
            if ("toggle".equals(eventName)) {
                boolean collapsed = Boolean.parseBoolean((String)params.get(clientId + "_collapsed"));
                Visibility visibility = collapsed ? Visibility.HIDDEN : Visibility.VISIBLE;
                ToggleEvent eventToQueue = new ToggleEvent((UIComponent)this, behaviorEvent.getBehavior(), visibility);
                eventToQueue.setPhaseId(behaviorEvent.getPhaseId());
                super.queueEvent((FacesEvent)new ToggleEvent((UIComponent)this, behaviorEvent.getBehavior(), visibility));
            } else if ("close".equals(eventName)) {
                CloseEvent eventToQueue = new CloseEvent((UIComponent)this, behaviorEvent.getBehavior());
                eventToQueue.setPhaseId(behaviorEvent.getPhaseId());
                super.queueEvent((FacesEvent)eventToQueue);
            }
        } else {
            super.queueEvent(event);
        }
    }

    public void processDecodes(FacesContext context) {
        if (ComponentUtils.isRequestSource((UIComponent)this, context)) {
            this.decode(context);
        } else {
            super.processDecodes(context);
        }
    }

    public void processValidators(FacesContext context) {
        if (!ComponentUtils.isRequestSource((UIComponent)this, context)) {
            super.processValidators(context);
        }
    }

    public void processUpdates(FacesContext context) {
        ELContext elContext;
        ValueExpression expr;
        if (!ComponentUtils.isRequestSource((UIComponent)this, context)) {
            super.processUpdates(context);
        }
        if ((expr = ValueExpressionAnalyzer.getExpression(elContext = context.getELContext(), this.getValueExpression(PanelBase.PropertyKeys.collapsed.toString()), true)) != null && !expr.isReadOnly(elContext)) {
            expr.setValue(elContext, (Object)this.isCollapsed());
            this.getStateHelper().remove((Serializable)((Object)PanelBase.PropertyKeys.collapsed));
        }
    }

    @Override
    public void restoreMultiViewState() {
        PanelState ps = this.getMultiViewState(false);
        if (ps != null) {
            this.setCollapsed(ps.isCollapsed());
        }
    }

    @Override
    public PanelState getMultiViewState(boolean create) {
        FacesContext fc = this.getFacesContext();
        String viewId = fc.getViewRoot().getViewId();
        return PrimeFaces.current().multiViewState().get(viewId, this.getClientId(fc), create, PanelState::new);
    }

    @Override
    public void resetMultiViewState() {
        this.setCollapsed(false);
    }
}

