/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.panel;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import java.util.Map;
import org.primefaces.component.menu.Menu;
import org.primefaces.component.panel.Panel;
import org.primefaces.component.panel.PanelState;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.FacetUtils;
import org.primefaces.util.WidgetBuilder;

public class PanelRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        String visibleParam;
        Panel panel = (Panel)component;
        String clientId = panel.getClientId(context);
        Map params = context.getExternalContext().getRequestParameterMap();
        String collapsedParam = (String)params.get(clientId + "_collapsed");
        if (collapsedParam != null) {
            panel.setCollapsed(Boolean.parseBoolean(collapsedParam));
            if (panel.isMultiViewState()) {
                PanelState ps = panel.getMultiViewState(true);
                ps.setCollapsed(panel.isCollapsed());
            }
        }
        if ((visibleParam = (String)params.get(clientId + "_visible")) != null) {
            panel.setVisible(Boolean.parseBoolean(visibleParam));
        }
        this.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        Panel panel = (Panel)component;
        Menu optionsMenu = panel.getOptionsMenu();
        if (panel.isMultiViewState()) {
            panel.restoreMultiViewState();
        }
        this.encodeMarkup(facesContext, panel, optionsMenu);
        this.encodeScript(facesContext, panel, optionsMenu);
    }

    protected void encodeScript(FacesContext context, Panel panel, Menu optionsMenu) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("Panel", panel);
        if (panel.isToggleable()) {
            wb.attr("toggleable", true).attr("toggleSpeed", panel.getToggleSpeed()).attr("collapsed", panel.isCollapsed()).attr("toggleOrientation", panel.getToggleOrientation()).attr("toggleableHeader", panel.isToggleableHeader()).attr("multiViewState", panel.isMultiViewState(), false);
        }
        if (panel.isClosable()) {
            wb.attr("closable", true).attr("closeSpeed", panel.getCloseSpeed());
        }
        if (optionsMenu != null) {
            wb.attr("hasMenu", true);
        }
        this.encodeClientBehaviors(context, panel);
        wb.finish();
    }

    protected void encodeMarkup(FacesContext context, Panel panel, Menu optionsMenu) throws IOException {
        Object styleClass;
        ResponseWriter writer = context.getResponseWriter();
        String clientId = panel.getClientId(context);
        String widgetVar = panel.resolveWidgetVar(context);
        boolean collapsed = panel.isCollapsed();
        boolean visible = panel.isVisible();
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, null);
        Object object = styleClass = panel.getStyleClass() == null ? "ui-panel ui-widget ui-widget-content ui-corner-all" : "ui-panel ui-widget ui-widget-content ui-corner-all " + panel.getStyleClass();
        if (collapsed) {
            styleClass = (String)styleClass + " ui-hidden-container";
            if (panel.getToggleOrientation().equals("horizontal")) {
                styleClass = (String)styleClass + " ui-panel-collapsed-h";
            }
        }
        if (!visible) {
            styleClass = (String)styleClass + " ui-helper-hidden";
        }
        writer.writeAttribute("class", styleClass, "styleClass");
        if (panel.getStyle() != null) {
            writer.writeAttribute("style", (Object)panel.getStyle(), "style");
        }
        writer.writeAttribute("data-widget", (Object)widgetVar, null);
        writer.writeAttribute("role", (Object)"region", null);
        boolean isRenderHeader = this.shouldRenderHeader(context, panel);
        if (isRenderHeader) {
            writer.writeAttribute("aria-labelledby", (Object)(clientId + "_header"), null);
        }
        this.renderDynamicPassThruAttributes(context, (UIComponent)panel);
        if (isRenderHeader) {
            this.encodeHeader(context, panel, optionsMenu);
        }
        this.encodeContent(context, panel);
        this.encodeFooter(context, panel);
        if (panel.isToggleable()) {
            this.encodeStateHolder(context, panel, clientId + "_collapsed", String.valueOf(collapsed));
        }
        if (panel.isClosable()) {
            this.encodeStateHolder(context, panel, clientId + "_visible", String.valueOf(visible));
        }
        if (optionsMenu != null) {
            optionsMenu.setOverlay(true);
            optionsMenu.setTrigger("@(#" + ComponentUtils.escapeSelector(clientId) + "_menu)");
            optionsMenu.setMy("left top");
            optionsMenu.setAt("left bottom");
            optionsMenu.encodeAll(context);
        }
        writer.endElement("div");
    }

    protected boolean shouldRenderHeader(FacesContext context, Panel panel) throws IOException {
        UIComponent header = panel.getFacet("header");
        String headerText = panel.getHeader();
        return headerText != null || FacetUtils.shouldRenderFacet(header, panel.isRenderEmptyFacets());
    }

    protected void encodeHeader(FacesContext context, Panel panel, Menu optionsMenu) throws IOException {
        UIComponent actionsFacet;
        ResponseWriter writer = context.getResponseWriter();
        UIComponent header = panel.getFacet("header");
        String headerText = panel.getHeader();
        String clientId = panel.getClientId(context);
        boolean shouldRenderFacet = FacetUtils.shouldRenderFacet(header, panel.isRenderEmptyFacets());
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)(panel.getClientId(context) + "_header"), null);
        writer.writeAttribute("class", (Object)"ui-panel-titlebar ui-widget-header ui-helper-clearfix ui-corner-all", null);
        if (panel.isToggleable()) {
            writer.writeAttribute("role", (Object)"button", null);
            writer.writeAttribute("aria-expanded", (Object)String.valueOf(!panel.isCollapsed()), null);
            writer.writeAttribute("aria-controls", (Object)(clientId + "_content"), null);
        }
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-panel-title", null);
        if (shouldRenderFacet) {
            this.renderChild(context, header);
        } else {
            writer.writeText((Object)headerText, null);
        }
        writer.endElement("span");
        if (panel.isClosable()) {
            this.encodeIcon(context, panel, "ui-icon-closethick", clientId + "_closer", panel.getCloseTitle(), null);
        }
        if (panel.isToggleable()) {
            String icon = panel.isCollapsed() ? "ui-icon-plusthick" : "ui-icon-minusthick";
            this.encodeIcon(context, panel, icon, clientId + "_toggler", panel.getToggleTitle(), null);
        }
        if (optionsMenu != null) {
            this.encodeIcon(context, panel, "ui-icon-gear", clientId + "_menu", panel.getMenuTitle(), null);
        }
        if (FacetUtils.shouldRenderFacet(actionsFacet = panel.getFacet("actions"))) {
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)"ui-panel-actions", null);
            actionsFacet.encodeAll(context);
            writer.endElement("div");
        }
        writer.endElement("div");
    }

    protected void encodeContent(FacesContext context, Panel panel) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)(panel.getClientId(context) + "_content"), null);
        writer.writeAttribute("class", (Object)"ui-panel-content ui-widget-content", null);
        if (panel.isCollapsed()) {
            writer.writeAttribute("style", (Object)"display:none", null);
        }
        this.renderChildren(context, (UIComponent)panel);
        writer.endElement("div");
    }

    protected void encodeFooter(FacesContext context, Panel panel) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        UIComponent footer = panel.getFacet("footer");
        String footerText = panel.getFooter();
        boolean shouldRenderFacet = FacetUtils.shouldRenderFacet(footer, panel.isRenderEmptyFacets());
        if (footerText == null && !shouldRenderFacet) {
            return;
        }
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)(panel.getClientId(context) + "_footer"), null);
        writer.writeAttribute("class", (Object)"ui-panel-footer ui-widget-content", null);
        if (shouldRenderFacet) {
            this.renderChild(context, footer);
        } else {
            writer.writeText((Object)footerText, null);
        }
        writer.endElement("div");
    }

    protected void encodeIcon(FacesContext context, Panel panel, String iconClass, String id, String title, String ariaLabel) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("a", null);
        if (id != null) {
            writer.writeAttribute("id", (Object)id, null);
        }
        writer.writeAttribute("href", (Object)"#", null);
        writer.writeAttribute("class", (Object)"ui-panel-titlebar-icon ui-corner-all ui-state-default", null);
        if (title != null) {
            writer.writeAttribute("title", (Object)title, null);
        }
        if (ariaLabel != null) {
            writer.writeAttribute("aria-label", (Object)ariaLabel, null);
        }
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)("ui-icon " + iconClass), null);
        writer.endElement("span");
        writer.endElement("a");
    }

    protected void encodeStateHolder(FacesContext context, Panel panel, String name, String value) throws IOException {
        this.renderHiddenInput(context, name, value, false);
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

