/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.panelmenu;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import java.util.List;
import org.primefaces.component.menu.AbstractMenu;
import org.primefaces.component.menu.BaseMenuRenderer;
import org.primefaces.component.panelmenu.PanelMenu;
import org.primefaces.model.menu.MenuElement;
import org.primefaces.model.menu.MenuItem;
import org.primefaces.model.menu.Submenu;
import org.primefaces.util.WidgetBuilder;

public class PanelMenuRenderer
extends BaseMenuRenderer {
    @Override
    protected void encodeScript(FacesContext context, AbstractMenu abstractMenu) throws IOException {
        PanelMenu menu = (PanelMenu)abstractMenu;
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("PanelMenu", menu).attr("stateful", menu.isStateful()).attr("statefulGlobal", menu.isStatefulGlobal(), false).attr("multiple", menu.isMultiple());
        wb.finish();
    }

    @Override
    protected void encodeMarkup(FacesContext context, AbstractMenu abstractMenu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        PanelMenu menu = (PanelMenu)abstractMenu;
        String clientId = menu.getClientId(context);
        String style = menu.getStyle();
        Object styleClass = menu.getStyleClass();
        styleClass = styleClass == null ? "ui-panelmenu ui-widget" : "ui-panelmenu ui-widget " + (String)styleClass;
        writer.startElement("div", (UIComponent)menu);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", styleClass, "styleClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        writer.writeAttribute("role", (Object)"tablist", null);
        if (menu.getElementsCount() > 0) {
            List<MenuElement> elements = menu.getElements();
            for (MenuElement element : elements) {
                if (!element.isRendered() || !(element instanceof Submenu)) continue;
                this.encodeRootSubmenu(context, menu, (Submenu)element);
            }
        }
        writer.endElement("div");
    }

    protected void encodeRootSubmenu(FacesContext context, PanelMenu menu, Submenu submenu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String style = submenu.getStyle();
        Object styleClass = submenu.getStyleClass();
        styleClass = styleClass == null ? "ui-panelmenu-panel" : "ui-panelmenu-panel " + (String)styleClass;
        boolean expanded = submenu.isExpanded();
        String headerClass = expanded ? "ui-widget ui-panelmenu-header ui-state-default ui-state-active ui-corner-top" : "ui-widget ui-panelmenu-header ui-state-default ui-corner-all";
        String headerIconClass = expanded ? "ui-icon ui-icon-triangle-1-s" : "ui-icon ui-icon-triangle-1-e";
        String contentClass = expanded ? "ui-panelmenu-content ui-widget-content" : "ui-panelmenu-content ui-widget-content ui-helper-hidden";
        writer.startElement("div", null);
        writer.writeAttribute("class", styleClass, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        writer.startElement("h3", null);
        writer.writeAttribute("class", (Object)headerClass, null);
        writer.writeAttribute("role", (Object)"tab", null);
        writer.writeAttribute("tabindex", (Object)"0", null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)headerIconClass, null);
        writer.endElement("span");
        writer.startElement("a", null);
        writer.writeAttribute("href", (Object)"#", null);
        writer.writeAttribute("tabindex", (Object)"-1", null);
        writer.writeText((Object)submenu.getLabel(), null);
        writer.endElement("a");
        writer.endElement("h3");
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)contentClass, null);
        writer.writeAttribute("role", (Object)"tabpanel", null);
        writer.writeAttribute("id", (Object)(menu.getClientId(context) + "_" + submenu.getId()), null);
        writer.writeAttribute("tabindex", (Object)"0", null);
        if (submenu.getElementsCount() > 0) {
            List<MenuElement> elements = submenu.getElements();
            writer.startElement("ul", null);
            writer.writeAttribute("role", (Object)"menu", null);
            writer.writeAttribute("class", (Object)"ui-menu-list ui-helper-reset", null);
            for (MenuElement element : elements) {
                if (!element.isRendered()) continue;
                if (element instanceof MenuItem) {
                    MenuItem menuItem = (MenuItem)element;
                    String containerStyle = menuItem.getContainerStyle();
                    Object containerStyleClass = menuItem.getContainerStyleClass();
                    containerStyleClass = containerStyleClass == null ? "ui-menuitem ui-widget ui-corner-all" : "ui-menuitem ui-widget ui-corner-all " + (String)containerStyleClass;
                    writer.startElement("li", null);
                    writer.writeAttribute("role", (Object)"none", null);
                    writer.writeAttribute("class", containerStyleClass, null);
                    if (containerStyle != null) {
                        writer.writeAttribute("style", (Object)containerStyle, null);
                    }
                    this.encodeMenuItem(context, menu, menuItem, "-1");
                    writer.endElement("li");
                    continue;
                }
                if (!(element instanceof Submenu)) continue;
                this.encodeDescendantSubmenu(context, menu, (Submenu)element);
            }
            writer.endElement("ul");
        }
        writer.endElement("div");
        writer.endElement("div");
    }

    protected void encodeDescendantSubmenu(FacesContext context, PanelMenu menu, Submenu submenu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String icon = submenu.getIcon();
        String style = submenu.getStyle();
        Object styleClass = submenu.getStyleClass();
        styleClass = styleClass == null ? "ui-widget ui-menuitem ui-corner-all ui-menu-parent" : "ui-widget ui-menuitem ui-corner-all ui-menu-parent " + (String)styleClass;
        boolean expanded = submenu.isExpanded();
        String toggleIconClass = expanded ? "ui-panelmenu-icon ui-icon ui-icon-triangle-1-s" : "ui-panelmenu-icon ui-icon ui-icon-triangle-1-e";
        String listClass = expanded ? "ui-menu-list ui-helper-reset" : "ui-menu-list ui-helper-reset ui-helper-hidden";
        boolean hasIcon = icon != null;
        String linkClass = hasIcon ? "ui-menuitem-link ui-menuitem-link-hasicon ui-corner-all" : "ui-menuitem-link ui-corner-all";
        writer.startElement("li", null);
        writer.writeAttribute("id", (Object)submenu.getClientId(), null);
        writer.writeAttribute("role", (Object)"none", null);
        writer.writeAttribute("class", styleClass, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        writer.startElement("a", null);
        writer.writeAttribute("role", (Object)"menuitem", null);
        writer.writeAttribute("class", (Object)linkClass, null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)toggleIconClass, null);
        writer.endElement("span");
        if (hasIcon) {
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)("ui-icon " + icon), null);
            writer.endElement("span");
        }
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-menuitem-text", null);
        writer.writeText((Object)submenu.getLabel(), null);
        writer.endElement("span");
        writer.endElement("a");
        if (submenu.getElementsCount() > 0) {
            List<MenuElement> elements = submenu.getElements();
            writer.startElement("ul", null);
            writer.writeAttribute("class", (Object)listClass, null);
            writer.writeAttribute("role", (Object)"menu", null);
            for (MenuElement element : elements) {
                if (!element.isRendered()) continue;
                if (element instanceof MenuItem) {
                    writer.startElement("li", null);
                    writer.writeAttribute("role", (Object)"none", null);
                    writer.writeAttribute("class", (Object)"ui-menuitem ui-widget ui-corner-all", null);
                    this.encodeMenuItem(context, menu, (MenuItem)element, "-1");
                    writer.endElement("li");
                    continue;
                }
                if (!(element instanceof Submenu)) continue;
                this.encodeDescendantSubmenu(context, menu, (Submenu)element);
            }
            writer.endElement("ul");
        }
        writer.endElement("li");
    }
}

