/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.polarareachart;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import org.primefaces.component.charts.ChartRenderer;
import org.primefaces.component.polarareachart.PolarAreaChart;
import org.primefaces.model.charts.polar.PolarAreaChartOptions;
import org.primefaces.util.WidgetBuilder;

public class PolarAreaChartRenderer
extends ChartRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        PolarAreaChart chart = (PolarAreaChart)component;
        this.encodeMarkup(context, chart);
        this.encodeScript(context, chart);
    }

    protected void encodeScript(FacesContext context, PolarAreaChart chart) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("PolarAreaChart", chart);
        this.encodeConfig(context, chart.getModel());
        this.encodeClientBehaviors(context, chart);
        wb.finish();
    }

    @Override
    protected void encodeOptions(FacesContext context, String type, Object options) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        if (options == null) {
            return;
        }
        PolarAreaChartOptions polarOptions = (PolarAreaChartOptions)options;
        writer.write(",\"options\":{");
        this.encodeResponsive(context, polarOptions, false);
        writer.write(",\"animation\":{");
        writer.write("\"animateRotate\":" + polarOptions.isAnimateRotate());
        writer.write(",\"animateScale\":" + polarOptions.isAnimateScale());
        writer.write("}");
        this.encodeScales(context, type, polarOptions.getScales(), true);
        this.encodeElements(context, polarOptions.getElements(), true);
        this.encodeAnimation(context, polarOptions.getAnimation(), true);
        this.encodePlugins(context, polarOptions, true);
        writer.write("}");
    }
}

