/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.roweditor;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import org.primefaces.component.roweditor.RowEditor;
import org.primefaces.renderkit.CoreRenderer;

public class RowEditorRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        RowEditor rowEditor = (RowEditor)component;
        String style = rowEditor.getStyle();
        Object styleClass = rowEditor.getStyleClass();
        styleClass = styleClass == null ? "ui-row-editor ui-helper-clearfix" : "ui-row-editor ui-helper-clearfix " + (String)styleClass;
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)component.getClientId(context), null);
        writer.writeAttribute("class", styleClass, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        this.encodeIcon(writer, "pencil", rowEditor.getEditTitle());
        this.encodeIcon(writer, "check", rowEditor.getSaveTitle());
        this.encodeIcon(writer, "close", rowEditor.getCancelTitle());
        writer.endElement("div");
    }

    protected void encodeIcon(ResponseWriter writer, String type, String title) throws IOException {
        String iconClass = "ui-icon ui-icon-" + type;
        iconClass = "pencil".equals(type) ? iconClass : iconClass + " ui-c";
        writer.startElement("a", null);
        writer.writeAttribute("href", (Object)"#", null);
        writer.writeAttribute("class", (Object)("ui-row-editor-" + type), null);
        writer.startElement("span", null);
        if (title != null) {
            writer.writeAttribute("title", (Object)title, null);
        }
        writer.writeAttribute("class", (Object)iconClass, null);
        writer.endElement("span");
        writer.endElement("a");
    }
}

