/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.selectcheckboxmenu;

import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIInput;
import jakarta.faces.component.UINamingContainer;
import jakarta.faces.component.UISelectMany;
import jakarta.faces.component.behavior.ClientBehaviorHolder;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.convert.Converter;
import jakarta.faces.convert.ConverterException;
import jakarta.faces.model.SelectItem;
import jakarta.faces.model.SelectItemGroup;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Stream;
import org.primefaces.component.column.Column;
import org.primefaces.component.selectcheckboxmenu.SelectCheckboxMenu;
import org.primefaces.expression.SearchExpressionUtils;
import org.primefaces.renderkit.SelectManyRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.FacetUtils;
import org.primefaces.util.WidgetBuilder;

public class SelectCheckboxMenuRenderer
extends SelectManyRenderer {
    @Override
    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        Object renderer = ComponentUtils.getUnwrappedRenderer(context, "jakarta.faces.SelectMany", "jakarta.faces.Checkbox");
        return renderer.getConvertedValue(context, component, submittedValue);
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        SelectCheckboxMenu menu = (SelectCheckboxMenu)component;
        this.encodeMarkup(context, menu);
        this.encodeScript(context, menu);
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void encodeMarkup(FacesContext context, SelectCheckboxMenu menu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = menu.getClientId(context);
        List<SelectItem> selectItems = this.getSelectItems(context, (UIInput)menu);
        boolean valid = menu.isValid();
        String title = menu.getTitle();
        String style = menu.getStyle();
        Object styleclass = this.createStyleClass((UIInput)menu, "ui-selectcheckboxmenu ui-widget ui-state-default ui-corner-all");
        styleclass = menu.isMultiple() ? "ui-selectcheckboxmenu-multiple " + (String)styleclass : styleclass;
        writer.startElement("div", (UIComponent)menu);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", styleclass, "styleclass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        if (title != null) {
            writer.writeAttribute("title", (Object)title, "title");
        }
        this.encodeKeyboardTarget(context, menu);
        this.encodeInputs(context, menu, selectItems);
        if (menu.isMultiple()) {
            this.encodeMultipleLabel(context, menu, selectItems);
        } else {
            this.encodeLabel(context, menu, valid);
        }
        this.encodeMenuIcon(context, menu, valid);
        this.encodePanel(context, menu, selectItems);
        writer.endElement("div");
    }

    protected void encodeInputs(FacesContext context, SelectCheckboxMenu menu, List<SelectItem> selectItems) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Converter converter = menu.getConverter();
        Object values = this.getValues((UIComponent)menu);
        Object submittedValues = this.getSubmittedValues((UIComponent)menu);
        writer.startElement("div", (UIComponent)menu);
        writer.writeAttribute("class", (Object)"ui-helper-hidden", null);
        int idx = -1;
        for (int i = 0; i < selectItems.size(); ++i) {
            SelectItem selectItem = selectItems.get(i);
            if (selectItem instanceof SelectItemGroup) {
                SelectItemGroup selectItemGroup = (SelectItemGroup)selectItem;
                String selectItemGroupLabel = selectItemGroup.getLabel() == null ? "" : selectItemGroup.getLabel();
                for (SelectItem childSelectItem : selectItemGroup.getSelectItems()) {
                    this.encodeOption(context, menu, values, submittedValues, converter, childSelectItem, ++idx, selectItemGroupLabel);
                }
                continue;
            }
            this.encodeOption(context, menu, values, submittedValues, converter, selectItem, ++idx);
        }
        writer.endElement("div");
    }

    protected void encodeOption(FacesContext context, SelectCheckboxMenu menu, Object values, Object submittedValues, Converter converter, SelectItem option, int idx) throws IOException {
        this.encodeOption(context, menu, values, submittedValues, converter, option, idx, null);
    }

    protected void encodeOption(FacesContext context, SelectCheckboxMenu menu, Object values, Object submittedValues, Converter converter, SelectItem option, int idx, String selectItemGroupLabel) throws IOException {
        Object itemValue;
        Object valuesArray;
        ResponseWriter writer = context.getResponseWriter();
        String itemValueAsString = this.getOptionAsString(context, (UIComponent)menu, converter, option.getValue());
        String name = menu.getClientId(context);
        String id = name + UINamingContainer.getSeparatorChar((FacesContext)context) + idx;
        boolean disabled = option.isDisabled() || menu.isDisabled();
        boolean escaped = option.isEscape();
        String itemLabel = option.getLabel();
        String string = itemLabel = this.isValueBlank(itemLabel) ? "&nbsp;" : itemLabel;
        if (submittedValues != null) {
            valuesArray = submittedValues;
            itemValue = itemValueAsString;
        } else {
            valuesArray = values;
            itemValue = option.getValue();
        }
        boolean checked = this.isSelected(context, (UIComponent)menu, itemValue, valuesArray, converter);
        if (option.isNoSelectionOption() && values != null && !checked) {
            return;
        }
        writer.startElement("input", this.getSelectItemComponent(option));
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("name", (Object)name, null);
        writer.writeAttribute("type", (Object)"checkbox", null);
        writer.writeAttribute("value", (Object)itemValueAsString, null);
        writer.writeAttribute("data-escaped", (Object)String.valueOf(escaped), null);
        if (selectItemGroupLabel != null) {
            writer.writeAttribute("data-group-label", (Object)selectItemGroupLabel, null);
        }
        if (checked) {
            writer.writeAttribute("checked", (Object)"checked", null);
        }
        if (option.getDescription() != null) {
            writer.writeAttribute("title", (Object)option.getDescription(), null);
        }
        if (menu.getOnchange() != null) {
            writer.writeAttribute("onchange", (Object)menu.getOnchange(), null);
        }
        this.renderAccessibilityAttributes(context, (UIInput)menu, option.isDisabled(), false);
        writer.endElement("input");
        writer.startElement("label", null);
        writer.writeAttribute("for", (Object)id, null);
        if (disabled) {
            writer.writeAttribute("class", (Object)"ui-state-disabled", null);
        }
        if ("&nbsp;".equals(itemLabel)) {
            writer.write(itemLabel);
        } else if (escaped) {
            writer.writeText((Object)itemLabel, "value");
        } else {
            writer.write(itemLabel);
        }
        writer.endElement("label");
    }

    protected void encodeLabel(FacesContext context, SelectCheckboxMenu menu, boolean valid) throws IOException {
        String labelClass;
        ResponseWriter writer = context.getResponseWriter();
        String label = menu.getLabel();
        String string = labelClass = !valid ? "ui-selectcheckboxmenu-label ui-corner-all ui-state-error" : "ui-selectcheckboxmenu-label ui-corner-all";
        if (label == null) {
            label = "";
        }
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-selectcheckboxmenu-label-container", null);
        writer.startElement("label", null);
        writer.writeAttribute("class", (Object)labelClass, null);
        writer.writeText((Object)label, null);
        writer.endElement("label");
        writer.endElement("span");
    }

    protected void encodeMultipleLabel(FacesContext context, SelectCheckboxMenu menu, List<SelectItem> selectItems) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Converter converter = menu.getConverter();
        Object values = this.getValues((UIComponent)menu);
        Object submittedValues = this.getSubmittedValues((UIComponent)menu);
        Object valuesArray = submittedValues != null ? submittedValues : values;
        String listClass = this.createStyleClass((UIInput)menu, null, "ui-selectcheckboxmenu-multiple-container ui-widget ui-inputfield ui-state-default ui-corner-all");
        String label = menu.getEmptyLabel() == null ? menu.getLabel() : menu.getEmptyLabel();
        writer.startElement("ul", null);
        writer.writeAttribute("data-label", (Object)label, null);
        writer.writeAttribute("class", (Object)listClass, null);
        if (valuesArray != null) {
            int length = Array.getLength(valuesArray);
            for (int i = 0; i < length; ++i) {
                Object value = Array.get(valuesArray, i);
                SelectItem selectedItem = null;
                block1: for (int j = 0; j < selectItems.size(); ++j) {
                    SelectItem item = selectItems.get(j);
                    if (item instanceof SelectItemGroup) {
                        SelectItemGroup group = (SelectItemGroup)item;
                        for (SelectItem groupItem : group.getSelectItems()) {
                            if (!this.isSelectValueEqual(context, (UIComponent)menu, value, groupItem.getValue(), converter)) continue;
                            selectedItem = groupItem;
                            continue block1;
                        }
                        continue;
                    }
                    if (!this.isSelectValueEqual(context, (UIComponent)menu, value, item.getValue(), converter)) continue;
                    selectedItem = item;
                    break;
                }
                if (selectedItem == null) continue;
                String itemValueAsString = value == null || value instanceof String ? (String)value : this.getOptionAsString(context, (UIComponent)menu, converter, value);
                writer.startElement("li", null);
                writer.writeAttribute("class", (Object)"ui-selectcheckboxmenu-token ui-state-active ui-corner-all", null);
                writer.writeAttribute("data-item-value", (Object)itemValueAsString, null);
                writer.startElement("span", null);
                writer.writeAttribute("class", (Object)"ui-selectcheckboxmenu-token-label", null);
                if (selectedItem.getLabel() != null) {
                    String selectedItemLabel;
                    String string = selectedItemLabel = this.isValueBlank(selectedItem.getLabel()) ? "&nbsp;" : selectedItem.getLabel();
                    if (selectedItem.isEscape() && !"&nbsp;".equals(selectedItemLabel)) {
                        writer.writeText((Object)selectedItemLabel, null);
                    } else {
                        writer.write(selectedItemLabel);
                    }
                } else {
                    writer.writeText(value, null);
                }
                writer.endElement("span");
                writer.startElement("span", null);
                writer.writeAttribute("class", (Object)"ui-selectcheckboxmenu-token-icon ui-icon ui-icon-close", null);
                writer.endElement("span");
                writer.endElement("li");
            }
        }
        writer.endElement("ul");
    }

    protected void encodeMenuIcon(FacesContext context, SelectCheckboxMenu menu, boolean valid) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String iconClass = valid ? "ui-selectcheckboxmenu-trigger ui-state-default ui-corner-right" : "ui-selectcheckboxmenu-trigger ui-state-default ui-corner-right ui-state-error";
        writer.startElement("div", (UIComponent)menu);
        writer.writeAttribute("class", (Object)iconClass, null);
        writer.startElement("span", (UIComponent)menu);
        writer.writeAttribute("class", (Object)"ui-icon ui-icon-triangle-1-s", null);
        writer.endElement("span");
        writer.endElement("div");
    }

    protected void encodePanel(FacesContext context, SelectCheckboxMenu menu, List<SelectItem> selectItems) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String panelStyle = menu.getPanelStyle();
        Object panelStyleClass = "ui-selectcheckboxmenu-panel ui-widget ui-widget-content ui-corner-all ui-helper-hidden ui-input-overlay";
        if (menu.getPanelStyleClass() != null) {
            panelStyleClass = (String)panelStyleClass + " " + menu.getPanelStyleClass();
        }
        String maxScrollHeight = this.getMaxScrollHeight(menu);
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)(menu.getClientId(context) + "_panel"), null);
        writer.writeAttribute("class", panelStyleClass, null);
        writer.writeAttribute("role", (Object)"dialog", null);
        if (panelStyle != null) {
            writer.writeAttribute("style", (Object)panelStyle, null);
        }
        if (menu.isShowHeader()) {
            this.encodePanelHeader(context, menu, selectItems);
        }
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-selectcheckboxmenu-items-wrapper", null);
        writer.writeAttribute("style", (Object)("max-height:" + maxScrollHeight), null);
        if (!menu.isDynamic()) {
            this.encodePanelContent(context, menu, selectItems);
        }
        writer.endElement("div");
        this.encodePanelFooter(context, menu);
        writer.endElement("div");
    }

    private void encodePanelHeader(FacesContext context, SelectCheckboxMenu menu, List<SelectItem> selectItems) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Converter converter = menu.getConverter();
        Object submittedValues = this.getSubmittedValues((UIComponent)menu);
        Object values = this.getValues((UIComponent)menu);
        Object valuesArray = submittedValues != null ? submittedValues : values;
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-widget-header ui-corner-all ui-selectcheckboxmenu-header ui-helper-clearfix", null);
        boolean notChecked = selectItems.stream().flatMap(selectItem -> {
            if (selectItem instanceof SelectItemGroup) {
                SelectItemGroup selectItemGroup = (SelectItemGroup)selectItem;
                return Stream.of(selectItemGroup.getSelectItems());
            }
            return Stream.of(selectItem);
        }).anyMatch(selectItem -> {
            Object value = submittedValues != null ? this.getOptionAsString(context, (UIComponent)menu, converter, selectItem.getValue()) : selectItem.getValue();
            return !this.isSelected(context, (UIComponent)menu, value, valuesArray, converter);
        });
        this.encodeCheckbox(context, null, false, !notChecked, null, null, -1, -1);
        if (menu.isFilter()) {
            this.encodeFilter(context, menu);
        }
        writer.startElement("a", null);
        writer.writeAttribute("class", (Object)"ui-selectcheckboxmenu-close ui-corner-all", null);
        writer.writeAttribute("href", (Object)"#", null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-icon ui-icon-circle-close", null);
        writer.endElement("span");
        writer.endElement("a");
        writer.endElement("div");
    }

    protected void encodeFilter(FacesContext context, SelectCheckboxMenu menu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String id = menu.getClientId(context) + "_filter";
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-selectcheckboxmenu-filter-container", null);
        writer.startElement("input", null);
        writer.writeAttribute("class", (Object)"ui-selectcheckboxmenu-filter ui-inputfield ui-inputtext ui-widget ui-state-default ui-corner-all", null);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("name", (Object)id, null);
        writer.writeAttribute("type", (Object)"text", null);
        writer.writeAttribute("autocomplete", (Object)"off", null);
        writer.writeAttribute("aria-autocomplete", (Object)"list", null);
        writer.writeAttribute("aria-controls", (Object)(menu.getClientId(context) + "_table"), null);
        writer.writeAttribute("aria-disabled", (Object)false, null);
        writer.writeAttribute("aria-multiline", (Object)false, null);
        writer.writeAttribute("aria-readonly", (Object)false, null);
        if (menu.getFilterPlaceholder() != null) {
            writer.writeAttribute("placeholder", (Object)menu.getFilterPlaceholder(), null);
        }
        writer.endElement("input");
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-icon ui-icon-search", id);
        writer.endElement("span");
        writer.endElement("div");
    }

    protected void encodePanelContent(FacesContext context, SelectCheckboxMenu menu, List<SelectItem> selectItems) throws IOException {
        boolean customContent;
        ResponseWriter writer = context.getResponseWriter();
        boolean bl = customContent = menu.getVar() != null;
        if (customContent) {
            ComponentUtils.runWithoutFacesContextVar(context, "org.primefaces.HELPER_RENDERER", () -> {
                List<Column> columns = menu.getColumns();
                writer.startElement("table", null);
                writer.writeAttribute("id", (Object)(menu.getClientId(context) + "_list"), null);
                writer.writeAttribute("class", (Object)"ui-selectcheckboxmenu-items ui-selectcheckboxmenu-table ui-widget-content ui-widget ui-corner-all ui-helper-reset", null);
                writer.writeAttribute("role", (Object)"listbox", null);
                writer.writeAttribute("aria-multiselectable", (Object)"true", null);
                this.encodeColumnsHeader(context, menu, columns);
                writer.startElement("tbody", null);
                this.encodeOptionsAsTable(context, menu, selectItems, columns);
                writer.endElement("tbody");
                writer.endElement("table");
            });
        }
    }

    protected void encodePanelFooter(FacesContext context, SelectCheckboxMenu menu) throws IOException {
        UIComponent facet = menu.getFacet("footer");
        if (!FacetUtils.shouldRenderFacet(facet)) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-selectcheckboxmenu-footer", null);
        facet.encodeAll(context);
        writer.endElement("div");
    }

    protected void encodeColumnsHeader(FacesContext context, SelectCheckboxMenu menu, List<Column> columns) throws IOException {
        Column column;
        int i;
        ResponseWriter writer = context.getResponseWriter();
        boolean hasHeader = false;
        for (i = 0; i < columns.size(); ++i) {
            column = columns.get(i);
            if (!column.isRendered() || column.getHeaderText() == null && column.getFacet("header") == null) continue;
            hasHeader = true;
            break;
        }
        if (hasHeader) {
            writer.startElement("thead", null);
            writer.startElement("th", null);
            writer.endElement("th");
            for (i = 0; i < columns.size(); ++i) {
                UIComponent headerFacet;
                column = columns.get(i);
                if (!column.isRendered()) continue;
                String headerText = column.getHeaderText();
                String styleClass = column.getStyleClass() == null ? "ui-state-default" : "ui-state-default " + column.getStyleClass();
                writer.startElement("th", null);
                writer.writeAttribute("class", (Object)styleClass, null);
                if (column.getStyle() != null) {
                    writer.writeAttribute("style", (Object)column.getStyle(), null);
                }
                if (FacetUtils.shouldRenderFacet(headerFacet = column.getFacet("header"))) {
                    headerFacet.encodeAll(context);
                } else if (headerText != null) {
                    writer.writeText((Object)headerText, null);
                }
                writer.endElement("th");
            }
            writer.endElement("thead");
        }
    }

    protected void encodeOptionsAsTable(FacesContext context, SelectCheckboxMenu menu, List<SelectItem> selectItems, List<Column> columns) throws IOException {
        int idx = -1;
        int totalItems = selectItems.size();
        for (int i = 0; i < totalItems; ++i) {
            SelectItem selectItem = selectItems.get(i);
            if (selectItem instanceof SelectItemGroup) {
                SelectItemGroup selectItemGroup = (SelectItemGroup)selectItem;
                this.encodeTableOption(context, menu, (SelectItem)selectItemGroup, columns, idx, totalItems);
                for (SelectItem groupSelectItem : selectItemGroup.getSelectItems()) {
                    this.encodeTableOption(context, menu, groupSelectItem, columns, ++idx, totalItems);
                }
                continue;
            }
            this.encodeTableOption(context, menu, selectItem, columns, idx, totalItems);
        }
    }

    protected void encodeTableOption(FacesContext context, SelectCheckboxMenu menu, SelectItem selectItem, List<Column> columns, int index, int totalItems) throws IOException {
        Object rowStyleClass;
        ResponseWriter writer = context.getResponseWriter();
        boolean checked = false;
        String itemLabel = this.getOptionLabel(selectItem);
        String itemValueAsString = null;
        if (selectItem instanceof SelectItemGroup) {
            rowStyleClass = "ui-selectcheckboxmenu-item-group ui-selectcheckboxmenu-row ui-widget-content";
        } else {
            Object value;
            Object valuesArray;
            Converter converter = menu.getConverter();
            Object submittedValues = this.getSubmittedValues((UIComponent)menu);
            Object values = this.getValues((UIComponent)menu);
            if (submittedValues != null) {
                valuesArray = submittedValues;
                value = this.getOptionAsString(context, (UIComponent)menu, converter, selectItem.getValue());
            } else {
                valuesArray = values;
                value = selectItem.getValue();
            }
            checked = this.isSelected(context, (UIComponent)menu, value, valuesArray, converter);
            if (selectItem.isNoSelectionOption() && !checked) {
                return;
            }
            rowStyleClass = "ui-selectcheckboxmenu-item ui-selectcheckboxmenu-row ui-widget-content";
            rowStyleClass = (String)rowStyleClass + (checked ? " ui-selectcheckboxmenu-checked" : " ui-selectcheckboxmenu-unchecked");
            if (selectItem.isNoSelectionOption()) {
                rowStyleClass = (String)rowStyleClass + " ui-noselection-option";
            }
            if (selectItem.isDisabled()) {
                rowStyleClass = (String)rowStyleClass + " ui-state-disabled";
            }
            itemValueAsString = this.getOptionAsString(context, (UIComponent)menu, converter, selectItem.getValue());
            String var = menu.getVar();
            Object varValue = selectItem.getValue();
            context.getExternalContext().getRequestMap().put(var, varValue);
        }
        writer.startElement("tr", this.getSelectItemComponent(selectItem));
        writer.writeAttribute("class", rowStyleClass, null);
        writer.writeAttribute("data-label", (Object)itemLabel, null);
        if (itemValueAsString != null && menu.isMultiple()) {
            writer.writeAttribute("data-item-value", itemValueAsString, null);
        }
        if (selectItem.getDescription() != null) {
            writer.writeAttribute("title", (Object)selectItem.getDescription(), null);
        }
        if (selectItem instanceof SelectItemGroup) {
            int colspan = 1 + columns.size();
            writer.startElement("td", null);
            writer.writeAttribute("colspan", (Object)colspan, null);
            writer.writeText((Object)itemLabel, null);
            writer.endElement("td");
        } else {
            String uuid = UUID.randomUUID().toString();
            boolean disabled = selectItem.isDisabled() || menu.isDisabled();
            writer.startElement("td", null);
            this.encodeCheckbox(context, uuid, disabled, checked, selectItem.getDescription(), selectItem.getLabel(), index, totalItems);
            writer.endElement("td");
            for (int i = 0; i < columns.size(); ++i) {
                Column column = columns.get(i);
                if (!column.isRendered()) continue;
                String style = column.getStyle();
                String styleClass = column.getStyleClass();
                writer.startElement("td", null);
                if (style != null) {
                    writer.writeAttribute("style", (Object)style, null);
                }
                if (styleClass != null) {
                    writer.writeAttribute("class", (Object)styleClass, null);
                }
                this.encodeIndexedId(context, (UIComponent)column, index);
                writer.endElement("td");
            }
        }
        writer.endElement("tr");
    }

    protected void encodeScript(FacesContext context, SelectCheckboxMenu menu) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("SelectCheckboxMenu", menu).callback("onShow", "function()", menu.getOnShow()).callback("onHide", "function()", menu.getOnHide()).callback("onChange", "function()", menu.getOnchange()).attr("scrollHeight", this.getMaxScrollHeight(menu), null).attr("showHeader", menu.isShowHeader(), true).attr("updateLabel", menu.isUpdateLabel(), false).attr("labelSeparator", menu.getLabelSeparator(), ", ").attr("emptyLabel", menu.getEmptyLabel()).attr("selectedLabel", menu.getSelectedLabel(), null).attr("multiple", menu.isMultiple(), false).attr("dynamic", menu.isDynamic(), false).attr("renderPanelContentOnClient", menu.getVar() == null, false).attr("appendTo", SearchExpressionUtils.resolveOptionalClientIdForClientSide(context, (UIComponent)menu, menu.getAppendTo()));
        if (menu.isFilter()) {
            wb.attr("filter", true).attr("filterMatchMode", menu.getFilterMatchMode(), null).nativeAttr("filterFunction", menu.getFilterFunction(), null).attr("caseSensitive", menu.isCaseSensitive(), false).attr("filterPlaceholder", menu.getFilterPlaceholder(), null).attr("filterNormalize", menu.isFilterNormalize(), false);
        }
        wb.attr("panelStyle", menu.getPanelStyle(), null).attr("panelStyleClass", menu.getPanelStyleClass(), null);
        this.encodeClientBehaviors(context, (ClientBehaviorHolder)menu);
        wb.finish();
    }

    protected String getMaxScrollHeight(SelectCheckboxMenu menu) {
        try {
            return Integer.parseInt(menu.getScrollHeight()) + "px";
        }
        catch (NumberFormatException e) {
            return menu.getScrollHeight();
        }
    }

    protected String getOptionLabel(SelectItem option) {
        String itemLabel = option.getLabel();
        return this.isValueBlank(itemLabel) ? "&nbsp;" : itemLabel;
    }

    @Override
    protected String getSubmitParam(FacesContext context, UISelectMany selectMany) {
        return selectMany.getClientId(context);
    }

    protected void encodeKeyboardTarget(FacesContext context, SelectCheckboxMenu menu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String inputId = menu.getClientId(context) + "_focus";
        String tabindex = menu.isDisabled() ? "-1" : Objects.toString(menu.getTabindex(), "0");
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-helper-hidden-accessible", null);
        writer.startElement("input", (UIComponent)menu);
        writer.writeAttribute("id", (Object)inputId, null);
        writer.writeAttribute("name", (Object)inputId, null);
        writer.writeAttribute("type", (Object)"text", null);
        writer.writeAttribute("tabindex", (Object)tabindex, null);
        this.renderARIACombobox(context, (UIInput)menu);
        this.renderAccessibilityAttributes(context, (UIInput)menu);
        writer.endElement("input");
        writer.endElement("div");
    }

    protected void encodeCheckbox(FacesContext context, String id, boolean disabled, boolean checked, String title, String ariaLabel, int index, int totalItems) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Object boxClass = "ui-chkbox-box ui-widget ui-corner-all ui-state-default";
        if (disabled) {
            boxClass = (String)boxClass + " ui-state-disabled";
        }
        if (checked) {
            boxClass = (String)boxClass + " ui-state-active";
        }
        String iconClass = checked ? "ui-chkbox-icon ui-icon ui-icon-check ui-c" : "ui-chkbox-icon ui-icon ui-icon-blank ui-c";
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-chkbox ui-widget", null);
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-helper-hidden-accessible", null);
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"checkbox", null);
        if (id != null) {
            writer.writeAttribute("id", (Object)id, null);
        }
        if (checked) {
            writer.writeAttribute("checked", (Object)"checked", null);
        }
        if (title != null) {
            writer.writeAttribute("title", (Object)title, null);
        }
        if (ariaLabel != null) {
            writer.writeAttribute("aria-label", (Object)ariaLabel, null);
        }
        if (totalItems > -1) {
            writer.writeAttribute("class", (Object)"ui-selectcheckboxmenu-item-input", null);
            writer.writeAttribute("aria-selected", (Object)String.valueOf(checked), null);
            writer.writeAttribute("role", (Object)"option", null);
            writer.writeAttribute("aria-setsize", (Object)totalItems, null);
            writer.writeAttribute("aria-posinset", (Object)(index + 1), null);
        }
        writer.endElement("input");
        writer.endElement("div");
        writer.startElement("div", null);
        writer.writeAttribute("class", boxClass, null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)iconClass, null);
        writer.endElement("span");
        writer.endElement("div");
        writer.endElement("div");
    }
}

