/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.selectmanybutton;

import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIInput;
import jakarta.faces.component.UINamingContainer;
import jakarta.faces.component.UISelectMany;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.convert.Converter;
import jakarta.faces.convert.ConverterException;
import jakarta.faces.model.SelectItem;
import java.io.IOException;
import java.util.List;
import org.primefaces.component.selectmanybutton.SelectManyButton;
import org.primefaces.renderkit.SelectManyRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.WidgetBuilder;

public class SelectManyButtonRenderer
extends SelectManyRenderer {
    @Override
    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        Object renderer = ComponentUtils.getUnwrappedRenderer(context, "jakarta.faces.SelectMany", "jakarta.faces.Checkbox");
        return renderer.getConvertedValue(context, component, submittedValue);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        SelectManyButton button = (SelectManyButton)component;
        this.encodeMarkup(context, button);
        this.encodeScript(context, button);
    }

    protected void encodeMarkup(FacesContext context, SelectManyButton button) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = button.getClientId(context);
        List<SelectItem> selectItems = this.getSelectItems(context, (UIInput)button);
        int selectItemsSize = selectItems.size();
        String style = button.getStyle();
        Object styleClass = this.createStyleClass((UIInput)button, "ui-selectmanybutton ui-buttonset ui-widget ui-corner-all");
        styleClass = (String)styleClass + " ui-buttonset-" + selectItemsSize;
        writer.startElement("div", (UIComponent)button);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", styleClass, "styleClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        this.encodeSelectItems(context, button, selectItems);
        writer.endElement("div");
    }

    protected void encodeSelectItems(FacesContext context, SelectManyButton button, List<SelectItem> selectItems) throws IOException {
        Converter converter = button.getConverter();
        Object values = this.getValues((UIComponent)button);
        Object submittedValues = this.getSubmittedValues((UIComponent)button);
        for (int i = 0; i < selectItems.size(); ++i) {
            SelectItem selectItem = selectItems.get(i);
            this.encodeOption(context, (UIInput)button, values, submittedValues, converter, selectItem, i, selectItems.size());
        }
    }

    protected void encodeOption(FacesContext context, UIInput component, Object values, Object submittedValues, Converter converter, SelectItem option, int idx, int size) throws IOException {
        Object itemValue;
        Object valuesArray;
        ResponseWriter writer = context.getResponseWriter();
        SelectManyButton button = (SelectManyButton)component;
        String itemValueAsString = this.getOptionAsString(context, (UIComponent)component, converter, option.getValue());
        String name = button.getClientId(context);
        String id = name + UINamingContainer.getSeparatorChar((FacesContext)context) + idx;
        boolean disabled = option.isDisabled() || button.isDisabled();
        String tabindex = button.getTabindex();
        if (submittedValues != null) {
            valuesArray = submittedValues;
            itemValue = itemValueAsString;
        } else {
            valuesArray = values;
            itemValue = option.getValue();
        }
        boolean selected = this.isSelected(context, (UIComponent)component, itemValue, valuesArray, converter);
        if (option.isNoSelectionOption() && values != null && !selected) {
            return;
        }
        Object buttonStyle = "ui-button ui-widget ui-state-default ui-button-text-only";
        if (size == 0) {
            buttonStyle = (String)buttonStyle + " ui-corner-all";
        } else if (idx == 0) {
            buttonStyle = (String)buttonStyle + " ui-corner-left";
        } else if (idx == size - 1) {
            buttonStyle = (String)buttonStyle + " ui-corner-right";
        }
        buttonStyle = selected ? (String)buttonStyle + " ui-state-active" : buttonStyle;
        buttonStyle = disabled ? (String)buttonStyle + " ui-state-disabled" : buttonStyle;
        writer.startElement("div", this.getSelectItemComponent(option));
        writer.writeAttribute("class", buttonStyle, null);
        if (option.getDescription() != null) {
            writer.writeAttribute("title", (Object)option.getDescription(), null);
        }
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("name", (Object)name, null);
        writer.writeAttribute("type", (Object)"checkbox", null);
        writer.writeAttribute("value", (Object)itemValueAsString, null);
        writer.writeAttribute("class", (Object)"ui-helper-hidden-accessible", null);
        writer.writeAttribute("aria-label", (Object)option.getLabel(), null);
        this.renderOnchange(context, (UIComponent)button);
        if (selected) {
            writer.writeAttribute("checked", (Object)"checked", null);
        }
        if (tabindex != null) {
            writer.writeAttribute("tabindex", (Object)tabindex, null);
        }
        this.renderAccessibilityAttributes(context, (UIInput)button);
        writer.endElement("input");
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-button-text ui-c", null);
        if (option.isEscape()) {
            writer.writeText((Object)option.getLabel(), "itemLabel");
        } else {
            writer.write(option.getLabel());
        }
        writer.endElement("span");
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, SelectManyButton button) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("SelectManyButton", button).finish();
    }

    @Override
    protected String getSubmitParam(FacesContext context, UISelectMany selectMany) {
        return selectMany.getClientId(context);
    }
}

