/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.selectmanycheckbox;

import jakarta.faces.FacesException;
import jakarta.faces.component.EditableValueHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIInput;
import jakarta.faces.component.UINamingContainer;
import jakarta.faces.component.UISelectMany;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.convert.Converter;
import jakarta.faces.convert.ConverterException;
import jakarta.faces.model.SelectItem;
import jakarta.faces.model.SelectItemGroup;
import java.io.IOException;
import java.util.List;
import org.primefaces.component.selectmanycheckbox.SelectManyCheckbox;
import org.primefaces.renderkit.SelectManyRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.FacetUtils;
import org.primefaces.util.GridLayoutUtils;
import org.primefaces.util.LangUtils;
import org.primefaces.util.WidgetBuilder;
import org.primefaces.validate.ClientValidator;

public class SelectManyCheckboxRenderer
extends SelectManyRenderer {
    @Override
    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        Object renderer = ComponentUtils.getUnwrappedRenderer(context, "jakarta.faces.SelectMany", "jakarta.faces.Checkbox");
        return renderer.getConvertedValue(context, component, submittedValue);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        SelectManyCheckbox checkbox = (SelectManyCheckbox)component;
        this.encodeMarkup(context, checkbox);
        this.encodeScript(context, checkbox);
    }

    protected void encodeMarkup(FacesContext context, SelectManyCheckbox checkbox) throws IOException {
        boolean custom;
        ResponseWriter writer = context.getResponseWriter();
        String layout = checkbox.getLayout();
        if (LangUtils.isEmpty(layout)) {
            String string = layout = FacetUtils.shouldRenderFacet(checkbox.getFacet("custom")) ? "custom" : "lineDirection";
        }
        if (custom = "custom".equals(layout)) {
            writer.startElement("span", (UIComponent)checkbox);
            writer.writeAttribute("id", (Object)checkbox.getClientId(context), "id");
            writer.writeAttribute("class", (Object)"ui-helper-hidden", null);
            this.renderARIARequired(context, (UIInput)checkbox);
            this.encodeCustomLayout(context, checkbox);
            writer.endElement("span");
        } else if ("grid".equals(layout)) {
            this.encodeLegacyTabularLayout(context, checkbox, layout);
        } else {
            this.encodeResponsiveLayout(context, checkbox, layout);
        }
    }

    protected void encodeScript(FacesContext context, SelectManyCheckbox checkbox) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        String layout = checkbox.getLayout();
        boolean custom = layout != null && "custom".equals(layout);
        wb.init("SelectManyCheckbox", checkbox).attr("custom", custom, false).finish();
    }

    protected void encodeResponsiveLayout(FacesContext context, SelectManyCheckbox checkbox, String layout) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = checkbox.getClientId(context);
        String style = checkbox.getStyle();
        boolean flex = ComponentUtils.isFlex(context, checkbox);
        if (flex) {
            layout = "responsive";
        }
        boolean lineDirection = "lineDirection".equals(layout);
        String styleClass = this.getStyleClassBuilder(context).add(lineDirection, "layout-line-direction").add("ui-selectmanycheckbox ui-widget").add(GridLayoutUtils.getResponsiveClass(flex)).add(checkbox.getStyleClass()).build();
        int columns = checkbox.getColumns();
        if (lineDirection || "pageDirection".equals(layout)) {
            columns = 1;
        }
        if (columns <= 0) {
            throw new FacesException("The value of columns attribute must be greater than zero.");
        }
        writer.startElement("div", (UIComponent)checkbox);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        this.renderARIARequired(context, (UIInput)checkbox);
        List<SelectItem> selectItems = this.getSelectItems(context, (UIInput)checkbox);
        Converter converter = checkbox.getConverter();
        Object values = this.getValues((UIComponent)checkbox);
        Object submittedValues = this.getSubmittedValues((UIComponent)checkbox);
        int idx = 0;
        int groupIdx = 0;
        int colMod = 0;
        for (int i = 0; i < selectItems.size(); ++i) {
            SelectItem selectItem = selectItems.get(i);
            if (selectItem instanceof SelectItemGroup) {
                writer.startElement("div", null);
                writer.writeAttribute("class", (Object)"ui-selectmanycheckbox-responsive-group", null);
                this.encodeGroupLabel(context, checkbox, (SelectItemGroup)selectItem);
                writer.endElement("div");
                if (flex) {
                    writer.startElement("div", null);
                    writer.writeAttribute("class", (Object)GridLayoutUtils.getFlexGridClass(true), null);
                }
                for (SelectItem childSelectItem : ((SelectItemGroup)selectItem).getSelectItems()) {
                    colMod = idx % columns;
                    if (!flex && !lineDirection && colMod == 0) {
                        writer.startElement("div", null);
                        writer.writeAttribute("class", (Object)GridLayoutUtils.getFlexGridClass(false), null);
                    }
                    writer.startElement("div", null);
                    writer.writeAttribute("class", (Object)GridLayoutUtils.getColumnClass(flex, columns), null);
                    this.encodeOption(context, (UIInput)checkbox, values, submittedValues, converter, childSelectItem, ++groupIdx);
                    writer.endElement("div");
                    colMod = ++idx % columns;
                    if (flex || lineDirection || colMod != 0) continue;
                    writer.endElement("div");
                }
                if (flex || !flex && idx != 0 && idx % columns != 0) {
                    writer.endElement("div");
                }
                idx = 0;
                continue;
            }
            colMod = idx % columns;
            if (flex && idx == 0 || !flex && !lineDirection && colMod == 0) {
                writer.startElement("div", null);
                writer.writeAttribute("class", (Object)GridLayoutUtils.getFlexGridClass(flex), null);
            }
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)GridLayoutUtils.getColumnClass(flex, columns), null);
            this.encodeOption(context, (UIInput)checkbox, values, submittedValues, converter, selectItem, idx);
            writer.endElement("div");
            colMod = ++idx % columns;
            if (flex || lineDirection || colMod != 0) continue;
            writer.endElement("div");
        }
        if (idx != 0 && (flex || !flex && idx % columns != 0)) {
            writer.endElement("div");
        }
        writer.endElement("div");
    }

    @Deprecated
    protected void encodeLegacyTabularLayout(FacesContext context, SelectManyCheckbox checkbox, String layout) throws IOException {
        String clientId = checkbox.getClientId(context);
        this.logDevelopmentWarning(context, "Table layout is deprecated and will be removed in future release. Please switch to responsive layout. ClientId: " + clientId);
        ResponseWriter writer = context.getResponseWriter();
        String style = checkbox.getStyle();
        Object styleClass = checkbox.getStyleClass();
        styleClass = styleClass == null ? "ui-selectmanycheckbox ui-widget" : "ui-selectmanycheckbox ui-widget " + (String)styleClass;
        writer.startElement("table", (UIComponent)checkbox);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("role", (Object)"presentation", null);
        writer.writeAttribute("class", styleClass, "styleClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        this.renderARIARequired(context, (UIInput)checkbox);
        this.encodeSelectItems(context, checkbox, layout);
        writer.endElement("table");
    }

    protected void encodeOptionInput(FacesContext context, SelectManyCheckbox checkbox, String id, String name, boolean checked, boolean disabled, String value) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String tabindex = checkbox.getTabindex();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-helper-hidden-accessible", null);
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("name", (Object)name, null);
        writer.writeAttribute("type", (Object)"checkbox", null);
        writer.writeAttribute("value", (Object)value, null);
        if (tabindex != null) {
            writer.writeAttribute("tabindex", (Object)tabindex, null);
        }
        this.renderOnchange(context, (UIComponent)checkbox);
        if (checked) {
            writer.writeAttribute("checked", (Object)"checked", null);
        }
        if (disabled) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        this.renderValidationMetadata(context, (EditableValueHolder)checkbox, new ClientValidator[0]);
        writer.endElement("input");
        writer.endElement("div");
    }

    protected void encodeOptionLabel(FacesContext context, SelectManyCheckbox checkbox, String containerClientId, SelectItem option, boolean disabled) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("label", null);
        if (disabled) {
            writer.writeAttribute("class", (Object)"ui-state-disabled", null);
        }
        writer.writeAttribute("for", (Object)containerClientId, null);
        if (option.getDescription() != null) {
            writer.writeAttribute("title", (Object)option.getDescription(), null);
        }
        if (option.isEscape()) {
            writer.writeText((Object)option.getLabel(), null);
        } else {
            writer.write(option.getLabel());
        }
        writer.endElement("label");
    }

    protected void encodeGroupLabel(FacesContext context, SelectManyCheckbox checkbox, SelectItemGroup group) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-selectmanycheckbox-item-group", null);
        if (group.isEscape()) {
            writer.writeText((Object)group.getLabel(), null);
        } else {
            writer.write(group.getLabel());
        }
        writer.endElement("span");
    }

    protected void encodeOptionOutput(FacesContext context, SelectManyCheckbox checkbox, boolean checked, boolean disabled) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Object boxClass = this.createStyleClass((UIInput)checkbox, null, "ui-chkbox-box ui-widget ui-corner-all ui-state-default");
        boxClass = checked ? (String)boxClass + " ui-state-active" : boxClass;
        boxClass = disabled ? (String)boxClass + " ui-state-disabled" : boxClass;
        String iconClass = checked ? "ui-chkbox-icon ui-icon ui-icon-check ui-c" : "ui-chkbox-icon ui-icon ui-icon-blank ui-c";
        writer.startElement("div", null);
        writer.writeAttribute("class", boxClass, null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)iconClass, null);
        writer.endElement("span");
        writer.endElement("div");
    }

    @Deprecated
    protected void encodeSelectItems(FacesContext context, SelectManyCheckbox checkbox, String layout) throws IOException {
        if ("lineDirection".equals(layout)) {
            this.encodeLineLayout(context, checkbox);
        } else if ("pageDirection".equals(layout)) {
            this.encodePageLayout(context, checkbox);
        } else if ("grid".equals(layout)) {
            this.encodeGridLayout(context, checkbox);
        } else {
            throw new FacesException("Invalid '" + layout + "' type for component '" + checkbox.getClientId(context) + "'.");
        }
    }

    @Deprecated
    protected void encodeLineLayout(FacesContext context, SelectManyCheckbox checkbox) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        List<SelectItem> selectItems = this.getSelectItems(context, (UIInput)checkbox);
        Converter converter = checkbox.getConverter();
        Object values = this.getValues((UIComponent)checkbox);
        Object submittedValues = this.getSubmittedValues((UIComponent)checkbox);
        writer.startElement("tr", null);
        for (int i = 0; i < selectItems.size(); ++i) {
            SelectItem selectItem = selectItems.get(i);
            if (selectItem instanceof SelectItemGroup) {
                writer.startElement("td", null);
                this.encodeGroupLabel(context, checkbox, (SelectItemGroup)selectItem);
                writer.endElement("td");
                continue;
            }
            writer.startElement("td", null);
            this.encodeOption(context, (UIInput)checkbox, values, submittedValues, converter, selectItem, i);
            writer.endElement("td");
        }
        writer.endElement("tr");
    }

    @Deprecated
    protected void encodePageLayout(FacesContext context, SelectManyCheckbox checkbox) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        List<SelectItem> selectItems = this.getSelectItems(context, (UIInput)checkbox);
        Converter converter = checkbox.getConverter();
        Object values = this.getValues((UIComponent)checkbox);
        Object submittedValues = this.getSubmittedValues((UIComponent)checkbox);
        int idx = 0;
        for (int i = 0; i < selectItems.size(); ++i) {
            SelectItem selectItem = selectItems.get(i);
            if (selectItem instanceof SelectItemGroup) {
                writer.startElement("tr", null);
                writer.startElement("td", null);
                this.encodeGroupLabel(context, checkbox, (SelectItemGroup)selectItem);
                writer.endElement("td");
                writer.endElement("tr");
                ++idx;
                for (SelectItem childSelectItem : ((SelectItemGroup)selectItem).getSelectItems()) {
                    writer.startElement("tr", null);
                    writer.startElement("td", null);
                    this.encodeOption(context, (UIInput)checkbox, values, submittedValues, converter, childSelectItem, idx);
                    writer.endElement("td");
                    writer.endElement("tr");
                    ++idx;
                }
                continue;
            }
            writer.startElement("tr", null);
            writer.startElement("td", null);
            this.encodeOption(context, (UIInput)checkbox, values, submittedValues, converter, selectItem, idx);
            writer.endElement("td");
            writer.endElement("tr");
            ++idx;
        }
    }

    @Deprecated
    protected void encodeGridLayout(FacesContext context, SelectManyCheckbox checkbox) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        List<SelectItem> selectItems = this.getSelectItems(context, (UIInput)checkbox);
        Converter converter = checkbox.getConverter();
        Object values = this.getValues((UIComponent)checkbox);
        Object submittedValues = this.getSubmittedValues((UIComponent)checkbox);
        int columns = checkbox.getColumns();
        if (columns <= 0) {
            throw new FacesException("The value of columns attribute must be greater than zero.");
        }
        int idx = 0;
        int colMod = 0;
        for (int i = 0; i < selectItems.size(); ++i) {
            SelectItem selectItem = selectItems.get(i);
            colMod = idx % columns;
            if (colMod == 0) {
                writer.startElement("tr", null);
            }
            writer.startElement("td", null);
            this.encodeOption(context, (UIInput)checkbox, values, submittedValues, converter, selectItem, idx);
            writer.endElement("td");
            colMod = ++idx % columns;
            if (colMod != 0) continue;
            writer.endElement("tr");
        }
        if (colMod != 0) {
            writer.endElement("tr");
        }
    }

    protected void encodeCustomLayout(FacesContext context, SelectManyCheckbox checkbox) throws IOException {
        List<SelectItem> selectItems = this.getSelectItems(context, (UIInput)checkbox);
        Converter converter = checkbox.getConverter();
        Object values = this.getValues((UIComponent)checkbox);
        Object submittedValues = this.getSubmittedValues((UIComponent)checkbox);
        int idx = 0;
        for (int i = 0; i < selectItems.size(); ++i) {
            Object itemValue;
            Object valuesArray;
            SelectItem selectItem = selectItems.get(i);
            String itemValueAsString = this.getOptionAsString(context, (UIComponent)checkbox, converter, selectItem.getValue());
            String name = checkbox.getClientId(context);
            String id = name + UINamingContainer.getSeparatorChar((FacesContext)context) + idx;
            if (submittedValues != null) {
                valuesArray = submittedValues;
                itemValue = itemValueAsString;
            } else {
                valuesArray = values;
                itemValue = selectItem.getValue();
            }
            boolean selected = this.isSelected(context, (UIComponent)checkbox, itemValue, valuesArray, converter);
            if (selectItem.isNoSelectionOption() && values != null && !selected) {
                return;
            }
            boolean disabled = selectItem.isDisabled() || checkbox.isDisabled();
            this.encodeOptionInput(context, checkbox, id, name, selected, disabled, itemValueAsString);
            ++idx;
        }
    }

    protected void encodeOption(FacesContext context, UIInput component, Object values, Object submittedValues, Converter converter, SelectItem option, int idx) throws IOException {
        Object itemValue;
        Object valuesArray;
        boolean disabled;
        ResponseWriter writer = context.getResponseWriter();
        SelectManyCheckbox checkbox = (SelectManyCheckbox)component;
        String itemValueAsString = this.getOptionAsString(context, (UIComponent)component, converter, option.getValue());
        String name = checkbox.getClientId(context);
        String id = name + UINamingContainer.getSeparatorChar((FacesContext)context) + idx;
        boolean bl = disabled = option.isDisabled() || checkbox.isDisabled();
        if (submittedValues != null) {
            valuesArray = submittedValues;
            itemValue = itemValueAsString;
        } else {
            valuesArray = values;
            itemValue = option.getValue();
        }
        boolean selected = this.isSelected(context, (UIComponent)component, itemValue, valuesArray, converter);
        if (option.isNoSelectionOption() && values != null && !selected) {
            return;
        }
        writer.startElement("div", this.getSelectItemComponent(option));
        writer.writeAttribute("class", (Object)"ui-chkbox ui-widget", null);
        this.encodeOptionInput(context, checkbox, id, name, selected, disabled, itemValueAsString);
        this.encodeOptionOutput(context, checkbox, selected, disabled);
        writer.endElement("div");
        this.encodeOptionLabel(context, checkbox, id, option, disabled);
    }

    @Override
    protected String getSubmitParam(FacesContext context, UISelectMany selectMany) {
        return selectMany.getClientId(context);
    }

    @Override
    public String getHighlighter() {
        return "manychkbox";
    }

    @Override
    protected boolean isGrouped() {
        return true;
    }
}

