/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.selectmanymenu;

import jakarta.faces.component.EditableValueHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIInput;
import jakarta.faces.component.UISelectMany;
import jakarta.faces.component.behavior.ClientBehaviorHolder;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.convert.Converter;
import jakarta.faces.convert.ConverterException;
import jakarta.faces.model.SelectItem;
import java.io.IOException;
import java.util.List;
import org.primefaces.component.column.Column;
import org.primefaces.component.selectmanymenu.SelectManyMenu;
import org.primefaces.renderkit.RendererUtils;
import org.primefaces.renderkit.SelectManyRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.HTML;
import org.primefaces.util.WidgetBuilder;
import org.primefaces.validate.ClientValidator;

public class SelectManyMenuRenderer
extends SelectManyRenderer {
    @Override
    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        Object renderer = ComponentUtils.getUnwrappedRenderer(context, "jakarta.faces.SelectMany", "jakarta.faces.Menu");
        return renderer.getConvertedValue(context, component, submittedValue);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        SelectManyMenu menu = (SelectManyMenu)component;
        this.encodeMarkup(context, menu);
        this.encodeScript(context, menu);
    }

    protected void encodeMarkup(FacesContext context, SelectManyMenu menu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = menu.getClientId(context);
        List<SelectItem> selectItems = this.getSelectItems(context, (UIInput)menu);
        String style = menu.getStyle();
        String styleClass = this.createStyleClass((UIInput)menu, "ui-selectmanymenu ui-inputfield ui-widget ui-widget-content ui-corner-all");
        writer.startElement("div", (UIComponent)menu);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        if (menu.isFilter()) {
            this.encodeFilter(context, menu);
        }
        this.encodeInput(context, menu, clientId, selectItems);
        this.encodeList(context, menu, selectItems);
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, SelectManyMenu menu) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("SelectManyMenu", menu).attr("disabled", menu.isDisabled(), false).attr("showCheckbox", menu.isShowCheckbox(), false).attr("metaKeySelection", menu.isMetaKeySelection(), true);
        if (menu.isFilter()) {
            wb.attr("filter", true).attr("filterMatchMode", menu.getFilterMatchMode(), null).nativeAttr("filterFunction", menu.getFilterFunction(), null).attr("caseSensitive", menu.isCaseSensitive(), false).attr("filterNormalize", menu.isFilterNormalize(), false);
        }
        this.encodeClientBehaviors(context, (ClientBehaviorHolder)menu);
        wb.finish();
    }

    protected void encodeInput(FacesContext context, SelectManyMenu menu, String clientId, List<SelectItem> selectItems) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String inputid = clientId + "_input";
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-helper-hidden-accessible", null);
        writer.startElement("select", null);
        writer.writeAttribute("id", (Object)inputid, "id");
        writer.writeAttribute("name", (Object)inputid, null);
        writer.writeAttribute("multiple", (Object)"multiple", null);
        writer.writeAttribute("size", (Object)"2", null);
        this.renderAccessibilityAttributes(context, (UIInput)menu);
        this.renderPassThruAttributes(context, (UIComponent)menu, HTML.TAB_INDEX);
        this.renderDomEvents(context, (UIComponent)menu, SelectManyMenu.DOM_EVENTS);
        this.renderValidationMetadata(context, (EditableValueHolder)menu, new ClientValidator[0]);
        this.encodeSelectItems(context, menu, selectItems);
        writer.endElement("select");
        writer.endElement("div");
    }

    protected void encodeList(FacesContext context, SelectManyMenu menu, List<SelectItem> selectItems) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Converter converter = menu.getConverter();
        Object values = this.getValues((UIComponent)menu);
        Object submittedValues = this.getSubmittedValues((UIComponent)menu);
        boolean customContent = menu.getVar() != null;
        boolean showCheckbox = menu.isShowCheckbox();
        writer.startElement("div", (UIComponent)menu);
        writer.writeAttribute("class", (Object)"ui-selectlistbox-listcontainer", null);
        writer.writeAttribute("style", (Object)("height:" + this.calculateWrapperHeight(menu, this.countSelectItems(selectItems))), null);
        if (customContent) {
            writer.startElement("table", null);
            writer.writeAttribute("class", (Object)"ui-selectlistbox-list", null);
            writer.writeAttribute("role", (Object)"listbox", null);
            writer.writeAttribute("aria-multiselectable", (Object)("" + menu.isMetaKeySelection()), null);
            writer.startElement("tbody", null);
            for (int i = 0; i < selectItems.size(); ++i) {
                SelectItem selectItem = selectItems.get(i);
                this.encodeItem(context, menu, selectItem, values, submittedValues, converter, customContent, showCheckbox);
            }
            writer.endElement("tbody");
            writer.endElement("table");
        } else {
            writer.startElement("ul", null);
            writer.writeAttribute("class", (Object)"ui-selectlistbox-list", null);
            writer.writeAttribute("role", (Object)"listbox", null);
            writer.writeAttribute("aria-multiselectable", (Object)("" + menu.isMetaKeySelection()), null);
            for (int i = 0; i < selectItems.size(); ++i) {
                SelectItem selectItem = selectItems.get(i);
                this.encodeItem(context, menu, selectItem, values, submittedValues, converter, customContent, showCheckbox);
            }
            writer.endElement("ul");
        }
        writer.endElement("div");
    }

    protected void encodeItem(FacesContext context, SelectManyMenu menu, SelectItem option, Object values, Object submittedValues, Converter converter, boolean customContent, boolean showCheckbox) throws IOException {
        Object itemValue;
        Object valuesArray;
        Object itemClass;
        ResponseWriter writer = context.getResponseWriter();
        String itemValueAsString = this.getOptionAsString(context, (UIComponent)menu, converter, option.getValue());
        boolean disabled = option.isDisabled() || menu.isDisabled();
        Object object = itemClass = disabled ? "ui-selectlistbox-item ui-corner-all ui-state-disabled" : "ui-selectlistbox-item ui-corner-all";
        if (submittedValues != null) {
            valuesArray = submittedValues;
            itemValue = itemValueAsString;
        } else {
            valuesArray = values;
            itemValue = option.getValue();
        }
        boolean selected = this.isSelected(context, (UIComponent)menu, itemValue, valuesArray, converter);
        if (option.isNoSelectionOption() && values != null && !selected) {
            return;
        }
        if (selected) {
            itemClass = (String)itemClass + " ui-state-highlight";
        }
        if (customContent) {
            String var = menu.getVar();
            context.getExternalContext().getRequestMap().put(var, option.getValue());
            writer.startElement("tr", this.getSelectItemComponent(option));
            writer.writeAttribute("class", itemClass, null);
            writer.writeAttribute("tabindex", (Object)"0", null);
            writer.writeAttribute("role", (Object)"option", null);
            writer.writeAttribute("aria-label", (Object)option.getLabel(), null);
            writer.writeAttribute("aria-disabled", (Object)("" + option.isDisabled()), null);
            writer.writeAttribute("aria-selected", (Object)("" + selected), null);
            if (option.getDescription() != null) {
                writer.writeAttribute("title", (Object)option.getDescription(), null);
            }
            if (showCheckbox) {
                writer.startElement("td", null);
                writer.writeAttribute("class", (Object)"ui-selectlistbox-chkbox", "styleClass");
                RendererUtils.encodeCheckbox(context, selected);
                writer.endElement("td");
            }
            for (UIComponent child : menu.getChildren()) {
                if (!(child instanceof Column) || !child.isRendered()) continue;
                String style = ((Column)child).getStyle();
                String styleClass = ((Column)child).getStyleClass();
                writer.startElement("td", null);
                if (styleClass != null) {
                    writer.writeAttribute("class", (Object)styleClass, "styleClass");
                }
                if (style != null) {
                    writer.writeAttribute("style", (Object)style, "style");
                }
                this.renderChildren(context, child);
                writer.endElement("td");
            }
            writer.endElement("tr");
        } else {
            writer.startElement("li", this.getSelectItemComponent(option));
            writer.writeAttribute("class", itemClass, null);
            writer.writeAttribute("tabindex", (Object)"0", null);
            writer.writeAttribute("role", (Object)"option", null);
            writer.writeAttribute("aria-label", (Object)option.getLabel(), null);
            writer.writeAttribute("aria-disabled", (Object)("" + option.isDisabled()), null);
            writer.writeAttribute("aria-selected", (Object)("" + selected), null);
            if (showCheckbox) {
                RendererUtils.encodeCheckbox(context, selected);
            }
            if (option.isEscape()) {
                writer.writeText((Object)option.getLabel(), null);
            } else {
                writer.write(option.getLabel());
            }
            writer.endElement("li");
        }
    }

    protected void encodeSelectItems(FacesContext context, SelectManyMenu menu, List<SelectItem> selectItems) throws IOException {
        Converter converter = menu.getConverter();
        Object values = this.getValues((UIComponent)menu);
        Object submittedValues = this.getSubmittedValues((UIComponent)menu);
        for (int i = 0; i < selectItems.size(); ++i) {
            SelectItem selectItem = selectItems.get(i);
            this.encodeOption(context, menu, selectItem, values, submittedValues, converter);
        }
    }

    protected void encodeOption(FacesContext context, SelectManyMenu menu, SelectItem option, Object values, Object submittedValues, Converter converter) throws IOException {
        Object itemValue;
        Object valuesArray;
        boolean disabled;
        ResponseWriter writer = context.getResponseWriter();
        String itemValueAsString = this.getOptionAsString(context, (UIComponent)menu, converter, option.getValue());
        boolean bl = disabled = option.isDisabled() || menu.isDisabled();
        if (submittedValues != null) {
            valuesArray = submittedValues;
            itemValue = itemValueAsString;
        } else {
            valuesArray = values;
            itemValue = option.getValue();
        }
        boolean selected = this.isSelected(context, (UIComponent)menu, itemValue, valuesArray, converter);
        if (option.isNoSelectionOption() && values != null && !selected) {
            return;
        }
        writer.startElement("option", this.getSelectItemComponent(option));
        writer.writeAttribute("value", (Object)itemValueAsString, null);
        if (disabled) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        if (selected) {
            writer.writeAttribute("selected", (Object)"selected", null);
        }
        if (option.isEscape()) {
            writer.writeText((Object)option.getLabel(), null);
        } else {
            writer.write(option.getLabel());
        }
        writer.endElement("option");
    }

    protected void encodeFilter(FacesContext context, SelectManyMenu menu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String id = menu.getClientId(context) + "_filter";
        boolean disabled = menu.isDisabled();
        String filterClass = disabled ? "ui-selectlistbox-filter ui-inputfield ui-widget ui-state-default ui-corner-all ui-state-disabled" : "ui-selectlistbox-filter ui-inputfield ui-widget ui-state-default ui-corner-all";
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-selectlistbox-filter-container", null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-icon ui-icon-search", id);
        writer.endElement("span");
        writer.startElement("input", null);
        writer.writeAttribute("class", (Object)filterClass, null);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("name", (Object)id, null);
        writer.writeAttribute("type", (Object)"text", null);
        writer.writeAttribute("autocomplete", (Object)"off", null);
        if (disabled) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        writer.endElement("input");
        writer.endElement("div");
    }

    protected String calculateWrapperHeight(SelectManyMenu menu, int itemSize) {
        int height = menu.getScrollHeight();
        if (height != Integer.MAX_VALUE) {
            return height + "px";
        }
        if (itemSize > 10) {
            return "200px";
        }
        return "auto";
    }

    @Override
    protected String getSubmitParam(FacesContext context, UISelectMany selectMany) {
        return selectMany.getClientId(context) + "_input";
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }

    @Override
    public String getHighlighter() {
        return "listbox";
    }
}

