/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.signature;

import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIInput;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import java.util.Map;
import org.primefaces.component.signature.Signature;
import org.primefaces.component.signature.SignatureBase;
import org.primefaces.renderkit.InputRenderer;
import org.primefaces.util.LangUtils;
import org.primefaces.util.WidgetBuilder;

public class SignatureRenderer
extends InputRenderer {
    public void decode(FacesContext context, UIComponent component) {
        String base64Value;
        Signature signature = (Signature)component;
        if (!this.shouldDecode((UIInput)signature)) {
            return;
        }
        Map params = context.getExternalContext().getRequestParameterMap();
        String value = (String)params.get(signature.getClientId(context) + "_value");
        signature.setSubmittedValue(value);
        String textValue = (String)params.get(signature.getClientId(context) + "_text");
        if (LangUtils.isNotBlank(textValue)) {
            signature.setTextValue(textValue);
        }
        if ((base64Value = (String)params.get(signature.getClientId(context) + "_base64")) != null) {
            signature.setBase64Value(base64Value);
        }
        this.decodeBehaviors(context, (UIComponent)signature);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        Signature signature = (Signature)component;
        this.encodeMarkup(facesContext, signature);
        this.encodeScript(facesContext, signature);
    }

    protected void encodeMarkup(FacesContext context, Signature signature) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = signature.getClientId(context);
        String style = signature.getStyle();
        String styleClass = this.getStyleClassBuilder(context).add("ui-inputfield ui-inputtextarea ui-widget ui-state-default ui-corner-all").add(signature.getStyleClass()).add(signature.isReadonly(), "ui-widget ui-widget-content ui-corner-all").add(signature.isDisabled(), "ui-state-disabled").add(!signature.isValid(), "ui-state-error").build();
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        this.encodeInputField(context, signature, clientId + "_value", signature.getValue());
        this.encodeInputField(context, signature, clientId + "_text", signature.getTextValue());
        if (signature.getValueExpression(SignatureBase.PropertyKeys.base64Value.toString()) != null) {
            this.encodeInputField(context, signature, clientId + "_base64", null);
        }
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, Signature signature) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("Signature", signature).attr("background", signature.getBackgroundColor(), null).attr("color", signature.getColor(), null).attr("thickness", signature.getThickness(), 2).attr("readonly", signature.isReadonly(), false).attr("guideline", signature.isGuideline(), false).attr("guidelineColor", signature.getGuidelineColor(), null).attr("guidelineOffset", signature.getGuidelineOffset(), 25).attr("guidelineIndent", signature.getGuidelineIndent(), 10).attr("fontFamily", signature.getFontFamily(), null).attr("fontSize", signature.getFontSize(), 40).attr("ariaLabel", signature.getAriaLabel(), null).attr("ariaLabelledBy", signature.getLabelledBy(), null).attr("tabindex", signature.getTabindex(), "0").callback("onchange", "function()", signature.getOnchange());
        if (signature.getValueExpression(SignatureBase.PropertyKeys.base64Value.toString()) != null) {
            wb.attr("base64", true);
        }
        wb.finish();
    }

    protected void encodeInputField(FacesContext context, Signature signature, String name, Object value) throws IOException {
        String valueToRender = null;
        if (value != null) {
            valueToRender = value.toString();
        }
        this.renderHiddenInput(context, name, valueToRender, this.isDisabled((UIInput)signature));
    }
}

