/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.slider;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import org.primefaces.component.api.InputHolder;
import org.primefaces.component.slider.Slider;
import org.primefaces.expression.SearchExpressionUtils;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.WidgetBuilder;

public class SliderRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        this.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Slider slider = (Slider)component;
        this.encodeMarkup(context, slider);
        this.encodeScript(context, slider);
    }

    protected void encodeMarkup(FacesContext context, Slider slider) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = slider.getClientId(context);
        writer.startElement("div", (UIComponent)slider);
        writer.writeAttribute("id", (Object)clientId, "id");
        if (slider.getStyle() != null) {
            writer.writeAttribute("style", (Object)slider.getStyle(), null);
        }
        if (slider.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)slider.getStyleClass(), null);
        }
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, Slider slider) throws IOException {
        String range = slider.getRange();
        UIComponent output = this.getTarget(context, slider, slider.getDisplay());
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("Slider", slider);
        if ("true".equals(range)) {
            String inputMaxValue;
            String[] inputIds = slider.getFor().split(",");
            UIComponent inputMin = this.getTarget(context, slider, inputIds[0]);
            UIComponent inputMax = this.getTarget(context, slider, inputIds[1]);
            String inputMinValue = ComponentUtils.getValueToRender(context, inputMin);
            if (inputMinValue == null) {
                inputMinValue = "";
            }
            if ((inputMaxValue = ComponentUtils.getValueToRender(context, inputMax)) == null) {
                inputMaxValue = "";
            }
            wb.attr("input", inputMin.getClientId(context) + "," + inputMax.getClientId(context)).append(",values:[").append(inputMinValue).append(",").append(inputMaxValue).append("]");
        } else {
            UIComponent input = this.getTarget(context, slider, slider.getFor());
            String inputClientId = input instanceof InputHolder ? ((InputHolder)input).getInputClientId() : input.getClientId(context);
            wb.attr("value", ComponentUtils.getValueToRender(context, input)).attr("input", inputClientId);
        }
        wb.attr("min", slider.getMinValue()).attr("max", slider.getMaxValue()).attr("animate", slider.isAnimate()).attr("step", slider.getStep()).attr("orientation", slider.getType()).attr("disabled", slider.isDisabled(), false).attr("displayTemplate", slider.getDisplayTemplate(), null).attr("touchable", ComponentUtils.isTouchable(context, slider), true).callback("onSlideStart", "function(event,ui)", slider.getOnSlideStart()).callback("onSlide", "function(event,ui)", slider.getOnSlide()).callback("onSlideEnd", "function(event,ui)", slider.getOnSlideEnd());
        switch (range) {
            case "true": 
            case "false": {
                wb.attr("range", Boolean.valueOf(range));
                break;
            }
            default: {
                wb.attr("range", range);
            }
        }
        if (output != null) {
            wb.attr("display", output.getClientId(context));
        }
        this.encodeClientBehaviors(context, slider);
        wb.finish();
    }

    protected UIComponent getTarget(FacesContext context, Slider slider, String target) {
        if (target == null) {
            return null;
        }
        UIComponent targetComponent = SearchExpressionUtils.contextlessResolveComponent(context, (UIComponent)slider, target);
        return targetComponent;
    }
}

