/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.tabview;

import jakarta.faces.FacesException;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.primefaces.component.tabview.Tab;
import org.primefaces.component.tabview.TabView;
import org.primefaces.component.tabview.TabViewState;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.FacetUtils;
import org.primefaces.util.LangUtils;
import org.primefaces.util.WidgetBuilder;

public class TabViewRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        TabView tabView;
        Map params = context.getExternalContext().getRequestParameterMap();
        String activeIndexValue = (String)params.get((tabView = (TabView)component).getClientId(context) + "_activeIndex");
        if (LangUtils.isNotBlank(activeIndexValue)) {
            tabView.setActiveIndex(Integer.parseInt(activeIndexValue));
            if (tabView.isMultiViewState()) {
                TabViewState ts = tabView.getMultiViewState(true);
                ts.setActiveIndex(tabView.getActiveIndex());
            }
        }
        this.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Map params = context.getExternalContext().getRequestParameterMap();
        TabView tabView = (TabView)component;
        String clientId = tabView.getClientId(context);
        if (tabView.isContentLoadRequest(context)) {
            if (tabView.isRepeating()) {
                int index = Integer.parseInt((String)params.get(clientId + "_tabindex"));
                tabView.setIndex(index);
                Tab tabToLoad = tabView.getDynamicTab();
                tabToLoad.encodeAll(context);
                if (tabView.isDynamic()) {
                    tabToLoad.setLoaded(index, true);
                }
                tabView.setIndex(-1);
            } else {
                String tabClientId = (String)params.get(clientId + "_newTab");
                Tab tabToLoad = tabView.findTab(tabClientId);
                tabToLoad.encodeAll(context);
                if (tabView.isDynamic()) {
                    tabToLoad.setLoaded(true);
                }
            }
        } else {
            if (tabView.isMultiViewState()) {
                tabView.restoreMultiViewState();
            }
            tabView.resetLoadedTabsState();
            this.encodeMarkup(context, tabView);
            this.encodeScript(context, tabView);
        }
    }

    protected void encodeScript(FacesContext context, TabView tabView) throws IOException {
        boolean dynamic = tabView.isDynamic();
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("TabView", tabView);
        if (dynamic) {
            wb.attr("dynamic", true).attr("cache", tabView.isCache());
        }
        wb.callback("onTabChange", "function(index)", tabView.getOnTabChange()).callback("onTabShow", "function(index)", tabView.getOnTabShow()).callback("onTabClose", "function(index)", tabView.getOnTabClose());
        wb.attr("effect", tabView.getEffect(), null).attr("effectDuration", tabView.getEffectDuration(), null).attr("scrollable", tabView.isScrollable()).attr("tabindex", tabView.getTabindex(), null).attr("focusOnError", tabView.isFocusOnError(), false).attr("focusOnLastActiveTab", tabView.isFocusOnLastActiveTab(), false).attr("touchable", ComponentUtils.isTouchable(context, tabView), true).attr("multiViewState", tabView.isMultiViewState(), false);
        this.encodeClientBehaviors(context, tabView);
        wb.finish();
    }

    protected void encodeMarkup(FacesContext context, TabView tabView) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = tabView.getClientId(context);
        String widgetVar = tabView.resolveWidgetVar(context);
        String orientation = tabView.getOrientation();
        String styleClass = this.getStyleClassBuilder(context).add("ui-tabs ui-widget ui-widget-content ui-corner-all ui-hidden-container").add("ui-tabs-" + orientation).add(tabView.isScrollable(), "ui-tabs-scrollable").add(tabView.getStyleClass()).add(ComponentUtils.isRTL(context, tabView), "ui-tabs-rtl").build();
        writer.startElement("div", (UIComponent)tabView);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (tabView.getStyle() != null) {
            writer.writeAttribute("style", (Object)tabView.getStyle(), "style");
        }
        writer.writeAttribute("data-widget", (Object)widgetVar, null);
        if ("bottom".equals(orientation)) {
            this.encodeFooter(context, tabView);
            this.encodeContents(context, tabView);
            this.encodeHeaders(context, tabView);
        } else {
            this.encodeHeaders(context, tabView);
            this.encodeContents(context, tabView);
            this.encodeFooter(context, tabView);
        }
        this.encodeStateHolder(context, tabView, clientId + "_activeIndex", String.valueOf(tabView.getActiveIndex()));
        if (tabView.isScrollable()) {
            String scrollParam = clientId + "_scrollState";
            String scrollState = (String)context.getExternalContext().getRequestParameterMap().get(scrollParam);
            String scrollValue = scrollState == null ? "0" : scrollState;
            this.encodeStateHolder(context, tabView, scrollParam, scrollValue);
        }
        writer.endElement("div");
    }

    protected void encodeStateHolder(FacesContext facesContext, TabView tabView, String name, String value) throws IOException {
        this.renderHiddenInput(facesContext, name, value, false);
    }

    protected void encodeFooter(FacesContext context, TabView tabView) throws IOException {
        UIComponent footerFacet = tabView.getFacet("footer");
        if (FacetUtils.shouldRenderFacet(footerFacet)) {
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)"ui-tabs-footer", null);
            footerFacet.encodeAll(context);
            writer.endElement("div");
        }
    }

    protected void encodeHeaders(FacesContext context, TabView tabView) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        boolean scrollable = tabView.isScrollable();
        if (scrollable) {
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)"ui-tabs-navscroller", null);
            this.encodeScrollerButton(context, tabView, "ui-tabs-navscroller-btn ui-tabs-navscroller-btn-left ui-state-default ui-corner-right", "ui-icon ui-icon-carat-1-w");
            this.encodeScrollerButton(context, tabView, "ui-tabs-navscroller-btn ui-tabs-navscroller-btn-right ui-state-default ui-corner-left", "ui-icon ui-icon-carat-1-e");
        }
        writer.startElement("ul", null);
        writer.writeAttribute("class", (Object)"ui-tabs-nav ui-helper-reset ui-widget-header ui-corner-all", null);
        writer.writeAttribute("role", (Object)"tablist", null);
        AtomicBoolean withActiveFacet = new AtomicBoolean(false);
        tabView.forEachTab((tab, i, active) -> {
            try {
                if (this.encodeTabHeader(context, tabView, (Tab)((Object)tab), (int)i, (boolean)active)) {
                    withActiveFacet.set(true);
                }
            }
            catch (IOException ex) {
                throw new FacesException((Throwable)ex);
            }
        });
        UIComponent actionsFacet = tabView.getFacet("actions");
        if (FacetUtils.shouldRenderFacet(actionsFacet)) {
            writer.startElement("li", null);
            writer.writeAttribute("class", (Object)"ui-tabs-actions ui-tabs-actions-global", null);
            writer.writeAttribute("aria-hidden", (Object)String.valueOf(withActiveFacet.get()), null);
            actionsFacet.encodeAll(context);
            writer.endElement("li");
        }
        writer.endElement("ul");
        if (scrollable) {
            writer.endElement("div");
        }
    }

    protected boolean encodeTabHeader(FacesContext context, TabView tabView, Tab tab, int index, boolean active) throws IOException {
        UIComponent optionsFacet;
        boolean withFacet = false;
        ResponseWriter writer = context.getResponseWriter();
        String styleClass = this.getStyleClassBuilder(context).add(active, "ui-tabs-header ui-state-default ui-tabs-selected ui-state-active", "ui-tabs-header ui-state-default").add("ui-corner-" + tabView.getOrientation()).add(tab.isDisabled(), "ui-state-disabled").add(tab.getTitleStyleClass()).build();
        UIComponent titleFacet = tab.getFacet("title");
        String tabindex = tab.isDisabled() ? "-1" : tabView.getTabindex();
        writer.startElement("li", (UIComponent)tab);
        writer.writeAttribute("class", (Object)styleClass, null);
        writer.writeAttribute("role", (Object)"presentation", null);
        writer.writeAttribute("data-index", (Object)index, null);
        if (tab.getTitleStyle() != null) {
            writer.writeAttribute("style", (Object)tab.getTitleStyle(), null);
        }
        if (tab.getTitletip() != null) {
            writer.writeAttribute("title", (Object)tab.getTitletip(), null);
        }
        String clientId = tab.getClientId(context);
        String tabHeaderId = clientId + "_header";
        writer.startElement("a", null);
        writer.writeAttribute("id", (Object)tabHeaderId, null);
        writer.writeAttribute("href", (Object)("#" + clientId), null);
        writer.writeAttribute("role", (Object)"tab", null);
        writer.writeAttribute("aria-expanded", (Object)String.valueOf(active), null);
        writer.writeAttribute("aria-selected", (Object)String.valueOf(active), null);
        writer.writeAttribute("aria-label", (Object)tab.getAriaLabel(), null);
        writer.writeAttribute("data-index", (Object)index, null);
        writer.writeAttribute("aria-controls", (Object)clientId, null);
        if (tabindex != null) {
            writer.writeAttribute("tabindex", (Object)tabindex, null);
        }
        if (!FacetUtils.shouldRenderFacet(titleFacet)) {
            String tabTitle = tab.getTitle();
            if (tabTitle != null) {
                writer.writeText((Object)tabTitle, null);
            }
        } else {
            titleFacet.encodeAll(context);
        }
        writer.endElement("a");
        if (tab.isClosable()) {
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)"ui-icon ui-icon-close", null);
            writer.endElement("span");
        }
        if (FacetUtils.shouldRenderFacet(optionsFacet = tab.getFacet("actions"))) {
            withFacet = true;
            writer.startElement("li", null);
            writer.writeAttribute("class", (Object)"ui-tabs-actions", null);
            writer.writeAttribute("aria-hidden", (Object)String.valueOf(!active), null);
            optionsFacet.encodeAll(context);
            writer.endElement("li");
        }
        writer.endElement("li");
        return active && withFacet;
    }

    protected void encodeContents(FacesContext context, TabView tabView) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        boolean dynamic = tabView.isDynamic();
        boolean repeating = tabView.isRepeating();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-tabs-panels", null);
        tabView.forEachTab((tab, i, active) -> {
            try {
                String tabindex = active != false ? tabView.getTabindex() : "-1";
                this.encodeTabContent(context, (Tab)((Object)tab), (int)i, (boolean)active, dynamic, repeating, tabindex);
            }
            catch (IOException ex) {
                throw new FacesException((Throwable)ex);
            }
        });
        writer.endElement("div");
    }

    protected void encodeTabContent(FacesContext context, Tab tab, int index, boolean active, boolean dynamic, boolean repeating, String tabindex) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String styleClass = active ? "ui-tabs-panel ui-widget-content ui-corner-bottom" : "ui-tabs-panel ui-widget-content ui-corner-bottom ui-helper-hidden";
        String clientId = tab.getClientId(context);
        String tabHeaderId = clientId + "_header";
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)styleClass, null);
        writer.writeAttribute("role", (Object)"tabpanel", null);
        writer.writeAttribute("aria-hidden", (Object)String.valueOf(!active), null);
        writer.writeAttribute("aria-labelledby", (Object)tabHeaderId, null);
        writer.writeAttribute("data-index", (Object)index, null);
        writer.writeAttribute("tabindex", (Object)tabindex, null);
        if (dynamic) {
            if (active) {
                tab.encodeAll(context);
                if (repeating) {
                    tab.setLoaded(index, true);
                } else {
                    tab.setLoaded(true);
                }
            }
        } else {
            tab.encodeAll(context);
        }
        writer.endElement("div");
    }

    protected void encodeScrollerButton(FacesContext context, TabView tabView, String styleClass, String iconClass) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("a", null);
        writer.writeAttribute("class", (Object)styleClass, null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)iconClass, null);
        writer.endElement("span");
        writer.endElement("a");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

