/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.terminal;

import jakarta.faces.application.ResourceDependencies;
import jakarta.faces.application.ResourceDependency;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.BehaviorEvent;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.primefaces.component.terminal.TerminalBase;
import org.primefaces.model.terminal.TerminalAutoCompleteMatches;
import org.primefaces.model.terminal.TerminalAutoCompleteModel;
import org.primefaces.model.terminal.TerminalCommand;
import org.primefaces.util.MapBuilder;

@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="terminal/terminal.css"), @ResourceDependency(library="primefaces", name="components.css"), @ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="jquery/jquery-plugins.js"), @ResourceDependency(library="primefaces", name="core.js"), @ResourceDependency(library="primefaces", name="components.js"), @ResourceDependency(library="primefaces", name="terminal/terminal.js")})
public class Terminal
extends TerminalBase {
    public static final String COMPONENT_TYPE = "org.primefaces.component.Terminal";
    public static final String CONTAINER_CLASS = "ui-terminal ui-widget ui-widget-content ui-corner-all";
    public static final String WELCOME_MESSAGE_CLASS = "ui-terminal-welcome";
    public static final String CONTENT_CLASS = "ui-terminal-content";
    public static final String PROMPT_CLASS = "ui-terminal-prompt";
    public static final String INPUT_CLASS = "ui-terminal-input";
    private static final String DEFAULT_EVENT = "command";
    private static final Map<String, Class<? extends BehaviorEvent>> BEHAVIOR_EVENT_MAPPING = MapBuilder.builder().put("command", null).build();
    private static final Collection<String> EVENT_NAMES = BEHAVIOR_EVENT_MAPPING.keySet();

    @Override
    public Map<String, Class<? extends BehaviorEvent>> getBehaviorEventMapping() {
        return BEHAVIOR_EVENT_MAPPING;
    }

    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    public String getDefaultEventName() {
        return DEFAULT_EVENT;
    }

    public boolean isCommandRequest() {
        FacesContext context = this.getFacesContext();
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_command");
    }

    public boolean isAutoCompleteRequest() {
        FacesContext context = this.getFacesContext();
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_autocomplete");
    }

    TerminalAutoCompleteMatches traverseAutoCompleteModel(TerminalAutoCompleteModel commandModel, String input, String[] args) {
        ArrayDeque<String> argumentQueue = new ArrayDeque<String>(Arrays.asList(args));
        return this.traverseAutoCompleteModel(commandModel, input, argumentQueue);
    }

    private TerminalAutoCompleteMatches traverseAutoCompleteModel(TerminalAutoCompleteModel commandModel, String input, ArrayDeque<String> inputArguments) {
        TerminalAutoCompleteMatches matches = new TerminalAutoCompleteMatches();
        for (TerminalCommand command : commandModel.getCommands()) {
            if (!this.isPartialMatch(command, input)) continue;
            if (this.isExactMatch(command, input) && command.hasArguments()) {
                matches.extendBaseCommand(input);
                return this.traverseArguments(command, matches, inputArguments);
            }
            matches.addMatch(command);
        }
        return matches;
    }

    private TerminalAutoCompleteMatches traverseArguments(TerminalCommand command, TerminalAutoCompleteMatches matches, ArrayDeque<String> inputArguments) {
        if (command.getArguments() != null) {
            for (TerminalCommand argument : command.getArguments()) {
                if (!inputArguments.isEmpty()) {
                    String inputArgument = inputArguments.peek();
                    if (!this.isPartialMatch(argument, inputArgument)) continue;
                    if (this.isExactMatch(argument, inputArgument) && argument.hasArguments()) {
                        matches.extendBaseCommand(argument);
                        inputArguments.removeFirst();
                        return this.traverseArguments(argument, matches, inputArguments);
                    }
                    matches.addMatch(argument);
                    continue;
                }
                matches.addMatch(argument);
            }
        }
        return matches;
    }

    private boolean isPartialMatch(TerminalCommand command, String input) {
        return command.getText().startsWith(input);
    }

    private boolean isExactMatch(TerminalCommand command, String input) {
        return command.getText().equalsIgnoreCase(input);
    }
}

