/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.tieredmenu;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import java.util.List;
import org.primefaces.component.badge.BadgeRenderer;
import org.primefaces.component.menu.AbstractMenu;
import org.primefaces.component.menu.BaseMenuRenderer;
import org.primefaces.component.tieredmenu.TieredMenu;
import org.primefaces.model.menu.MenuElement;
import org.primefaces.model.menu.MenuItem;
import org.primefaces.model.menu.Separator;
import org.primefaces.model.menu.Submenu;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.LangUtils;
import org.primefaces.util.WidgetBuilder;

public class TieredMenuRenderer
extends BaseMenuRenderer {
    @Override
    protected void encodeScript(FacesContext context, AbstractMenu abstractMenu) throws IOException {
        TieredMenu menu = (TieredMenu)abstractMenu;
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("TieredMenu", menu).attr("autoDisplay", menu.isAutoDisplay()).attr("showDelay", menu.getShowDelay(), 0).attr("hideDelay", menu.getHideDelay(), 0).attr("tabIndex", menu.getTabindex(), "0").attr("toggleEvent", menu.getToggleEvent(), null);
        if (menu.isOverlay()) {
            this.encodeOverlayConfig(context, menu, wb);
        }
        wb.finish();
    }

    @Override
    protected void encodeMarkup(FacesContext context, AbstractMenu abstractMenu) throws IOException {
        TieredMenu menu = (TieredMenu)abstractMenu;
        String style = menu.getStyle();
        String styleClass = this.getStyleClassBuilder(context).add(menu.getStyleClass()).add(menu.isOverlay(), "ui-menu ui-tieredmenu ui-menu-dynamic ui-widget ui-widget-content ui-corner-all ui-helper-clearfix ui-shadow", "ui-menu ui-tieredmenu ui-widget ui-widget-content ui-corner-all ui-helper-clearfix").add(ComponentUtils.isRTL(context, abstractMenu), "ui-menu-rtl").build();
        this.encodeMenu(context, menu, style, styleClass, "vertical");
    }

    protected void encodeMenu(FacesContext context, AbstractMenu menu, String style, String styleClass, String orientation) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", (UIComponent)menu);
        writer.writeAttribute("id", (Object)menu.getClientId(context), "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (LangUtils.isNotEmpty(style)) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        writer.startElement("ul", null);
        writer.writeAttribute("role", (Object)"menubar", null);
        writer.writeAttribute("aria-orientation", (Object)orientation, null);
        writer.writeAttribute("class", (Object)"ui-menu-list ui-helper-reset", null);
        writer.writeAttribute("tabindex", (Object)"-1", null);
        this.encodeFacet(context, menu, "start", "ui-menuitem ui-menubar-start ui-widget ui-corner-all");
        if (menu.getElementsCount() > 0) {
            this.encodeElements(context, menu, menu.getElements());
        }
        this.encodeFacet(context, menu, "options", "ui-menuitem ui-menubar-options ui-widget ui-corner-all");
        this.encodeFacet(context, menu, "end", "ui-menuitem ui-menubar-end ui-widget ui-corner-all");
        writer.endElement("ul");
        writer.endElement("div");
    }

    protected void encodeElements(FacesContext context, AbstractMenu menu, List<MenuElement> elements) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        for (MenuElement element : elements) {
            if (!element.isRendered()) continue;
            if (element instanceof MenuItem) {
                MenuItem menuItem = (MenuItem)element;
                String containerStyle = menuItem.getContainerStyle();
                String containerStyleClass = this.getStyleClassBuilder(context).add("ui-menuitem ui-widget ui-corner-all").add(menuItem.getContainerStyleClass()).add(menuItem.getBadge() != null, "ui-overlay-badge").build();
                writer.startElement("li", null);
                writer.writeAttribute("class", (Object)containerStyleClass, null);
                writer.writeAttribute("role", (Object)"none", null);
                if (LangUtils.isNotEmpty(containerStyle)) {
                    writer.writeAttribute("style", (Object)containerStyle, null);
                }
                if (menuItem.getBadge() != null) {
                    BadgeRenderer.encode(context, menuItem.getBadge());
                }
                this.encodeMenuItem(context, menu, menuItem, "-1");
                writer.endElement("li");
                continue;
            }
            if (element instanceof Submenu) {
                Submenu submenu = (Submenu)element;
                String style = submenu.getStyle();
                String styleClass = this.getStyleClassBuilder(context).add("ui-widget ui-menuitem ui-corner-all ui-menu-parent").add(submenu.getStyleClass()).build();
                writer.startElement("li", null);
                if (this.shouldRenderId(submenu)) {
                    writer.writeAttribute("id", (Object)submenu.getClientId(), null);
                }
                writer.writeAttribute("class", (Object)styleClass, null);
                if (LangUtils.isNotEmpty(style)) {
                    writer.writeAttribute("style", (Object)style, null);
                }
                writer.writeAttribute("role", (Object)"none", null);
                this.encodeSubmenu(context, menu, submenu);
                writer.endElement("li");
                continue;
            }
            if (!(element instanceof Separator)) continue;
            this.encodeSeparator(context, (Separator)element);
        }
    }

    protected void encodeSubmenu(FacesContext context, AbstractMenu menu, Submenu submenu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        boolean disabled = submenu.isDisabled();
        boolean isRtl = ComponentUtils.isRTL(context, menu);
        writer.startElement("a", null);
        writer.writeAttribute("role", (Object)"menuitem", null);
        writer.writeAttribute("aria-haspopup", (Object)"true", null);
        writer.writeAttribute("aria-expanded", (Object)"false", null);
        writer.writeAttribute("href", (Object)"#", null);
        writer.writeAttribute("tabindex", (Object)"-1", null);
        String styleClass = this.getStyleClassBuilder(context).add("ui-menuitem-link ui-submenu-link ui-corner-all").add(disabled, "ui-state-disabled").build();
        writer.writeAttribute("class", (Object)styleClass, null);
        if (disabled) {
            writer.writeAttribute("onclick", (Object)"return false;", null);
        }
        if (isRtl) {
            this.encodeSubmenuIcon(context, submenu, isRtl, true);
            this.encodeMenuLabel(context, submenu);
            this.encodeMenuIcon(context, submenu);
        } else {
            this.encodeMenuIcon(context, submenu);
            this.encodeMenuLabel(context, submenu);
            this.encodeSubmenuIcon(context, submenu, isRtl, true);
        }
        writer.endElement("a");
        if (!disabled && submenu.getElementsCount() > 0) {
            writer.startElement("ul", null);
            writer.writeAttribute("class", (Object)"ui-widget-content ui-menu-list ui-corner-all ui-helper-clearfix ui-menu-child ui-shadow", null);
            writer.writeAttribute("role", (Object)"menu", null);
            writer.writeAttribute("aria-label", (Object)submenu.getLabel(), null);
            this.encodeElements(context, menu, submenu.getElements());
            writer.endElement("ul");
        }
    }
}

