/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.timeline;

import jakarta.faces.component.UIComponent;
import jakarta.faces.component.search.SearchExpressionContext;
import jakarta.faces.component.search.SearchExpressionHint;
import jakarta.faces.context.FacesContext;
import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.primefaces.component.timeline.Timeline;
import org.primefaces.model.timeline.TimelineEvent;

public abstract class TimelineUpdater {
    protected String clientId;

    public TimelineUpdater() {
    }

    public TimelineUpdater(String clientId) {
        this.clientId = clientId;
    }

    public static TimelineUpdater getCurrentInstance(String expression) {
        FacesContext context = FacesContext.getCurrentInstance();
        Map map = (Map)context.getAttributes().get(TimelineUpdater.class.getName());
        if (map == null) {
            return null;
        }
        AtomicReference widgetVar = new AtomicReference();
        SearchExpressionContext sec = SearchExpressionContext.createSearchExpressionContext((FacesContext)context, (UIComponent)context.getViewRoot(), EnumSet.of(SearchExpressionHint.RESOLVE_SINGLE_COMPONENT), null);
        context.getApplication().getSearchExpressionHandler().resolveComponent(sec, expression, (ctx, target) -> {
            Timeline timeline = (Timeline)target;
            widgetVar.set(timeline.resolveWidgetVar(context));
        });
        return (TimelineUpdater)map.get(widgetVar.get());
    }

    public abstract void add(TimelineEvent<?> var1);

    public abstract void update(TimelineEvent<?> var1);

    public abstract void delete(String var1);

    public abstract void select(String var1);

    public abstract void clear();
}

